/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.common.structures;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.security.common.osgi.SecurityOSGiUtils;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class CommonCache {
    private static final TraceComponent tc = Tr.register(CommonCache.class, null, null);
    private final PrivilegedAction<ScheduledExecutorService> getScheduledExecutorServiceAction = new GetScheduledExecutorServiceAction();
    protected int entryLimit = 50000;
    protected long timeoutInMilliSeconds = 300000L;
    private ScheduledExecutorService evictionSchedule;
    private ScheduledFuture<?> previousScheduledTask = null;
    static final long serialVersionUID = -2224300814444226299L;

    public int size() {
        return this.entryLimit;
    }

    public long getTimeoutInMilliseconds() {
        return this.timeoutInMilliSeconds;
    }

    public abstract void remove(@Sensitive Object var1);

    public abstract Object get(@Sensitive String var1);

    public abstract void put(@Sensitive String var1, Object var2);

    public synchronized void rescheduleCleanup(long newTimeoutInMillis) {
        if (newTimeoutInMillis > 0L) {
            this.timeoutInMilliSeconds = newTimeoutInMillis;
        }
        if (this.previousScheduledTask != null) {
            this.previousScheduledTask.cancel(true);
        }
        this.evictionSchedule = System.getSecurityManager() == null ? this.getScheduledExecutorService() : AccessController.doPrivileged(this.getScheduledExecutorServiceAction);
        if (this.evictionSchedule != null) {
            this.previousScheduledTask = this.evictionSchedule.scheduleWithFixedDelay(new EvictionTask(), this.timeoutInMilliSeconds, this.timeoutInMilliSeconds, TimeUnit.MILLISECONDS);
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Failed to obtain a ScheduledExecutorService", (Object[])new Object[0]);
        }
    }

    protected abstract void evictStaleEntries();

    private ScheduledExecutorService getScheduledExecutorService() {
        return SecurityOSGiUtils.getService(this.getClass(), ScheduledExecutorService.class);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class GetScheduledExecutorServiceAction
    implements PrivilegedAction<ScheduledExecutorService> {
        static final long serialVersionUID = 9034288836361748463L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private GetScheduledExecutorServiceAction() {
        }

        @Override
        public ScheduledExecutorService run() {
            return CommonCache.this.getScheduledExecutorService();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.common.structures.CommonCache$GetScheduledExecutorServiceAction", GetScheduledExecutorServiceAction.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class EvictionTask
    implements Runnable {
        static final long serialVersionUID = -1733067057985688587L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private EvictionTask() {
        }

        @Override
        public void run() {
            CommonCache.this.evictStaleEntries();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.common.structures.CommonCache$EvictionTask", EvictionTask.class, null, null);
        }
    }
}

