/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcpchannel.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.tcpchannel.internal.TCPProxyConnLink;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.channelfw.ChannelFrameworkFactory;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.tcpchannel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcpchannel.TCPReadRequestContext;
import com.ibm.wsspi.tcpchannel.TCPWriteCompletedCallback;
import com.ibm.wsspi.tcpchannel.TCPWriteRequestContext;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public class TCPProxyResponse {
    protected TCPProxyConnLink connLink;
    public static final String PROXY_TARGET_HOST_PORT = "PROXY_TARGET_HOST_PORT";
    public static final String PROXY_TARGET_USER_PASS = "PROXY_TARGET_USER_PASS";
    private static byte[] PROXY_CONNECT = null;
    private static byte[] PROXY_HTTPVERSION = null;
    private static byte[] PROXY_AUTHORIZATION = null;
    private static final byte[] PROXY_CRLF = new byte[]{13, 10};
    private ProxyWriteCallback proxyWriteCB = null;
    private ProxyReadCallback proxyReadCB = null;
    private boolean isProxyResponseValid = false;
    protected static final int STATUS_NOT_DONE = 0;
    protected static final int STATUS_DONE = 1;
    protected static final int STATUS_ERROR = 2;
    protected static final TraceComponent tc = Tr.register(TCPProxyResponse.class, (String)"TCPChannel", (String)"com.ibm.ws.tcpchannel.internal.resources.TCPChannelMessages");

    public TCPProxyResponse(TCPProxyConnLink _connLink) {
        this.connLink = _connLink;
    }

    protected void setIsProxyResponseValid(boolean newValue) {
        this.isProxyResponseValid = newValue;
    }

    protected void proxyReadHandshake() {
        this.connLink.getReadInterface().setJITAllocateSize(1024);
        if (this.connLink.isAsyncConnect()) {
            this.proxyReadCB = new ProxyReadCallback();
            this.readProxyResponse(this.connLink.getVirtualConnection());
        } else {
            int rc = 0;
            while (rc == 0) {
                this.readProxyResponse(this.connLink.getVirtualConnection());
                rc = this.checkResponse(this.connLink.getReadInterface());
            }
            if (rc == 2) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"could not complete proxy handshake, read request failed", (Object[])new Object[0]);
                }
                this.releaseProxyReadBuffer();
                if (!this.connLink.isSyncError()) {
                    this.connLink.connectFailed(new IOException("Invalid Proxy Server Response "));
                }
            }
        }
    }

    protected int checkResponse(TCPReadRequestContext rsc) {
        WsByteBuffer[] buffers = rsc.getBuffers();
        if (null == buffers) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Could not complete proxy handshake, null buffers", (Object[])new Object[0]);
            }
            return 2;
        }
        int status = this.validateProxyResponse(buffers);
        if (1 == status) {
            this.releaseProxyReadBuffer();
        }
        return status;
    }

    protected void writeAndShake() {
        if (!this.connLink.isAsyncConnect()) {
            try {
                this.connLink.getWriteInterface().write(-1L, 0);
                this.releaseProxyWriteBuffer();
                this.proxyReadHandshake();
            }
            catch (IOException x) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"connectComplete: could not complete sync handshake", (Object[])new Object[0]);
                }
                this.releaseProxyWriteBuffer();
                this.connLink.connectFailed(x);
            }
        } else {
            this.proxyWriteCB = new ProxyWriteCallback();
            VirtualConnection vcRC = this.connLink.getWriteInterface().write(-1L, this.proxyWriteCB, false, 0);
            if (null != vcRC) {
                this.proxyWriteCB.complete(vcRC, this.connLink.getWriteInterface());
            }
        }
    }

    protected void releaseProxyWriteBuffer() {
        WsByteBuffer buffer = this.connLink.getWriteInterface().getBuffer();
        if (null != buffer) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Releasing proxy write buffer: " + buffer), (Object[])new Object[0]);
            }
            buffer.release();
            this.connLink.getWriteInterface().setBuffer(null);
        }
    }

    protected void releaseProxyReadBuffer() {
        WsByteBuffer buffer = this.connLink.getReadInterface().getBuffer();
        if (null != buffer) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Releasing proxy read buffer: " + buffer), (Object[])new Object[0]);
            }
            buffer.release();
            this.connLink.getReadInterface().setBuffer(null);
        }
    }

    protected int validateProxyResponse(WsByteBuffer[] buffers) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"validateProxyResponse", (Object[])new Object[0]);
        }
        int status = 0;
        for (int i = 0; i < buffers.length; ++i) {
            buffers[i].flip();
            byte[] data = new byte[buffers[i].limit()];
            buffers[i].get(data);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("buffer: [" + new String(data) + "]"), (Object[])new Object[0]);
            }
            if (!this.isProxyResponseValid) {
                this.isProxyResponseValid = this.containsHTTP200(data);
                if (!this.isProxyResponseValid) {
                    status = 2;
                    break;
                }
            }
            if (this.containsEOLDelimiters(data)) {
                status = 1;
                break;
            }
            buffers[i].clear();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("validateProxyResponse, rc=" + status));
        }
        return status;
    }

    protected boolean containsEOLDelimiters(byte[] data) {
        int numCRLFs = 0;
        for (int i = 0; i < data.length; ++i) {
            if (13 == data[i] || 10 == data[i]) {
                if (4 == ++numCRLFs) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"contains 4 consecutive CRs and/or LFs: true", (Object[])new Object[0]);
                    }
                    return true;
                }
                if (i <= 0 || 10 != data[i] || 10 != data[i - 1]) continue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"contains LF-LF: true", (Object[])new Object[0]);
                }
                return true;
            }
            numCRLFs = 0;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("containsEOLDelimiters: false count=" + numCRLFs), (Object[])new Object[0]);
        }
        return false;
    }

    protected boolean containsHTTP200(byte[] data) {
        boolean rc = true;
        if (data.length < 12 || data[0] != 72 || data[1] != 84 || data[2] != 84 || data[3] != 80 || data[9] != 50 || data[10] != 48 || data[11] != 48) {
            rc = false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("containsHTTP200: " + rc), (Object[])new Object[0]);
        }
        return rc;
    }

    protected boolean setForwardProxyBuffers(Map<Object, Object> config) {
        byte[] target = (byte[])config.get(PROXY_TARGET_HOST_PORT);
        if (null == target) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Proxy tunnel attempt missing target host", (Object[])new Object[0]);
            }
            this.connLink.connectFailed(new IOException("Missing forward proxy target host"));
            return false;
        }
        byte[] authInfo = (byte[])config.get(PROXY_TARGET_USER_PASS);
        int size = 100 + target.length + (null != authInfo ? authInfo.length : 0);
        WsByteBuffer buffer = ChannelFrameworkFactory.getBufferManager().allocate(size);
        buffer.put(PROXY_CONNECT);
        buffer.put(target);
        buffer.put(PROXY_HTTPVERSION);
        if (null != authInfo) {
            buffer.put(PROXY_AUTHORIZATION);
            buffer.put(authInfo);
            buffer.put(PROXY_CRLF);
        }
        buffer.put(PROXY_CRLF);
        buffer.flip();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            byte[] output = new byte[buffer.limit()];
            buffer.get(output);
            Tr.debug((TraceComponent)tc, (String)("ForwardProxyBuffers[" + new String(output) + "]"), (Object[])new Object[0]);
            buffer.position(0);
        }
        this.connLink.getWriteInterface().setBuffer(buffer);
        return true;
    }

    protected void readProxyResponse(VirtualConnection inVC) {
        int size = 1;
        if (!this.isProxyResponseValid) {
            size = 12;
        }
        if (this.connLink.isAsyncConnect()) {
            VirtualConnection vcRC = this.connLink.getReadInterface().read(size, this.proxyReadCB, false, 0);
            if (null != vcRC) {
                this.proxyReadCB.complete(vcRC, this.connLink.getReadInterface());
            }
        } else {
            try {
                this.connLink.getReadInterface().read(size, 0);
            }
            catch (IOException x) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"could not complete proxy handshake, read request failed", (Object[])new Object[0]);
                }
                this.releaseProxyReadBuffer();
                this.connLink.connectFailed(x);
            }
        }
    }

    static {
        PROXY_CONNECT = "CONNECT ".getBytes(StandardCharsets.ISO_8859_1);
        PROXY_HTTPVERSION = " HTTP/1.0\r\n".getBytes(StandardCharsets.ISO_8859_1);
        PROXY_AUTHORIZATION = "Proxy-authorization: basic ".getBytes(StandardCharsets.ISO_8859_1);
    }

    protected class ProxyReadCallback
    implements TCPReadCompletedCallback {
        protected ProxyReadCallback() {
        }

        @Override
        public void complete(VirtualConnection inVC, TCPReadRequestContext wsc) {
            int status;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("ProxyReadCallback --> complete for " + inVC), (Object[])new Object[0]);
            }
            if ((status = TCPProxyResponse.this.checkResponse(wsc)) == 1) {
                TCPProxyResponse.this.connLink.getApplicationCallback().ready(inVC);
            } else if (status == 0) {
                TCPProxyResponse.this.readProxyResponse(inVC);
            } else {
                TCPProxyResponse.this.releaseProxyReadBuffer();
                TCPProxyResponse.this.connLink.connectFailed(new IOException("Invalid Proxy Server Response "));
            }
        }

        @Override
        public void error(VirtualConnection inVC, TCPReadRequestContext wsc, IOException ioe) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("ProxyReadCallback--> error for " + inVC), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("ioe: " + ioe), (Object[])new Object[0]);
            }
            TCPProxyResponse.this.releaseProxyReadBuffer();
            TCPProxyResponse.this.connLink.connectFailed(ioe);
        }
    }

    protected class ProxyWriteCallback
    implements TCPWriteCompletedCallback {
        protected ProxyWriteCallback() {
        }

        @Override
        public void complete(VirtualConnection inVC, TCPWriteRequestContext wsc) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("ProxyWriteCallback --> complete for " + inVC), (Object[])new Object[0]);
            }
            TCPProxyResponse.this.releaseProxyWriteBuffer();
            TCPProxyResponse.this.proxyReadHandshake();
        }

        @Override
        public void error(VirtualConnection inVC, TCPWriteRequestContext wsc, IOException ioe) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("ProxyWriteCallback--> error for " + inVC), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("ioe: " + ioe), (Object[])new Object[0]);
            }
            TCPProxyResponse.this.releaseProxyWriteBuffer();
            TCPProxyResponse.this.connLink.connectFailed(ioe);
        }
    }
}

