/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.resources.writeable;

import com.ibm.ws.repository.common.enums.ResourceType;
import com.ibm.ws.repository.connections.RepositoryConnection;
import com.ibm.ws.repository.exceptions.RepositoryResourceCreationException;
import com.ibm.ws.repository.resources.internal.AdminScriptResourceImpl;
import com.ibm.ws.repository.resources.internal.ConfigSnippetResourceImpl;
import com.ibm.ws.repository.resources.internal.EsaResourceImpl;
import com.ibm.ws.repository.resources.internal.IfixResourceImpl;
import com.ibm.ws.repository.resources.internal.ProductResourceImpl;
import com.ibm.ws.repository.resources.internal.SampleResourceImpl;
import com.ibm.ws.repository.resources.internal.ToolResourceImpl;
import com.ibm.ws.repository.resources.writeable.AdminScriptResourceWritable;
import com.ibm.ws.repository.resources.writeable.ConfigSnippetResourceWritable;
import com.ibm.ws.repository.resources.writeable.EsaResourceWritable;
import com.ibm.ws.repository.resources.writeable.IfixResourceWritable;
import com.ibm.ws.repository.resources.writeable.ProductResourceWritable;
import com.ibm.ws.repository.resources.writeable.RepositoryResourceWritable;
import com.ibm.ws.repository.resources.writeable.SampleResourceWritable;
import com.ibm.ws.repository.resources.writeable.ToolResourceWritable;

public class WritableResourceFactory {
    public static AdminScriptResourceWritable createAdminScript(RepositoryConnection repoConnection) {
        return new AdminScriptResourceImpl(repoConnection);
    }

    public static ConfigSnippetResourceWritable createConfigSnippet(RepositoryConnection repoConnection) {
        return new ConfigSnippetResourceImpl(repoConnection);
    }

    public static EsaResourceWritable createEsa(RepositoryConnection repoConnection) {
        return new EsaResourceImpl(repoConnection);
    }

    public static IfixResourceWritable createIfix(RepositoryConnection repoConnection) {
        return new IfixResourceImpl(repoConnection);
    }

    public static ProductResourceWritable createProduct(RepositoryConnection repoConnection, ResourceType type) {
        ProductResourceImpl product = new ProductResourceImpl(repoConnection);
        product.setType(type);
        return product;
    }

    public static SampleResourceWritable createSample(RepositoryConnection repoConnection, ResourceType type) {
        SampleResourceImpl sample = new SampleResourceImpl(repoConnection);
        sample.setType(type);
        return sample;
    }

    public static ToolResourceWritable createTool(RepositoryConnection repoConnection) {
        return new ToolResourceImpl(repoConnection);
    }

    public static RepositoryResourceWritable createResource(RepositoryConnection repoConnection, ResourceType type) throws RepositoryResourceCreationException {
        switch (type) {
            case ADDON: 
            case INSTALL: {
                return WritableResourceFactory.createProduct(repoConnection, type);
            }
            case ADMINSCRIPT: {
                return WritableResourceFactory.createAdminScript(repoConnection);
            }
            case CONFIGSNIPPET: {
                return WritableResourceFactory.createConfigSnippet(repoConnection);
            }
            case FEATURE: {
                return WritableResourceFactory.createEsa(repoConnection);
            }
            case IFIX: {
                return WritableResourceFactory.createIfix(repoConnection);
            }
            case OPENSOURCE: 
            case PRODUCTSAMPLE: {
                return WritableResourceFactory.createSample(repoConnection, type);
            }
            case TOOL: {
                return WritableResourceFactory.createTool(repoConnection);
            }
        }
        throw new RepositoryResourceCreationException("Can not create an asset of type " + (Object)((Object)type), null);
    }
}

