/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.jwt.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.structures.CacheEntry;
import com.ibm.ws.security.common.structures.SingleTableCache;
import com.ibm.ws.security.jwt.config.JwtConsumerConfig;
import java.util.ArrayList;
import java.util.Map;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.NumericDate;
import org.jose4j.jwt.consumer.JwtContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JwtCache
extends SingleTableCache {
    private static final TraceComponent tc = Tr.register(JwtCache.class, (String)"JWTBUILDER", (String)"com.ibm.ws.security.jwt.internal.resources.JWTMessages");
    static final int DEFAULT_ENTRY_LIMIT = 500;
    private final JwtConsumerConfig config;
    static final long serialVersionUID = -7986219924430484784L;

    public JwtCache(long timeoutInMilliSeconds, JwtConsumerConfig config) {
        super(500, timeoutInMilliSeconds);
        this.config = config;
    }

    public synchronized Object get(@Sensitive String key) {
        JwtContext jwtContext = (JwtContext)super.get(key);
        if (jwtContext == null || this.isJwtExpired(jwtContext)) {
            return null;
        }
        return jwtContext;
    }

    protected synchronized void evictStaleEntries() {
        super.evictStaleEntries();
        ArrayList<String> keysToRemove = new ArrayList<String>();
        for (Map.Entry entry : this.lookupTable.entrySet()) {
            String key = (String)entry.getKey();
            CacheEntry cacheEntry = (CacheEntry)entry.getValue();
            JwtContext jwtContext = (JwtContext)cacheEntry.getValue();
            if (jwtContext != null && !this.isJwtExpired(jwtContext)) continue;
            keysToRemove.add(key);
        }
        for (String keyToRemove : keysToRemove) {
            this.lookupTable.remove(keyToRemove);
        }
    }

    @FFDCIgnore(value={MalformedClaimException.class})
    public boolean isJwtExpired(JwtContext jwtContext) {
        JwtClaims jwtClaims = jwtContext.getJwtClaims();
        if (jwtClaims == null) {
            return true;
        }
        long jwtExp = 0L;
        try {
            NumericDate expirationTime = jwtClaims.getExpirationTime();
            if (expirationTime == null) {
                return true;
            }
            jwtExp = expirationTime.getValueInMillis();
        }
        catch (MalformedClaimException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Caught exception getting expiration time for JWT: " + (Object)((Object)e)), (Object[])new Object[0]);
            }
            return true;
        }
        return System.currentTimeMillis() > jwtExp + this.config.getClockSkew();
    }
}

