/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authentication.internal.cache;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.internal.cache.AuthCache;
import com.ibm.ws.security.authentication.internal.cache.AuthCacheServiceImpl;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import io.openliberty.jcache.CacheService;
import javax.cache.Cache;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JCacheAuthCache
implements AuthCache {
    private static final TraceComponent tc = Tr.register(JCacheAuthCache.class, (String)"Authentication", (String)"com.ibm.ws.security.authentication.internal.resources.AuthenticationMessages");
    private CacheService cacheService = null;
    private AuthCache inMemoryCache = null;
    static final long serialVersionUID = -4678907629830827495L;

    public JCacheAuthCache(CacheService cacheService, AuthCache inMemoryCache) {
        this.cacheService = cacheService;
        this.inMemoryCache = inMemoryCache;
    }

    @Override
    public void clearAllEntries() {
        this.inMemoryCache.clearAllEntries();
        if (!FrameworkState.isStopping() && AuthCacheServiceImpl.isServerStarted()) {
            Cache<Object, Object> jCache = this.getJCache();
            if (jCache != null) {
                jCache.removeAll();
            }
            Tr.info((TraceComponent)tc, (String)"JCACHE_AUTH_CACHE_CLEARED_ALL_ENTRIES", (Object[])new Object[]{this.cacheService.getCache().getName()});
        }
    }

    @Override
    public Object get(Object key) {
        Cache<Object, Object> jCache = this.getJCache();
        if (jCache != null) {
            Object value = jCache.get(key);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                if (value == null) {
                    Tr.debug((TraceComponent)tc, (String)("JCache MISS for key " + key), (Object[])new Object[0]);
                } else {
                    Tr.debug((TraceComponent)tc, (String)("JCache HIT for key " + key), (Object[])new Object[0]);
                }
            }
            return value;
        }
        return null;
    }

    @Override
    public void insert(Object key, Object value) {
        Cache<Object, Object> jCache = this.getJCache();
        if (jCache != null) {
            jCache.put(key, value);
        }
    }

    @Override
    public void remove(Object key) {
        Cache<Object, Object> jCache = this.getJCache();
        if (jCache != null) {
            jCache.remove(key);
        }
    }

    private Cache<Object, Object> getJCache() {
        Cache jCache = null;
        if (this.cacheService != null) {
            jCache = this.cacheService.getCache();
        }
        return jCache;
    }

    @Override
    @Trivial
    public void stopEvictionTask() {
        if (this.inMemoryCache != null) {
            this.inMemoryCache.stopEvictionTask();
        }
    }
}

