/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.net.HttpURLConnection;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public final class ChunkedUtil {
    static final long serialVersionUID = -731677501972978737L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    private ChunkedUtil() {
    }

    public static InputStream getPartialResponse(HttpURLConnection connection, int responseCode) throws IOException {
        InputStream in = null;
        if (responseCode == 202 || responseCode == 200) {
            if (connection.getContentLength() > 0) {
                in = connection.getInputStream();
            } else if (ChunkedUtil.hasChunkedResponse(connection) || ChunkedUtil.hasEofTerminatedResponse(connection)) {
                in = ChunkedUtil.getNonEmptyContent(connection);
            }
        }
        return in;
    }

    private static boolean hasChunkedResponse(HttpURLConnection connection) {
        return "chunked".equalsIgnoreCase(connection.getHeaderField("Transfer-Encoding"));
    }

    private static boolean hasEofTerminatedResponse(HttpURLConnection connection) {
        return "close".equalsIgnoreCase(connection.getHeaderField("Connection"));
    }

    private static InputStream getNonEmptyContent(HttpURLConnection connection) {
        PushbackInputStream in = null;
        try {
            PushbackInputStream pin = new PushbackInputStream(connection.getInputStream());
            int c = pin.read();
            if (c != -1) {
                pin.unread((byte)c);
                in = pin;
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"org.apache.cxf.transport.http.ChunkedUtil", (String)"94", null, (Object[])new Object[]{connection});
        }
        return in;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.apache.cxf.transport.http.ChunkedUtil", ChunkedUtil.class, null, null);
    }
}

