/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.jcache.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.productinfo.ProductInfo;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.serialization.SerializationService;
import io.openliberty.jcache.CacheManagerService;
import io.openliberty.jcache.CacheService;
import io.openliberty.jcache.internal.CacheProxy;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.MutableConfiguration;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(immediate=true, configurationPolicy=ConfigurationPolicy.REQUIRE, configurationPid={"io.openliberty.jcache.cache"}, property={"service.vendor=IBM"})
public class CacheServiceImpl
implements CacheService {
    private static final TraceComponent tc = Tr.register(CacheServiceImpl.class, (String)"jcache", (String)"io.openliberty.jcache.internal.resources.JCacheMessages");
    private static final String KEY_CACHE_NAME = "name";
    private static final String KEY_ID = "id";
    private CacheManagerService cacheManagerService = null;
    private SerializationService serializationService = null;
    private ScheduledExecutorService scheduledExecutorService = null;
    private String cacheName = null;
    private Cache<Object, Object> cache = null;
    private Object syncObject = new Object();
    private String id;
    private static boolean issuedBetaMessage = false;
    static final long serialVersionUID = -8098165221073120736L;

    @Activate
    public void activate(Map<String, Object> configProps) {
        this.betaFenceCheck();
        this.id = (String)configProps.get(KEY_ID);
        this.cacheName = (String)configProps.get(KEY_CACHE_NAME);
        this.scheduledExecutorService.execute(new Runnable(){
            static final long serialVersionUID = -5666725693501979368L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public void run() {
                CacheServiceImpl.this.getCache();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"io.openliberty.jcache.internal.CacheServiceImpl$1", 1.class, (String)"jcache", (String)"io.openliberty.jcache.internal.resources.JCacheMessages");
            }
        });
    }

    @Deactivate
    public void deactivate() {
        if (this.cache != null) {
            this.cache.close();
        }
        this.cache = null;
    }

    private void betaFenceCheck() throws UnsupportedOperationException {
        if (!ProductInfo.getBetaEdition()) {
            throw new UnsupportedOperationException("The cache feature is beta and is not available.");
        }
        if (!issuedBetaMessage) {
            Tr.info((TraceComponent)tc, (String)("BETA: A beta method has been invoked for the class " + this.getClass().getName() + " for the first time."), (Object[])new Object[0]);
            issuedBetaMessage = !issuedBetaMessage;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Sensitive
    public Object deserialize(@Sensitive byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = this.serializationService.createObjectInputStream((InputStream)bais, this.cacheManagerService.getCachingProviderService().getUnifiedClassLoader());
            return ois.readObject();
        }
        catch (ClassNotFoundException bais) {
            void e;
            Object[] objectArray = new Object[1];
            objectArray[0] = "<sensitive byte[]>";
            FFDCFilter.processException((Throwable)bais, (String)"io.openliberty.jcache.internal.CacheServiceImpl", (String)"137", (Object)this, (Object[])objectArray);
            Tr.error((TraceComponent)tc, (String)"CWLJC0008_DESERIALIZE_ERR", (Object[])new Object[]{this.cacheName, e});
            return null;
        }
        catch (IOException e) {
            Object[] objectArray = new Object[1];
            objectArray[0] = "<sensitive byte[]>";
            FFDCFilter.processException((Throwable)e, (String)"io.openliberty.jcache.internal.CacheServiceImpl", (String)"140", (Object)this, (Object[])objectArray);
            Tr.error((TraceComponent)tc, (String)"CWLJC0008_DESERIALIZE_ERR", (Object[])new Object[]{this.cacheName, e});
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Sensitive
    public byte[] serialize(@Sensitive Object o) {
        if (o == null) {
            return null;
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = this.serializationService.createObjectOutputStream((OutputStream)baos);
            oos.writeObject(o);
            return baos.toByteArray();
        }
        catch (IOException baos) {
            void e;
            Object[] objectArray = new Object[1];
            objectArray[0] = "<sensitive java.lang.Object>";
            FFDCFilter.processException((Throwable)baos, (String)"io.openliberty.jcache.internal.CacheServiceImpl", (String)"157", (Object)this, (Object[])objectArray);
            Tr.error((TraceComponent)tc, (String)"CWLJC0009_SERIALIZE_ERR", (Object[])new Object[]{this.cacheName, e});
            return null;
        }
    }

    @Override
    public Cache<Object, Object> getCache() {
        if (this.cache != null) {
            return this.cache;
        }
        return AccessController.doPrivileged(() -> {
            Object object = this.syncObject;
            synchronized (object) {
                if (this.cache == null) {
                    long loadTimeMs;
                    try {
                        CacheManager cacheManager = this.cacheManagerService.getCacheManager();
                        loadTimeMs = System.currentTimeMillis();
                        Cache jCache = cacheManager.getCache(this.cacheName, Object.class, Object.class);
                        loadTimeMs = System.currentTimeMillis() - loadTimeMs;
                        if (jCache != null) {
                            this.cache = new CacheProxy((Cache<Object, Object>)jCache, this);
                        }
                    }
                    catch (Throwable e) {
                        Tr.error((TraceComponent)tc, (String)"CWLJC0011_GET_CACHE_ERR", (Object[])new Object[]{this.cacheName, e});
                        throw e;
                    }
                    if (this.cache == null) {
                        MutableConfiguration config = new MutableConfiguration();
                        config.setTypes(Object.class, Object.class);
                        CacheManager cacheManager = this.cacheManagerService.getCacheManager();
                        loadTimeMs = System.currentTimeMillis();
                        this.cache = new CacheProxy((Cache<Object, Object>)cacheManager.createCache(this.cacheName, (Configuration)config), this);
                        loadTimeMs = System.currentTimeMillis() - loadTimeMs;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isInfoEnabled()) {
                            Tr.info((TraceComponent)tc, (String)"CWLJC0001_CACHE_CREATED", (Object[])new Object[]{this.cacheName, loadTimeMs});
                        }
                    } else if (TraceComponent.isAnyTracingEnabled() && tc.isInfoEnabled()) {
                        Tr.info((TraceComponent)tc, (String)"CWLJC0002_CACHE_FOUND", (Object[])new Object[]{this.cacheName, loadTimeMs});
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isInfoEnabled()) {
                        Tr.info((TraceComponent)tc, (String)"CWLJC0003_USING_PROVIDER", (Object[])new Object[]{this.cacheName, this.cacheManagerService.getCachingProviderService().getCachingProvider().getClass().getName()});
                    }
                }
                return this.cache;
            }
        });
    }

    @Override
    public String getCacheName() {
        return this.cacheName;
    }

    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    public void setCachingProviderService(CacheManagerService service) {
        this.cacheManagerService = service;
    }

    public void unsetCachingProviderService(CacheManagerService service) {
        this.cacheManagerService = null;
    }

    @Reference(name="scheduledExecutorService", service=ScheduledExecutorService.class, target="(deferrable=false)")
    public void setScheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorService = scheduledExecutorService;
    }

    public void unsetScheduledExecutorService(ServiceReference<ScheduledExecutorService> scheduledExecutorService) {
        this.scheduledExecutorService = null;
    }

    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    public void setSerializationService(SerializationService serializationService) {
        this.serializationService = serializationService;
    }

    public void unsetSerializationService(SerializationService serializationService) {
        this.serializationService = null;
    }

    public String toString() {
        return super.toString() + "{id=" + this.id + ", cacheName=" + this.cacheName + "}";
    }
}

