/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.jcache.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.productinfo.ProductInfo;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.classloading.ClassLoadingService;
import com.ibm.wsspi.library.Library;
import io.openliberty.jcache.internal.CacheServiceClassLoader;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.cache.Caching;
import javax.cache.spi.CachingProvider;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={CachingProviderService.class}, immediate=true, configurationPolicy=ConfigurationPolicy.REQUIRE, configurationPid={"io.openliberty.jcache.cachingprovider"}, property={"service.vendor=IBM"})
public class CachingProviderService {
    private static final TraceComponent tc = Tr.register(CachingProviderService.class, (String)"jcache", (String)"io.openliberty.jcache.internal.resources.JCacheMessages");
    private static final String KEY_PROVIDER_CLASS = "providerClass";
    private static final String KEY_ID = "id";
    private CachingProvider cachingProvider = null;
    private Set<Library> libraries;
    private ClassLoader classLoader = null;
    private String cachingProviderClass = null;
    private String id = null;
    private ClassLoadingService classLoadingService = null;
    private static boolean issuedBetaMessage = false;
    static final long serialVersionUID = 8465603055630331426L;

    /*
     * WARNING - void declaration
     */
    @Activate
    public void activate(Map<String, Object> configProps) throws Exception {
        this.betaFenceCheck();
        this.cachingProviderClass = (String)configProps.get(KEY_PROVIDER_CLASS);
        this.id = (String)configProps.get(KEY_ID);
        try {
            this.cachingProvider = this.cachingProviderClass != null && !this.cachingProviderClass.trim().isEmpty() ? Caching.getCachingProvider((String)this.cachingProviderClass, (ClassLoader)this.getUnifiedClassLoader()) : Caching.getCachingProvider((ClassLoader)this.getUnifiedClassLoader());
        }
        catch (Throwable throwable) {
            void e;
            FFDCFilter.processException((Throwable)throwable, (String)"io.openliberty.jcache.internal.CachingProviderService", (String)"88", (Object)this, (Object[])new Object[]{configProps});
            Tr.error((TraceComponent)tc, (String)"CWLJC0004_GET_PROVIDER_FAILED", (Object[])new Object[]{this.id, e});
            throw e;
        }
    }

    @Deactivate
    public void deactivate() {
        this.cachingProvider = null;
        this.classLoader = null;
    }

    private void betaFenceCheck() throws UnsupportedOperationException {
        if (!ProductInfo.getBetaEdition()) {
            throw new UnsupportedOperationException("The cachingProvider feature is beta and is not available.");
        }
        if (!issuedBetaMessage) {
            Tr.info((TraceComponent)tc, (String)("BETA: A beta method has been invoked for the class " + this.getClass().getName() + " for the first time."), (Object[])new Object[0]);
            issuedBetaMessage = !issuedBetaMessage;
        }
    }

    public ClassLoader getUnifiedClassLoader() {
        if (this.classLoader != null) {
            return this.classLoader;
        }
        ClassLoader[] followOns = new ClassLoader[this.libraries.size()];
        int idx = 0;
        for (Library lib : this.libraries) {
            followOns[idx++] = lib.getClassLoader();
        }
        ClassLoader unifiedClassLoader = this.classLoadingService.unify(CachingProviderService.class.getClassLoader(), followOns);
        this.classLoader = new CacheServiceClassLoader(unifiedClassLoader);
        return this.classLoader;
    }

    public CachingProvider getCachingProvider() {
        return this.cachingProvider;
    }

    @Reference(name="library", cardinality=ReferenceCardinality.AT_LEAST_ONE, target="(id=unbound)")
    public void setLibrary(Library library) {
        if (this.libraries == null) {
            this.libraries = new HashSet<Library>();
        }
        this.libraries.add(library);
        this.classLoader = null;
    }

    public void unsetLibrary(Library library) {
        if (this.libraries != null) {
            this.libraries.remove(library);
            this.classLoader = null;
        }
    }

    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    public void setClassLoadingService(ClassLoadingService classLoadingService) {
        this.classLoadingService = classLoadingService;
    }

    public void unsetClassLoadingService(ClassLoadingService classLoadingService) {
        this.classLoadingService = null;
    }

    public String toString() {
        return super.toString() + "{id=" + this.id + ", cachingProvider=" + this.cachingProvider + ", libraries=" + this.libraries + "}";
    }
}

