/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.artifact.zip.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.artifact.contributor.ArtifactContainerFactoryHelper;
import com.ibm.ws.artifact.zip.cache.ZipCachingService;
import com.ibm.ws.artifact.zip.internal.ContainerFactoryHolder;
import com.ibm.ws.artifact.zip.internal.FileUtils;
import com.ibm.ws.artifact.zip.internal.ZipFileContainer;
import com.ibm.ws.artifact.zip.internal.ZipValidator;
import com.ibm.ws.classloading.configuration.GlobalClassloadingConfiguration;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.ArtifactEntry;
import com.ibm.wsspi.artifact.factory.ArtifactContainerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipInputStream;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ZipFileContainerFactory
implements ArtifactContainerFactoryHelper,
ContainerFactoryHolder {
    static final TraceComponent tc = Tr.register(ZipFileContainerFactory.class, (String)"archive.artifact.zip", (String)"com.ibm.ws.artifact.zip.internal.resources.ZipArtifactMessages");
    private BundleContext bundleContext;
    private ArtifactContainerFactory rootContainerFactory;
    private GlobalClassloadingConfiguration classLoadingConfiguration;
    private ZipCachingService zipCachingService;
    private static final String[] ZIP_EXTENSIONS = new String[]{"jar", "zip", "ear", "war", "rar", "eba", "esa", "sar"};
    private static final String ZIP_EXTENSION_SPRING = "spring";
    private static final boolean IGNORE_CASE = true;
    static final long serialVersionUID = 5626472933885908038L;

    protected synchronized void activate(ComponentContext componentContext) {
        this.bundleContext = componentContext.getBundleContext();
    }

    protected synchronized void deactivate(ComponentContext componentContext) {
        this.rootContainerFactory = null;
        this.bundleContext = null;
    }

    @Override
    @Trivial
    public synchronized BundleContext getBundleContext() {
        if (this.bundleContext == null) {
            throw new IllegalStateException();
        }
        return this.bundleContext;
    }

    protected synchronized void setContainerFactory(ArtifactContainerFactory rootContainerFactory) {
        this.rootContainerFactory = rootContainerFactory;
    }

    protected synchronized void unsetContainerFactory(ArtifactContainerFactory rootContainerFactory) {
        if (this.rootContainerFactory == rootContainerFactory) {
            this.rootContainerFactory = null;
        }
    }

    @Override
    @Trivial
    public synchronized ArtifactContainerFactory getContainerFactory() {
        if (this.rootContainerFactory == null) {
            throw new IllegalStateException();
        }
        return this.rootContainerFactory;
    }

    protected void setGlobalClassloadingConfiguration(GlobalClassloadingConfiguration classloadingConfiguration) {
        this.classLoadingConfiguration = classloadingConfiguration;
    }

    @Override
    @Trivial
    public boolean useJarUrls() {
        if (this.classLoadingConfiguration != null) {
            return this.classLoadingConfiguration.useJarUrls();
        }
        return false;
    }

    protected void setZipCachingService(ZipCachingService zipCachingService) {
        this.zipCachingService = zipCachingService;
    }

    @Override
    @Trivial
    public ZipCachingService getZipCachingService() {
        if (this.zipCachingService == null) {
            throw new IllegalStateException();
        }
        return this.zipCachingService;
    }

    public ArtifactContainer createContainer(File cacheDir, Object containerData) {
        if (!(containerData instanceof File)) {
            return null;
        }
        File fileContainerData = (File)containerData;
        if (!FileUtils.fileIsFile(fileContainerData)) {
            return null;
        }
        if (!ZipFileContainerFactory.isZip(fileContainerData)) {
            return null;
        }
        return new ZipFileContainer(cacheDir, fileContainerData, this);
    }

    public ArtifactContainer createContainer(File cacheDir, ArtifactContainer enclosingContainer, ArtifactEntry entryInEnclosingContainer, Object containerData) {
        if (containerData instanceof File && FileUtils.fileIsFile((File)containerData)) {
            File fileContainerData = (File)containerData;
            if (ZipFileContainerFactory.isZip(fileContainerData)) {
                return new ZipFileContainer(cacheDir, enclosingContainer, entryInEnclosingContainer, fileContainerData, this);
            }
            return null;
        }
        if (ZipFileContainerFactory.isZip(entryInEnclosingContainer)) {
            return new ZipFileContainer(cacheDir, enclosingContainer, entryInEnclosingContainer, null, this);
        }
        return null;
    }

    private static boolean hasZipExtension(String name) {
        int nameLen = name.length();
        if (nameLen < 4) {
            return false;
        }
        if (nameLen >= 7 && name.charAt(nameLen - 7) == '.' && name.regionMatches(true, nameLen - 6, ZIP_EXTENSION_SPRING, 0, 6)) {
            return true;
        }
        if (name.charAt(nameLen - 4) != '.') {
            return false;
        }
        for (String ext : ZIP_EXTENSIONS) {
            if (!name.regionMatches(true, nameLen - 3, ext, 0, 3)) continue;
            return true;
        }
        return false;
    }

    private static boolean isZip(ArtifactEntry artifactEntry) {
        if (!ZipFileContainerFactory.hasZipExtension(artifactEntry.getName())) {
            return false;
        }
        boolean validZip = false;
        InputStream entryInputStream = null;
        try {
            entryInputStream = artifactEntry.getInputStream();
            if (entryInputStream == null) {
                return false;
            }
            ZipInputStream zipInputStream = new ZipInputStream(entryInputStream);
            try {
                if (zipInputStream.getNextEntry() == null) {
                    ZipValidator zipValidator = new ZipValidator(ZipFileContainerFactory.getPhysicalPath(artifactEntry));
                    validZip = zipValidator.isValid();
                } else {
                    validZip = true;
                }
            }
            catch (IOException zipValidator) {
                FFDCFilter.processException((Throwable)zipValidator, (String)"com.ibm.ws.artifact.zip.internal.ZipFileContainerFactory", (String)"359", null, (Object[])new Object[]{artifactEntry});
                String entryPath = ZipFileContainerFactory.getPhysicalPath(artifactEntry);
                Tr.error((TraceComponent)tc, (String)"bad.zip.data", (Object[])new Object[]{entryPath});
            }
            try {
                zipInputStream.close();
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.artifact.zip.internal.ZipFileContainerFactory", (String)"367", null, (Object[])new Object[]{artifactEntry});
            }
        }
        catch (IOException zipInputStream) {
            FFDCFilter.processException((Throwable)zipInputStream, (String)"com.ibm.ws.artifact.zip.internal.ZipFileContainerFactory", (String)"370", null, (Object[])new Object[]{artifactEntry});
            return false;
        }
        return validZip;
    }

    private static String getPhysicalPath(ArtifactEntry artifactEntry) {
        String physicalPath = artifactEntry.getPhysicalPath();
        if (physicalPath != null) {
            return physicalPath;
        }
        String entryPath = artifactEntry.getPath();
        String rootPath = artifactEntry.getRoot().getPhysicalPath();
        if (rootPath != null) {
            return rootPath + "!" + entryPath;
        }
        while ((artifactEntry = artifactEntry.getRoot().getEntryInEnclosingContainer()) != null) {
            String nextPhysicalPath = artifactEntry.getPhysicalPath();
            if (nextPhysicalPath != null) {
                return nextPhysicalPath + "!" + entryPath;
            }
            entryPath = artifactEntry.getPath() + "!" + entryPath;
        }
        return entryPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={IOException.class, FileNotFoundException.class})
    private static boolean isZip(File file) {
        if (!ZipFileContainerFactory.hasZipExtension(file.getName())) {
            return false;
        }
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            ZipInputStream zipInputStream = new ZipInputStream(inputStream);
            try {
                if (zipInputStream.getNextEntry() == null) {
                    ZipValidator zipValidator = new ZipValidator(file.getAbsolutePath());
                    boolean bl = zipValidator.isValid();
                    return bl;
                }
                boolean zipValidator = true;
                return zipValidator;
            }
            catch (IOException e) {
                Tr.error((TraceComponent)tc, (String)"bad.zip.data", (Object[])new Object[]{file.getAbsolutePath()});
                boolean bl = false;
                return bl;
            }
        }
        catch (FileNotFoundException e) {
            Tr.error((TraceComponent)tc, (String)"missing.zip.file", (Object[])new Object[]{file.getAbsolutePath()});
            boolean bl = false;
            return bl;
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

