/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.cache.CacheOnDisk;
import com.ibm.ws.cache.HTODDynacache;
import com.ibm.ws.cache.Scheduler;
import com.ibm.ws.cache.util.ExceptionUtility;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.concurrent.Future;

public class DiskCleanupThread
implements Runnable {
    private static TraceComponent tc = Tr.register(DiskCleanupThread.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    CacheOnDisk cod;
    HTODDynacache htod;
    Future<?> currentThread;
    boolean processDiskCleanup;
    boolean stopped = false;
    final Object dcMonitor = new Object(){};
    boolean scan;

    public DiskCleanupThread(CacheOnDisk cod) {
        this.cod = cod;
        this.htod = cod.htod;
        this.processDiskCleanup = false;
        this.scan = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        Object object;
        String methodName = "DiskCleanupThread.run()";
        while (true) {
            object = this.dcMonitor;
            // MONITORENTER : object
            if (!this.processDiskCleanup) {
                this.currentThread = null;
                // MONITOREXIT : object
                return;
            }
            this.processDiskCleanup = false;
            // MONITOREXIT : object
            if (this.stopped) {
                return;
            }
            if (this.cleanUpHTOD(this.scan) == 1) {
                this.cod.stopOnError(this.cod.htod.diskCacheException);
                this.stopped = true;
                continue;
            }
            if (!this.cod.htod.invalidationBuffer.isCleanupPending()) continue;
            this.cod.htod.invalidationBuffer.resetCleanupPending();
            this.scan = true;
            if (this.cleanUpHTOD(true) != 1) continue;
            this.cod.stopOnError(this.cod.htod.diskCacheException);
            this.stopped = true;
            continue;
            break;
        }
        finally {
            this.cod.populateEvictionTable = false;
            this.cod.htod.invalidationBuffer.setlastRemoveTime();
            object = this.cod.diskCacheMonitor;
        }
    }

    protected int cleanUpHTOD(boolean scan) {
        String methodName = "cleanUpHTOD()";
        int returnCode = 0;
        if (this.htod != null) {
            try {
                returnCode = this.htod.removeExpiredCache(scan);
                if (returnCode == 1) {
                    return returnCode;
                }
                if (scan) {
                    this.cod.updateLastScanFile();
                }
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.cache.DiskCleanupTask.cleanupHTOD", (String)"96", (Object)this);
                this.traceDebug("cleanUpHTOD()", "cacheName=" + this.cod.cacheName + "\nException: " + ExceptionUtility.getStackTrace(t));
            }
        }
        if (scan && this.cod.diskCachePerformanceLevel != 3 && !this.stopped && !this.htod.invalidationBuffer.isCleanupPending()) {
            if (this.cod.cleanupFrequency == 0) {
                this.cod.sleepTime = this.cod.calculateSleepTime();
            }
            this.traceDebug("cleanUpHTOD()", "cacheName=" + this.cod.cacheName + " set alarm sleepTime=" + this.cod.sleepTime);
            Scheduler.createNonDeferrable(this.cod.sleepTime, this.cod, this);
        } else if (scan && this.cod.diskCachePerformanceLevel != 3) {
            this.traceDebug("cleanUpHTOD()", "cacheName=" + this.cod.cacheName + " alarm is not enabled now. stopped=" + this.stopped + " cleanupPending=" + this.htod.invalidationBuffer.isCleanupPending());
        }
        return returnCode;
    }

    private void traceDebug(String methodName, String message) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(methodName + " " + message), (Object[])new Object[0]);
        }
    }
}

