/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.config;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ssl.SSLConfig;
import com.ibm.ws.config.xml.internal.nester.Nester;
import com.ibm.ws.ssl.config.DynamicSSLCacheMissComparator;
import com.ibm.ws.ssl.config.SSLConfigManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;

public class OutboundSSLSelections {
    private static final TraceComponent tc = Tr.register(OutboundSSLSelections.class, (String)"SSL", (String)"com.ibm.ws.ssl.resources.ssl");
    private static boolean warningIssued = false;
    private final Map<String, String> dynamicHostPortSelections = new ConcurrentHashMap<String, String>();
    private final Map<String, String> dynamicHostSelections = new ConcurrentHashMap<String, String>();
    private final Map<String, String> dynamicSelections = new ConcurrentHashMap<String, String>();
    private final Map<Map<String, Object>, SSLConfig> dynamicLookupCache = new HashMap<Map<String, Object>, SSLConfig>();
    private final Set<Map<String, Object>> dynamicLookupMisses = new TreeSet<Map<String, Object>>(new DynamicSSLCacheMissComparator());

    public Map<String, String> getDynamicSelections() {
        return this.dynamicSelections;
    }

    public void removeDynamicSelection(String oldConnectionInfo) {
        if (this.dynamicSelections.containsKey(oldConnectionInfo)) {
            this.dynamicSelections.remove(oldConnectionInfo);
        }
        if (this.dynamicHostSelections.containsKey(oldConnectionInfo)) {
            this.dynamicHostSelections.remove(oldConnectionInfo);
        }
        if (this.dynamicHostPortSelections.containsKey(oldConnectionInfo)) {
            this.dynamicHostPortSelections.remove(oldConnectionInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void loadOutboundConnectionInfo(String sslCfgAlias, Map<String, Object> config, Set<String> newConnectionInfo) {
        List<Map<String, Object>> outboundEntries;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"loadOutboundConnectionInfo", (Object[])new Object[0]);
        }
        if (!(outboundEntries = Nester.nest("outboundConnection", config)).isEmpty()) {
            for (Map<String, Object> outboundEntry : outboundEntries) {
                Integer port;
                String key = null;
                String host = (String)outboundEntry.get("host");
                String certAlias = (String)outboundEntry.get("clientCertificate");
                if (certAlias != null) {
                    sslCfgAlias = sslCfgAlias + ":" + certAlias;
                }
                if ((port = (Integer)outboundEntry.get("port")) != null) {
                    key = host + "," + port.toString();
                    if (this.dynamicHostPortSelections.containsKey(key)) {
                        if (!this.dynamicHostPortSelections.get(key).equals(sslCfgAlias)) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"loadOutboundConnectionInfo", (Object[])new Object[]{"Existing " + key + " : " + this.dynamicHostPortSelections.get(key) + ",  trying to add " + sslCfgAlias});
                            }
                            this.issueConflictWarning(host, port.toString(), this.dynamicHostPortSelections.get(key));
                        }
                    } else {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"loadOutboundConnectionInfo", (Object[])new Object[]{"Adding " + key + " to the host port list, sslCfgAlias " + sslCfgAlias});
                        }
                        this.dynamicHostPortSelections.put(key, sslCfgAlias);
                    }
                } else {
                    if (host.equals("*") && !warningIssued && this.isDefaultOutboundRefSet(sslCfgAlias)) continue;
                    key = host + ",*";
                    if (this.dynamicHostSelections.containsKey(key)) {
                        if (!this.dynamicHostSelections.get(key).equals(sslCfgAlias)) {
                            this.issueConflictWarning(host, "*", this.dynamicHostSelections.get(key));
                        }
                    } else {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"loadOutboundConnectionInfo", (Object[])new Object[]{"Adding " + key + " to the host list"});
                        }
                        this.dynamicHostSelections.put(key, sslCfgAlias);
                    }
                }
                newConnectionInfo.add(key);
                this.dynamicSelections.put(key, sslCfgAlias);
            }
        }
        this.dynamicLookupCache.clear();
        Set<Map<String, Object>> set = this.dynamicLookupMisses;
        synchronized (set) {
            this.dynamicLookupMisses.clear();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"loadOutboundConnectionInfo");
        }
    }

    public void checkDefaultConflict() {
        if (this.dynamicHostSelections.containsKey("*,*")) {
            String sslConfigAlias = this.dynamicHostSelections.get("*,*");
            if (!warningIssued && this.isDefaultOutboundRefSet(sslConfigAlias)) {
                this.dynamicHostSelections.remove("*,*");
            }
        }
    }

    private boolean isDefaultOutboundRefSet(String sslCfgAlias) {
        String defaultOutboundAlias = SSLConfigManager.getInstance().getGlobalProperty("com.ibm.ws.ssl.outboundDefaultAlias");
        if (defaultOutboundAlias != null) {
            Tr.warning((TraceComponent)tc, (String)"ssl.defaultOutbound.conflict.CWPKI0816W", (Object[])new Object[]{sslCfgAlias, defaultOutboundAlias});
            warningIssued = true;
            return true;
        }
        return false;
    }

    private void issueConflictWarning(String host, String port, String cfgAlias) {
        Tr.warning((TraceComponent)tc, (String)"ssl.dynamicSelection.conflict.CWPKI0815W", (Object[])new Object[]{host, port, cfgAlias});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getPropertiesFromDynamicSelectionInfo(Map<String, Object> connectionInfo) {
        SSLConfig cachedConfig;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getPropertiesFromDynamicSelectionInfo", (Object[])new Object[]{connectionInfo});
        }
        if (connectionInfo == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No connection information provided.", (Object[])new Object[0]);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getPropertiesFromDynamicSelectionInfo");
            }
            return null;
        }
        if (this.dynamicSelections.isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"There are no dynamic outbound selections configured.", (Object[])new Object[0]);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getPropertiesFromDynamicSelectionInfo");
            }
            return null;
        }
        Set<Map<String, Object>> set = this.dynamicLookupMisses;
        synchronized (set) {
            if (this.dynamicLookupMisses.contains(connectionInfo)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"This connectionInfo was checked before, found in the lookup misses cache.", (Object[])new Object[0]);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getPropertiesFromDynamicSelectionInfo");
                }
                return null;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Dynamic outbound lookup cache size is " + this.dynamicLookupCache.size()), (Object[])new Object[0]);
        }
        if ((cachedConfig = this.dynamicLookupCache.get(connectionInfo)) != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Found in cache.", (Object[])new Object[0]);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getPropertiesFromDynamicSelectionInfo", (Object)cachedConfig);
            }
            return cachedConfig;
        }
        String direction = (String)connectionInfo.get("com.ibm.ssl.direction");
        if (direction != null && direction.equals("inbound")) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Connection information is for an inbound connection return null.", (Object[])new Object[0]);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getPropertiesFromDynamicSelectionInfo");
            }
            return null;
        }
        String connInfoRemoteHost = (String)connectionInfo.get("com.ibm.ssl.remoteHost");
        String connInfoRemotePort = (String)connectionInfo.get("com.ibm.ssl.remotePort");
        Tr.debug((TraceComponent)tc, (String)("Host from connectionInfo is " + connInfoRemoteHost + " and port from connectionInfo is " + connInfoRemotePort), (Object[])new Object[0]);
        if (connInfoRemoteHost != null) {
            SSLConfig sslCfg = this.lookForMatchInList(this.dynamicHostPortSelections, connInfoRemoteHost, connInfoRemotePort);
            if (sslCfg != null) {
                this.dynamicLookupCache.put(connectionInfo, sslCfg);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Found in the host and port list.", (Object[])new Object[0]);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getPropertiesFromDynamicSelectionInfo", (Object)sslCfg);
                }
                return sslCfg;
            }
            sslCfg = this.lookForMatchInList(this.dynamicHostSelections, connInfoRemoteHost, connInfoRemotePort);
            if (sslCfg != null) {
                this.dynamicLookupCache.put(connectionInfo, sslCfg);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Found in the host list.", (Object[])new Object[0]);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getPropertiesFromDynamicSelectionInfo", (Object)sslCfg);
                }
                return sslCfg;
            }
        }
        Set<Map<String, Object>> set2 = this.dynamicLookupMisses;
        synchronized (set2) {
            if (this.dynamicLookupMisses.size() > 50) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Cache miss tree set size is > 50, clearing the TreeSet.", (Object[])new Object[0]);
                }
                this.dynamicLookupMisses.clear();
            }
            this.dynamicLookupMisses.add(connectionInfo);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Cache miss tree set size is " + this.dynamicLookupMisses.size() + " entries."), (Object[])new Object[0]);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"No match found in host or host and port list.", (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getPropertiesFromDynamicSelectionInfo");
        }
        return null;
    }

    protected SSLConfig lookForMatchInList(Map<String, String> selectionList, String remoteHost, String remotePort) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"lookForMatchInList", (Object[])new Object[]{remoteHost, remotePort});
        }
        String sslCfgAlias = null;
        String domainMatch = null;
        for (String dynamicSelectionInfo : selectionList.keySet()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("SSLConfig dynamic selection info: " + dynamicSelectionInfo), (Object[])new Object[0]);
            }
            boolean domainCheck = false;
            String[] dynamicSelectionAttributes = dynamicSelectionInfo.split(",");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("This entry has " + dynamicSelectionAttributes.length + " attributes."), (Object[])new Object[0]);
            }
            if (dynamicSelectionAttributes == null || dynamicSelectionAttributes.length != 2) continue;
            String host = dynamicSelectionAttributes[0];
            String port = dynamicSelectionAttributes[1];
            if (host.startsWith("*.")) {
                domainCheck = true;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Host: " + host + ", Port: " + port), (Object[])new Object[0]);
            }
            if (port == null) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"Ending evaluation, one of the values is null.", (Object[])new Object[0]);
                continue;
            }
            if (!(port.equals("*") || remotePort != null && this.doesPortMatch(port, remotePort))) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"Port does not match.", (Object[])new Object[0]);
                continue;
            }
            if (domainCheck) {
                if (remoteHost == null || !this.doesHostDomainMatch(host, remoteHost)) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"Host does not match.", (Object[])new Object[0]);
                    continue;
                }
                if (domainMatch != null && (domainMatch == null || host.length() <= domainMatch.length())) continue;
                sslCfgAlias = selectionList.get(dynamicSelectionInfo);
                domainMatch = host;
                continue;
            }
            if (!(host.equals("*") || remoteHost != null && this.doesHostMatch(host, remoteHost))) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"Host does not match.", (Object[])new Object[0]);
                continue;
            }
            sslCfgAlias = selectionList.get(dynamicSelectionInfo);
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
            Tr.debug((TraceComponent)tc, (String)("Exact match on the host so this config is selected: " + sslCfgAlias), (Object[])new Object[0]);
            break;
        }
        if (sslCfgAlias != null) {
            SSLConfig config;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Found a dynamic selection match! with ssl configuration: " + sslCfgAlias), (Object[])new Object[0]);
            }
            if ((config = this.getSSLConfigForAlias(sslCfgAlias)) != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"lookForMatchInList", (Object)config);
                }
                return config;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"No match found list", (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"lookForMatchInList");
        }
        return null;
    }

    private SSLConfig getSSLConfigForAlias(String sslAliasAndCert) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSSLConfigForAlias", (Object[])new Object[]{sslAliasAndCert});
        }
        String sslAlias = null;
        String sslCert = null;
        if (sslAliasAndCert != null && sslAliasAndCert.indexOf(":") != -1) {
            String[] split = sslAliasAndCert.split(":");
            if (split != null && split.length == 2) {
                sslAlias = split[0];
                sslCert = split[1];
            }
        } else if (sslAliasAndCert != null) {
            sslAlias = sslAliasAndCert;
        }
        SSLConfig config = SSLConfigManager.getInstance().getSSLConfig(sslAlias);
        if (config != null) {
            String clientAlias;
            if (!(sslCert == null || (clientAlias = config.getProperty("com.ibm.ssl.keyStoreClientAlias")) != null && clientAlias.equals(sslAlias))) {
                config = new SSLConfig(config);
                config.setProperty("com.ibm.ssl.keyStoreClientAlias", sslCert);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getSSLConfigForAlias", (Object)new Object[]{config});
            }
            return config;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getSSLConfigForAlias");
        }
        return null;
    }

    private boolean doesHostMatch(String connectionObjHost, String remoteHost) {
        boolean match = false;
        if (remoteHost.equalsIgnoreCase(connectionObjHost)) {
            match = true;
        }
        return match;
    }

    private boolean doesHostDomainMatch(String connectionObjHost, String remoteHost) {
        boolean match = false;
        if (connectionObjHost.startsWith("*.")) {
            String compareHost = connectionObjHost.substring(1);
            if (remoteHost.toLowerCase().endsWith(compareHost.toLowerCase())) {
                match = true;
            }
        }
        return match;
    }

    private boolean doesPortMatch(String connectionObjPort, String remotePort) {
        boolean match = false;
        if (remotePort.equalsIgnoreCase(connectionObjPort)) {
            match = true;
        }
        return match;
    }

    public void removeDynamicSelectionsWithSSLConfig(String sslConfig) {
        for (String dynamicSelectionInfo : this.dynamicSelections.keySet()) {
            String configName = this.dynamicSelections.get(dynamicSelectionInfo);
            if (configName != null && (configName.equals(sslConfig) || (configName + ":").equals(sslConfig))) {
                this.dynamicSelections.remove(dynamicSelectionInfo);
            }
            if ((configName = this.dynamicHostSelections.get(dynamicSelectionInfo)) != null && (configName.equals(sslConfig) || (configName + ":").equals(sslConfig))) {
                this.dynamicHostSelections.remove(dynamicSelectionInfo);
            }
            if ((configName = this.dynamicHostPortSelections.get(dynamicSelectionInfo)) == null || !configName.equals(sslConfig) && !(configName + ":").equals(sslConfig)) continue;
            this.dynamicHostPortSelections.remove(dynamicSelectionInfo);
        }
    }
}

