/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.metrics.monitor;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.microprofile.metrics23.impl.SimpleTimerImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.time.Duration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class MonitorSimpleTimer
extends SimpleTimerImpl {
    private static final TraceComponent tc = Tr.register(MonitorSimpleTimer.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.monitor.resources.MonitorMetrics");
    MBeanServer mbs;
    String objectName;
    String counterAttribute;
    String counterSubAttribute;
    String gaugeAttribute;
    String gaugeSubAttribute;
    boolean isComposite = false;
    static final long serialVersionUID = -8181497381152034888L;

    public MonitorSimpleTimer(MBeanServer mbs, String objectName, String counterAttribute, String counterSubAttribute, String gaugeAttribute, String gaugeSubAttribute) {
        this.mbs = mbs;
        this.objectName = objectName;
        this.counterAttribute = counterAttribute;
        this.counterSubAttribute = counterSubAttribute;
        this.gaugeAttribute = gaugeAttribute;
        this.gaugeSubAttribute = gaugeSubAttribute;
    }

    /*
     * WARNING - void declaration
     */
    public long getCount() {
        try {
            if (this.counterSubAttribute != null) {
                CompositeData value = (CompositeData)this.mbs.getAttribute(new ObjectName(this.objectName), this.counterAttribute);
                Number numValue = (Number)value.get(this.counterSubAttribute);
                return numValue.longValue();
            }
            Number value = (Number)this.mbs.getAttribute(new ObjectName(this.objectName), this.counterAttribute);
            return value.longValue();
        }
        catch (Exception value) {
            FFDCFilter.processException((Throwable)value, (String)"com.ibm.ws.microprofile.metrics.monitor.MonitorSimpleTimer", (String)"54", (Object)((Object)this), (Object[])new Object[0]);
            if (tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)"getCount exception message: ", (Object[])new Object[]{e.getMessage()});
                FFDCFilter.processException((Throwable)e, (String)((Object)((Object)this)).getClass().getSimpleName(), (String)"getCount:Exception");
            }
            return 0L;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Duration getElapsedTime() {
        try {
            if (this.gaugeSubAttribute != null) {
                CompositeData value = (CompositeData)this.mbs.getAttribute(new ObjectName(this.objectName), this.gaugeAttribute);
                Number numValue = (Number)value.get(this.gaugeSubAttribute);
                return Duration.ofNanos(numValue.longValue());
            }
            Number numValue = (Number)this.mbs.getAttribute(new ObjectName(this.objectName), this.gaugeAttribute);
            return Duration.ofNanos(numValue.longValue());
        }
        catch (Exception numValue) {
            FFDCFilter.processException((Throwable)numValue, (String)"com.ibm.ws.microprofile.metrics.monitor.MonitorSimpleTimer", (String)"75", (Object)((Object)this), (Object[])new Object[0]);
            if (tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)"getElapsedTime exception message: ", (Object[])new Object[]{e.getMessage()});
                FFDCFilter.processException((Throwable)e, (String)((Object)((Object)this)).getClass().getSimpleName(), (String)"getElapsedTime:Exception");
            }
            return Duration.ZERO;
        }
    }
}

