/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs.monitor;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.monitor.annotation.Monitor;
import com.ibm.websphere.monitor.annotation.PublishedMetric;
import com.ibm.websphere.monitor.meters.MeterCollection;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.jaxrs.monitor.REST_Stats;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.Provider;

@Monitor(group={"REST"})
@Provider
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JaxRsMonitorFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final TraceComponent tc = Tr.register(JaxRsMonitorFilter.class, null, null);
    @Context
    ResourceInfo resourceInfo;
    @PublishedMetric
    public final MeterCollection<REST_Stats> jaxRsCountByName = new MeterCollection("REST", (Object)this);
    static final ConcurrentHashMap<String, RestMetricInfo> appMetricInfos = new ConcurrentHashMap();
    static final Set<JaxRsMonitorFilter> instances = new HashSet<JaxRsMonitorFilter>();
    private static final String START_TIME = "Start_Time";
    private static final String CMD = "CMD";
    static final long serialVersionUID = -1242278139893225783L;

    @PostConstruct
    public void postConstruct() {
        instances.add(this);
    }

    @PreDestroy
    public void preDestroy() {
        instances.remove(this);
    }

    public void filter(ContainerRequestContext reqCtx) throws IOException {
        reqCtx.setProperty(START_TIME, (Object)System.nanoTime());
        reqCtx.setProperty(CMD, (Object)ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData());
    }

    public void filter(ContainerRequestContext reqCtx, ContainerResponseContext respCtx) throws IOException {
        Class resourceClass;
        ComponentMetaData cmd = (ComponentMetaData)reqCtx.getProperty(CMD);
        if (cmd == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("ContainerRequestContext.filter() has not been invoked for " + reqCtx.getUriInfo().getPath()), (Object[])new Object[0]);
            }
            return;
        }
        long elapsedTime = 0L;
        Long startTime = (Long)reqCtx.getProperty(START_TIME);
        if (startTime != null) {
            elapsedTime = System.nanoTime() - startTime;
        }
        if ((resourceClass = this.resourceInfo.getResourceClass()) != null) {
            String metricsHeader;
            String modName;
            Method resourceMethod = this.resourceInfo.getResourceMethod();
            Class<?>[] parameterClasses = resourceMethod.getParameterTypes();
            int i = 0;
            String fullMethodName = resourceClass.getName() + "/" + resourceMethod.getName() + "(";
            for (Class<?> p : parameterClasses) {
                String parameter = p.getCanonicalName();
                fullMethodName = i > 0 ? fullMethodName + "_" + parameter : fullMethodName + parameter;
                ++i;
            }
            fullMethodName = fullMethodName + ")";
            String appName = this.getAppName(cmd);
            String keyPrefix = this.createKeyPrefix(appName, modName = this.getModName(cmd));
            String key = keyPrefix + "/" + fullMethodName;
            REST_Stats stats = (REST_Stats)this.jaxRsCountByName.get(key);
            if (stats == null) {
                stats = this.initJaxRsStats(key, keyPrefix, fullMethodName);
            }
            if ((metricsHeader = respCtx.getHeaderString("com.ibm.ws.microprofile.metrics.monitor.MetricsJaxRsEMCallbackImpl.Exception")) == null) {
                metricsHeader = respCtx.getHeaderString("io.openliberty.microprofile.metrics.internal.monitor.MetricsJaxRsEMCallbackImpl.Exception");
            }
            this.addKeyToMetricInfo(appName, key);
            if (metricsHeader == null) {
                this.maybeStartNewMinute(stats);
                stats.incrementCountBy(1);
                stats.updateRT(elapsedTime < 0L ? 0L : elapsedTime);
                if (elapsedTime >= 0L) {
                    long minuteLatestMaximumDuration = stats.getMinuteLatestMaximumDuration();
                    while (elapsedTime > minuteLatestMaximumDuration && !stats.compareAndUpdateMinuteLatestMaximumDuration(minuteLatestMaximumDuration, elapsedTime)) {
                        minuteLatestMaximumDuration = stats.getMinuteLatestMaximumDuration();
                    }
                    long minuteLatestMinimumDuration = stats.getMinuteLatestMinimumDuration();
                    if (elapsedTime != 0L || minuteLatestMinimumDuration != 0L) {
                        while (!(elapsedTime >= minuteLatestMinimumDuration && minuteLatestMinimumDuration != 0L || stats.compareAndUpdateMinuteLatestMinimumDuration(minuteLatestMinimumDuration, elapsedTime))) {
                            minuteLatestMinimumDuration = stats.getMinuteLatestMinimumDuration();
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeStartNewMinute(REST_Stats stats) {
        long newMinute = this.getCurrentMinuteFromSystem();
        if (newMinute > stats.getMinuteLatest()) {
            JaxRsMonitorFilter jaxRsMonitorFilter = this;
            synchronized (jaxRsMonitorFilter) {
                if (newMinute > stats.getMinuteLatest()) {
                    stats.updateMinutePreviousMaximumDuration(stats.getMinuteLatestMaximumDuration());
                    stats.updateMinutePreviousMinimumDuration(stats.getMinuteLatestMinimumDuration());
                    stats.updateMinutePrevious(stats.getMinuteLatest());
                    stats.updateMinuteLatestMaximumDuration(0L);
                    stats.updateMinuteLatestMinimumDuration(0L);
                    stats.updateMinuteLatest(newMinute);
                }
            }
        }
    }

    private long getCurrentMinuteFromSystem() {
        return System.currentTimeMillis() / 60000L;
    }

    private synchronized REST_Stats initJaxRsStats(String key, String keyPrefix, String method) {
        REST_Stats nStats = (REST_Stats)this.jaxRsCountByName.get(key);
        if (nStats == null) {
            nStats = new REST_Stats(keyPrefix, method);
            this.jaxRsCountByName.put(key, (Object)nStats);
        }
        return nStats;
    }

    private String getModName(ComponentMetaData cmd) {
        ModuleMetaData mmd;
        String modName = null;
        if (cmd != null && (mmd = cmd.getModuleMetaData()) != null) {
            modName = mmd.getName();
        }
        return modName;
    }

    private String getAppName(ComponentMetaData cmd) {
        J2EEName j2name;
        String appName = null;
        if (cmd != null && (j2name = cmd.getJ2EEName()) != null) {
            appName = j2name.getApplication();
        }
        return appName;
    }

    private String createKeyPrefix(String appName, String modName) {
        if (JaxRsMonitorFilter.getMetricInfo((String)appName).isEar) {
            return appName + "/" + modName;
        }
        return modName;
    }

    static RestMetricInfo getMetricInfo(String appName) {
        RestMetricInfo rMetricInfo = appMetricInfos.get(appName);
        if (rMetricInfo == null) {
            rMetricInfo = new RestMetricInfo();
            appMetricInfos.put(appName, rMetricInfo);
        }
        return rMetricInfo;
    }

    private void addKeyToMetricInfo(String appName, String key) {
        RestMetricInfo rMetricInfo = appMetricInfos.get(appName);
        if (rMetricInfo != null) {
            rMetricInfo.setKey(key);
        }
    }

    static void cleanApplication(String appName) {
        RestMetricInfo rMetricInfo = appMetricInfos.get(appName);
        if (rMetricInfo != null) {
            HashSet<String> keys = rMetricInfo.getKeys();
            if (!keys.isEmpty()) {
                Iterator<String> keyIterator = keys.iterator();
                String key = null;
                while (keyIterator.hasNext()) {
                    key = keyIterator.next();
                    for (JaxRsMonitorFilter filter : instances) {
                        filter.jaxRsCountByName.remove(key);
                    }
                }
            }
            appMetricInfos.remove(appName);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static class RestMetricInfo {
        boolean isEar = false;
        HashSet<String> keys = new HashSet();
        static final long serialVersionUID = 7744330487318592956L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        RestMetricInfo() {
        }

        void setIsEar() {
            this.isEar = true;
        }

        void setKey(String key) {
            this.keys.add(key);
        }

        HashSet<String> getKeys() {
            return this.keys;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.jaxrs.monitor.JaxRsMonitorFilter$RestMetricInfo", RestMetricInfo.class, null, null);
        }
    }
}

