/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.artifact.zip.cache.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.artifact.zip.cache.ZipCachingProperties;
import com.ibm.ws.artifact.zip.cache.internal.ZipFileData;
import com.ibm.ws.artifact.zip.cache.internal.ZipFileDataStore;
import com.ibm.ws.artifact.zip.internal.SystemUtils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

@Trivial
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class ZipFileReaper {
    static final TraceComponent tc = Tr.register(ZipFileReaper.class, (String)"archive.artifact", null);
    private static final DeferredLogEmitter logEmitter = new DeferredLogEmitter();
    private static final Thread logThread = new Thread((Runnable)logEmitter, "reaper logger");
    private static final ErrorConsumer<String> NULL_ERROR_HANDLER;
    public static final boolean DO_DEBUG_STATE = true;
    public static final boolean DO_NOT_DEBUG_STATE = false;
    private final String reaperName;
    private final boolean debugState;
    private final int maxCache;
    private final long quickPendMin;
    private final long quickPendMax;
    private final long slowPendMin;
    private final long slowPendMax;
    private boolean isActive;
    private final long initialAt;
    private boolean isFinal;
    private long finalAt;
    private final ConcurrentMap<String, ZipFileData> storage;
    private final ZipFileDataStore pendingQuickStorage;
    private final ZipFileDataStore pendingSlowStorage;
    private final PendingStorageLock pendingStorageLock = new PendingStorageLock();
    private final ZipFileDataStore completedStorage;
    static ReferenceQueue<ZipFilePathLock> refQueue;
    private static ConcurrentHashMap<String, ZipFilePathLockRef> zipFilePathLockMap;
    private final ReaperShutdownRunnable reaperShutdown;
    private final Thread reaperShutdownThread;
    private final ReaperRunnable reaperRunnable;
    private final Thread reaperThread;
    private final ErrorConsumer<String> errorHandler;
    static final int NUM_REASONS = 10;
    private final Reasons waitReasons;
    private final ReaperLock reaperLock;
    private static final boolean IS_NOT_SHUTDOWN_REAP = false;
    private static final boolean IS_SHUTDOWN_REAP = true;
    private static final long REAP_DELAY_INDEFINITE = -1L;
    static final long serialVersionUID = -4995448959463331779L;

    @Trivial
    private static String toCount(int count) {
        return ZipCachingProperties.toCount(count);
    }

    @Trivial
    private static String toRelSec_s(long baseNS, long actualNS) {
        return ZipCachingProperties.toRelSec(baseNS, actualNS) + " (s)";
    }

    @Trivial
    private static String toAbsSec_s(long durationNS) {
        return ZipCachingProperties.toAbsSec(durationNS) + " (s)";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    public void validate() {
        Object object = this.pendingStorageLock;
        synchronized (object) {
            this.pendingQuickStorage.validate();
            this.pendingSlowStorage.validate();
        }
        if (!this.debugState) {
            object = this.completedStorage;
            synchronized (object) {
                this.completedStorage.validate();
            }
        }
    }

    private static void asyncWarning(String msgKey, Object ... msgArgs) {
        logEmitter.post(msgKey, msgArgs);
    }

    @Trivial
    public ZipFileReaper(String reaperName) {
        this(reaperName, System.nanoTime());
    }

    @Trivial
    public ZipFileReaper(String reaperName, long initialAt) {
        this(reaperName, ZipCachingProperties.ZIP_REAPER_DEBUG_STATE, ZipCachingProperties.ZIP_CACHE_REAPER_MAX_PENDING, ZipCachingProperties.ZIP_CACHE_REAPER_QUICK_PEND_MIN, ZipCachingProperties.ZIP_CACHE_REAPER_QUICK_PEND_MIN, ZipCachingProperties.ZIP_CACHE_REAPER_SLOW_PEND_MAX, ZipCachingProperties.ZIP_CACHE_REAPER_SLOW_PEND_MAX, NULL_ERROR_HANDLER, initialAt);
    }

    @Trivial
    public ZipFileReaper(String reaperName, boolean debugState, int maxCache, long quickPendMin, long quickPendMax, long slowPendMin, long slowPendMax, ErrorConsumer<String> errorHandler) {
        this(reaperName, debugState, maxCache, quickPendMin, quickPendMax, slowPendMin, slowPendMax, errorHandler, System.nanoTime());
    }

    @Trivial
    public ZipFileReaper(String reaperName, boolean debugState, int maxCache, long quickPendMin, long quickPendMax, long slowPendMin, long slowPendMax) {
        this(reaperName, debugState, maxCache, quickPendMin, quickPendMax, slowPendMin, slowPendMax, NULL_ERROR_HANDLER, System.nanoTime());
    }

    private static void validate(int maxCache, long quickPendMin, long quickPendMax, long slowPendMin, long slowPendMax) throws IllegalArgumentException {
        if (maxCache == 0) {
            throw new IllegalArgumentException("Max cache cannot be zero.");
        }
        if (quickPendMin == 0L || quickPendMax == 0L) {
            if (quickPendMin != 0L || quickPendMax != 0L) {
                throw new IllegalArgumentException("If one quick pend duration is zero, the other must be zero.");
            }
        } else {
            if (quickPendMin < 0L) {
                throw new IllegalArgumentException("Minimum quick pend duration [ " + quickPendMin + " ] must be positive or zero");
            }
            if (quickPendMax < 0L) {
                throw new IllegalArgumentException("Maximum quick pend duration[ " + quickPendMax + " ] must be positive or zero");
            }
            if (quickPendMin >= quickPendMax) {
                throw new IllegalArgumentException("Both quick durations must be zero, or, the minimum quick pend duration [ " + quickPendMin + " ] must be less than maximum quick pend duration [ " + quickPendMax + " ]");
            }
        }
        if (slowPendMin <= 0L) {
            throw new IllegalArgumentException("Minimum slow pend duration [ " + slowPendMin + " ] must be positive");
        }
        if (slowPendMax <= 0L) {
            throw new IllegalArgumentException("Maximum slow pend duration [ " + slowPendMax + " ] must be positive");
        }
        if (slowPendMin >= slowPendMax) {
            throw new IllegalArgumentException("Minimum slow pend duration [ " + slowPendMin + " ] must be less than maximum slow pend duration [ " + slowPendMax + " ]");
        }
        if (slowPendMin <= quickPendMax) {
            throw new IllegalArgumentException("Minimum slow pend duration [ " + slowPendMin + " ] must be greater than maximum quick pend duration [ " + quickPendMax + " ]");
        }
    }

    public ZipFileReaper(String reaperName, boolean debugState, int maxCache, long quickPendMin, long quickPendMax, long slowPendMin, long slowPendMax, ErrorConsumer<String> errorHandler, long initialAt) {
        ZipFileReaper.validate(maxCache, quickPendMin, quickPendMax, slowPendMin, slowPendMax);
        this.reaperName = reaperName;
        this.debugState = debugState;
        this.maxCache = maxCache;
        this.quickPendMin = quickPendMin;
        this.quickPendMax = quickPendMax;
        this.slowPendMin = slowPendMin;
        this.slowPendMax = slowPendMax;
        this.storage = new ConcurrentHashMap<String, ZipFileData>();
        this.pendingQuickStorage = new ZipFileDataStore("pendingQuick");
        this.pendingSlowStorage = new ZipFileDataStore("pendingSlow");
        this.completedStorage = !debugState ? new ZipFileDataStore("completed") : null;
        this.reaperLock = new ReaperLock();
        this.reaperRunnable = new ReaperRunnable(this);
        this.reaperThread = new Thread((Runnable)this.reaperRunnable, "zip file reaper");
        this.reaperThread.setDaemon(true);
        if (this.debugState) {
            this.reaperShutdown = new ReaperShutdownRunnable(this.reaperThread);
            this.reaperShutdownThread = new Thread(this.reaperShutdown);
        } else {
            this.reaperShutdown = null;
            this.reaperShutdownThread = null;
        }
        this.initialAt = initialAt;
        this.finalAt = 0L;
        this.isActive = true;
        this.waitReasons = new Reasons("Reaper Waits");
        this.errorHandler = errorHandler;
        this.reaperThread.start();
        if (this.debugState) {
            SystemUtils.addShutdownHook(this.reaperShutdownThread);
        }
        try {
            this.reaperRunnable.waitForStartup();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void shutDown() {
        this.reaperThread.interrupt();
    }

    @Trivial
    public String getReaperName() {
        return this.reaperName;
    }

    @Trivial
    public boolean getDebugState() {
        return this.debugState;
    }

    @Trivial
    public int getMaxCache() {
        return this.maxCache;
    }

    @Trivial
    public long getQuickPendMin() {
        return this.quickPendMin;
    }

    @Trivial
    public long getQuickPendMax() {
        return this.quickPendMax;
    }

    @Trivial
    public long getSlowPendMin() {
        return this.slowPendMin;
    }

    @Trivial
    public long getSlowPendMax() {
        return this.slowPendMax;
    }

    @Trivial
    public boolean getIsActive() {
        return this.isActive;
    }

    @Trivial
    private void setIsActive(boolean isActive) {
        this.isActive = isActive;
    }

    @Trivial
    public long getInitialAt() {
        return this.initialAt;
    }

    @Trivial
    public boolean getIsFinal() {
        return this.isFinal;
    }

    @Trivial
    public long getFinalAt() {
        return this.finalAt;
    }

    private void setFinalAt(long finalAt) {
        this.isFinal = true;
        this.finalAt = finalAt;
    }

    @Trivial
    private String fromInitial_s(long actualNS) {
        return ZipFileReaper.toRelSec_s(this.getInitialAt(), actualNS);
    }

    @Trivial
    private final ZipFilePathLock getLockForPath(String path) {
        ZipFilePathLock lock;
        this.poll();
        ZipFilePathLockRef lockRef = zipFilePathLockMap.get(path);
        ZipFilePathLock zipFilePathLock = lock = lockRef != null ? (ZipFilePathLock)lockRef.get() : null;
        if (lock != null) {
            return lock;
        }
        lock = new ZipFilePathLock();
        ZipFilePathLockRef retVal;
        while ((retVal = zipFilePathLockMap.putIfAbsent(path, new ZipFilePathLockRef(lock, path))) != null) {
            ZipFilePathLock retLock = (ZipFilePathLock)retVal.get();
            if (retLock != null) {
                return retLock;
            }
            zipFilePathLockMap.remove(path, retVal);
        }
        return lock;
    }

    @Trivial
    private final void poll() {
        ZipFilePathLockRef lockRef;
        while ((lockRef = (ZipFilePathLockRef)refQueue.poll()) != null) {
            zipFilePathLockMap.remove(lockRef.key, lockRef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZipFileData.ZipFileState getState(String path) {
        this.reaperLock.acquireReadLock();
        try {
            ZipFilePathLock lock;
            ZipFilePathLock zipFilePathLock = lock = this.getLockForPath(path);
            synchronized (zipFilePathLock) {
                Object object;
                ZipFileData data = (ZipFileData)this.storage.get(path);
                if (data == null && !this.debugState) {
                    object = this.completedStorage;
                    synchronized (object) {
                        data = this.completedStorage.get(path);
                    }
                }
                object = data == null ? null : data.zipFileState;
                return object;
            }
        }
        finally {
            this.reaperLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ZipFileData getRipest() {
        long expireAtSlow;
        long expireAtQuick;
        ZipFileData ripestSlow;
        ZipFileData ripestQuick;
        PendingStorageLock pendingStorageLock = this.pendingStorageLock;
        synchronized (pendingStorageLock) {
            ripestQuick = this.pendingQuickStorage.getFirst();
            ripestSlow = this.pendingSlowStorage.getFirst();
        }
        ZipFileData ripest = ripestQuick == null ? ripestSlow : (ripestSlow == null ? ripestQuick : ((expireAtQuick = ripestQuick.lastPendAt + this.quickPendMin) <= (expireAtSlow = ripestSlow.lastPendAt + this.slowPendMin) ? ripestQuick : ripestSlow));
        return ripest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fullyClose(ZipFileData data, long fullCloseAt, boolean isShutdown) {
        String methodName = "fullyClose";
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(methodName + " Path [ " + data.path + " ] at [ " + this.fromInitial_s(fullCloseAt) + " ]"), (Object[])new Object[0]);
        }
        data.closeZipFile();
        data.enactFullClose(fullCloseAt);
        if (!isShutdown && !this.debugState) {
            ZipFileData oldestCompletedClose;
            ZipFileData fullyClosedData = (ZipFileData)this.storage.remove(data.path);
            ZipFileDataStore zipFileDataStore = this.completedStorage;
            synchronized (zipFileDataStore) {
                oldestCompletedClose = this.completedStorage.addLast(data, this.getMaxCache());
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && oldestCompletedClose != null) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " Discard completed close [ " + oldestCompletedClose.path + " ]"), (Object[])new Object[0]);
            }
        }
    }

    @Trivial
    private ReaperShutdownRunnable getReaperShutdown() {
        return this.reaperShutdown;
    }

    @Trivial
    private Thread getReaperShutdownThread() {
        return this.reaperShutdownThread;
    }

    @Trivial
    private ReaperRunnable getReaper() {
        return this.reaperRunnable;
    }

    @Trivial
    private Thread getReaperThread() {
        return this.reaperThread;
    }

    private void introspectReaperThread(PrintWriter output) {
        output.println();
        output.println("  Reaper [ " + this.reaperThread + " ]");
        output.println("    Id          [ " + this.reaperThread.getId() + " ]");
        output.println("    Name        [ " + this.reaperThread.getName() + " ]");
        output.println("    Daemon      [ " + this.reaperThread.isDaemon() + " ]");
        output.println("    Priority    [ " + this.reaperThread.getPriority() + " ]");
        output.println("    Group       [ " + this.reaperThread.getThreadGroup() + " ]");
        output.println();
        output.println("    State       [ " + (Object)((Object)this.reaperThread.getState()) + " ]");
        output.println("    Alive       [ " + this.reaperThread.isAlive() + " ]");
        output.println("    Interrupted [ " + this.reaperThread.isInterrupted() + " ]");
        output.println();
        this.reaperLock.introspect(output);
        output.println();
        this.waitReasons.introspect(output);
        output.println();
        this.reaperRunnable.introspect(output);
    }

    private void handleError(String errorMessage) {
        Tr.error((TraceComponent)tc, (String)errorMessage, (Object[])new Object[0]);
        if (this.errorHandler != null) {
            this.errorHandler.accept(errorMessage);
        }
        PrintWriter writer = new PrintWriter(System.out);
        this.introspect(writer, System.nanoTime());
        writer.flush();
    }

    void addWaitReason(String reason) {
        this.waitReasons.add(reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long reap(long reapAt, boolean isShutdownReap) {
        long nextReapDelay;
        boolean useQuick;
        String methodName = "reap";
        long nextQuickReapDelay = -1L;
        long nextSlowReapDelay = -1L;
        Iterator iterator = this.pendingStorageLock;
        synchronized (iterator) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " At [ " + this.fromInitial_s(reapAt) + " ] Force [ " + isShutdownReap + " ]"), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)(methodName + " All [ " + this.storage.size() + " ] Pending Quick [ " + this.pendingQuickStorage.size() + " ] Pending Slow [ " + this.pendingSlowStorage.size() + " ]"), (Object[])new Object[0]);
            }
            Iterator<ZipFileData> pendingQuick = this.pendingQuickStorage.values();
            while (nextQuickReapDelay == -1L && pendingQuick.hasNext()) {
                ZipFileData nextPending = pendingQuick.next();
                long nextLastPendAt = nextPending.lastPendAt;
                long nextPendDuration = reapAt - nextLastPendAt;
                if (isShutdownReap) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(methodName + " Path [ " + nextPending.path + " ] Waiting [ " + ZipFileReaper.toAbsSec_s(nextPendDuration) + " ] (Quick): Forced"), (Object[])new Object[0]);
                    }
                    pendingQuick.remove();
                    this.fullyClose(nextPending, reapAt, true);
                    continue;
                }
                if (nextPendDuration > this.quickPendMin) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(methodName + " Path [ " + nextPending.path + " ] Waiting [ " + ZipFileReaper.toAbsSec_s(nextPendDuration) + " ] (Quick): Expired"), (Object[])new Object[0]);
                    }
                    pendingQuick.remove();
                    this.fullyClose(nextPending, reapAt, false);
                    continue;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(methodName + " Path [ " + nextPending.path + " ] Waiting [ " + ZipFileReaper.toAbsSec_s(nextPendDuration) + " ]: Still Waiting"), (Object[])new Object[0]);
                }
                if (nextPendDuration < 0L) {
                    nextPendDuration = 0L;
                }
                nextQuickReapDelay = this.quickPendMax - nextPendDuration;
            }
            Iterator<ZipFileData> pendingSlow = this.pendingSlowStorage.values();
            while (nextSlowReapDelay == -1L && pendingSlow.hasNext()) {
                ZipFileData nextPending = pendingSlow.next();
                long nextLastPendAt = nextPending.lastPendAt;
                long nextPendDuration = reapAt - nextLastPendAt;
                if (isShutdownReap) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(methodName + " Path [ " + nextPending.path + " ] Waiting [ " + ZipFileReaper.toAbsSec_s(nextPendDuration) + " ] (Slow): Forced"), (Object[])new Object[0]);
                    }
                    pendingSlow.remove();
                    this.fullyClose(nextPending, reapAt, true);
                    continue;
                }
                if (nextPendDuration > this.slowPendMin) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(methodName + " Path [ " + nextPending.path + " ] Waiting [ " + ZipFileReaper.toAbsSec_s(nextPendDuration) + " ] (Slow): Expired"), (Object[])new Object[0]);
                    }
                    pendingSlow.remove();
                    this.fullyClose(nextPending, reapAt, false);
                    continue;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(methodName + " Path [ " + nextPending.path + " ] Waiting [ " + ZipFileReaper.toAbsSec_s(nextPendDuration) + " ]: Still Waiting"), (Object[])new Object[0]);
                }
                if (nextPendDuration < 0L) {
                    nextPendDuration = 0L;
                }
                nextSlowReapDelay = this.slowPendMax - nextPendDuration;
            }
        }
        if (isShutdownReap) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " De-activating reaper"), (Object[])new Object[0]);
            }
            this.setIsActive(false);
            this.setFinalAt(reapAt);
            for (ZipFileData mustBeOpenOrClosed : this.storage.values()) {
                String path = mustBeOpenOrClosed.path;
                if (mustBeOpenOrClosed.isFullyClosed()) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)(methodName + " Closed [ " + path + " ]: No shutdown action"), (Object[])new Object[0]);
                    continue;
                }
                if (mustBeOpenOrClosed.isPending()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(methodName + " Unexpected Pending [ " + path + " ]: Shutdown close"), (Object[])new Object[0]);
                    }
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(methodName + " Open [ " + path + " ] [ " + mustBeOpenOrClosed.getActiveOpens() + " ]: Shutdown pend and close"), (Object[])new Object[0]);
                    }
                    mustBeOpenOrClosed.enactClose(reapAt, true);
                }
                this.fullyClose(mustBeOpenOrClosed, reapAt, true);
            }
            for (ZipFileData mustBeClosed : this.storage.values()) {
                mustBeClosed.setFinal(reapAt);
                mustBeClosed.debugState();
            }
        }
        if (nextQuickReapDelay < 0L && nextSlowReapDelay < 0L) {
            useQuick = true;
            nextReapDelay = -1L;
        } else if (nextQuickReapDelay < 0L) {
            useQuick = false;
            nextReapDelay = nextSlowReapDelay;
        } else if (nextSlowReapDelay < 0L) {
            useQuick = true;
            nextReapDelay = nextQuickReapDelay;
        } else if (nextQuickReapDelay < nextSlowReapDelay) {
            useQuick = true;
            nextReapDelay = nextQuickReapDelay;
        } else {
            useQuick = false;
            nextReapDelay = nextSlowReapDelay;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            String delayText = nextReapDelay == -1L ? "Indefinite" : ZipFileReaper.toAbsSec_s(nextReapDelay);
            String speedText = useQuick ? "Quick" : "Slow";
            Tr.debug((TraceComponent)tc, (String)(methodName + " Next reap [ " + delayText + " ] (" + speedText + ")"), (Object[])new Object[0]);
        }
        return nextReapDelay;
    }

    @Trivial
    public ZipFile open(String path) throws IOException, ZipException {
        return this.open(path, System.nanoTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    public ZipFile open(String path, long openAt) throws IOException, ZipException {
        String methodName = "open";
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(methodName + " Path [ " + path + " ] at [ " + ZipFileReaper.toRelSec_s(this.initialAt, openAt) + " ]"), (Object[])new Object[0]);
        }
        this.reaperLock.acquireReadLock();
        try {
            ZipFilePathLock lock;
            if (!this.getIsActive()) {
                ZipFileReaper.asyncWarning("reaper.inactive", path, this.reaperName);
                throw new IOException("Cannot open [ " + path + " ]: ZipFile cache is inactive");
            }
            ZipFilePathLock zipFilePathLock = lock = this.getLockForPath(path);
            synchronized (zipFilePathLock) {
                ZipFile zipFile;
                Object object;
                ZipFileData data = (ZipFileData)this.storage.get(path);
                if (data == null) {
                    if (!this.debugState) {
                        object = this.completedStorage;
                        synchronized (object) {
                            data = this.completedStorage.remove(path);
                        }
                    }
                    if (data == null) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)(methodName + " New [ " + path + " ]"), (Object[])new Object[0]);
                        }
                        data = new ZipFileData(path, this.getInitialAt());
                    } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(methodName + " Recovered [ " + path + " ]"), (Object[])new Object[0]);
                    }
                    this.storage.put(path, data);
                }
                if (data.isFullyClosed()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(methodName + " Open [ " + path + " ]"), (Object[])new Object[0]);
                    }
                    zipFile = data.openZipFile();
                } else {
                    if (data.isPending()) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)(methodName + " Unpend [ " + path + " ]"), (Object[])new Object[0]);
                        }
                        object = this.pendingStorageLock;
                        synchronized (object) {
                            if (data.expireQuickly) {
                                ZipFileData zipFileData = this.pendingQuickStorage.remove(path);
                            } else {
                                ZipFileData zipFileData = this.pendingSlowStorage.remove(path);
                            }
                        }
                        try {
                            zipFile = data.reacquireZipFile();
                        }
                        catch (Exception e) {
                            data.enactFullClose(openAt);
                            throw e;
                        }
                    }
                    if (data.isOpen()) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)(methodName + " Already open [ " + path + " ]"), (Object[])new Object[0]);
                        }
                        try {
                            zipFile = data.reacquireZipFile();
                        }
                        catch (Exception e) {
                            data.enactClose(openAt, true);
                            data.enactFullClose(openAt);
                            throw e;
                        }
                    } else {
                        throw data.unknownState();
                    }
                }
                data.enactOpen(openAt);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(methodName + " Path [ " + path + " ] [ " + zipFile + " ]"), (Object[])new Object[0]);
                }
                object = zipFile;
                return object;
            }
        }
        finally {
            this.reaperLock.releaseReadLock();
        }
    }

    public ZipFileData.ZipFileState close(String path) {
        return this.close(path, System.nanoTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZipFileData.ZipFileState close(String path, long closeAt) {
        ZipFileData.ZipFileState state;
        String skipWakeReason;
        String wakeReason;
        String methodName;
        block41: {
            methodName = "close";
            wakeReason = null;
            skipWakeReason = null;
            state = null;
            ZipFileData ripestPending = null;
            this.reaperLock.acquireReadLock();
            try {
                ZipFilePathLock lock2;
                PendingStorageLock pendingStorageLock;
                ZipFilePathLock lock;
                if (!this.getIsActive()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(methodName + " Path [ " + path + " ]: Ignore: Inactive"), (Object[])new Object[0]);
                    }
                    ZipFileData.ZipFileState zipFileState = null;
                    return zipFileState;
                }
                ZipFilePathLock zipFilePathLock = lock = this.getLockForPath(path);
                synchronized (zipFilePathLock) {
                    ZipFileData data = (ZipFileData)this.storage.get(path);
                    if (data == null) {
                        ZipFileReaper.asyncWarning("reaper.unregistered.path", path);
                    } else if (data.isFullyClosed()) {
                        ZipFileReaper.asyncWarning("reaper.closed.path", path);
                    } else if (data.isPending()) {
                        ZipFileReaper.asyncWarning("reaper.pending.path", path);
                    } else if (data.isOpen()) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)(methodName + " Active opens [ " + path + " ] [ " + data.getActiveOpens() + " ]"), (Object[])new Object[0]);
                        }
                        if (data.enactClose(closeAt, false)) {
                            boolean expireQuickly = data.setExpireQuickly(this.slowPendMin);
                            if (expireQuickly && this.quickPendMin == 0L) {
                                this.fullyClose(data, closeAt, false);
                            } else {
                                boolean wasSlowEmpty;
                                boolean wasQuickEmpty;
                                pendingStorageLock = this.pendingStorageLock;
                                synchronized (pendingStorageLock) {
                                    wasQuickEmpty = this.pendingQuickStorage.isEmpty();
                                    wasSlowEmpty = this.pendingSlowStorage.isEmpty();
                                    ripestPending = expireQuickly ? this.pendingQuickStorage.addLast(data, this.getMaxCache()) : this.pendingSlowStorage.addLast(data, this.getMaxCache());
                                }
                                if (wasQuickEmpty && wasSlowEmpty) {
                                    wakeReason = "Added first pending";
                                    skipWakeReason = null;
                                } else if (expireQuickly) {
                                    if (!wasQuickEmpty) {
                                        wakeReason = null;
                                        skipWakeReason = "Quick added with other quick";
                                    } else {
                                        wakeReason = "Added first quick while slow are present";
                                        skipWakeReason = null;
                                    }
                                } else {
                                    wakeReason = null;
                                    skipWakeReason = "slow added with quick or slow";
                                }
                            }
                        }
                    } else {
                        throw data.unknownState();
                    }
                    state = data == null ? null : data.zipFileState;
                }
                if (ripestPending == null) break block41;
                String ripestPath = ripestPending.path;
                ZipFilePathLock zipFilePathLock2 = lock2 = this.getLockForPath(ripestPath);
                synchronized (zipFilePathLock2) {
                    ZipFileData checkData = (ZipFileData)this.storage.get(ripestPath);
                    if (checkData == ripestPending && checkData.isPending()) {
                        ZipFileData pendingCheckData;
                        pendingStorageLock = this.pendingStorageLock;
                        synchronized (pendingStorageLock) {
                            pendingCheckData = checkData.expireQuickly ? this.pendingQuickStorage.get(ripestPath) : this.pendingSlowStorage.get(ripestPath);
                        }
                        if (pendingCheckData == null) {
                            this.fullyClose(ripestPending, closeAt, false);
                        }
                    }
                }
            }
            finally {
                this.reaperLock.releaseReadLock();
            }
        }
        if (wakeReason != null) {
            this.reaperLock.notify(methodName, wakeReason);
        } else if (skipWakeReason != null) {
            this.reaperLock.skipNotify(methodName, skipWakeReason);
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void introspect(PrintWriter output, long introspectAt) {
        block16: {
            this.reaperLock.acquireReadLock();
            try {
                output.println();
                output.println("  IsActive [ " + Boolean.valueOf(this.isActive) + " ]");
                output.println("  Initial  [ " + ZipFileReaper.toAbsSec_s(this.initialAt) + " ]");
                output.println("  Final    [ " + ZipFileReaper.toAbsSec_s(this.finalAt) + " ]");
                output.println("  Current  [ " + ZipFileReaper.toAbsSec_s(introspectAt) + " ]");
                this.introspectReaperThread(output);
                output.println();
                output.println("Active and Pending Data:");
                if (this.storage.isEmpty()) {
                    output.println("  ** NONE **");
                } else {
                    for (Map.Entry entry : this.storage.entrySet()) {
                        output.println();
                        ZipFilePathLock zipFilePathLock = this.getLockForPath((String)entry.getKey());
                        synchronized (zipFilePathLock) {
                            ((ZipFileData)entry.getValue()).introspect(output, introspectAt);
                        }
                    }
                }
                Object object = this.pendingStorageLock;
                synchronized (object) {
                    this.pendingQuickStorage.introspect(output, false, introspectAt);
                    this.pendingSlowStorage.introspect(output, false, introspectAt);
                }
                if (this.completedStorage == null) {
                    output.println();
                    output.println("Completed zip file data is not being tracked");
                    break block16;
                }
                object = this.completedStorage;
                synchronized (object) {
                    this.completedStorage.introspect(output, true, introspectAt);
                }
            }
            finally {
                this.reaperLock.releaseReadLock();
            }
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        logThread.setDaemon(true);
        logThread.start();
        NULL_ERROR_HANDLER = null;
        refQueue = new ReferenceQueue();
        zipFilePathLockMap = new ConcurrentHashMap();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class ReaperLock {
        final ReadWriteLock rwLock = new ReentrantReadWriteLock();
        final Condition condition = this.rwLock.writeLock().newCondition();
        final Reasons lockReasons = new Reasons("Reaper Lock Activity");
        static final long serialVersionUID = -2007151558679520981L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public void addReason(String reason) {
            this.lockReasons.add(reason);
        }

        public void introspect(PrintWriter printWriter) {
            this.lockReasons.introspect(printWriter);
        }

        public void skipNotify(String methodName, String text) {
            this.addReason(text);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " " + text), (Object[])new Object[0]);
            }
        }

        @Trivial
        void acquireWriteLock() {
            this.rwLock.writeLock().lock();
        }

        @Trivial
        void releaseWriteLock() {
            this.rwLock.writeLock().unlock();
        }

        @Trivial
        void acquireReadLock() {
            this.rwLock.readLock().lock();
        }

        @Trivial
        void releaseReadLock() {
            this.rwLock.readLock().unlock();
        }

        void notify(String methodName, String text) {
            this.addReason(text);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " " + text), (Object[])new Object[0]);
            }
            this.rwLock.writeLock().lock();
            try {
                this.condition.signal();
            }
            finally {
                this.rwLock.writeLock().unlock();
            }
        }

        void wait(String methodName, String text) throws InterruptedException {
            this.addReason(text);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " Waiting for [ " + text + " ]"), (Object[])new Object[0]);
            }
            this.condition.await();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " Waited for [ " + text + " ]"), (Object[])new Object[0]);
            }
        }

        void waitNS(long waitNs, String methodName, String text) throws InterruptedException {
            this.addReason(text);
            long waitMs = waitNs / 1000000L;
            int fracWaitNs = (int)(waitNs - waitMs * 1000000L);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " Waiting [ " + Long.toString(waitMs) + " (ms) " + Integer.toString(fracWaitNs) + " (ns) ] for [ " + text + " ]"), (Object[])new Object[0]);
            }
            if (waitMs == 0L && fracWaitNs == 0) {
                throw new IllegalArgumentException(methodName + ": Invalid zero wait request for [ " + text + " ]");
            }
            this.condition.await(waitNs, TimeUnit.NANOSECONDS);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " Waited [ " + Long.toString(waitMs) + " (ms) " + Integer.toString(fracWaitNs) + " (ns) ] for [ " + text + " ]"), (Object[])new Object[0]);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.zip.cache.internal.ZipFileReaper$ReaperLock", ReaperLock.class, (String)"archive.artifact", null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class Reasons {
        private final String description;
        private int nextReason;
        public final String[] reasons;
        static final long serialVersionUID = 3825694454729853907L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public Reasons(String description) {
            this.description = description;
            this.reasons = new String[10];
            this.nextReason = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(String reason) {
            String[] stringArray = this.reasons;
            synchronized (this.reasons) {
                this.reasons[this.nextReason] = reason;
                this.nextReason = this.nextReason == 9 ? 0 : ++this.nextReason;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void introspect(PrintWriter printWriter) {
            printWriter.println(this.description + ": ");
            String[] stringArray = this.reasons;
            synchronized (this.reasons) {
                int lastReason;
                int n = lastReason = this.nextReason == 0 ? 9 : this.nextReason - 1;
                if (this.reasons[lastReason] == null) {
                    printWriter.println("  *** NONE ***");
                } else {
                    for (int reasonNo = 0; reasonNo > -10; --reasonNo) {
                        String reason;
                        int actualReasonNo = this.nextReason + reasonNo - 1;
                        if (actualReasonNo < 0) {
                            actualReasonNo += 10;
                        }
                        if ((reason = this.reasons[actualReasonNo]) == null) break;
                        printWriter.println("  [ " + reasonNo + " ] [ " + this.reasons[actualReasonNo] + " ]");
                    }
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.zip.cache.internal.ZipFileReaper$Reasons", Reasons.class, (String)"archive.artifact", null);
        }
    }

    public static interface ErrorConsumer<T> {
        public void accept(T var1);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static final class ZipFilePathLockRef
    extends WeakReference<ZipFilePathLock> {
        final String key;
        static final long serialVersionUID = -3298162071915756235L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Trivial
        public ZipFilePathLockRef(ZipFilePathLock referent, String keyValue) {
            super(referent, refQueue);
            this.key = keyValue;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.zip.cache.internal.ZipFileReaper$ZipFilePathLockRef", ZipFilePathLockRef.class, (String)"archive.artifact", null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static final class ZipFilePathLock {
        static final long serialVersionUID = -6891568956178148500L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private ZipFilePathLock() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.zip.cache.internal.ZipFileReaper$ZipFilePathLock", ZipFilePathLock.class, (String)"archive.artifact", null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class PendingStorageLock {
        static final long serialVersionUID = -5123816833460318529L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private PendingStorageLock() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.zip.cache.internal.ZipFileReaper$PendingStorageLock", PendingStorageLock.class, (String)"archive.artifact", null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class ReaperShutdownRunnable
    implements Runnable {
        private final Thread reaperThread;
        static final long serialVersionUID = -4710337470754673672L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Trivial
        public ReaperShutdownRunnable(Thread reaperThread) {
            this.reaperThread = reaperThread;
        }

        @Trivial
        private Thread getReaperThread() {
            return this.reaperThread;
        }

        @Override
        public void run() {
            Thread useReaperThread = this.getReaperThread();
            useReaperThread.interrupt();
            try {
                useReaperThread.join();
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.artifact.zip.cache.internal.ZipFileReaper$ReaperShutdownRunnable", (String)"769", (Object)this, (Object[])new Object[0]);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.zip.cache.internal.ZipFileReaper$ReaperShutdownRunnable", ReaperShutdownRunnable.class, (String)"archive.artifact", null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class ReaperRunnable
    implements Runnable {
        private boolean didShutdownReap;
        private long shutdownReapAt;
        private long nextReapAt;
        private long lastReapAt;
        private long nextReapDelay;
        private String nextReapReason;
        private final CountDownLatch startupLatch;
        private final ZipFileReaper reaper;
        public static final long STALL_LIMIT = 10000000000L;
        static final long serialVersionUID = -3417611959388174435L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Trivial
        public ReaperRunnable(ZipFileReaper reaper) {
            this.reaper = reaper;
            this.didShutdownReap = false;
            this.shutdownReapAt = -1L;
            this.nextReapAt = -1L;
            this.lastReapAt = -1L;
            this.nextReapDelay = -1L;
            this.startupLatch = new CountDownLatch(1);
        }

        void waitForStartup() throws InterruptedException {
            this.startupLatch.await();
        }

        private void signalStartup() {
            this.startupLatch.countDown();
        }

        void introspect(PrintWriter output) {
            output.println();
            output.println("  Runner [ " + this + " ]");
            output.println("    Initial    [ " + ZipFileReaper.toAbsSec_s(this.reaper.getInitialAt()) + " ]");
            if (this.reaper.getIsFinal()) {
                output.println("    Final      [ " + this.reaper.fromInitial_s(this.reaper.getFinalAt()) + " ]");
            }
            if (this.didShutdownReap) {
                output.println("    Shutdown   [ " + this.reaper.fromInitial_s(this.shutdownReapAt) + " ]");
            }
            output.println("    Last Reap  [ " + this.reaper.fromInitial_s(this.lastReapAt) + " ]");
            output.println("    Next Reap  [ " + this.reaper.fromInitial_s(this.nextReapAt) + " ]");
            String delayText = this.nextReapDelay < 0L ? "INDEFINITE" : ZipFileReaper.toAbsSec_s(this.nextReapDelay);
            output.println("    Next Delay [ " + delayText + " ] (" + this.nextReapReason + ")");
            output.println();
            output.println("  Logger [ " + logThread + " ]");
        }

        @Trivial
        public ZipFileReaper getReaper() {
            return this.reaper;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Trivial
        public void run() {
            boolean doDebug;
            String methodName = "run";
            boolean bl = doDebug = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
            if (doDebug) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " Start [ " + ZipFileReaper.toAbsSec_s(this.reaper.getInitialAt()) + " ]"), (Object[])new Object[0]);
            }
            this.reaper.reaperLock.acquireWriteLock();
            try {
                this.signalStartup();
                this.nextReapDelay = -1L;
                this.reaper.addWaitReason("indefinite (initial)");
                this.nextReapAt = this.reaper.getInitialAt();
                this.nextReapReason = "indefinite (initial)";
                while (true) {
                    long pendMax;
                    ZipFileData ripestPending;
                    String errorMessage;
                    this.lastReapAt = this.nextReapAt;
                    ZipFileData testPending = this.reaper.getRipest();
                    if (this.nextReapDelay < 0L) {
                        if (testPending != null) {
                            errorMessage = "Indefinite wait with pending [ " + testPending + " ]";
                            this.nextReapReason = "specific (corrected from indefinite) [ " + this.nextReapDelay + " ]";
                            this.nextReapDelay = this.reaper.getQuickPendMin();
                            this.reaper.addWaitReason("specific (corrected from indefinite)");
                        } else {
                            errorMessage = null;
                            this.nextReapReason = "indefinite (no pending)";
                        }
                    } else if (this.nextReapDelay == 0L) {
                        errorMessage = "Incorrect explicit indefinited wait [ " + testPending + " ]";
                        if (testPending == null) {
                            this.nextReapDelay = -1L;
                            this.nextReapReason = "indefinite (corrected from zero)";
                            this.reaper.addWaitReason("indefinite (corrected from zero)");
                        } else {
                            this.nextReapDelay = this.reaper.getQuickPendMin();
                            this.nextReapReason = "specific (corrected from zero)";
                            this.reaper.addWaitReason("specific (corrected from zero)");
                        }
                    } else {
                        errorMessage = null;
                        this.nextReapReason = testPending == null ? "specific (no pending)" : "specific [ " + this.nextReapDelay + " ]";
                    }
                    if (errorMessage != null) {
                        this.reaper.handleError(errorMessage);
                    }
                    try {
                        if (this.nextReapDelay < 0L) {
                            this.reaper.reaperLock.wait(methodName, "new pending close");
                        } else {
                            this.reaper.reaperLock.waitNS(this.nextReapDelay, methodName, "active pending close");
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.artifact.zip.cache.internal.ZipFileReaper$ReaperRunnable", (String)"446", (Object)this, (Object[])new Object[0]);
                        if (doDebug) {
                            Tr.debug((TraceComponent)tc, (String)(methodName + " Interrupted!"), (Object[])new Object[0]);
                        }
                        break;
                    }
                    this.nextReapAt = System.nanoTime();
                    if (doDebug) {
                        long overage;
                        Tr.debug((TraceComponent)tc, (String)(methodName + " Reap [ " + this.reaper.fromInitial_s(this.nextReapAt) + " ]"), (Object[])new Object[0]);
                        long actualReapDelay = this.nextReapAt - this.lastReapAt;
                        String message = this.nextReapDelay > 0L ? ((overage = actualReapDelay - this.nextReapDelay) > 10000000000L ? " Excessive reap cycle time:" : " Reap cycle time:") : " Reap cycle time:";
                        Tr.debug((TraceComponent)tc, (String)(methodName + message + " Actual delay [ " + ZipFileReaper.toAbsSec_s(actualReapDelay) + " ]; Requested delay [ " + ZipFileReaper.toAbsSec_s(this.nextReapDelay) + " ]"), (Object[])new Object[0]);
                    }
                    if ((ripestPending = this.reaper.getRipest()) == null) {
                        if (doDebug) {
                            Tr.debug((TraceComponent)tc, (String)(methodName + " No pending!"), (Object[])new Object[0]);
                        }
                        this.nextReapDelay = -1L;
                        this.reaper.addWaitReason("indefinite (no pending)");
                        continue;
                    }
                    long lastPendAt = ripestPending.lastPendAt;
                    long consumedPend = this.nextReapAt - lastPendAt;
                    long l = pendMax = ripestPending.expireQuickly ? this.reaper.getQuickPendMin() : this.reaper.getSlowPendMax();
                    if (consumedPend < pendMax) {
                        this.nextReapDelay = pendMax - consumedPend;
                        this.reaper.addWaitReason("specific (incomplete pend)");
                        if (!doDebug) continue;
                        Tr.debug((TraceComponent)tc, (String)(methodName + " Ripest [ " + ripestPending.path + " ] waited [ " + ZipFileReaper.toAbsSec_s(consumedPend) + " ] remaining [ " + ZipFileReaper.toAbsSec_s(this.nextReapDelay) + " ]"), (Object[])new Object[0]);
                        continue;
                    }
                    if (doDebug) {
                        Tr.debug((TraceComponent)tc, (String)(methodName + " Ripest [ " + ripestPending.path + " ] waited [ " + ZipFileReaper.toAbsSec_s(consumedPend) + " ]"), (Object[])new Object[0]);
                    }
                    this.nextReapDelay = this.reaper.reap(this.nextReapAt, false);
                    this.reaper.addWaitReason("specific (reap)");
                }
            }
            finally {
                this.reaper.reaperLock.releaseWriteLock();
            }
            long shutdownAt = System.nanoTime();
            if (doDebug) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " Shutting down [ " + this.reaper.fromInitial_s(shutdownAt) + " ]"), (Object[])new Object[0]);
            }
            this.reaper.reaperLock.acquireWriteLock();
            try {
                this.reaper.reap(shutdownAt, true);
            }
            finally {
                this.reaper.reaperLock.releaseWriteLock();
            }
            long stopAt = System.nanoTime();
            if (doDebug) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " Stop [ " + this.reaper.fromInitial_s(stopAt) + " ]"), (Object[])new Object[0]);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.zip.cache.internal.ZipFileReaper$ReaperRunnable", ReaperRunnable.class, (String)"archive.artifact", null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class DeferredLogEmitter
    implements Runnable {
        private final BlockingQueue<DeferredLogRecord> deferredLogQueue = new LinkedBlockingQueue<DeferredLogRecord>();
        static final long serialVersionUID = -4569900396467865701L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        public void run() {
            try {
                while (true) {
                    this.take().emit();
                }
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.artifact.zip.cache.internal.ZipFileReaper$DeferredLogEmitter", (String)"230", (Object)this, (Object[])new Object[0]);
                return;
            }
        }

        public void post(String msgKey, Object ... msgArgs) {
            try {
                this.deferredLogQueue.put(new DeferredLogRecord(msgKey, msgArgs));
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.artifact.zip.cache.internal.ZipFileReaper$DeferredLogEmitter", (String)"245", (Object)this, (Object[])new Object[]{msgKey, msgArgs});
            }
        }

        public DeferredLogRecord take() throws InterruptedException {
            return this.deferredLogQueue.take();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.zip.cache.internal.ZipFileReaper$DeferredLogEmitter", DeferredLogEmitter.class, (String)"archive.artifact", null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class DeferredLogRecord {
        private final String msgKey;
        private final Object[] msgArgs;
        static final long serialVersionUID = -3088694982418321168L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public DeferredLogRecord(String msgKey, Object ... msgArgs) {
            this.msgKey = msgKey;
            this.msgArgs = msgArgs;
        }

        public void emit() {
            Tr.warning((TraceComponent)tc, (String)this.msgKey, (Object[])this.msgArgs);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.zip.cache.internal.ZipFileReaper$DeferredLogRecord", DeferredLogRecord.class, (String)"archive.artifact", null);
        }
    }
}

