/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.admin.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.config.admin.internal.ConfigAdminServiceFactory;
import com.ibm.ws.config.admin.internal.ConfigurationStore;
import com.ibm.ws.config.admin.internal.ExtendedConfigurationImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.util.tracker.ServiceTracker;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class ManagedServiceTracker
extends ServiceTracker<ManagedService, ManagedService> {
    private static final String ME = ManagedServiceTracker.class.getName();
    private static final TraceComponent tc = Tr.register(ManagedServiceTracker.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
    private final ConfigAdminServiceFactory caFactory;
    private final Map<String, ManagedService> managedServices = new HashMap<String, ManagedService>();
    private final Map<String, ServiceReference<ManagedService>> managedServiceReferences = new HashMap<String, ServiceReference<ManagedService>>();
    static final long serialVersionUID = -1361093010813248208L;

    public ManagedServiceTracker(ConfigAdminServiceFactory casf, BundleContext bc) {
        super(bc, ManagedService.class.getName(), null);
        this.caFactory = casf;
    }

    protected Future<?> notifyDeleted(ExtendedConfigurationImpl config) {
        config.checkLocked();
        String pid = config.getPid(false);
        ServiceReference<ManagedService> reference = this.getManagedServiceReference(pid);
        if (reference != null && config.bind(reference.getBundle())) {
            return this.asyncUpdated(this.getManagedService(pid), pid, null);
        }
        return null;
    }

    protected Future<?> notifyUpdated(ExtendedConfigurationImpl config) {
        config.checkLocked();
        String pid = config.getPid();
        ServiceReference<ManagedService> reference = this.getManagedServiceReference(pid);
        if (reference != null && config.bind(reference.getBundle())) {
            ManagedService ms = this.getManagedService(pid);
            Dictionary<String, Object> properties = config.getProperties();
            this.caFactory.modifyConfiguration(reference, properties, ms);
            return this.asyncUpdated(ms, pid, properties);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManagedService addingService(ServiceReference<ManagedService> reference) {
        String[] pids = ManagedServiceTracker.getServicePid(reference);
        if (pids == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("handleRegistration(): Invalid service.pid type: " + reference), (Object[])new Object[0]);
            }
            return null;
        }
        ManagedService ms = (ManagedService)this.context.getService(reference);
        if (ms == null) {
            return null;
        }
        ConfigurationStore configurationStore = this.caFactory.getConfigurationStore();
        synchronized (configurationStore) {
            for (String pid : pids) {
                this.add(reference, pid, ms);
            }
        }
        return ms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifiedService(ServiceReference<ManagedService> reference, ManagedService service) {
        String[] pids = ManagedServiceTracker.getServicePid(reference);
        List<Object> newPids = Collections.emptyList();
        if (pids != null) {
            newPids = Arrays.asList(pids);
        }
        ConfigurationStore configurationStore = this.caFactory.getConfigurationStore();
        synchronized (configurationStore) {
            List<String> previousPids = this.getPidsForManagedService(service);
            HashSet<String> prevSet = new HashSet<String>(previousPids);
            HashSet newSet = new HashSet(newPids);
            if (!prevSet.equals(newSet)) {
                for (String string : previousPids) {
                    if (newSet.contains(string)) continue;
                    this.remove(reference, string);
                }
                for (String string : newPids) {
                    if (prevSet.contains(string)) continue;
                    this.add(reference, string, service);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference<ManagedService> reference, ManagedService service) {
        String[] pids = ManagedServiceTracker.getServicePid(reference);
        if (pids == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("removedService(): Invalid service.pid type: " + reference), (Object[])new Object[0]);
            }
            return;
        }
        ConfigurationStore configurationStore = this.caFactory.getConfigurationStore();
        synchronized (configurationStore) {
            for (String pid : pids) {
                this.remove(reference, pid);
            }
        }
        this.context.ungetService(reference);
    }

    private static String[] getServicePid(ServiceReference<ManagedService> reference) {
        Object pidObj = reference.getProperty("service.pid");
        if (pidObj instanceof String) {
            return new String[]{(String)pidObj};
        }
        if (pidObj instanceof String[]) {
            return (String[])pidObj;
        }
        if (pidObj instanceof Collection) {
            Collection pidCollection = (Collection)pidObj;
            return pidCollection.toArray(new String[pidCollection.size()]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(ServiceReference<ManagedService> reference, String pid, ManagedService service) {
        ExtendedConfigurationImpl config = this.caFactory.getConfigurationStore().findConfiguration(pid);
        if (config == null) {
            if (this.trackManagedService(pid, reference, service)) {
                this.asyncUpdated(service, pid, null);
            }
        } else {
            config.lock();
            try {
                if (this.trackManagedService(pid, reference, service)) {
                    if (config.getFactoryPid(false) != null) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Configuration for service.pid=" + pid + " should only be used by a " + ManagedServiceFactory.class.getName()), (Object[])new Object[]{config});
                        }
                    } else if (config.isDeleted()) {
                        this.asyncUpdated(service, pid, null);
                    } else if (config.bind(reference.getBundle())) {
                        Dictionary<String, Object> properties = config.getProperties();
                        this.caFactory.modifyConfiguration(reference, properties, service);
                        this.asyncUpdated(service, pid, properties);
                    } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Configuration for service.pid=" + pid + " could not be bound to " + reference.getBundle().getLocation()), (Object[])new Object[0]);
                    }
                }
            }
            finally {
                config.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(ServiceReference<ManagedService> reference, String pid) {
        ExtendedConfigurationImpl config = this.caFactory.getConfigurationStore().findConfiguration(pid);
        if (config == null) {
            this.untrackManagedService(pid, reference);
        } else {
            config.lock();
            try {
                this.untrackManagedService(pid, reference);
            }
            finally {
                config.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean trackManagedService(String pid, ServiceReference<ManagedService> reference, ManagedService service) {
        Map<String, ServiceReference<ManagedService>> map = this.managedServiceReferences;
        synchronized (map) {
            if (this.managedServiceReferences.containsKey(pid)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(ManagedService.class.getName() + " already registered for " + "service.pid" + "=" + pid), (Object[])new Object[0]);
                }
                return false;
            }
            this.managedServiceReferences.put(pid, reference);
            this.managedServices.put(pid, service);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void untrackManagedService(String pid, ServiceReference<ManagedService> reference) {
        Map<String, ServiceReference<ManagedService>> map = this.managedServiceReferences;
        synchronized (map) {
            this.managedServiceReferences.remove(pid);
            this.managedServices.remove(pid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ManagedService getManagedService(String pid) {
        Map<String, ServiceReference<ManagedService>> map = this.managedServiceReferences;
        synchronized (map) {
            return this.managedServices.get(pid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceReference<ManagedService> getManagedServiceReference(String pid) {
        Map<String, ServiceReference<ManagedService>> map = this.managedServiceReferences;
        synchronized (map) {
            return this.managedServiceReferences.get(pid);
        }
    }

    private Future<?> asyncUpdated(final ManagedService service, final String pid, final Dictionary<String, ?> properties) {
        return this.caFactory.updateQueue.add(pid, new Runnable(){
            static final long serialVersionUID = -761992670364686064L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            /*
             * WARNING - void declaration
             */
            @Override
            public void run() {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("asyncUpdated: service.updated called for " + pid), (Object[])new Object[0]);
                }
                try {
                    service.updated(properties);
                }
                catch (Throwable throwable) {
                    void t;
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.config.admin.internal.ManagedServiceTracker$1", (String)"273", (Object)this, (Object[])new Object[0]);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"asyncUpdated(): Exception thrown while trying to update ManagedService.", (Object[])new Object[]{t});
                    }
                    FFDCFilter.processException((Throwable)t, (String)ME, (String)"asyncUpdated()", (Object[])new Object[]{pid, service});
                }
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.config.admin.internal.ManagedServiceTracker$1", 1.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getPidsForManagedService(ManagedService service) {
        ArrayList<String> pids = new ArrayList<String>();
        Map<String, ServiceReference<ManagedService>> map = this.managedServiceReferences;
        synchronized (map) {
            for (Map.Entry<String, ManagedService> entry : this.managedServices.entrySet()) {
                if (entry.getValue() != service) continue;
                pids.add(entry.getKey());
            }
        }
        return pids;
    }
}

