/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authorization.util;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authorization.util.UnauthenticatedException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.annotation.security.DenyAll;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class RoleMethodAuthUtil {
    private static final Logger LOG = Logger.getLogger(RoleMethodAuthUtil.class.getName());
    static final long serialVersionUID = -271993835459118614L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public RoleMethodAuthUtil() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("com.ibm.ws.security.authorization.util.RoleMethodAuthUtil", "<init>", new Object[0]);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("com.ibm.ws.security.authorization.util.RoleMethodAuthUtil", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void checkAuthentication(Principal principal) throws UnauthenticatedException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("com.ibm.ws.security.authorization.util.RoleMethodAuthUtil", "checkAuthentication", new Object[]{principal});
        }
        if (principal == null) {
            throw new UnauthenticatedException("principal is null");
        }
        if ("UNAUTHENTICATED".equals(principal.getName())) {
            throw new UnauthenticatedException("principal is UNAUTHENTICATED");
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("com.ibm.ws.security.authorization.util.RoleMethodAuthUtil", "checkAuthentication");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean parseMethodSecurity(Method method, Principal principal, Predicate<String> isUserInRoleFunction) throws UnauthenticatedException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("com.ibm.ws.security.authorization.util.RoleMethodAuthUtil", "parseMethodSecurity", new Object[]{method, principal, isUserInRoleFunction});
        }
        boolean denyAll = RoleMethodAuthUtil.getDenyAll(method);
        if (denyAll) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Found DenyAll for method: {} " + method.getName() + ", Injection Processing for web service is ignored");
            }
            boolean bl = false;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("com.ibm.ws.security.authorization.util.RoleMethodAuthUtil", "parseMethodSecurity", bl);
            }
            return bl;
        }
        RolesAllowed rolesAllowed = RoleMethodAuthUtil.getRolesAllowed(method);
        if (rolesAllowed != null) {
            boolean allowed;
            String[] theseroles = rolesAllowed.value();
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.log(Level.FINEST, "found RolesAllowed in method: {} " + method.getName(), new Object[]{theseroles});
            }
            if (allowed = Stream.of(theseroles).anyMatch(isUserInRoleFunction)) {
                boolean bl = true;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    bl = bl;
                    LOG.exiting("com.ibm.ws.security.authorization.util.RoleMethodAuthUtil", "parseMethodSecurity", bl);
                }
                return bl;
            }
            RoleMethodAuthUtil.checkAuthentication(principal);
            boolean bl = false;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("com.ibm.ws.security.authorization.util.RoleMethodAuthUtil", "parseMethodSecurity", bl);
            }
            return bl;
        }
        boolean permitAll = RoleMethodAuthUtil.getPermitAll(method);
        if (permitAll) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Found PermitAll for method: {}" + method.getName());
            }
            boolean bl = true;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("com.ibm.ws.security.authorization.util.RoleMethodAuthUtil", "parseMethodSecurity", bl);
            }
            return bl;
        }
        Class<?> cls = method.getDeclaringClass();
        boolean bl = RoleMethodAuthUtil.parseClassSecurity(cls, principal, isUserInRoleFunction);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("com.ibm.ws.security.authorization.util.RoleMethodAuthUtil", "parseMethodSecurity", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static boolean parseClassSecurity(Class<?> cls, Principal principal, Predicate<String> isUserInRoleFunction) throws UnauthenticatedException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("com.ibm.ws.security.authorization.util.RoleMethodAuthUtil", "parseClassSecurity", new Object[]{cls, principal, isUserInRoleFunction});
        }
        DenyAll denyAll = cls.getAnnotation(DenyAll.class);
        if (denyAll != null) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Found class level @DenyAll - authorization denied for " + cls.getName());
            }
            boolean bl = false;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("com.ibm.ws.security.authorization.util.RoleMethodAuthUtil", "parseClassSecurity", bl);
            }
            return bl;
        }
        RolesAllowed rolesAllowed = cls.getAnnotation(RolesAllowed.class);
        if (rolesAllowed != null) {
            boolean allowed;
            String[] theseroles = rolesAllowed.value();
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.log(Level.FINEST, "found RolesAllowed in class: {} " + cls.getName(), new Object[]{theseroles});
            }
            if (allowed = Stream.of(theseroles).anyMatch(isUserInRoleFunction)) {
                boolean bl = true;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    bl = bl;
                    LOG.exiting("com.ibm.ws.security.authorization.util.RoleMethodAuthUtil", "parseClassSecurity", bl);
                }
                return bl;
            }
            RoleMethodAuthUtil.checkAuthentication(principal);
            boolean bl = false;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("com.ibm.ws.security.authorization.util.RoleMethodAuthUtil", "parseClassSecurity", bl);
            }
            return bl;
        }
        boolean bl = true;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("com.ibm.ws.security.authorization.util.RoleMethodAuthUtil", "parseClassSecurity", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static RolesAllowed getRolesAllowed(Method method) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("com.ibm.ws.security.authorization.util.RoleMethodAuthUtil", "getRolesAllowed", new Object[]{method});
        }
        RolesAllowed rolesAllowed = method.getAnnotation(RolesAllowed.class);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            rolesAllowed = rolesAllowed;
            LOG.exiting("com.ibm.ws.security.authorization.util.RoleMethodAuthUtil", "getRolesAllowed", rolesAllowed);
        }
        return rolesAllowed;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static boolean getPermitAll(Method method) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("com.ibm.ws.security.authorization.util.RoleMethodAuthUtil", "getPermitAll", new Object[]{method});
        }
        boolean bl = method.isAnnotationPresent(PermitAll.class);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("com.ibm.ws.security.authorization.util.RoleMethodAuthUtil", "getPermitAll", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static boolean getDenyAll(Method method) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("com.ibm.ws.security.authorization.util.RoleMethodAuthUtil", "getDenyAll", new Object[]{method});
        }
        boolean bl = method.isAnnotationPresent(DenyAll.class);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("com.ibm.ws.security.authorization.util.RoleMethodAuthUtil", "getDenyAll", bl);
        }
        return bl;
    }
}

