/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.module.ejb;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Set;
import javax.ejb.Timeout;
import javax.enterprise.inject.spi.BeanAttributes;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.annotated.slim.SlimAnnotatedTypeStore;
import org.jboss.weld.annotated.slim.backed.BackedAnnotatedType;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.bean.interceptor.InterceptorBindingsAdapter;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.ejb.spi.EjbDescriptor;
import org.jboss.weld.ejb.spi.EjbServices;
import org.jboss.weld.injection.producer.BasicInjectionTarget;
import org.jboss.weld.injection.producer.ConstructorInterceptionInstantiator;
import org.jboss.weld.injection.producer.DefaultInstantiator;
import org.jboss.weld.injection.producer.Instantiator;
import org.jboss.weld.injection.producer.InterceptionModelInitializer;
import org.jboss.weld.injection.producer.InterceptorApplyingInstantiator;
import org.jboss.weld.injection.producer.SubclassedComponentInstantiator;
import org.jboss.weld.interceptor.spi.model.InterceptionModel;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.module.EjbSupport;
import org.jboss.weld.module.ejb.EjbDescriptors;
import org.jboss.weld.module.ejb.EnterpriseBeanInstance;
import org.jboss.weld.module.ejb.InternalEjbDescriptor;
import org.jboss.weld.module.ejb.NewSessionBean;
import org.jboss.weld.module.ejb.SessionBeanImpl;
import org.jboss.weld.module.ejb.SessionBeanInjectionTarget;
import org.jboss.weld.module.ejb.SessionBeans;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.Preconditions;
import org.jboss.weld.util.collections.SetMultimap;
import org.jboss.weld.util.reflection.Reflections;

class EjbSupportImpl
implements EjbSupport {
    private final EjbServices ejbServices;
    private final EjbDescriptors ejbDescriptors;

    EjbSupportImpl(EjbServices ejbServices, Collection<EjbDescriptor<?>> descriptors) {
        this.ejbServices = ejbServices;
        this.ejbDescriptors = new EjbDescriptors(descriptors);
    }

    @Override
    public void cleanup() {
    }

    @Override
    public <T> BasicInjectionTarget<T> createSessionBeanInjectionTarget(EnhancedAnnotatedType<T> type, SessionBean<T> bean, BeanManagerImpl beanManager) {
        return SessionBeanInjectionTarget.of(type, bean, beanManager);
    }

    @Override
    public <T> BasicInjectionTarget<T> createMessageDrivenInjectionTarget(EnhancedAnnotatedType<T> type, EjbDescriptor<T> d, BeanManagerImpl manager) {
        InternalEjbDescriptor<T> descriptor = InternalEjbDescriptor.of(d);
        EnhancedAnnotatedType<T> implementationClass = SessionBeans.getEjbImplementationClass(descriptor, manager, type);
        Instantiator<T> instantiator = null;
        instantiator = type.equals(implementationClass) ? new DefaultInstantiator<T>(type, null, manager) : SubclassedComponentInstantiator.forSubclassedEjb(type, implementationClass, null, manager);
        InterceptionModel interceptionModel = (InterceptionModel)manager.getInterceptorModelRegistry().get(type.slim());
        if (interceptionModel != null) {
            if (interceptionModel.hasExternalNonConstructorInterceptors()) {
                instantiator = SubclassedComponentInstantiator.forInterceptedDecoratedBean(implementationClass, null, instantiator, manager);
                instantiator = new InterceptorApplyingInstantiator<T>(instantiator, interceptionModel, type.slim());
            }
            if (interceptionModel.hasExternalConstructorInterceptors()) {
                instantiator = new ConstructorInterceptionInstantiator<T>(instantiator, interceptionModel, type.slim());
            }
        }
        return BasicInjectionTarget.createDefault(type, null, manager, instantiator);
    }

    @Override
    public <T> BeanAttributes<T> createSessionBeanAttributes(EnhancedAnnotatedType<T> annotated, BeanManagerImpl manager) {
        InternalEjbDescriptor descriptor = this.ejbDescriptors.getUnique(annotated.getJavaClass());
        Preconditions.checkArgument(descriptor != null, annotated.getJavaClass() + " is not an EJB.");
        return this.createSessionBeanAttributes(annotated, descriptor, manager);
    }

    private <T> BeanAttributes<T> createSessionBeanAttributes(EnhancedAnnotatedType<T> annotated, InternalEjbDescriptor<?> descriptor, BeanManagerImpl manager) {
        return SessionBeans.createBeanAttributes(annotated, descriptor, manager);
    }

    @Override
    public void createSessionBeans(BeanDeployerEnvironment environment, SetMultimap<Class<?>, SlimAnnotatedType<?>> types, BeanManagerImpl manager) {
        ClassTransformer transformer = manager.getServices().get(ClassTransformer.class);
        for (InternalEjbDescriptor<?> ejbDescriptor : this.getEjbDescriptors()) {
            if (environment.isVetoed(ejbDescriptor.getBeanClass()) || Beans.isVetoed(ejbDescriptor.getBeanClass()) || !ejbDescriptor.isSingleton() && !ejbDescriptor.isStateful() && !ejbDescriptor.isStateless()) continue;
            Set classes = (Set)types.get((Object)ejbDescriptor.getBeanClass());
            if (!classes.isEmpty()) {
                for (SlimAnnotatedType annotatedType : classes) {
                    this.createSessionBean(ejbDescriptor, annotatedType, environment, manager, transformer);
                }
                continue;
            }
            this.createSessionBean(ejbDescriptor, environment, manager, transformer);
        }
    }

    private <T> SessionBean<T> createSessionBean(InternalEjbDescriptor<?> descriptor, SlimAnnotatedType<T> slimType, BeanDeployerEnvironment environment, BeanManagerImpl manager, ClassTransformer transformer) {
        EnhancedAnnotatedType<T> type = transformer.getEnhancedAnnotatedType(slimType);
        BeanAttributes<T> attributes = this.createSessionBeanAttributes(type, descriptor, manager);
        SessionBean<T> bean = SessionBeanImpl.of(attributes, (InternalEjbDescriptor)Reflections.cast(descriptor), manager, type);
        environment.addSessionBean(bean);
        return bean;
    }

    protected <T> SessionBean<T> createSessionBean(InternalEjbDescriptor<T> descriptor, BeanDeployerEnvironment environment, BeanManagerImpl manager, ClassTransformer transformer) {
        BackedAnnotatedType type = transformer.getBackedAnnotatedType(descriptor.getBeanClass(), manager.getId());
        manager.getServices().get(SlimAnnotatedTypeStore.class).put(type);
        return this.createSessionBean(descriptor, type, environment, manager, transformer);
    }

    @Override
    public void createNewSessionBeans(BeanDeployerEnvironment environment, BeanManagerImpl manager) {
        SlimAnnotatedTypeStore store = manager.getServices().get(SlimAnnotatedTypeStore.class);
        ClassTransformer classTransformer = manager.getServices().get(ClassTransformer.class);
        for (Type type : environment.getNewBeanTypes()) {
            Class clazz = Reflections.getRawType(type);
            if (!this.isEjb(clazz)) continue;
            EnhancedAnnotatedType enhancedType = classTransformer.getEnhancedAnnotatedType(clazz, type, manager.getId());
            InternalEjbDescriptor descriptor = this.ejbDescriptors.getUnique(clazz);
            environment.addSessionBean(this.createNewSessionBean(enhancedType, descriptor, manager, store));
        }
    }

    private <T> SessionBean<T> createNewSessionBean(EnhancedAnnotatedType<?> type, InternalEjbDescriptor<T> ejbDescriptor, BeanManagerImpl beanManager, SlimAnnotatedTypeStore store) {
        store.put(type.slim());
        BeanAttributes attributes = (BeanAttributes)Reflections.cast(SessionBeans.createBeanAttributesForNew(type, ejbDescriptor, beanManager, type.getJavaClass()));
        return NewSessionBean.of(attributes, ejbDescriptor, beanManager);
    }

    @Override
    public Class<? extends Annotation> getTimeoutAnnotation() {
        return Timeout.class;
    }

    @Override
    public void registerCdiInterceptorsForMessageDrivenBeans(BeanDeployerEnvironment environment, BeanManagerImpl manager) {
        for (InternalEjbDescriptor<?> descriptor : this.getEjbDescriptors()) {
            InterceptionModel model;
            if (!descriptor.isMessageDriven()) continue;
            EnhancedAnnotatedType type = manager.getServices().getRequired(ClassTransformer.class).getEnhancedAnnotatedType(descriptor.getBeanClass(), manager.getId());
            if (!manager.getInterceptorModelRegistry().containsKey(type.slim())) {
                InterceptionModelInitializer.of(manager, type, null).init();
            }
            if ((model = (InterceptionModel)manager.getInterceptorModelRegistry().get(type.slim())) == null) continue;
            this.ejbServices.registerInterceptors(descriptor.delegate(), new InterceptorBindingsAdapter(model));
        }
    }

    public Collection<InternalEjbDescriptor<?>> getEjbDescriptors() {
        return this.ejbDescriptors.getAll();
    }

    @Override
    public boolean isEjb(Class<?> beanClass) {
        return this.ejbDescriptors.contains(beanClass);
    }

    public <T> InternalEjbDescriptor<T> getEjbDescriptor(String beanName) {
        return this.ejbDescriptors.get(beanName);
    }

    @Override
    public boolean isSessionBeanProxy(Object instance) {
        return instance instanceof EnterpriseBeanInstance;
    }
}

