/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.jitdeploy;

import com.ibm.ejs.container.EJBConfigurationException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ejbcontainer.jitdeploy.JITUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.ejb.EntityBean;

public final class EJBUtils {
    private static final TraceComponent tc = Tr.register(EJBUtils.class, (String)"JITDeploy", (String)"com.ibm.ejs.container.container");

    static int getMethodId(Method method, Method[] allMethods, int startIndex) {
        int i;
        int numMethods = allMethods.length;
        for (i = startIndex; i < numMethods; ++i) {
            if (!EJBUtils.methodsMatch(method, allMethods[i])) continue;
            return i;
        }
        for (i = 0; i < startIndex; ++i) {
            if (!EJBUtils.methodsMatch(method, allMethods[i])) continue;
            return i;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getMethodId: start = " + startIndex), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("getMethodId: method = " + method), (Object[])new Object[0]);
            for (i = 0; i < numMethods; ++i) {
                Tr.debug((TraceComponent)tc, (String)("getMethodId: [" + i + "] = " + allMethods[i]), (Object[])new Object[0]);
            }
        }
        throw new RuntimeException("Internal Error: Method not found: " + method);
    }

    static boolean methodsMatch(Method m1, Method m2) {
        Class<?>[] parms2;
        Class<?>[] parms1;
        if (m1 == m2) {
            return true;
        }
        if (m1.getName().equals(m2.getName()) && (parms1 = m1.getParameterTypes()).length == (parms2 = m2.getParameterTypes()).length) {
            int length = parms1.length;
            for (int i = 0; i < length; ++i) {
                if (parms1[i] == parms2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    static void validateEjbClass(Class<?> ejbClass, String beanName, int beanType) throws EJBConfigurationException {
        int modifiers = ejbClass.getModifiers();
        if (!Modifier.isPublic(modifiers)) {
            Tr.error((TraceComponent)tc, (String)"JIT_NON_PUBLIC_CLASS_CNTR5003E", (Object[])new Object[]{beanName, ejbClass.getName()});
            throw new EJBConfigurationException("EJB class " + ejbClass.getName() + " must be defined as public : " + beanName);
        }
        if (Modifier.isFinal(modifiers)) {
            Tr.error((TraceComponent)tc, (String)"JIT_INVALID_FINAL_CLASS_CNTR5004E", (Object[])new Object[]{beanName, ejbClass.getName()});
            throw new EJBConfigurationException("EJB class " + ejbClass.getName() + " must not be defined as final : " + beanName);
        }
        if (beanType != 6 && Modifier.isAbstract(modifiers)) {
            Tr.error((TraceComponent)tc, (String)"JIT_INVALID_ABSTRACT_CLASS_CNTR5005E", (Object[])new Object[]{beanName, ejbClass.getName()});
            throw new EJBConfigurationException("EJB class " + ejbClass.getName() + " must not be defined as abstract : " + beanName);
        }
        if (ejbClass.getEnclosingClass() != null) {
            Tr.error((TraceComponent)tc, (String)"JIT_NOT_TOP_LEVEL_CLASS_CNTR5006E", (Object[])new Object[]{beanName, ejbClass.getName()});
            throw new EJBConfigurationException("EJB class " + ejbClass.getName() + " must be a top level class : " + beanName);
        }
        try {
            ejbClass.getConstructor(JITUtils.NO_PARAMS);
        }
        catch (Throwable ex) {
            Tr.error((TraceComponent)tc, (String)"JIT_NO_DEFAULT_CTOR_CNTR5007E", (Object[])new Object[]{beanName, ejbClass.getName()});
            throw new EJBConfigurationException("EJB class " + ejbClass.getName() + " must have a public constructor that takes no parameters : " + beanName, ex);
        }
        try {
            ejbClass.getDeclaredMethod("finalize", JITUtils.NO_PARAMS);
            Tr.error((TraceComponent)tc, (String)"JIT_INVALID_FINALIZE_MTHD_CNTR5008E", (Object[])new Object[]{beanName, ejbClass.getName()});
            throw new EJBConfigurationException("EJB class " + ejbClass.getName() + " must not define the finalize() method : " + beanName);
        }
        catch (Throwable throwable) {
            if (!(beanType != 5 && beanType != 6 || EntityBean.class.isAssignableFrom(ejbClass))) {
                Tr.error((TraceComponent)tc, (String)"JIT_MISSING_ENTITYBEAN_CNTR5009E", (Object[])new Object[]{beanName, ejbClass.getName()});
                throw new EJBConfigurationException("EJB Entity class " + ejbClass.getName() + " must implement javax.ejb.EntityBean : " + beanName);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("validateEjbClass : successful : " + ejbClass.getName()), (Object[])new Object[0]);
            }
            return;
        }
    }
}

