/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TrConfigurator;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.kernel.security.thread.ThreadIdentityManager;
import com.ibm.ws.logging.internal.impl.BaseTraceService;
import com.ibm.ws.logging.internal.impl.CountingOutputStream;
import com.ibm.ws.logging.internal.impl.FileLogHeader;
import com.ibm.ws.logging.internal.impl.FileLogSet;
import com.ibm.ws.logging.internal.impl.LoggingConstants;
import com.ibm.ws.logging.internal.impl.LoggingFileUtils;
import com.ibm.wsspi.logging.TextFileOutputStreamFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Calendar;

public class FileLogHolder
implements BaseTraceService.TraceWriter {
    public static final boolean NEW_LOGS_ON_START_DEFAULT = true;
    public static final String NEW_LOGS_ON_START_PROPERTY = "com.ibm.ws.logging.newLogsOnStart";
    private static final boolean IS_UNIT_TEST = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            return Boolean.getBoolean("com.ibm.ws.is.unit.test");
        }
    });
    private static TraceComponent tc = null;
    protected FileOutputStream currentFileStream;
    protected CountingOutputStream currentCountingStream;
    private PrintStream currentPrintStream;
    protected StreamStatus currentStatus;
    private final FileLogHeader logHeader;
    protected final FileLogSet fileLogSet = new FileLogSet(true);
    protected long maxFileSizeBytes;
    protected final boolean newLogsOnStart;
    private Long checkTime = null;
    private Long retryTime = null;

    private static TraceComponent getTc() {
        if (tc == null) {
            tc = Tr.register(FileLogHolder.class, null, "com.ibm.ws.logging.internal.resources.LoggingMessages");
        }
        return tc;
    }

    public static FileLogHolder createFileLogHolder(BaseTraceService.TraceWriter oldLog, FileLogHeader logHeader, File logDirectory, String newFileName, int maxFiles, long maxSizeBytes) {
        return FileLogHolder.createFileLogHolder(oldLog, logHeader, logDirectory, newFileName, maxFiles, maxSizeBytes, true, false);
    }

    public static FileLogHolder createFileLogHolder(BaseTraceService.TraceWriter oldLog, FileLogHeader logHeader, File logDirectory, String newFileName, int maxFiles, long maxSizeBytes, boolean newLogsOnStart, boolean isRestore) {
        FileLogHolder logHolder;
        String fileExtension;
        String fileName;
        int dio;
        int lio = newFileName.lastIndexOf("/");
        if (lio > 0) {
            newFileName = newFileName.substring(lio + 1);
        }
        if (File.separatorChar != '/' && (lio = newFileName.lastIndexOf(File.separatorChar)) > 0) {
            newFileName = newFileName.substring(lio + 1);
        }
        if ((dio = newFileName.lastIndexOf(".")) > 0) {
            fileName = newFileName.substring(0, dio);
            fileExtension = newFileName.substring(dio);
        } else {
            fileName = newFileName;
            fileExtension = "";
        }
        if (oldLog != null && oldLog instanceof FileLogHolder) {
            logHolder = (FileLogHolder)oldLog;
            logHolder.update(logDirectory, fileName, fileExtension, maxFiles, maxSizeBytes, isRestore);
        } else {
            if (oldLog != null) {
                try {
                    oldLog.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            logHolder = new FileLogHolder(logHeader, logDirectory, fileName, fileExtension, maxFiles, maxSizeBytes, newLogsOnStart, isRestore);
        }
        return logHolder;
    }

    private FileLogHolder(FileLogHeader logHeader, File directory, String fileName, String fileExtension, int maxNumFiles, long maxFileSizeBytes, boolean newLogsOnStart, boolean isRestore) {
        this.logHeader = logHeader;
        this.newLogsOnStart = newLogsOnStart;
        this.currentPrintStream = DummyOutputStream.psInstance;
        this.update(directory, fileName, fileExtension, maxNumFiles, maxFileSizeBytes, isRestore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void update(File newDirectory, String newFileName, String newFileExtension, int newMaxFiles, long newMaxSizeBytes, boolean isRestore) {
        boolean updateLocation;
        Object token = ThreadIdentityManager.runAsServer();
        try {
            updateLocation = this.fileLogSet.update(newDirectory, newFileName, newFileExtension, newMaxFiles);
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
        if (updateLocation || isRestore) {
            this.setStreamStatus(StreamStatus.INIT, this.currentFileStream, this.currentCountingStream, this.currentPrintStream);
        }
        this.maxFileSizeBytes = newMaxSizeBytes;
    }

    @Override
    public synchronized void close() {
        if (this.currentStatus != StreamStatus.CLOSED) {
            this.currentPrintStream.flush();
            if (!LoggingFileUtils.tryToClose(this.currentPrintStream)) {
                LoggingFileUtils.tryToClose(this.currentFileStream);
            }
            this.setStreamStatus(StreamStatus.CLOSED, null, null, DummyOutputStream.psInstance);
        }
    }

    @Override
    public synchronized void writeRecord(String record) {
        long length = record.length() + LoggingConstants.nlen;
        PrintStream ps = this.getPrintStream(length);
        ps.println(record);
        if (ps.checkError()) {
            this.setStreamStatus(StreamStatus.CLOSED, null, null, DummyOutputStream.psInstance);
            if (System.getProperty("test.classesDir") == null && System.getProperty("test.buildDir") == null) {
                System.err.println(Tr.formatMessage(FileLogHolder.getTc(), "FAILED_TO_WRITE_LOG", this.getPrimaryFile().getAbsolutePath()));
            }
        }
    }

    private File getPrimaryFile() {
        return new File(this.fileLogSet.getDirectory(), this.fileLogSet.getFileName() + this.fileLogSet.getFileExtension());
    }

    private synchronized PrintStream getPrintStream(long numNewChars) {
        switch (this.currentStatus) {
            case INIT: {
                File primaryFile;
                if (!this.newLogsOnStart && (primaryFile = this.getPrimaryFile()).exists() && (this.maxFileSizeBytes <= 0L || primaryFile.length() + this.logHeader.length() + numNewChars <= this.maxFileSizeBytes)) {
                    return this.getPrimaryStream(true);
                }
                return this.createStream(true);
            }
            case ACTIVE: {
                long bytesWritten;
                if (this.maxFileSizeBytes <= 0L || (bytesWritten = this.currentCountingStream.count()) + numNewChars <= this.maxFileSizeBytes) break;
                return this.createStream(true);
            }
            case CLOSED: {
                boolean showError;
                if (this.checkTime == null) {
                    this.checkTime = Calendar.getInstance().getTimeInMillis();
                    break;
                }
                long currentTime = Calendar.getInstance().getTimeInMillis();
                if (currentTime - this.checkTime <= 5000L) break;
                this.checkTime = currentTime;
                boolean bl = showError = this.retryTime == null || currentTime - this.retryTime > 600000L;
                if (showError) {
                    this.retryTime = currentTime;
                }
                PrintStream ps = this.createStream(showError);
                if (this.currentStatus == StreamStatus.ACTIVE) {
                    if (!IS_UNIT_TEST) {
                        Tr.audit(FileLogHolder.getTc(), "LOG_FILE_RESUMED", this.getPrimaryFile().getAbsolutePath());
                    }
                    this.checkTime = null;
                    this.retryTime = null;
                }
                return ps;
            }
        }
        return this.currentPrintStream;
    }

    private synchronized PrintStream createStream(boolean showError) {
        this.setStreamFromFile(null, true, 0L, showError);
        return this.currentPrintStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStreamFromFile(File targetLogFile, boolean closeExisting, long startOffset, boolean showError) {
        block12: {
            long realMaxFileSizeBytes = this.maxFileSizeBytes;
            this.maxFileSizeBytes = 0L;
            Object token = ThreadIdentityManager.runAsServer();
            try {
                if (closeExisting) {
                    this.currentPrintStream.flush();
                    if (this.currentFileStream != null) {
                        LoggingFileUtils.tryToClose(this.currentFileStream);
                    }
                }
                if (targetLogFile == null) {
                    targetLogFile = LoggingFileUtils.createNewFile(this.fileLogSet, showError);
                }
                if (targetLogFile != null) {
                    FileOutputStream newFileStream = null;
                    CountingOutputStream newCountingStream = null;
                    PrintStream newPrintStream = null;
                    try {
                        TextFileOutputStreamFactory fileStreamFactory = TrConfigurator.getFileOutputStreamFactory();
                        newFileStream = fileStreamFactory.createOutputStream(targetLogFile, true);
                        newCountingStream = new CountingOutputStream(newFileStream, startOffset);
                        newPrintStream = new PrintStream(newCountingStream);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (newFileStream != null && newCountingStream != null && newPrintStream != null) {
                        if (this.logHeader != null) {
                            this.logHeader.print(newPrintStream);
                        }
                        this.setStreamStatus(StreamStatus.ACTIVE, newFileStream, newCountingStream, newPrintStream);
                    } else {
                        this.setStreamStatus(StreamStatus.CLOSED, null, null, DummyOutputStream.psInstance);
                    }
                    break block12;
                }
                this.setStreamStatus(StreamStatus.CLOSED, null, null, DummyOutputStream.psInstance);
            }
            finally {
                ThreadIdentityManager.reset((Object)token);
                this.maxFileSizeBytes = realMaxFileSizeBytes;
            }
        }
    }

    private PrintStream getPrimaryStream(boolean showError) {
        File primaryFile = this.getPrimaryFile();
        this.setStreamFromFile(primaryFile, false, primaryFile.length(), showError);
        return this.currentPrintStream;
    }

    private synchronized void setStreamStatus(StreamStatus newStatus, FileOutputStream newFileStream, CountingOutputStream newCountingStream, PrintStream newPrintStream) {
        this.currentStatus = newStatus;
        this.currentFileStream = newFileStream;
        this.currentCountingStream = newCountingStream;
        this.currentPrintStream = newPrintStream;
    }

    public synchronized void releaseFile() {
        if (this.currentStatus == StreamStatus.ACTIVE) {
            this.currentPrintStream.flush();
            if (!LoggingFileUtils.tryToClose(this.currentPrintStream)) {
                LoggingFileUtils.tryToClose(this.currentFileStream);
            }
            this.setStreamStatus(StreamStatus.INIT, null, null, DummyOutputStream.psInstance);
        }
    }

    static class DummyOutputStream
    extends OutputStream {
        static final DummyOutputStream instance = new DummyOutputStream();
        static final PrintStream psInstance = new PrintStream(instance);

        DummyOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
        }
    }

    static enum StreamStatus {
        INIT,
        ACTIVE,
        CLOSED;

    }
}

