/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.schemagen.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.config.schemagen.internal.CompactOutputXMLStreamWriter;
import com.ibm.ws.config.schemagen.internal.DelegatingXMLStreamWriter;
import com.ibm.ws.config.schemagen.internal.GeneratorOptions;
import com.ibm.ws.config.schemagen.internal.IndentingXMLStreamWriter;
import com.ibm.ws.config.schemagen.internal.SchemaGeneratorException;
import com.ibm.ws.config.schemagen.internal.SchemaWriter;
import com.ibm.ws.config.xml.internal.schema.MetaTypeInformationSpecification;
import com.ibm.ws.config.xml.internal.schema.SchemaMetaTypeParser;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.feature.internal.generator.ManifestFileProcessor;
import com.ibm.ws.kernel.feature.provisioning.FeatureResource;
import com.ibm.ws.kernel.feature.provisioning.ProvisioningFeatureDefinition;
import com.ibm.ws.kernel.feature.provisioning.SubsystemContentType;
import com.ibm.ws.kernel.provisioning.BundleRepositoryRegistry;
import com.ibm.ws.kernel.provisioning.ContentBasedLocalBundleRepository;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.File;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeSet;
import javax.xml.stream.XMLOutputFactory;
import org.osgi.service.metatype.MetaTypeInformation;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class Generator {
    public static final ResourceBundle messages;
    public static final ResourceBundle options;
    private static final String SCRIPT_NAME = "schemaGen";
    public static final String CORE_PRODUCT_NAME = "core";
    public static final String USR_PRODUCT_EXT_NAME = "usr";
    private final GeneratorOptions generatorOptions = new GeneratorOptions();
    static final long serialVersionUID = 6618811131857470705L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static void main(String[] args) {
        Generator schemaGen = new Generator();
        System.exit(schemaGen.createSchema(args));
    }

    /*
     * WARNING - void declaration
     */
    int createSchema(String[] args) {
        ReturnCode rc = ReturnCode.OK;
        try {
            rc = this.generatorOptions.processArgs(args);
            switch (rc) {
                case GENERATE_ACTION: {
                    rc = ReturnCode.OK;
                    ManifestFileProcessor mfp = new ManifestFileProcessor();
                    HashMap bundlesByProductMap = new HashMap();
                    Map fdsByProd = mfp.getFeatureDefinitionsByProduct();
                    ContentBasedLocalBundleRepository lbr = null;
                    for (Map.Entry entry : fdsByProd.entrySet()) {
                        BundleRepositoryRegistry.BundleRepositoryHolder brh;
                        String productName = (String)entry.getKey();
                        Map fds = (Map)entry.getValue();
                        lbr = productName.equals(CORE_PRODUCT_NAME) ? BundleRepositoryRegistry.getInstallBundleRepository() : (productName.equals(USR_PRODUCT_EXT_NAME) ? BundleRepositoryRegistry.getUsrInstallBundleRepository() : ((brh = BundleRepositoryRegistry.getRepositoryHolder((String)productName)) != null ? brh.getBundleRepository() : null));
                        ArrayList<File> bundles = new ArrayList<File>();
                        for (ProvisioningFeatureDefinition def : fds.values()) {
                            for (FeatureResource bundle : def.getConstituents(SubsystemContentType.BUNDLE_TYPE)) {
                                File f;
                                if (lbr == null || (f = lbr.selectBundle(bundle.getLocation(), bundle.getSymbolicName(), bundle.getVersionRange())) == null) continue;
                                bundles.add(f);
                            }
                        }
                        bundlesByProductMap.put(productName, bundles);
                    }
                    SchemaMetaTypeParser smtp = new SchemaMetaTypeParser(this.generatorOptions.getLocale(), bundlesByProductMap);
                    this.generate(smtp.getMetatypeInformation());
                    break;
                }
                case HELP_ACTION: {
                    this.showPurpose();
                    this.showBriefUsage();
                    this.showUsageInfo();
                    rc = ReturnCode.OK;
                    break;
                }
                case NO_ARGUMENT: {
                    this.showPurpose();
                    this.showBriefUsage();
                }
                default: {
                    rc = ReturnCode.BAD_ARGUMENT;
                    break;
                }
            }
        }
        catch (SchemaGeneratorException mfp) {
            void e;
            FFDCFilter.processException((Throwable)mfp, (String)"com.ibm.ws.config.schemagen.internal.Generator", (String)"162", (Object)this, (Object[])new Object[]{args});
            System.out.println(e.getMessage());
            rc = ReturnCode.RUNTIME_EXCEPTION;
        }
        catch (RuntimeException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.config.schemagen.internal.Generator", (String)"166", (Object)this, (Object[])new Object[]{args});
            System.out.println(MessageFormat.format(messages.getString("error.schemaGenException"), e.getMessage()));
            e.printStackTrace();
            rc = ReturnCode.RUNTIME_EXCEPTION;
        }
        return rc.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private void generate(List<MetaTypeInformationSpecification> metatype) {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        try {
            PrintWriter writer = new PrintWriter(this.generatorOptions.getOutputFile(), this.generatorOptions.getEncoding());
            DelegatingXMLStreamWriter xmlWriter = null;
            xmlWriter = this.generatorOptions.getCompactOutput() ? new CompactOutputXMLStreamWriter(factory.createXMLStreamWriter(writer)) : new IndentingXMLStreamWriter(factory.createXMLStreamWriter(writer), writer);
            SchemaWriter schemaWriter = new SchemaWriter(xmlWriter);
            schemaWriter.setIgnoredPids(this.generatorOptions.getIgnoredPids());
            schemaWriter.setGenerateDocumentation(true);
            schemaWriter.setEncoding(this.generatorOptions.getEncoding());
            schemaWriter.setLocale(this.generatorOptions.getLocale());
            schemaWriter.setSchemaVersion(this.generatorOptions.getSchemaVersion());
            schemaWriter.setOutputVersion(this.generatorOptions.getOutputVersion());
            for (MetaTypeInformationSpecification item : metatype) {
                schemaWriter.add((MetaTypeInformation)item);
            }
            schemaWriter.generate(true);
        }
        catch (RuntimeException writer) {
            void e;
            FFDCFilter.processException((Throwable)writer, (String)"com.ibm.ws.config.schemagen.internal.Generator", (String)"203", (Object)this, (Object[])new Object[]{metatype});
            throw e;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.config.schemagen.internal.Generator", (String)"205", (Object)this, (Object[])new Object[]{metatype});
            throw new RuntimeException(e);
        }
    }

    private void showPurpose() {
        System.out.println();
        System.out.println(MessageFormat.format(options.getString("purpose"), SCRIPT_NAME));
        System.out.println();
    }

    private void showBriefUsage() {
        System.out.println(MessageFormat.format(options.getString("briefUsageScript"), SCRIPT_NAME));
        System.out.println();
    }

    private void showUsageInfo() {
        String okpfx = "option-key.";
        String odpfx = "option-desc.";
        HashSet<String> exclusionSet = new HashSet<String>();
        exclusionSet.add("option-key.productExtension");
        Enumeration<String> keys = options.getKeys();
        TreeSet<String> optionKeys = new TreeSet<String>();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (!key.startsWith("option-key.") || exclusionSet.contains(key)) continue;
            optionKeys.add(key);
        }
        if (optionKeys.size() > 0) {
            System.out.println(options.getString("use.options"));
            System.out.println();
            for (String optionKey : optionKeys) {
                String option = optionKey.substring("option-key.".length());
                System.out.println(options.getString(optionKey));
                System.out.println(options.getString("option-desc." + option));
                System.out.println();
            }
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.config.schemagen.internal.Generator", Generator.class, null, null);
        messages = ResourceBundle.getBundle("com.ibm.ws.config.internal.resources.ConfigMessages");
        options = ResourceBundle.getBundle("com.ibm.ws.config.internal.resources.ConfigOptions");
    }

    public static enum ReturnCode {
        OK(0),
        BAD_ARGUMENT(20),
        RUNTIME_EXCEPTION(21),
        NO_ARGUMENT(22),
        HELP_ACTION(-1),
        GENERATE_ACTION(-2);

        final int val;

        private ReturnCode(int val) {
            this.val = val;
        }

        public int getValue() {
            return this.val;
        }
    }
}

