/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.security;

import com.ibm.websphere.cache.DistributedMap;
import com.ibm.websphere.cache.DistributedObjectCache;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.websphere.security.auth.InvalidTokenException;
import com.ibm.websphere.security.auth.TokenExpiredException;
import com.ibm.ws.common.internal.encoder.Base64Coder;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.jaas.common.callback.AuthenticationHelper;
import com.ibm.ws.security.token.TokenManager;
import com.ibm.ws.webcontainer.security.LoggedOutCookieCache;
import com.ibm.ws.webcontainer.security.LoggedOutCookieCacheHelper;
import com.ibm.ws.webcontainer.security.LoggedOutTokenCache;
import com.ibm.wsspi.cache.DistributedObjectCacheFactory;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.security.ltpa.Token;
import java.util.Map;
import java.util.Properties;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class LoggedOutTokenCacheImpl
implements LoggedOutTokenCache {
    private static final TraceComponent tc = Tr.register(LoggedOutTokenCacheImpl.class, (String)"WebAppSecurity", (String)"com.ibm.ws.webcontainer.security.resources.WebAppSecurityMessages");
    private static final AtomicServiceReference<TokenManager> tokenManager = new AtomicServiceReference("tokenManager");
    private final InMemoryLoggedOutTokenCache inMemoryCookieCache = new InMemoryLoggedOutTokenCache();
    static final long serialVersionUID = 5858136764846171164L;

    protected void setTokenManager(ServiceReference<TokenManager> ref) {
        tokenManager.setReference(ref);
    }

    protected void unsetTokenManager(ServiceReference<TokenManager> ref) {
        tokenManager.setReference(ref);
    }

    protected void activate(ComponentContext cc, Map<String, Object> properties) {
        tokenManager.activate(cc);
    }

    protected void deactivate(ComponentContext cc) {
        tokenManager.deactivate(cc);
    }

    @Trivial
    public static LoggedOutTokenCache getInstance() {
        return Singleton.instance;
    }

    @Override
    public boolean contains(Object key) {
        String keyStr = (String)key;
        LoggedOutCookieCache jCacheCookieCache = LoggedOutCookieCacheHelper.getLoggedOutCookieCacheService();
        if (jCacheCookieCache != null) {
            return jCacheCookieCache.contains(keyStr);
        }
        return this.inMemoryCookieCache.contains(keyStr);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void put(Object key, Object value) {
        String keyStr = (String)key;
        TokenManager tm = (TokenManager)tokenManager.getService();
        int timeOut = -1;
        try {
            byte[] tokenBytes = AuthenticationHelper.copyCredToken((byte[])Base64Coder.base64DecodeString((String)keyStr));
            Token token = tm.recreateTokenFromBytes(tokenBytes, new String[0]);
            if (token != null) {
                long tokenExp = token.getExpiration();
                long calcTimeOut = tokenExp - System.currentTimeMillis();
                timeOut = (int)calcTimeOut / 1000;
                String userName = token.getAttributes("u")[0];
                if (userName != null) {
                    value = userName;
                }
            }
        }
        catch (InvalidTokenException tokenBytes) {
            FFDCFilter.processException((Throwable)tokenBytes, (String)"com.ibm.ws.webcontainer.security.LoggedOutTokenCacheImpl", (String)"101", (Object)this, (Object[])new Object[]{key, value});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)("Token is not valid so do not cache it " + e.getMessage()), (Object[])new Object[0]);
            }
            return;
        }
        catch (TokenExpiredException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.webcontainer.security.LoggedOutTokenCacheImpl", (String)"106", (Object)this, (Object[])new Object[]{key, value});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Token is expired so do not cache it " + e.getMessage()), (Object[])new Object[0]);
            }
            return;
        }
        LoggedOutCookieCache jCacheCookieCache = LoggedOutCookieCacheHelper.getLoggedOutCookieCacheService();
        if (jCacheCookieCache != null) {
            jCacheCookieCache.put(keyStr, value);
        } else {
            this.inMemoryCookieCache.put(keyStr, value, timeOut);
        }
    }

    @Override
    public boolean shouldTrackTokens() {
        return LoggedOutCookieCacheHelper.getLoggedOutCookieCacheService() != null;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class InMemoryLoggedOutTokenCache {
        private DistributedMap dmns = null;
        static final long serialVersionUID = 8076247203324424151L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private InMemoryLoggedOutTokenCache() {
        }

        public boolean contains(Object key) {
            if (this.dmns != null) {
                return this.dmns.containsKey(key);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The LoggedOutTokenMap DistributedMap does not exist.", (Object[])new Object[0]);
            }
            return false;
        }

        public Object put(Object key, Object value, int timeToLive) {
            DistributedMap map = this.getDMLoggedOutTokenMap();
            if (map != null) {
                Object dist_object = map.put(key, value, 1, timeToLive, 2, null);
                return dist_object;
            }
            return null;
        }

        private DistributedMap getDMLoggedOutTokenMap() {
            if (this.dmns == null) {
                this.dmns = this.getDistributedMap("LoggedOutTokenMap");
            }
            return this.dmns;
        }

        private DistributedMap getDistributedMap(String mapName) {
            DistributedObjectCache dm = null;
            dm = DistributedObjectCacheFactory.getMap((String)mapName, (Properties)new Properties());
            return dm;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.webcontainer.security.LoggedOutTokenCacheImpl$InMemoryLoggedOutTokenCache", InMemoryLoggedOutTokenCache.class, (String)"WebAppSecurity", (String)"com.ibm.ws.webcontainer.security.resources.WebAppSecurityMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static final class Singleton {
        private static final LoggedOutTokenCache instance;
        static final long serialVersionUID = 1100361998063308966L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        Singleton() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.webcontainer.security.LoggedOutTokenCacheImpl$Singleton", Singleton.class, (String)"WebAppSecurity", (String)"com.ibm.ws.webcontainer.security.resources.WebAppSecurityMessages");
            instance = new LoggedOutTokenCacheImpl();
        }
    }
}

