/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channel.ssl.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ssl.Constants;
import java.util.Properties;
import javax.net.ssl.SSLEngine;

public class SSLLinkConfig {
    private static final TraceComponent tc = Tr.register(SSLLinkConfig.class, (String)"SSLChannel", (String)"com.ibm.ws.channel.ssl.internal.resources.SSLChannelMessages");
    private Properties myConfig = null;

    public SSLLinkConfig(Properties config) {
        this.myConfig = config;
    }

    public boolean getBooleanProperty(String key) {
        return "true".equalsIgnoreCase(this.myConfig.getProperty(key));
    }

    public String getProperty(String key) {
        return this.myConfig.getProperty(key);
    }

    public Properties getProperties() {
        return this.myConfig;
    }

    public String[] getEnabledCipherSuites(SSLEngine sslEngine) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getEnabledCipherSuites", (Object[])new Object[0]);
        }
        String[] ciphers = null;
        Object ciphersObject = this.myConfig.get("com.ibm.ssl.enabledCipherSuites");
        if (null == ciphersObject) {
            String securityLevel = this.myConfig.getProperty("com.ibm.ssl.securityLevel");
            if (null == securityLevel) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Defaulting to HIGH security level", (Object[])new Object[0]);
                }
                securityLevel = "HIGH";
            }
            ciphers = Constants.adjustSupportedCiphersToSecurityLevel((String[])sslEngine.getEnabledCipherSuites(), (String)securityLevel);
        } else if (ciphersObject instanceof String) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("enabledCipherSuites is a String: " + ciphersObject), (Object[])new Object[0]);
            }
            ciphers = ((String)ciphersObject).split("\\s+");
        } else if (ciphersObject instanceof String[]) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"enabledCipherSuites is a String array", (Object[])new Object[0]);
            }
            ciphers = (String[])ciphersObject;
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Invalid object for enabledCipherSuites: " + ciphersObject), (Object[])new Object[0]);
        }
        if ((null == ciphers || 0 == ciphers.length) && TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Unable to find any enabled ciphers", (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getEnabledCipherSuites");
        }
        return ciphers;
    }

    public String[] getSSLProtocol() {
        String protocol;
        String[] protocols;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSSLProtocol", (Object[])new Object[0]);
        }
        if ((protocols = (protocol = (String)this.myConfig.get("com.ibm.ssl.protocol")).split(",")).length == 1 && (protocols[0].equals("TLS") || protocols[0].equals("SSL"))) {
            protocols = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getSSLProtocol " + protocols));
        }
        return protocols;
    }
}

