/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.jitdeploy;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ejbcontainer.jitdeploy.JITPlatformHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.File;
import java.io.FileOutputStream;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Set;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;

final class JITUtils {
    static final String JIT_TRACE_GROUP = "JITDeploy";
    static final String JIT_RSRC_BUNDLE = "com.ibm.ejs.container.container";
    static final String INDENT = "     ";
    static final Class<?>[] NO_PARAMS = new Class[0];
    static final int LINE_NUMBER_DEFAULT = 1;
    static final int LINE_NUMBER_RETURN = 2;
    static final int LINE_NUMBER_ARG_BEGIN = 100;
    static final int LINE_NUMBER_CATCH_BEGIN = 1000;
    private static final String CLASS_NAME = JITUtils.class.getName();
    private static final TraceComponent tc = Tr.register(JITUtils.class, (String)"JITDeploy", (String)"com.ibm.ejs.container.container");
    private static final TraceComponent tcJITDeployRuntime = Tr.register((String)(CLASS_NAME + "-Runtime"), JITUtils.class, (String)"JITDeployRuntime", null);
    private static final String JIT_DEPLOY_DIR = File.separator + "jitdeploy" + File.separator;
    static final Type TYPE_Exception = Type.getType((String)"Ljava/lang/Exception;");
    static final Type TYPE_Object = Type.getType((String)"Ljava/lang/Object;");
    static final Type TYPE_Object_ARRAY = Type.getType((String)"[Ljava/lang/Object;");
    static final Type TYPE_String = Type.getType((String)"Ljava/lang/String;");
    static final Type TYPE_Throwable = Type.getType((String)"Ljava/lang/Throwable;");
    static final Type TYPE_RuntimeException = Type.getType((String)"Ljava/lang/RuntimeException;");
    static final Type TYPE_Serializable = Type.getType((String)"Ljava/io/Serializable;");

    JITUtils() {
    }

    static String convertClassName(String className) {
        return className.replace('.', '/');
    }

    static String convertClassName(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        String className = clazz.getName();
        return className.replace('.', '/');
    }

    public static String methodKey(Method m) {
        StringBuilder result = new StringBuilder(m.getName());
        result.append("(");
        Class<?>[] argTypes = m.getParameterTypes();
        for (int i = 0; i < argTypes.length; ++i) {
            if (i > 0) {
                result.append(",");
            }
            result.append(argTypes[i].getName());
        }
        result.append(")");
        return result.toString();
    }

    static final String jdiMethodSignature(Method method) {
        StringBuilder sb = new StringBuilder();
        Class<?>[] methodParams = method.getParameterTypes();
        sb.append("(");
        for (int j = 0; j < methodParams.length; ++j) {
            sb.append(JITUtils.mapTypeToJDIEncoding(methodParams[j]));
        }
        sb.append(")");
        sb.append(JITUtils.mapTypeToJDIEncoding(method.getReturnType()));
        return sb.toString();
    }

    private static final String mapTypeToJDIEncoding(Class<?> type) {
        String typeName = type.getName();
        String returnValue = type.isArray() ? typeName.replace('.', '/') : (typeName.indexOf(46) > 0 ? "L" + typeName.replace('.', '/') + ";" : (typeName.equals("void") ? "V" : (typeName.equals("boolean") ? "Z" : (typeName.equals("int") ? "I" : (typeName.equals("long") ? "J" : (typeName.equals("double") ? "D" : (typeName.equals("float") ? "F" : (typeName.equals("char") ? "C" : (typeName.equals("byte") ? "B" : (typeName.equals("short") ? "S" : "L" + typeName + ";"))))))))));
        return returnValue;
    }

    static Type[] getTypes(Class<?>[] classes) {
        int size = classes.length;
        Type[] types = new Type[size];
        for (int i = 0; i < size; ++i) {
            types[i] = Type.getType(classes[i]);
        }
        return types;
    }

    static Class<?>[] sortExceptions(Class<?>[] exceptions, boolean removeSubclasses) {
        int numExceptions = exceptions.length;
        ArrayList checkedExceptions = new ArrayList(numExceptions);
        for (Class<?> exception : exceptions) {
            Class checkedEx;
            int j;
            if (removeSubclasses) {
                boolean isSubclass = false;
                for (Class<?> parentEx : exceptions) {
                    if (exception == parentEx || !parentEx.isAssignableFrom(exception)) continue;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("getCheckedExceptions: ignoring " + exception.getName() + ", subclass of " + parentEx.getName()), (Object[])new Object[0]);
                    }
                    isSubclass = true;
                    break;
                }
                if (isSubclass) continue;
                checkedExceptions.add(exception);
                continue;
            }
            int numChecked = checkedExceptions.size();
            for (j = 0; j < numChecked && !(checkedEx = (Class)checkedExceptions.get(j)).isAssignableFrom(exception); ++j) {
            }
            checkedExceptions.add(j, exception);
        }
        return checkedExceptions.toArray(new Class[checkedExceptions.size()]);
    }

    public static void setLineNumber(MethodVisitor mv, int line) {
        Label label = new Label();
        mv.visitLabel(label);
        mv.visitLineNumber(line, label);
    }

    public static void checkCast(MethodVisitor mv, String internalName) {
        if (TraceComponent.isAnyTracingEnabled() && tcJITDeployRuntime.isDebugEnabled()) {
            String className;
            if (internalName.charAt(0) == '[') {
                int begin = 0;
                while (internalName.charAt(++begin) == '[') {
                }
                className = internalName.charAt(begin) == 'L' ? internalName.substring(0, begin) + internalName.substring(begin + 1, internalName.length() - 1).replace('/', '.') : internalName;
            } else {
                className = internalName.replace('/', '.');
            }
            mv.visitVarInsn(25, 0);
            mv.visitLdcInsn((Object)className);
            mv.visitMethodInsn(184, "com/ibm/ejs/container/JIT_Debug", "checkCast", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        }
        mv.visitTypeInsn(192, internalName);
    }

    static void unbox(GeneratorAdapter mg, Type type) {
        switch (type.getSort()) {
            case 0: {
                return;
            }
            case 1: {
                mg.visitTypeInsn(192, "java/lang/Boolean");
                mg.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z");
                break;
            }
            case 2: {
                mg.visitTypeInsn(192, "java/lang/Character");
                mg.visitMethodInsn(182, "java/lang/Character", "charValue", "()C");
                break;
            }
            case 3: {
                mg.visitTypeInsn(192, "java/lang/Byte");
                mg.visitMethodInsn(182, "java/lang/Byte", "byteValue", "()B");
                break;
            }
            case 4: {
                mg.visitTypeInsn(192, "java/lang/Short");
                mg.visitMethodInsn(182, "java/lang/Short", "shortValue", "()S");
                break;
            }
            case 5: {
                mg.visitTypeInsn(192, "java/lang/Integer");
                mg.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I");
                break;
            }
            case 6: {
                mg.visitTypeInsn(192, "java/lang/Float");
                mg.visitMethodInsn(182, "java/lang/Float", "floatValue", "()F");
                break;
            }
            case 7: {
                mg.visitTypeInsn(192, "java/lang/Long");
                mg.visitMethodInsn(182, "java/lang/Long", "longValue", "()J");
                break;
            }
            case 8: {
                mg.visitTypeInsn(192, "java/lang/Double");
                mg.visitMethodInsn(182, "java/lang/Double", "doubleValue", "()D");
                break;
            }
            default: {
                mg.checkCast(type);
            }
        }
    }

    public static String getClassConstantFieldName(Class<?> klass) {
        String dollarName = klass.getName().replace('.', '$');
        if (dollarName.startsWith("[")) {
            if (dollarName.endsWith(";")) {
                dollarName = dollarName.substring(0, dollarName.length() - 1);
            }
            return "array" + dollarName.replace('[', '$');
        }
        return "class$" + dollarName;
    }

    public static void loadClassConstant(MethodVisitor mg, String className, Set<String> classConstantFieldNames, Class<?> classConstant) {
        String fieldName = JITUtils.getClassConstantFieldName(classConstant);
        classConstantFieldNames.add(fieldName);
        mg.visitFieldInsn(178, className, fieldName, "Ljava/lang/Class;");
        Label if_null_then = new Label();
        mg.visitJumpInsn(198, if_null_then);
        mg.visitFieldInsn(178, className, fieldName, "Ljava/lang/Class;");
        Label else_nonnull = new Label();
        mg.visitJumpInsn(167, else_nonnull);
        mg.visitLabel(if_null_then);
        mg.visitLdcInsn((Object)classConstant.getName());
        mg.visitMethodInsn(184, className, "class$", "(Ljava/lang/String;)Ljava/lang/Class;");
        mg.visitInsn(89);
        mg.visitFieldInsn(179, className, fieldName, "Ljava/lang/Class;");
        mg.visitLabel(else_nonnull);
    }

    public static void addClassConstantMembers(ClassVisitor cv, Set<String> classConstantFieldNames) {
        if (!classConstantFieldNames.isEmpty()) {
            JITUtils.addClassConstantMethod(cv);
            for (String fieldName : classConstantFieldNames) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("     adding class constant field : " + fieldName), (Object[])new Object[0]);
                }
                FieldVisitor fv = cv.visitField(4104, fieldName, "Ljava/lang/Class;", null, null);
                fv.visitEnd();
            }
        }
    }

    private static void addClassConstantMethod(ClassVisitor cv) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"     adding method : class$ (Ljava/lang/String;)Ljava/lang/Class;", (Object[])new Object[0]);
        }
        MethodVisitor mv = cv.visitMethod(4104, "class$", "(Ljava/lang/String;)Ljava/lang/Class;", null, null);
        mv.visitCode();
        Label try_begin = new Label();
        mv.visitLabel(try_begin);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(184, "java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;");
        mv.visitInsn(176);
        Label try_end = new Label();
        mv.visitLabel(try_end);
        mv.visitVarInsn(58, 1);
        mv.visitTypeInsn(187, "java/lang/NoClassDefFoundError");
        mv.visitInsn(89);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, "java/lang/Throwable", "getMessage", "()Ljava/lang/String;");
        mv.visitMethodInsn(183, "java/lang/NoClassDefFoundError", "<init>", "(Ljava/lang/String;)V");
        mv.visitInsn(191);
        mv.visitTryCatchBlock(try_begin, try_end, try_end, "java/lang/ClassNotFoundException");
        mv.visitMaxs(3, 2);
        mv.visitEnd();
    }

    static void writeToClassFile(final String internalClassName, final byte[] classBytes) {
        block5: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("writeToClassFile (" + internalClassName + ", " + (classBytes == null ? "null" : classBytes.length + " bytes") + ")"), (Object[])new Object[0]);
            }
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        String fileName = JITPlatformHelper.getLogLocation() + JIT_DEPLOY_DIR + internalClassName + ".class";
                        File file = new File(fileName);
                        File directory = file.getParentFile();
                        directory.mkdirs();
                        FileOutputStream classFile = new FileOutputStream(file);
                        classFile.write(classBytes);
                        classFile.flush();
                        classFile.close();
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException paex) {
                FFDCFilter.processException((Throwable)paex.getCause(), (String)(CLASS_NAME + ".writeToClassFile"), (String)"674");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("writeToClassFile failed for class " + internalClassName + " : " + paex.getCause().getMessage()), (Object[])new Object[0]);
                }
            }
            catch (Throwable ex) {
                FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".writeToClassFile"), (String)"463");
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block5;
                Tr.debug((TraceComponent)tc, (String)("writeToClassFile failed for class " + internalClassName + " : " + ex.getMessage()), (Object[])new Object[0]);
            }
        }
    }
}

