/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.wim.adapter.urbridge.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.wim.ras.WIMMessageHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.wim.adapter.urbridge.URBridge;
import com.ibm.ws.security.wim.adapter.urbridge.utils.URBridgeEntity;
import com.ibm.ws.security.wim.adapter.urbridge.utils.URBridgeEntityFactory;
import com.ibm.wsspi.security.wim.exception.WIMApplicationException;
import com.ibm.wsspi.security.wim.exception.WIMException;
import com.ibm.wsspi.security.wim.model.Entity;
import com.ibm.wsspi.security.wim.model.Group;
import com.ibm.wsspi.security.wim.model.IdentifierType;
import com.ibm.wsspi.security.wim.model.PersonAccount;
import com.ibm.wsspi.security.wim.model.Root;
import java.util.List;
import java.util.Map;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class URBridgeGroup
extends URBridgeEntity {
    private static final TraceComponent tc = Tr.register(URBridgeGroup.class, (String)"wimUtil", (String)"com.ibm.ws.security.wim.util.resources.WimUtilMessages");
    static final long serialVersionUID = -2155392345845436244L;

    public URBridgeGroup(Entity inEntity, URBridge urBridge, Map<String, String> inAttrMap, String inNodeName, Map<String, String> inEntityConfigMap) {
        super(inEntity, urBridge, inAttrMap, inNodeName, inEntityConfigMap);
        this.securityNameProp = inAttrMap.get("groupSecurityNameProperty");
        this.uniqueIdProp = inAttrMap.get("uniqueGroupIdProperty");
        this.displayNameProp = inAttrMap.get("groupDisplayNameProperty");
        this.rdnProp = inEntityConfigMap.get(this.entity.getTypeName());
    }

    @Override
    public String getUniqueIdForEntity(String securityName) throws Exception {
        return this.urBridge.getUniqueGroupId(securityName);
    }

    @Override
    public String getSecurityNameForEntity(String uniqueId) throws Exception {
        return this.urBridge.getGroupSecurityName(uniqueId);
    }

    @Override
    public String getDisplayNameForEntity(String securityName) throws Exception {
        return this.urBridge.getGroupDisplayName(securityName);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void getUsersForGroup(List<String> grpMbrAttrs, int countLimit) throws WIMException {
        String securityName = null;
        try {
            securityName = this.getSecurityName(false);
            List returnNames = this.urBridge.getUsersForGroup(securityName, countLimit).getList();
            for (int j = 0; j < returnNames.size(); ++j) {
                Root fakeRoot = new Root();
                PersonAccount memberDO = new PersonAccount();
                fakeRoot.getEntities().add(memberDO);
                IdentifierType identifier = new IdentifierType();
                memberDO.setIdentifier(identifier);
                URBridgeEntityFactory osFactory = new URBridgeEntityFactory();
                URBridgeEntity osEntity = osFactory.createObject((Entity)memberDO, this.urBridge, this.attrMap, this.baseEntryName, this.entityConfigMap);
                osEntity.setSecurityNameProp((String)returnNames.get(j));
                osEntity.populateEntity(grpMbrAttrs);
                osEntity.setRDNPropValue((String)returnNames.get(j));
                ((Group)this.entity).getMembers().add(memberDO);
            }
        }
        catch (Exception returnNames) {
            void e;
            FFDCFilter.processException((Throwable)returnNames, (String)"com.ibm.ws.security.wim.adapter.urbridge.utils.URBridgeGroup", (String)"126", (Object)this, (Object[])new Object[]{grpMbrAttrs, countLimit});
            throw new WIMApplicationException("ENTITY_GET_FAILED", Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_GET_FAILED", (Object[])WIMMessageHelper.generateMsgParms((Object)securityName, (Object)e.toString())));
        }
    }
}

