/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.internal.monitor;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.app.manager.AppMessageHelper;
import com.ibm.ws.app.manager.internal.lifecycle.ServiceReg;
import com.ibm.ws.app.manager.internal.monitor.ApplicationMonitorConfig;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.application.handler.ApplicationHandler;
import com.ibm.wsspi.kernel.filemonitor.FileMonitor;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.FilterUtils;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="_tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={DropinMonitor.class}, immediate=true, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class DropinMonitor {
    private static final TraceComponent _tc = Tr.register(DropinMonitor.class, (String[])new String[]{"applications", "app.manager"}, (String)"com.ibm.ws.app.manager.internal.resources.AppManagerMessages", (String)"com.ibm.ws.app.manager.internal.monitor.DropinMonitor");
    private BundleContext _ctx;
    private WsLocationAdmin locationService;
    protected ConfigurationAdmin configAdmin;
    protected final AtomicReference<File> monitoredDirectory = new AtomicReference();
    private final AtomicBoolean createdMonitoredDir = new AtomicBoolean();
    protected final AtomicReference<ApplicationMonitorConfig> _config = new AtomicReference();
    protected final ConcurrentMap<String, ServiceReg<FileMonitor>> _monitors = new ConcurrentHashMap<String, ServiceReg<FileMonitor>>();
    protected final ConcurrentMap<String, Configuration> _configs = new ConcurrentHashMap<String, Configuration>();
    private final ServiceReg<FileMonitor> _coreMonitor = new ServiceReg();
    static final long serialVersionUID = 3695985934094866411L;

    @Activate
    protected void activate(ComponentContext ctx) {
        this._ctx = ctx.getBundleContext();
        this._coreMonitor.setProperties(new Hashtable());
        this._coreMonitor.setProperty("service.vendor", "IBM");
        this._coreMonitor.setProperty("monitor.recurse", false);
        this._coreMonitor.setProperty("monitor.filter", ".*");
        this.deleteAllConfiguredApplications();
    }

    @Deactivate
    protected void deactivate(ComponentContext ctx, int reason) {
        this.stop();
    }

    @Modified
    protected void modified(Map<String, Object> config) {
    }

    @Reference(name="locationService")
    protected void setLocationService(WsLocationAdmin locationService) {
        this.locationService = locationService;
    }

    protected void unsetLocationService(WsLocationAdmin locationService) {
    }

    @Reference(name="configAdmin")
    protected void setConfigAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
    }

    protected void unsetConfigAdmin(ConfigurationAdmin configAdmin) {
    }

    public synchronized void refresh(ApplicationMonitorConfig config) {
        if (config != null && config.isDropinsMonitored()) {
            this._config.set(config);
            File previousMonitoredDirectory = null;
            boolean createdPreviousDirectory = this.createdMonitoredDir.get();
            String newMonitoredFolder = config.getLocation();
            if (newMonitoredFolder != null && !newMonitoredFolder.equals("")) {
                previousMonitoredDirectory = this.updateMonitoredDirectory(newMonitoredFolder);
            }
            if (!this._coreMonitor.isRegistered()) {
                this.stopRemovedApplications();
                this.configureCoreMonitor(config);
                this._coreMonitor.register(this._ctx, FileMonitor.class, new FileMonitorImpl());
                Tr.audit((TraceComponent)_tc, (String)"APPLICATION_MONITOR_STARTED", (Object[])new Object[]{newMonitoredFolder});
            } else if (!this.monitoredDirectory.get().equals(previousMonitoredDirectory)) {
                this.stopAllStartedApplications();
                this._coreMonitor.unregister();
                this.configureCoreMonitor(config);
                this._coreMonitor.register(this._ctx, FileMonitor.class, new FileMonitorImpl());
                this.tidyUpMonitoredDirectory(createdPreviousDirectory, previousMonitoredDirectory);
            }
        } else {
            this.stopAllStartedApplications();
            this.stop();
        }
    }

    private void configureCoreMonitor(ApplicationMonitorConfig config) {
        this._coreMonitor.setProperty("monitor.interval", config.getPollingRate());
        this._coreMonitor.setProperty("monitor.directories", new String[]{this.monitoredDirectory.get().getAbsolutePath()});
    }

    private void stopAllStartedApplications() {
        for (Configuration config : this._configs.values()) {
            try {
                config.delete();
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.app.manager.internal.monitor.DropinMonitor", (String)"273", (Object)this, (Object[])new Object[0]);
            }
        }
        this._configs.clear();
    }

    public synchronized void stop() {
        this._coreMonitor.unregister();
        for (ServiceReg reg : this._monitors.values()) {
            reg.unregister();
        }
        this._monitors.clear();
        this.tidyUpMonitoredDirectory(this.createdMonitoredDir.get(), this.monitoredDirectory.get());
    }

    private void tidyUpMonitoredDirectory(boolean createdDir, File dirToCleanup) {
        File[] fileListing;
        if (createdDir && dirToCleanup != null && (fileListing = dirToCleanup.listFiles()) != null && fileListing.length == 0) {
            if (!dirToCleanup.delete()) {
                Tr.error((TraceComponent)_tc, (String)"MONITOR_DIR_CLEANUP_FAIL", (Object[])new Object[]{dirToCleanup});
            } else if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("Server deleted the old dropins directory " + dirToCleanup), (Object[])new Object[0]);
            }
        }
    }

    private void stopApplication(File currentFile) {
        if (_tc.isEventEnabled()) {
            Tr.event((TraceComponent)_tc, (String)("Stopping dropin application '" + currentFile.getName() + "'"), (Object[])new Object[0]);
        }
        String filePath = this.getAppLocation(currentFile);
        try {
            Configuration config = (Configuration)this._configs.remove(filePath);
            if (config != null) {
                config.delete();
            }
        }
        catch (Exception config) {
            FFDCFilter.processException((Throwable)config, (String)"com.ibm.ws.app.manager.internal.monitor.DropinMonitor", (String)"335", (Object)this, (Object[])new Object[]{currentFile});
            this.getAppMessageHelper(null, filePath).error("MONITOR_APP_STOP_FAIL", currentFile.getName());
        }
    }

    private String getAppLocation(File currentFile) {
        String filePath = currentFile.getAbsolutePath();
        if (filePath.endsWith(".xml")) {
            filePath = filePath.substring(0, filePath.length() - 4);
        }
        return filePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AppMessageHelper getAppMessageHelper(String type, String fileName) {
        block7: {
            String[] parts;
            if (type == null && fileName != null && (parts = fileName.split("[\\\\/]")).length > 0) {
                String last = parts[parts.length - 1];
                int dot = last.indexOf(46);
                String string = dot >= 0 ? last.substring(dot + 1) : (type = parts.length > 1 ? parts[parts.length - 2] : null);
            }
            if (type != null) {
                AppMessageHelper appMessageHelper;
                String filter = FilterUtils.createPropertyFilter((String)"type", (String)type.toLowerCase());
                Collection refs = this._ctx.getServiceReferences(ApplicationHandler.class, filter);
                if (refs.size() <= 0) break block7;
                ServiceReference ref = (ServiceReference)refs.iterator().next();
                ApplicationHandler appHandler = (ApplicationHandler)this._ctx.getService(ref);
                try {
                    appMessageHelper = AppMessageHelper.get(appHandler);
                }
                catch (Throwable throwable) {
                    try {
                        this._ctx.ungetService(ref);
                        throw throwable;
                    }
                    catch (InvalidSyntaxException invalidSyntaxException) {
                        FFDCFilter.processException((Throwable)invalidSyntaxException, (String)"com.ibm.ws.app.manager.internal.monitor.DropinMonitor", (String)"385", (Object)this, (Object[])new Object[]{type, fileName});
                    }
                }
                this._ctx.ungetService(ref);
                return appMessageHelper;
            }
        }
        return AppMessageHelper.get(null);
    }

    private void startApplication(File currentFile, String type) {
        if (_tc.isEventEnabled()) {
            Tr.event((TraceComponent)_tc, (String)("Starting dropin application '" + currentFile.getName() + "'"), (Object[])new Object[0]);
        }
        try {
            Configuration[] configuredApps = this.configAdmin.listConfigurations("(service.factoryPid=com.ibm.ws.app.manager)");
            if (configuredApps != null) {
                for (Configuration c : configuredApps) {
                    File configuredFile;
                    Dictionary properties = c.getProperties();
                    String location = (String)properties.get("location");
                    if (location == null || this.monitoredDirectory.get() == null || (configuredFile = new File(this.locationService.resolveString(location))) == null || currentFile.compareTo(configuredFile) != 0) continue;
                    Tr.warning((TraceComponent)_tc, (String)"dropins.app.also.configured", (Object[])new Object[]{location});
                    return;
                }
            }
        }
        catch (IOException | InvalidSyntaxException configuredApps) {
            FFDCFilter.processException((Throwable)configuredApps, (String)"com.ibm.ws.app.manager.internal.monitor.DropinMonitor", (String)"419", (Object)this, (Object[])new Object[]{currentFile, type});
        }
        String filePath = this.getAppLocation(currentFile);
        try {
            Configuration config = (Configuration)this._configs.get(filePath);
            if (config == null) {
                Hashtable<String, Object> appConfigSettings = new Hashtable<String, Object>();
                appConfigSettings.put("location", filePath);
                if (type != null) {
                    appConfigSettings.put("type", type);
                }
                appConfigSettings.put(".installedByDropins", true);
                config = this.configAdmin.createFactoryConfiguration("com.ibm.ws.app.manager");
                config.update(appConfigSettings);
                this._configs.put(filePath, config);
            }
        }
        catch (Exception config) {
            FFDCFilter.processException((Throwable)config, (String)"com.ibm.ws.app.manager.internal.monitor.DropinMonitor", (String)"446", (Object)this, (Object[])new Object[]{currentFile, type});
            this.getAppMessageHelper(type, filePath).error("MONITOR_APP_START_FAIL", filePath);
        }
    }

    private File updateMonitoredDirectory(String newMonitoredFolder) {
        File oldDir = this.monitoredDirectory.get();
        File newDir = new File(newMonitoredFolder);
        if (!newDir.isAbsolute()) {
            newMonitoredFolder = this.locationService.resolveString("${server.config.dir}/" + newMonitoredFolder);
            newDir = new File(newMonitoredFolder);
        }
        if (!newDir.equals(oldDir)) {
            if (this.monitoredDirectory.compareAndSet(oldDir, newDir)) {
                for (ServiceReg mon : this._monitors.values()) {
                    mon.unregister();
                }
                this._monitors.clear();
                if (!newDir.exists()) {
                    this.createdMonitoredDir.set(newDir.mkdirs());
                }
            } else {
                oldDir = null;
            }
        } else {
            oldDir = null;
        }
        return oldDir;
    }

    private void deleteAllConfiguredApplications() {
        try {
            Configuration[] configs = this.configAdmin.listConfigurations("(&(service.factoryPid=com.ibm.ws.app.manager)(.installedByDropins=true))");
            if (configs != null) {
                for (Configuration c : configs) {
                    try {
                        c.delete();
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.app.manager.internal.monitor.DropinMonitor", (String)"501", (Object)this, (Object[])new Object[0]);
                    }
                }
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.app.manager.internal.monitor.DropinMonitor", (String)"506", (Object)this, (Object[])new Object[0]);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            FFDCFilter.processException((Throwable)invalidSyntaxException, (String)"com.ibm.ws.app.manager.internal.monitor.DropinMonitor", (String)"509", (Object)this, (Object[])new Object[0]);
        }
    }

    private void stopRemovedApplications() {
        for (String loc : this._configs.keySet()) {
            File f = new File(loc);
            if (f.exists() || (f = new File(loc + ".xml")).exists()) continue;
            Configuration config = (Configuration)this._configs.remove(loc);
            try {
                config.delete();
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.app.manager.internal.monitor.DropinMonitor", (String)"523", (Object)this, (Object[])new Object[0]);
            }
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class FileMonitorImpl
    implements FileMonitor {
        private final String _type;
        private final String _filePath;
        static final long serialVersionUID = 3099817490480555759L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public FileMonitorImpl() {
            this(null, null);
        }

        public FileMonitorImpl(String type, String filePath) {
            this._type = type;
            this._filePath = filePath;
        }

        public void onBaseline(Collection<File> currentFiles) {
            this.processNewFiles(currentFiles);
        }

        public void onChange(Collection<File> createdFiles, Collection<File> modifiedFiles, Collection<File> deletedFiles) {
            for (File f : deletedFiles) {
                ServiceReg mon;
                if (_tc.isEventEnabled()) {
                    Tr.event((TraceComponent)_tc, (String)("File '" + f.getName() + "' removed from monitoring directory " + DropinMonitor.this.monitoredDirectory.get().getAbsolutePath()), (Object[])new Object[0]);
                }
                if ((mon = (ServiceReg)DropinMonitor.this._monitors.remove(f.getAbsolutePath())) == null) {
                    DropinMonitor.this.stopApplication(f);
                    continue;
                }
                if (this._type == null) continue;
                mon.unregister();
            }
            this.processNewFiles(createdFiles);
        }

        private void processNewFiles(Collection<File> currentFiles) {
            for (File f : currentFiles) {
                if (this._filePath != null && this._filePath.equals(f.getAbsolutePath())) continue;
                if (_tc.isEventEnabled()) {
                    Tr.event((TraceComponent)_tc, (String)("File '" + f.getName() + "' added to monitoring directory " + DropinMonitor.this.monitoredDirectory.get().getAbsolutePath()), (Object[])new Object[0]);
                }
                String name = f.getName();
                if (f.isDirectory() && name.indexOf(46) == -1 && this._type == null) {
                    ServiceReg<FileMonitorImpl> mon;
                    String filePath = f.getAbsolutePath();
                    if (DropinMonitor.this._monitors.putIfAbsent(filePath, mon = new ServiceReg<FileMonitorImpl>()) != null) continue;
                    mon.setProperties(new Hashtable());
                    mon.setProperty("service.vendor", "IBM");
                    mon.setProperty("monitor.interval", DropinMonitor.this._config.get().getPollingRate());
                    mon.setProperty("monitor.recurse", false);
                    mon.setProperty("monitor.includeself", true);
                    mon.setProperty("monitor.filter", ".*");
                    mon.setProperty("monitor.directories", new String[]{filePath});
                    if (FrameworkState.isStopping()) {
                        return;
                    }
                    mon.register(DropinMonitor.this._ctx, FileMonitor.class, new FileMonitorImpl(name, filePath));
                    continue;
                }
                if (!f.isHidden()) {
                    if (f.isDirectory() || f.isFile()) {
                        DropinMonitor.this.startApplication(f, this._type);
                        continue;
                    }
                    Tr.error((TraceComponent)_tc, (String)"UNABLE_TO_DETERMINE_APPLICATION_TYPE", (Object[])new Object[]{name});
                    continue;
                }
                if (!_tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)_tc, (String)"ignoring hidden file in dropins dir called", (Object[])new Object[]{f});
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(FileMonitorImpl.class, (String[])new String[]{"applications", "app.manager"}, (String)"com.ibm.ws.app.manager.internal.resources.AppManagerMessages", (String)"com.ibm.ws.app.manager.internal.monitor.DropinMonitor$FileMonitorImpl");
        }
    }
}

