/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.metrics.writer;

import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.microprofile.metrics.Constants;
import com.ibm.ws.microprofile.metrics.exceptions.EmptyRegistryException;
import com.ibm.ws.microprofile.metrics.exceptions.NoSuchMetricException;
import com.ibm.ws.microprofile.metrics.exceptions.NoSuchRegistryException;
import com.ibm.ws.microprofile.metrics.helper.Util;
import com.ibm.ws.microprofile.metrics.writer.OutputWriter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;
import org.eclipse.microprofile.metrics.Metadata;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JSONMetadataWriter
implements OutputWriter {
    private static final TraceComponent tc = Tr.register(JSONMetadataWriter.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.resources.Metrics");
    private final Writer writer;
    private final Locale locale;
    static final long serialVersionUID = -1644536699450563399L;

    public JSONMetadataWriter(Writer writer, Locale locale) {
        this.writer = writer;
        this.locale = locale;
    }

    @Override
    public void write(String registryName, String metric) throws NoSuchRegistryException, NoSuchMetricException, IOException {
        try {
            this.serialize(this.getMetricsMetadataAsJson(registryName, metric));
        }
        catch (EmptyRegistryException emptyRegistryException) {
            FFDCFilter.processException((Throwable)emptyRegistryException, (String)"com.ibm.ws.microprofile.metrics.writer.JSONMetadataWriter", (String)"53", (Object)this, (Object[])new Object[]{registryName, metric});
        }
    }

    @Override
    public void write(String registryName) throws NoSuchRegistryException, EmptyRegistryException, IOException {
        this.serialize(this.getMetricsMetadataAsJson(registryName));
    }

    @Override
    @FFDCIgnore(value={EmptyRegistryException.class, NoSuchRegistryException.class})
    public void write() throws IOException {
        JSONObject payload = new JSONObject();
        for (String registryName : Constants.REGISTRY_NAMES_LIST) {
            try {
                payload.put((Object)registryName, (Object)this.getMetricsMetadataAsJson(registryName));
            }
            catch (NoSuchRegistryException noSuchRegistryException) {
            }
            catch (EmptyRegistryException emptyRegistryException) {}
        }
        this.serialize(payload);
    }

    private JSONObject getMetricsMetadataAsJson(String registryName) throws NoSuchRegistryException, EmptyRegistryException {
        return this.getJsonFromMetricMetadataMap(Util.getMetricsMetadataAsMap(registryName));
    }

    private JSONObject getMetricsMetadataAsJson(String registryName, String metric) throws NoSuchRegistryException, EmptyRegistryException, NoSuchMetricException {
        return this.getJsonFromMetricMetadataMap(Util.getMetricsMetadataAsMap(registryName, metric));
    }

    private JSONObject getJsonFromMetricMetadataMap(Map<String, Metadata> metadataMap) {
        JSONObject jsonObject = new JSONObject();
        for (Map.Entry<String, Metadata> entry : metadataMap.entrySet()) {
            jsonObject.put((Object)entry.getKey(), (Object)this.getJsonFromObject(entry.getValue()));
        }
        return jsonObject;
    }

    private JSONObject getJsonFromObject(Metadata metadata) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"name", (Object)this.sanitizeMetadata(metadata.getName()));
        jsonObject.put((Object)"displayName", (Object)this.sanitizeMetadata(metadata.getDisplayName()));
        jsonObject.put((Object)"description", (Object)Tr.formatMessage((TraceComponent)tc, (Locale)this.locale, (String)this.sanitizeMetadata(metadata.getDescription()), (Object[])new Object[0]));
        jsonObject.put((Object)"type", (Object)this.sanitizeMetadata(metadata.getType()));
        jsonObject.put((Object)"unit", (Object)this.sanitizeMetadata(metadata.getUnit()));
        jsonObject.put((Object)"tags", (Object)this.getJsonFromMap(metadata.getTags()));
        return jsonObject;
    }

    private String sanitizeMetadata(String s) {
        if (s == null || s.trim().isEmpty()) {
            return "";
        }
        return s;
    }

    private String getJsonFromMap(Map<String, String> map) {
        if (map == null) {
            return null;
        }
        StringBuilder tagList = new StringBuilder();
        String delimiter = "";
        for (Map.Entry<String, String> entry : map.entrySet()) {
            tagList.append(delimiter).append(entry.getKey()).append('=').append(entry.getValue());
            delimiter = ",";
        }
        return tagList.toString();
    }

    private void serialize(JSONObject payload) throws IOException {
        payload.serialize(this.writer);
    }
}

