/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.model;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Providers;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.util.ReflectionUtil;
import org.apache.cxf.jaxrs.impl.tl.ThreadLocalProxy;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.ThreadLocalProxyCopyOnWriteArraySet;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class AbstractResourceInfo {
    private static final TraceComponent tc = Tr.register(AbstractResourceInfo.class, null, null);
    public static final String PROXY_SET = "proxy-set";
    public static final String CONSTRUCTOR_PROXY_MAP = "jaxrs-constructor-proxy-map";
    private static final String FIELD_PROXY_MAP = "jaxrs-field-proxy-map";
    private static final String SETTER_PROXY_MAP = "jaxrs-setter-proxy-map";
    private static final Set<String> STANDARD_CONTEXT_CLASSES = new HashSet<String>();
    protected boolean root;
    protected Class<?> resourceClass;
    protected Class<?> serviceClass;
    private Map<Class<?>, List<Field>> contextFields;
    private Map<Class<?>, Map<Class<?>, Method>> contextMethods;
    private final Bus bus;
    private boolean constructorProxiesAvailable;
    private boolean contextsAvailable;
    private static final Map<String, ProviderContextInfo> CONTEXT_PROPS;
    static final long serialVersionUID = 6898748758160355649L;

    protected AbstractResourceInfo(Bus bus) {
        this.bus = bus;
    }

    protected AbstractResourceInfo(Class<?> resourceClass, Class<?> serviceClass, boolean isRoot, boolean checkContexts, Bus bus) {
        this(resourceClass, serviceClass, isRoot, checkContexts, null, bus, null);
    }

    protected AbstractResourceInfo(Class<?> resourceClass, Class<?> serviceClass, boolean isRoot, boolean checkContexts, Map<Class<?>, ThreadLocalProxy<?>> constructorProxies, Bus bus, Object provider) {
        this.bus = bus;
        this.serviceClass = serviceClass;
        this.resourceClass = resourceClass;
        this.root = isRoot;
        if (checkContexts && resourceClass != null) {
            this.findContexts(serviceClass, provider, constructorProxies);
        }
    }

    private void findContexts(Class<?> cls, Object provider, Map<Class<?>, ThreadLocalProxy<?>> constructorProxies) {
        ProviderContextInfo contextInfo = CONTEXT_PROPS.get(cls.getName());
        if (contextInfo == null || contextInfo.processingRequired) {
            this.findContextFields(cls, provider, contextInfo);
            this.findContextSetterMethods(cls, provider, contextInfo);
        }
        if (constructorProxies != null) {
            Map<Class<?>, Map<Class<?>, ThreadLocalProxy<?>>> proxies = this.getConstructorProxyMap();
            proxies.put(this.serviceClass, constructorProxies);
            ThreadLocalProxyCopyOnWriteArraySet<ThreadLocalProxy<?>> proxySet = this.getProxySet();
            proxySet.addAll(constructorProxies.values());
            this.constructorProxiesAvailable = true;
        }
        this.contextsAvailable = this.contextFields != null && !this.contextFields.isEmpty() || this.contextMethods != null && !this.contextMethods.isEmpty() || this.constructorProxiesAvailable;
    }

    public boolean contextsAvailable() {
        return this.contextsAvailable;
    }

    public Bus getBus() {
        return this.bus;
    }

    public void setResourceClass(Class<?> rClass) {
        this.resourceClass = rClass;
        if (this.serviceClass.isInterface() && this.resourceClass != null && !this.resourceClass.isInterface()) {
            this.findContexts(this.resourceClass, null, null);
        }
    }

    public Class<?> getServiceClass() {
        return this.serviceClass;
    }

    private void findContextFields(Class<?> cls, Object provider, ProviderContextInfo contextInfo) {
        ProviderContextInfo superContextInfo;
        Class<?> superClass;
        if (cls == Object.class || cls == null) {
            return;
        }
        if (contextInfo == null || contextInfo.fieldNames != null) {
            for (Field f : ReflectionUtil.getDeclaredFields(cls)) {
                if (contextInfo != null && !contextInfo.fieldNames.contains(f.getName())) continue;
                Class<?> fType = f.getType();
                for (Annotation a : f.getAnnotations()) {
                    if (a.annotationType() != Context.class) continue;
                    this.contextFields = this.addContextField(this.contextFields, f);
                    if (!fType.isInterface()) continue;
                    this.checkContextClass(fType);
                    ThreadLocalProxy<?> proxy = AbstractResourceInfo.getFieldThreadLocalProxy(f, provider);
                    if (InjectionUtils.VALUE_CONTEXTS.contains(f.getType().getName()) || !this.addToMap(this.getFieldProxyMap(true), f, proxy)) continue;
                    ThreadLocalProxyCopyOnWriteArraySet<ThreadLocalProxy<?>> proxySet = this.getProxySet();
                    proxySet.add(proxy);
                }
            }
        }
        if ((superClass = cls.getSuperclass()) != null && superClass != Object.class && ((superContextInfo = CONTEXT_PROPS.get(superClass.getName())) == null || superContextInfo.processingRequired)) {
            this.findContextFields(superClass, provider, superContextInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ThreadLocalProxy<?> getFieldThreadLocalProxy(Field f, Object provider) {
        if (provider != null) {
            ThreadLocalProxy<?> proxy = null;
            Object object = provider;
            synchronized (object) {
                try {
                    proxy = InjectionUtils.extractFieldValue(f, provider);
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"org.apache.cxf.jaxrs.model.AbstractResourceInfo", (String)"307", null, (Object[])new Object[]{f, provider});
                }
                if (!(proxy instanceof ThreadLocalProxy)) {
                    proxy = InjectionUtils.createThreadLocalProxy(f.getType());
                    InjectionUtils.injectFieldValue(f, provider, proxy);
                }
            }
            return proxy;
        }
        return InjectionUtils.createThreadLocalProxy(f.getType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={Throwable.class})
    private static ThreadLocalProxy<?> getMethodThreadLocalProxy(Method m, Object provider) {
        if (provider != null) {
            ThreadLocalProxy<?> proxy = null;
            Object object = provider;
            synchronized (object) {
                try {
                    proxy = InjectionUtils.extractFromMethod(provider, InjectionUtils.getGetterFromSetter(m), false);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (!(proxy instanceof ThreadLocalProxy)) {
                    proxy = InjectionUtils.createThreadLocalProxy(m.getParameterTypes()[0]);
                    InjectionUtils.injectThroughMethod(provider, m, proxy);
                }
            }
            return proxy;
        }
        return InjectionUtils.createThreadLocalProxy(m.getParameterTypes()[0]);
    }

    private <T> Map<Class<?>, Map<T, ThreadLocalProxy<?>>> getProxyMap(String prop, boolean create) {
        if (this.bus.getProperties() instanceof ConcurrentHashMap) {
            return (Map)this.bus.getProperties().computeIfAbsent(prop, k -> new ConcurrentHashMap(2));
        }
        ConcurrentHashMap property = null;
        property = this.bus.getProperty(prop);
        if (property == null && create) {
            ConcurrentHashMap map = new ConcurrentHashMap(2);
            this.bus.setProperty(prop, map);
            property = map;
        }
        return property;
    }

    private ThreadLocalProxyCopyOnWriteArraySet<ThreadLocalProxy<?>> getProxySet() {
        ThreadLocalProxyCopyOnWriteArraySet property = null;
        property = this.bus.getProperty(PROXY_SET);
        if (property == null) {
            ThreadLocalProxyCopyOnWriteArraySet proxyMap = new ThreadLocalProxyCopyOnWriteArraySet();
            this.bus.setProperty(PROXY_SET, proxyMap);
            property = proxyMap;
        }
        return property;
    }

    public Map<Class<?>, ThreadLocalProxy<?>> getConstructorProxies() {
        if (this.constructorProxiesAvailable) {
            return this.getConstructorProxyMap().get(this.serviceClass);
        }
        return null;
    }

    private Map<Class<?>, Map<Class<?>, ThreadLocalProxy<?>>> getConstructorProxyMap() {
        ConcurrentHashMap property = this.bus.getProperty(CONSTRUCTOR_PROXY_MAP);
        if (property == null) {
            ConcurrentHashMap map = new ConcurrentHashMap(2);
            this.bus.setProperty(CONSTRUCTOR_PROXY_MAP, map);
            property = map;
        }
        return property;
    }

    private Map<Class<?>, Map<Field, ThreadLocalProxy<?>>> getFieldProxyMap(boolean create) {
        return this.getProxyMap(FIELD_PROXY_MAP, create);
    }

    private Map<Class<?>, Map<Method, ThreadLocalProxy<?>>> getSetterProxyMap(boolean create) {
        return this.getProxyMap(SETTER_PROXY_MAP, create);
    }

    private void findContextSetterMethods(Class<?> cls, Object provider, ProviderContextInfo contextInfo) {
        ProviderContextInfo superContextInfo;
        Class<?>[] interfaces;
        if (contextInfo == null || contextInfo.methodNames != null) {
            block0: for (Method m : cls.getMethods()) {
                String methodName = m.getName();
                if (contextInfo != null && !contextInfo.methodNames.contains(methodName) || !methodName.startsWith("set") || m.getParameterTypes().length != 1) continue;
                for (Annotation a : m.getAnnotations()) {
                    if (a.annotationType() != Context.class) continue;
                    this.checkContextMethod(m, provider);
                    continue block0;
                }
            }
        }
        for (Class<?> i : interfaces = cls.getInterfaces()) {
            ProviderContextInfo iContextInfo = CONTEXT_PROPS.get(i.getName());
            if (iContextInfo != null && !iContextInfo.processingRequired) continue;
            this.findContextSetterMethods(i, provider, iContextInfo);
        }
        Class<?> superCls = cls.getSuperclass();
        if (superCls != null && superCls != Object.class && ((superContextInfo = CONTEXT_PROPS.get(superCls.getName())) == null || superContextInfo.processingRequired)) {
            this.findContextSetterMethods(superCls, provider, superContextInfo);
        }
    }

    private void checkContextMethod(Method m, Object provider) {
        Class<?> type = m.getParameterTypes()[0];
        if (type.isInterface() || type == Application.class) {
            this.checkContextClass(type);
            this.addContextMethod(type, m, provider);
        }
    }

    private void checkContextClass(Class<?> type) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && !STANDARD_CONTEXT_CLASSES.contains(type.getName())) {
            Tr.debug((TraceComponent)tc, (String)("Injecting a custom context " + type.getName() + ", ContextProvider is required for this type"), (Object[])new Object[0]);
        }
    }

    public Map<Class<?>, Method> getContextMethods() {
        Map<Class<?>, Method> methods = this.contextMethods == null ? null : this.contextMethods.get(this.getServiceClass());
        return methods == null ? Collections.EMPTY_MAP : Collections.unmodifiableMap(methods);
    }

    private void addContextMethod(Class<?> contextClass, Method m, Object provider) {
        if (this.contextMethods == null) {
            this.contextMethods = new HashMap();
        }
        this.addToMap(this.contextMethods, contextClass, m);
        if (m.getParameterTypes()[0] != Application.class) {
            ThreadLocalProxy<?> proxy = AbstractResourceInfo.getMethodThreadLocalProxy(m, provider);
            boolean added = this.addToMap(this.getSetterProxyMap(true), m, proxy);
            if (added) {
                ThreadLocalProxyCopyOnWriteArraySet<ThreadLocalProxy<?>> proxySet = this.getProxySet();
                proxySet.add(proxy);
            }
        }
    }

    public boolean isRoot() {
        return this.root;
    }

    public Class<?> getResourceClass() {
        return this.resourceClass;
    }

    public List<Field> getContextFields() {
        return this.getList(this.contextFields);
    }

    public ThreadLocalProxy<?> getContextFieldProxy(Field f) {
        return this.getProxy(this.getFieldProxyMap(true), f);
    }

    public ThreadLocalProxy<?> getContextSetterProxy(Method m) {
        return this.getProxy(this.getSetterProxyMap(true), m);
    }

    public abstract boolean isSingleton();

    public static void clearAllMaps() {
        Bus bus = BusFactory.getThreadDefaultBus((boolean)false);
        if (bus != null) {
            Object property = bus.getProperty(FIELD_PROXY_MAP);
            if (property != null) {
                ((Map)property).clear();
            }
            if ((property = bus.getProperty(SETTER_PROXY_MAP)) != null) {
                ((Map)property).clear();
            }
            if ((property = bus.getProperty(CONSTRUCTOR_PROXY_MAP)) != null) {
                ((Map)property).clear();
            }
        }
    }

    public void clearThreadLocalProxies() {
        this.clearProxies(this.getFieldProxyMap(false));
        this.clearProxies(this.getSetterProxyMap(false));
        this.clearProxies(this.getConstructorProxyMap());
    }

    private <T> void clearProxies(Map<Class<?>, Map<T, ThreadLocalProxy<?>>> tlps) {
        Map<T, ThreadLocalProxy<?>> proxies;
        Map<T, ThreadLocalProxy<?>> map = proxies = tlps == null ? null : tlps.get(this.getServiceClass());
        if (proxies == null) {
            return;
        }
        for (ThreadLocalProxy<?> tlp : proxies.values()) {
            if (tlp == null) continue;
            tlp.remove();
        }
    }

    private Map<Class<?>, List<Field>> addContextField(Map<Class<?>, List<Field>> theFields, Field f) {
        List<Field> fields;
        if (theFields == null) {
            theFields = new HashMap();
        }
        if ((fields = theFields.get(this.serviceClass)) == null) {
            fields = new ArrayList<Field>();
            theFields.put(this.serviceClass, fields);
        }
        if (!fields.contains(f)) {
            fields.add(f);
        }
        return theFields;
    }

    private <T, V> boolean addToMap(Map<Class<?>, Map<T, V>> proxyMap, T f, V proxy) {
        Map<T, V> proxies = proxyMap.get(this.serviceClass);
        if (proxies == null) {
            proxies = new ConcurrentHashMap<T, V>();
            proxyMap.put(this.serviceClass, proxies);
        }
        if (!proxies.containsKey(f)) {
            proxies.put(f, proxy);
            return true;
        }
        return false;
    }

    private List<Field> getList(Map<Class<?>, List<Field>> fields) {
        List<Field> ret = fields == null ? null : fields.get(this.getServiceClass());
        ret = ret != null ? Collections.unmodifiableList(ret) : Collections.emptyList();
        return ret;
    }

    private <T> ThreadLocalProxy<?> getProxy(Map<Class<?>, Map<T, ThreadLocalProxy<?>>> proxies, T key) {
        Map<T, ThreadLocalProxy<?>> theMap = proxies == null ? null : proxies.get(this.getServiceClass());
        ThreadLocalProxy<?> ret = null;
        if (theMap != null) {
            ret = theMap.get(key);
        }
        return ret;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        STANDARD_CONTEXT_CLASSES.add(Application.class.getName());
        STANDARD_CONTEXT_CLASSES.add(UriInfo.class.getName());
        STANDARD_CONTEXT_CLASSES.add(HttpHeaders.class.getName());
        STANDARD_CONTEXT_CLASSES.add(Request.class.getName());
        STANDARD_CONTEXT_CLASSES.add(SecurityContext.class.getName());
        STANDARD_CONTEXT_CLASSES.add(Providers.class.getName());
        STANDARD_CONTEXT_CLASSES.add(ContextResolver.class.getName());
        STANDARD_CONTEXT_CLASSES.add("javax.servlet.http.HttpServletRequest");
        STANDARD_CONTEXT_CLASSES.add("javax.servlet.http.HttpServletResponse");
        STANDARD_CONTEXT_CLASSES.add("javax.servlet.ServletContext");
        STANDARD_CONTEXT_CLASSES.add("javax.ws.rs.container.ResourceContext");
        STANDARD_CONTEXT_CLASSES.add("javax.ws.rs.container.ResourceInfo");
        STANDARD_CONTEXT_CLASSES.add("javax.ws.rs.core.Configuration");
        CONTEXT_PROPS = new HashMap<String, ProviderContextInfo>();
        CONTEXT_PROPS.put("javax.ws.rs.client.ClientRequestFilter", ProviderContextInfo.NO_PROCESSING_REQUIRED);
        CONTEXT_PROPS.put("javax.ws.rs.client.ClientResponseFilter", ProviderContextInfo.NO_PROCESSING_REQUIRED);
        CONTEXT_PROPS.put("javax.ws.rs.container.ContainerRequestFilter", ProviderContextInfo.NO_PROCESSING_REQUIRED);
        CONTEXT_PROPS.put("javax.ws.rs.container.ContainerResponseFilter", ProviderContextInfo.NO_PROCESSING_REQUIRED);
        CONTEXT_PROPS.put("javax.ws.rs.container.DynamicFeature", ProviderContextInfo.NO_PROCESSING_REQUIRED);
        CONTEXT_PROPS.put("javax.ws.rs.core.Application", ProviderContextInfo.NO_PROCESSING_REQUIRED);
        CONTEXT_PROPS.put("javax.ws.rs.core.Feature", ProviderContextInfo.NO_PROCESSING_REQUIRED);
        CONTEXT_PROPS.put("javax.ws.rs.ext.ContextResolver", ProviderContextInfo.NO_PROCESSING_REQUIRED);
        CONTEXT_PROPS.put("javax.ws.rs.ext.ExceptionMapper", ProviderContextInfo.NO_PROCESSING_REQUIRED);
        CONTEXT_PROPS.put("javax.ws.rs.ext.MessageBodyWriter", ProviderContextInfo.NO_PROCESSING_REQUIRED);
        CONTEXT_PROPS.put("javax.ws.rs.ext.MessageBodyReader", ProviderContextInfo.NO_PROCESSING_REQUIRED);
        CONTEXT_PROPS.put("javax.ws.rs.ext.ParamConverterProvider", ProviderContextInfo.NO_PROCESSING_REQUIRED);
        CONTEXT_PROPS.put("javax.ws.rs.ext.ReaderInterceptor", ProviderContextInfo.NO_PROCESSING_REQUIRED);
        CONTEXT_PROPS.put("javax.ws.rs.ext.WriterInterceptor", ProviderContextInfo.NO_PROCESSING_REQUIRED);
        CONTEXT_PROPS.put("org.apache.cxf.jaxrs.provider.BinaryDataProvider", ProviderContextInfo.NO_PROCESSING_REQUIRED);
        CONTEXT_PROPS.put("org.apache.cxf.jaxrs.provider.AbstractConfigurableProvider", ProviderContextInfo.NO_PROCESSING_REQUIRED);
        CONTEXT_PROPS.put("org.apache.cxf.jaxrs.provider.SourceProvider", new ProviderContextInfo(Collections.singleton("context"), null));
        CONTEXT_PROPS.put("org.apache.cxf.jaxrs.provider.DataSourceProvider", ProviderContextInfo.NO_PROCESSING_REQUIRED);
        CONTEXT_PROPS.put("org.apache.cxf.jaxrs.provider.FormEncodingProvider", new ProviderContextInfo(Collections.singleton("mc"), null));
        CONTEXT_PROPS.put("org.apache.cxf.jaxrs.provider.StringTextProvider", ProviderContextInfo.NO_PROCESSING_REQUIRED);
        CONTEXT_PROPS.put("org.apache.cxf.jaxrs.provider.PrimitiveTextProvider", ProviderContextInfo.NO_PROCESSING_REQUIRED);
        CONTEXT_PROPS.put("org.apache.cxf.jaxrs.provider.JAXBElementProvider", new ProviderContextInfo(null, Collections.singleton("setMessageContext")));
        CONTEXT_PROPS.put("org.apache.cxf.jaxrs.provider.AbstractJAXBProvider", ProviderContextInfo.NO_PROCESSING_REQUIRED);
        CONTEXT_PROPS.put("org.apache.cxf.jaxrs.provider.JAXBElementTypedProvider", new ProviderContextInfo(null, Collections.singleton("setMessageContext")));
        CONTEXT_PROPS.put("com.ibm.ws.jaxrs21.providers.json.JsonPProvider", ProviderContextInfo.NO_PROCESSING_REQUIRED);
        CONTEXT_PROPS.put("com.ibm.ws.jaxrs21.providers.json.JsonBProvider", ProviderContextInfo.NO_PROCESSING_REQUIRED);
        CONTEXT_PROPS.put("com.ibm.ws.jaxrs20.providers.multipart.IBMMultipartProvider", new ProviderContextInfo(Collections.singleton("mc"), null));
        CONTEXT_PROPS.put("org.apache.cxf.jaxrs.provider.MultipartProvider", new ProviderContextInfo(Collections.singleton("mc"), null));
        CONTEXT_PROPS.put("org.apache.cxf.jaxrs.nio.NioMessageBodyWriter", ProviderContextInfo.NO_PROCESSING_REQUIRED);
        CONTEXT_PROPS.put("org.apache.cxf.jaxrs.model.wadl.WadlGenerator", ProviderContextInfo.NO_PROCESSING_REQUIRED);
        CONTEXT_PROPS.put("com.ibm.ws.jaxrs21.sse.LibertySseEventSinkContextProvider", ProviderContextInfo.NO_PROCESSING_REQUIRED);
        CONTEXT_PROPS.put("org.apache.cxf.jaxrs.sse.SseContextProvider", ProviderContextInfo.NO_PROCESSING_REQUIRED);
        CONTEXT_PROPS.put("com.ibm.ws.jaxrs20.providers.customexceptionmapper.CustomWebApplicationExceptionMapper", ProviderContextInfo.NO_PROCESSING_REQUIRED);
        CONTEXT_PROPS.put("com.ibm.ws.jaxrs21.security.LibertyAuthFilter", ProviderContextInfo.NO_PROCESSING_REQUIRED);
        CONTEXT_PROPS.put("org.eclipse.microprofile.rest.client.ext.ResponseExceptionMapper", ProviderContextInfo.NO_PROCESSING_REQUIRED);
        CONTEXT_PROPS.put("org.eclipse.microprofile.rest.client.ext.AsyncInvocationInterceptorFactory", ProviderContextInfo.NO_PROCESSING_REQUIRED);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class ProviderContextInfo {
        static final ProviderContextInfo NO_PROCESSING_REQUIRED;
        final boolean processingRequired;
        final Set<String> fieldNames;
        final Set<String> methodNames;
        static final long serialVersionUID = 2956773389276396240L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private ProviderContextInfo() {
            this.processingRequired = false;
            this.fieldNames = null;
            this.methodNames = null;
        }

        ProviderContextInfo(Set<String> fields, Set<String> methods) {
            this.processingRequired = true;
            this.fieldNames = fields;
            this.methodNames = methods;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(super.toString());
            sb.append(": ");
            sb.append(this.processingRequired).append(' ');
            sb.append(this.fieldNames).append(' ');
            sb.append(this.methodNames);
            return sb.toString();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxrs.model.AbstractResourceInfo$ProviderContextInfo", ProviderContextInfo.class, null, null);
            NO_PROCESSING_REQUIRED = new ProviderContextInfo();
        }
    }
}

