/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.parsers;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.feature.provisioning.ProvisioningFeatureDefinition;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.repository.common.enums.AttachmentLinkType;
import com.ibm.ws.repository.common.enums.AttachmentType;
import com.ibm.ws.repository.common.enums.DisplayPolicy;
import com.ibm.ws.repository.common.enums.DownloadPolicy;
import com.ibm.ws.repository.common.enums.LicenseType;
import com.ibm.ws.repository.common.utils.internal.RepositoryCommonUtils;
import com.ibm.ws.repository.exceptions.RepositoryException;
import com.ibm.ws.repository.parsers.exceptions.RepositoryArchiveEntryNotFoundException;
import com.ibm.ws.repository.parsers.exceptions.RepositoryArchiveException;
import com.ibm.ws.repository.parsers.exceptions.RepositoryArchiveIOException;
import com.ibm.ws.repository.parsers.exceptions.RepositoryArchiveInvalidEntryException;
import com.ibm.ws.repository.resources.writeable.AttachmentResourceWritable;
import com.ibm.ws.repository.resources.writeable.RepositoryResourceWritable;
import com.ibm.ws.repository.resources.writeable.WebDisplayable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class ParserBase {
    public static String LINK_TYPE_PROPERTY_KEY;
    public static final String LA_HEADER_PRODUCT = "License-Agreement";
    public static final String LI_HEADER_PRODUCT = "License-Information";
    public static final String LA_HEADER_FEATURE = "IBM-License-Agreement";
    public static final String LI_HEADER_FEATURE = "IBM-License-Information";
    public static final String PROP_REQUIRE_FEATURE = "requires.feature";
    public static final String PROP_APPLIES_TO_MIN_VERSION = "applies.to.minimum.version";
    public static final String PROP_APPLIES_TO_EDITIONS = "applies.to.editions";
    public static final String PROP_PROVIDER_NAME = "provider";
    public static final String PROP_NAME = "name";
    public static final String PROP_DESCRIPTION = "longDescription";
    public static final String PROP_SHORT_DESCRIPTION = "shortDescription";
    public static final String PROP_URL = "url";
    public static final String PROP_ICONS = "icons";
    public static final String PROP_DOWNLOAD_URL = "downloadURL";
    public static final String PROP_STAGED_URL = "stagedURL";
    public static String PROP_DISPLAY_POLICY;
    public static String PROP_WEB_DISPLAY_POLICY;
    public static String PROP_VANITY_URL;
    protected final String LIVE_KEY = "75621234192";
    public static final String LICENSE_TYPE = "licenseType";
    private File tempDir;
    private static final Set<String> languages;
    private static final Set<String> countries;
    protected boolean overrideLicenseToNonSpecified = false;
    static final long serialVersionUID = 268441892778471054L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyStreams(InputStream is, OutputStream os) throws IOException {
        byte[] buffer = new byte[1024];
        try {
            int read;
            while ((read = is.read(buffer)) != -1) {
                os.write(buffer, 0, read);
                buffer = new byte[1024];
            }
        }
        finally {
            if (null != os) {
                os.close();
            }
            if (null != is) {
                is.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ExtractedFileInformation extractFileFromArchive(String fileName, String regex) throws RepositoryArchiveException, RepositoryArchiveEntryNotFoundException, RepositoryArchiveIOException {
        JarFile jarFile = null;
        ExtractedFileInformation result = null;
        File outputFile = null;
        File sourceArchive = new File(fileName);
        try {
            try {
                jarFile = new JarFile(sourceArchive);
            }
            catch (FileNotFoundException | NoSuchFileException iOException) {
                void fne;
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.repository.parsers.ParserBase", (String)"244", (Object)this, (Object[])new Object[]{fileName, regex});
                throw new RepositoryArchiveException("Unable to locate archive " + fileName, sourceArchive, (Throwable)fne);
            }
            catch (IOException fne) {
                void ioe;
                FFDCFilter.processException((Throwable)fne, (String)"com.ibm.ws.repository.parsers.ParserBase", (String)"246", (Object)this, (Object[])new Object[]{fileName, regex});
                throw new RepositoryArchiveIOException("Error opening archive ", sourceArchive, (Throwable)ioe);
            }
            Enumeration<JarEntry> enumEntries = jarFile.entries();
            while (enumEntries.hasMoreElements()) {
                JarEntry entry = enumEntries.nextElement();
                String name = entry.getName();
                if (!Pattern.matches(regex, name)) continue;
                outputFile = new File(name);
                outputFile = new File(outputFile.getName());
                outputFile.deleteOnExit();
                try {
                    this.copyStreams(jarFile.getInputStream(entry), new FileOutputStream(outputFile));
                }
                catch (IOException iOException) {
                    void ioe;
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.repository.parsers.ParserBase", (String)"270", (Object)this, (Object[])new Object[]{fileName, regex});
                    throw new RepositoryArchiveIOException("Failed to extract file " + name + " inside " + fileName + " to " + outputFile.getAbsolutePath(), sourceArchive, (Throwable)ioe);
                }
                result = new ExtractedFileInformation(outputFile, sourceArchive, name);
                break;
            }
        }
        catch (Throwable throwable) {
            try {
                if (null == jarFile) throw throwable;
                jarFile.close();
                throw throwable;
            }
            catch (IOException iOException) {
                void e;
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.repository.parsers.ParserBase", (String)"286", (Object)this, (Object[])new Object[]{fileName, regex});
                e.printStackTrace();
                throw new RepositoryArchiveIOException("Error closing archive ", sourceArchive, (Throwable)e);
            }
        }
        try {
            if (null != jarFile) {
                jarFile.close();
            }
        }
        catch (IOException enumEntries) {
            void e;
            FFDCFilter.processException((Throwable)enumEntries, (String)"com.ibm.ws.repository.parsers.ParserBase", (String)"286", (Object)this, (Object[])new Object[]{fileName, regex});
            e.printStackTrace();
            throw new RepositoryArchiveIOException("Error closing archive ", sourceArchive, (Throwable)e);
        }
        if (null != outputFile) return result;
        throw new RepositoryArchiveEntryNotFoundException("Failed to find file matching regular expression <" + regex + "> inside archive " + fileName, sourceArchive, regex);
    }

    public void tidyUp() {
        this.deleteDir(this.tempDir);
        this.tempDir.delete();
    }

    private void deleteDir(File dir) {
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                this.deleteDir(f);
            }
            if (f.delete()) continue;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.repository.parsers.ParserBase", (String)"316", (Object)this, (Object[])new Object[]{dir});
                f.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File unpackToTempDir(File zipFile) throws IOException {
        try {
            this.tempDir = File.createTempFile("packedEsa", null);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.repository.parsers.ParserBase", (String)"327", (Object)this, (Object[])new Object[]{zipFile});
            String temp = System.getProperty("java.io.tmpdir");
            File recreateTempDir = new File(temp);
            recreateTempDir.mkdirs();
            this.tempDir = File.createTempFile("packedEsa", null);
        }
        if (!this.tempDir.delete()) {
            throw new IOException("Couldn't delete temp file " + this.tempDir.getAbsolutePath());
        }
        if (!this.tempDir.mkdir()) {
            throw new IOException("Couldn't create temp dir " + this.tempDir.getAbsolutePath());
        }
        this.tempDir.deleteOnExit();
        FileInputStream fis = new FileInputStream(zipFile);
        ZipInputStream zis = new ZipInputStream(fis);
        try {
            ZipEntry ze = zis.getNextEntry();
            byte[] buf = new byte[2048];
            while (ze != null) {
                if (!ze.isDirectory()) {
                    String fileName = ze.getName();
                    File unzippedFile = new File(this.tempDir.getCanonicalPath() + File.separator + fileName);
                    new File(unzippedFile.getParent()).mkdirs();
                    try (FileOutputStream fos = new FileOutputStream(unzippedFile);){
                        int numBytes;
                        while ((numBytes = zis.read(buf)) > 0) {
                            fos.write(buf, 0, numBytes);
                        }
                    }
                }
                ze = zis.getNextEntry();
            }
        }
        finally {
            zis.closeEntry();
            zis.close();
        }
        for (File f : this.listAllFilesAndDirectories(this.tempDir)) {
            f.deleteOnExit();
        }
        return this.tempDir;
    }

    public Collection<File> listAllFilesAndDirectories(File rootDir) {
        return this.doListAllFiles(rootDir, true);
    }

    public Collection<File> listAllFiles(File rootDir) {
        return this.doListAllFiles(rootDir, false);
    }

    private Collection<File> doListAllFiles(File rootDir, boolean includeDirectories) {
        File[] files;
        Stack<File> result = new Stack<File>();
        for (File f : files = rootDir.listFiles()) {
            if (f.isDirectory()) {
                if (includeDirectories) {
                    result.add(f);
                }
                result.addAll(this.doListAllFiles(f, includeDirectories));
                continue;
            }
            if (!f.isFile()) continue;
            result.add(f);
        }
        return result;
    }

    public ArtifactMetadata explodeArtifact(File archiveFile) throws RepositoryArchiveException {
        return this.explodeArtifact(archiveFile, null);
    }

    /*
     * WARNING - void declaration
     */
    public ArtifactMetadata explodeArtifact(File archiveFile, File metadataFile) throws RepositoryArchiveException {
        String zipPath;
        String path;
        try {
            path = archiveFile.getCanonicalPath();
        }
        catch (IOException iOException) {
            void e;
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.repository.parsers.ParserBase", (String)"441", (Object)this, (Object[])new Object[]{archiveFile, metadataFile});
            throw new RepositoryArchiveException("Failed to get the path for the archive", archiveFile, (Throwable)e);
        }
        if (metadataFile != null) {
            try {
                zipPath = metadataFile.getCanonicalPath();
            }
            catch (IOException iOException) {
                void e;
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.repository.parsers.ParserBase", (String)"449", (Object)this, (Object[])new Object[]{archiveFile, metadataFile});
                throw new RepositoryArchiveException("Failed to get the path for the metadata file", metadataFile, (Throwable)e);
            }
        } else {
            zipPath = path + ".metadata.zip";
        }
        File zip = new File(zipPath);
        if (!zip.exists()) {
            return null;
        }
        return this.explodeZip(zip);
    }

    public ArtifactMetadata explodeZip(File zip) throws RepositoryArchiveException {
        ArtifactMetadata artifact = new ArtifactMetadata(zip);
        this.checkRequiredProperties(artifact);
        return artifact;
    }

    protected void checkRequiredProperties(ArtifactMetadata artifact) throws RepositoryArchiveInvalidEntryException {
        this.checkPropertySet(PROP_NAME, artifact);
        this.checkPropertySet(PROP_DESCRIPTION, artifact);
        this.checkPropertySet(PROP_SHORT_DESCRIPTION, artifact);
    }

    public void attachLicenseData(ArtifactMetadata licensedArtifact, RepositoryResourceWritable resource) throws RepositoryException {
        for (File licenseFile : licensedArtifact.licenseFiles) {
            String licenseName = licenseFile.getName();
            if (!this.isLocale(licenseName = licenseName.substring(0, licenseName.lastIndexOf(".")))) continue;
            resource.addLicense(licenseFile, RepositoryCommonUtils.localeForString((String)licenseName));
        }
        resource.setLicenseType(licensedArtifact.licenseType);
    }

    public boolean isLocale(String localeText) {
        if (localeText.contains("_")) {
            String[] languageAndCountry = localeText.split("_");
            return languages.contains(languageAndCountry[0]) && countries.contains(languageAndCountry[1]);
        }
        return languages.contains(localeText);
    }

    protected void processLAandLI(File archive, RepositoryResourceWritable resource, ProvisioningFeatureDefinition feature) throws IOException, RepositoryException {
        String LAHeader = feature.getHeader(LA_HEADER_FEATURE);
        String LIHeader = feature.getHeader(LI_HEADER_FEATURE);
        this.processLAandLI(archive, resource, LAHeader, LIHeader);
    }

    protected void processLAandLI(File archive, RepositoryResourceWritable resource, Manifest manifest) throws RepositoryException, IOException {
        Attributes attribs = manifest.getMainAttributes();
        String LAHeader = attribs.getValue(LA_HEADER_PRODUCT);
        String LIHeader = attribs.getValue(LI_HEADER_PRODUCT);
        this.processLAandLI(archive, resource, LAHeader, LIHeader);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processLAandLI(File archive, RepositoryResourceWritable resource, String LAHeader, String LIHeader) throws IOException, RepositoryException {
        if (LAHeader == null && LIHeader == null) {
            return;
        }
        if (resource.getLicenseType() == LicenseType.UNSPECIFIED || this.overrideLicenseToNonSpecified) {
            if (LAHeader == null) {
                throw new RepositoryException("New licenseTerms require LA. " + archive.getCanonicalPath());
            }
        } else if (LAHeader == null && LIHeader != null || LAHeader != null && LIHeader == null) {
            System.err.println("LA/LI Problem with archive" + archive.getCanonicalPath());
            System.err.println("LAHeader = " + LAHeader);
            System.err.println("LIHeader = " + LIHeader);
            System.err.println("Both must be specified if either are present. Processing aborted.");
            throw new RepositoryException("Problem in processLAandLI uploading " + archive.getCanonicalPath());
        }
        FileSystem archiveFS = FileSystems.newFileSystem(archive.toPath(), null);
        try {
            File tempFile;
            Path temp;
            String localeText;
            Path tempDir = Files.createTempDirectory("unpackedEsa", new FileAttribute[0]);
            tempDir.toFile().deleteOnExit();
            if (LAHeader != null) {
                String laPrefix = LAHeader.substring(LAHeader.lastIndexOf("/") + 1) + "_";
                Collection<Path> laPaths = ParserBase.findFiles(archiveFS, LAHeader);
                for (Path laPath : laPaths) {
                    localeText = laPath.getFileName().toString().substring(laPrefix.length());
                    if (!this.isLocale(localeText)) continue;
                    temp = tempDir.resolve(laPath.getFileName().toString());
                    tempFile = temp.toFile();
                    tempFile.deleteOnExit();
                    Files.copy(laPath, temp, StandardCopyOption.REPLACE_EXISTING);
                    resource.addLicenseAgreement(tempFile, RepositoryCommonUtils.localeForString((String)localeText));
                }
            }
            if (LIHeader != null) {
                String liPrefix = LIHeader.substring(LIHeader.lastIndexOf("/") + 1) + "_";
                Collection<Path> liPaths = ParserBase.findFiles(archiveFS, LIHeader);
                for (Path liPath : liPaths) {
                    localeText = liPath.getFileName().toString().substring(liPrefix.length());
                    if (!this.isLocale(localeText)) continue;
                    temp = tempDir.resolve(liPath.getFileName().toString());
                    tempFile = temp.toFile();
                    tempFile.deleteOnExit();
                    Files.copy(liPath, temp, StandardCopyOption.REPLACE_EXISTING);
                    resource.addLicenseInformation(tempFile, RepositoryCommonUtils.localeForString((String)localeText));
                }
            }
            if (archiveFS == null) return;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.repository.parsers.ParserBase", (String)"589", (Object)this, (Object[])new Object[]{archive, resource, LAHeader, LIHeader});
            if (archiveFS == null) throw throwable;
            try {
                archiveFS.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.repository.parsers.ParserBase", (String)"589", (Object)this, (Object[])new Object[]{archive, resource, LAHeader, LIHeader});
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        archiveFS.close();
    }

    private static Collection<Path> findFiles(FileSystem fs, final String contains) throws IOException {
        final ArrayList<Path> rv = new ArrayList<Path>();
        Iterator<Path> dirs = fs.getRootDirectories().iterator();
        Files.walkFileTree(dirs.next(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){
            static final long serialVersionUID = -248705131589551639L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                if (file.toString().contains(contains)) {
                    rv.add(file);
                }
                return FileVisitResult.CONTINUE;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.repository.parsers.ParserBase$1", 1.class, null, null);
            }
        });
        if (dirs.hasNext()) {
            throw new IOException("FileSystem had more than one root directory: " + fs);
        }
        return rv;
    }

    protected void addContent(RepositoryResourceWritable res, File assetFile, String name, ArtifactMetadata metadata, String contentUrl) throws RepositoryException {
        String downloadUrl = contentUrl;
        String linkTypeString = null;
        if (metadata != null && metadata.properties != null) {
            if (downloadUrl == null) {
                downloadUrl = metadata.properties.getProperty(PROP_DOWNLOAD_URL);
            }
            linkTypeString = metadata.properties.getProperty(LINK_TYPE_PROPERTY_KEY);
        }
        if (downloadUrl != null && !downloadUrl.isEmpty()) {
            AttachmentLinkType linkType = linkTypeString != null ? AttachmentLinkType.valueOf(linkTypeString) : null;
            res.addContent(assetFile, name, downloadUrl, linkType);
        } else if (assetFile != null) {
            res.addContent(assetFile, name);
        } else {
            res.setDownloadPolicy(DownloadPolicy.INSTALLER);
            res.setDisplayPolicy(DisplayPolicy.HIDDEN);
        }
    }

    public String getAppliesTo(ArtifactMetadata amd) throws RepositoryException {
        String editonString;
        StringBuilder appliesToBuilder = new StringBuilder("com.ibm.websphere.appserver");
        String minVersion = amd.getProperty(PROP_APPLIES_TO_MIN_VERSION);
        if (minVersion != null && !minVersion.isEmpty()) {
            appliesToBuilder.append("; productVersion=");
            appliesToBuilder.append(minVersion);
            appliesToBuilder.append("+");
        }
        if ((editonString = ParserBase.convertCommaSeparatedListToEditionString(amd.getProperty(PROP_APPLIES_TO_EDITIONS))) != null && !editonString.isEmpty()) {
            appliesToBuilder.append(editonString);
        }
        return appliesToBuilder.toString();
    }

    public void checkPropertySet(String propName, ArtifactMetadata amd) throws RepositoryArchiveInvalidEntryException {
        String prop = amd.getProperty(propName);
        if (prop == null) {
            throw new RepositoryArchiveInvalidEntryException("No " + propName + " field was specified in the properties file", amd.getArchive(), "*.properties");
        }
    }

    /*
     * WARNING - void declaration
     */
    private static String convertCommaSeparatedListToEditionString(String csList) throws RepositoryException {
        if (csList == null) {
            return null;
        }
        csList = csList.trim();
        ArrayList<Edition> editions = new ArrayList<Edition>();
        if (csList.length() > 0) {
            String[] sArray;
            for (String s : sArray = csList.split(",")) {
                if (s.length() == 0) continue;
                try {
                    editions.add(Edition.valueOf(s));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    void e;
                    FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ws.repository.parsers.ParserBase", (String)"740", null, (Object[])new Object[]{csList});
                    throw new RepositoryException("The list of editions '" + s + "' contained an invalid edition", (Throwable)e);
                }
            }
        }
        String editionString = null;
        for (Edition ed : editions) {
            if (editionString == null) {
                editionString = "; productEdition=\"";
                editionString = editionString + ed.getProductEdition();
                continue;
            }
            editionString = editionString + "," + ed.getProductEdition();
        }
        editionString = editionString == null ? "" : editionString + "\"";
        return editionString;
    }

    public List<String> getRequiresFeature(ArtifactMetadata amd) {
        String[] features;
        ArrayList<String> requiresFeature = new ArrayList<String>();
        String requiresFeatureProp = amd.getProperty(PROP_REQUIRE_FEATURE);
        if (requiresFeatureProp == null) {
            return null;
        }
        if (requiresFeatureProp.equals("")) {
            return requiresFeature;
        }
        for (String feature : features = requiresFeatureProp.split("\\,")) {
            requiresFeature.add(feature.trim());
        }
        return requiresFeature;
    }

    protected void processIcons(ArtifactMetadata amd, RepositoryResourceWritable res) throws RepositoryException {
        String current = "";
        String sizeString = "";
        String iconName = "";
        String iconNames = amd.getIcons();
        if (iconNames != null) {
            iconNames.replaceAll("\\s", "");
            StringTokenizer s = new StringTokenizer(iconNames, ",");
            while (s.hasMoreTokens()) {
                File icon;
                current = s.nextToken();
                int size = 0;
                if (current.contains(";")) {
                    StringTokenizer t = new StringTokenizer(current, ";");
                    while (t.hasMoreTokens()) {
                        sizeString = t.nextToken();
                        if (sizeString.contains("size=")) {
                            String[] sizes = sizeString.split("size=");
                            size = Integer.parseInt(sizes[sizes.length - 1]);
                            continue;
                        }
                        iconName = sizeString;
                    }
                } else {
                    iconName = current;
                }
                if ((icon = this.extractFileFromArchive(amd.getArchive().getAbsolutePath(), iconName).getExtractedFile()).exists()) {
                    AttachmentResourceWritable at = res.addAttachment(icon, AttachmentType.THUMBNAIL);
                    if (size == 0) continue;
                    at.setImageDimensions(size, size);
                    continue;
                }
                throw new RepositoryArchiveEntryNotFoundException("Icon does not exist", amd.getArchive(), iconName);
            }
        }
    }

    public String getProviderName(ArtifactMetadata amd) {
        return amd.getProperty(PROP_PROVIDER_NAME);
    }

    public void setCommonFieldsFromSideZip(ArtifactMetadata amd, RepositoryResourceWritable resource) {
        String webDisplayPolicy;
        resource.setDescription(amd.getLongDescription());
        resource.setShortDescription(amd.getShortDescription());
        resource.setName(amd.getName());
        resource.setVanityURL(amd.getProperty(PROP_VANITY_URL));
        String displayPolicy = amd.getProperty(PROP_DISPLAY_POLICY);
        if (displayPolicy != null) {
            resource.setDisplayPolicy(DisplayPolicy.valueOf((String)displayPolicy));
        }
        if ((webDisplayPolicy = amd.getProperty(PROP_WEB_DISPLAY_POLICY)) != null && !webDisplayPolicy.isEmpty() && resource instanceof WebDisplayable) {
            ((WebDisplayable)resource).setWebDisplayPolicy(DisplayPolicy.valueOf((String)webDisplayPolicy));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean doesZipContainFileTypes(File file, String ... fileTypes) {
        boolean bl;
        ZipFile zip;
        block14: {
            if (!file.getName().endsWith(".zip")) {
                return false;
            }
            zip = null;
            zip = new ZipFile(file);
            boolean[] foundFileTypes23333332 = new boolean[fileTypes.length];
            boolean foundAll = false;
            Enumeration<? extends ZipEntry> entries2222222 = zip.entries();
            while (entries2222222.hasMoreElements() && !foundAll) {
                foundAll = true;
                ZipEntry entry = entries2222222.nextElement();
                String name = entry.getName();
                for (int i = 0; i < fileTypes.length; ++i) {
                    if (foundFileTypes23333332[i]) continue;
                    foundFileTypes23333332[i] = name.endsWith(fileTypes[i]);
                    if (!foundAll) continue;
                    foundAll = foundFileTypes23333332[i];
                }
            }
            bl = foundAll;
            if (zip == null) break block14;
            try {
                zip.close();
            }
            catch (IOException name) {
                FFDCFilter.processException((Throwable)name, (String)"com.ibm.ws.repository.parsers.ParserBase", (String)"915", null, (Object[])new Object[]{file, fileTypes});
                return false;
            }
        }
        return bl;
        catch (IOException foundFileTypes23333332) {
            boolean bl2;
            block15: {
                try {
                    FFDCFilter.processException((Throwable)foundFileTypes23333332, (String)"com.ibm.ws.repository.parsers.ParserBase", (String)"909", null, (Object[])new Object[]{file, fileTypes});
                    bl2 = false;
                    if (zip == null) break block15;
                }
                catch (Throwable throwable) {
                    if (zip != null) {
                        try {
                            zip.close();
                        }
                        catch (IOException iOException) {
                            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.repository.parsers.ParserBase", (String)"915", null, (Object[])new Object[]{file, fileTypes});
                            return false;
                        }
                    }
                    throw throwable;
                }
                try {
                    zip.close();
                }
                catch (IOException entries2222222) {
                    FFDCFilter.processException((Throwable)entries2222222, (String)"com.ibm.ws.repository.parsers.ParserBase", (String)"915", null, (Object[])new Object[]{file, fileTypes});
                    return false;
                }
            }
            return bl2;
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.repository.parsers.ParserBase", ParserBase.class, null, null);
        LINK_TYPE_PROPERTY_KEY = "linkType";
        PROP_DISPLAY_POLICY = "displayPolicy";
        PROP_WEB_DISPLAY_POLICY = "webDisplayPolicy";
        PROP_VANITY_URL = "vanityUrl";
        languages = new HashSet<String>(Arrays.asList(Locale.getISOLanguages()));
        countries = new HashSet<String>(Arrays.asList(Locale.getISOCountries()));
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public class ArtifactMetadata {
        public Collection<File> licenseFiles;
        private final Properties properties;
        private final Collection<File> otherFiles;
        private LicenseType licenseType;
        private final File archive;
        static final long serialVersionUID = -824145237762276395L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private ArtifactMetadata(File zip) throws RepositoryArchiveException {
            Reader descriptionReader;
            block26: {
                this.archive = zip;
                this.licenseFiles = new ArrayList<File>();
                this.properties = new Properties();
                this.otherFiles = new ArrayList<File>();
                File propertiesFile = null;
                File descriptionFile = null;
                File tempDir = null;
                try {
                    tempDir = ParserBase.this.unpackToTempDir(zip);
                }
                catch (IOException iOException) {
                    void ioe;
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.repository.parsers.ParserBase$ArtifactMetadata", (String)"946", (Object)this, (Object[])new Object[]{zip});
                    throw new RepositoryArchiveException("Failed to extract contents from archive", zip, (Throwable)ioe);
                }
                Collection<File> allTempFiles = ParserBase.this.listAllFiles(tempDir);
                File assetInfo = new File(tempDir, "assetInfo.properties");
                if (assetInfo.exists()) {
                    propertiesFile = assetInfo;
                    allTempFiles.remove(assetInfo);
                }
                for (File f : allTempFiles) {
                    String name;
                    if (!f.isFile()) continue;
                    try {
                        name = f.getCanonicalPath();
                    }
                    catch (IOException iOException) {
                        void e;
                        FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.repository.parsers.ParserBase$ArtifactMetadata", (String)"963", (Object)this, (Object[])new Object[]{zip});
                        throw new RepositoryArchiveInvalidEntryException("Failed to read entry " + f.getAbsolutePath() + " in archive " + zip.getName(), zip, f.getAbsolutePath(), (Throwable)e);
                    }
                    if (propertiesFile == null && name.endsWith(".properties")) {
                        propertiesFile = f;
                        continue;
                    }
                    if (descriptionFile == null && f.getName().equalsIgnoreCase("description.html")) {
                        descriptionFile = f;
                        continue;
                    }
                    if (f.getParentFile().getName().equalsIgnoreCase("lafiles")) {
                        this.licenseFiles.add(f);
                        continue;
                    }
                    this.otherFiles.add(f);
                }
                if (propertiesFile == null) {
                    throw new RepositoryArchiveEntryNotFoundException("No properties file", zip, "*.properties");
                }
                FileReader propertiesReader = null;
                descriptionReader = null;
                try {
                    propertiesReader = new FileReader(propertiesFile);
                    this.properties.load(propertiesReader);
                    String licenseTypeInProps2332 = this.properties.getProperty(ParserBase.LICENSE_TYPE.toString());
                    if (licenseTypeInProps2332 != null) {
                        this.licenseType = LicenseType.valueOf((String)licenseTypeInProps2332);
                    }
                    if (descriptionFile != null) {
                        int chars;
                        descriptionReader = new InputStreamReader((InputStream)new FileInputStream(descriptionFile), "UTF-8");
                        char[] buf = new char[1024];
                        StringBuilder builder = new StringBuilder();
                        while ((chars = descriptionReader.read(buf, 0, 1024)) != -1) {
                            builder.append(buf, 0, chars);
                        }
                        this.properties.setProperty(ParserBase.PROP_DESCRIPTION, builder.toString());
                    }
                    if (propertiesReader == null) break block26;
                }
                catch (IOException e) {
                    try {
                        void iox;
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.repository.parsers.ParserBase$ArtifactMetadata", (String)"1008", (Object)this, (Object[])new Object[]{zip});
                        throw new RepositoryArchiveIOException("Failed to read properties, licence and description from archive " + zip.getName(), zip, (Throwable)iox);
                    }
                    catch (Throwable throwable) {
                        if (propertiesReader != null) {
                            try {
                                propertiesReader.close();
                            }
                            catch (IOException iOException) {
                                void e2;
                                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.repository.parsers.ParserBase$ArtifactMetadata", (String)"1014", (Object)this, (Object[])new Object[]{zip});
                                throw new RepositoryArchiveIOException("Failed to close the file reader that was reading the properties in the archive" + zip.getName(), zip, (Throwable)e2);
                            }
                        }
                        if (descriptionReader == null) throw throwable;
                        try {
                            descriptionReader.close();
                            throw throwable;
                        }
                        catch (IOException e2) {
                            void e3;
                            FFDCFilter.processException((Throwable)e2, (String)"com.ibm.ws.repository.parsers.ParserBase$ArtifactMetadata", (String)"1023", (Object)this, (Object[])new Object[]{zip});
                            throw new RepositoryArchiveIOException("Failed to close the file reader that was reading the description.html file" + zip.getName(), zip, (Throwable)e3);
                        }
                    }
                }
                try {
                    propertiesReader.close();
                }
                catch (IOException licenseTypeInProps2332) {
                    FFDCFilter.processException((Throwable)licenseTypeInProps2332, (String)"com.ibm.ws.repository.parsers.ParserBase$ArtifactMetadata", (String)"1014", (Object)this, (Object[])new Object[]{zip});
                    throw new RepositoryArchiveIOException("Failed to close the file reader that was reading the properties in the archive" + zip.getName(), zip, (Throwable)e);
                }
            }
            if (descriptionReader == null) return;
            try {
                descriptionReader.close();
                return;
            }
            catch (IOException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.repository.parsers.ParserBase$ArtifactMetadata", (String)"1023", (Object)this, (Object[])new Object[]{zip});
                throw new RepositoryArchiveIOException("Failed to close the file reader that was reading the description.html file" + zip.getName(), zip, e);
            }
        }

        public String getName() {
            return this.properties.getProperty(ParserBase.PROP_NAME);
        }

        public String getShortDescription() {
            return this.properties.getProperty(ParserBase.PROP_SHORT_DESCRIPTION);
        }

        public String getLongDescription() {
            return this.properties.getProperty(ParserBase.PROP_DESCRIPTION);
        }

        public String getIcons() {
            return this.properties.getProperty(ParserBase.PROP_ICONS);
        }

        public File getArchive() {
            return this.archive;
        }

        public String getProperty(String propName) {
            return this.properties.getProperty(propName);
        }

        public Collection<File> getOtherFiles() {
            return this.otherFiles;
        }

        public File getFileWithExtension(String ext) {
            File retFile = null;
            for (File f : this.otherFiles) {
                if (!f.getName().endsWith(ext)) continue;
                retFile = f;
                break;
            }
            return retFile;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.repository.parsers.ParserBase$ArtifactMetadata", ArtifactMetadata.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class ExtractedFileInformation {
        private final File extractedFile;
        private final File sourceArchive;
        private final String selectedPathFromArchive;
        static final long serialVersionUID = -5443173154996129441L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ExtractedFileInformation(File extractedFile, File sourceArchive, String selectedPathFromArchive) {
            this.extractedFile = extractedFile;
            this.sourceArchive = sourceArchive;
            this.selectedPathFromArchive = selectedPathFromArchive;
        }

        public File getExtractedFile() {
            return this.extractedFile;
        }

        public File getSourceArchive() {
            return this.sourceArchive;
        }

        public String getSelectedPathFromArchive() {
            return this.selectedPathFromArchive;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.repository.parsers.ParserBase$ExtractedFileInformation", ExtractedFileInformation.class, null, null);
        }
    }

    public static enum Edition {
        CORE("CORE"),
        BASE("BASE"),
        DEVELOPERS("DEVELOPERS"),
        EXPRESS("EXPRESS"),
        ND("ND"),
        zOS("zOS"),
        BASE_ILAN("BASE_ILAN"),
        EARLY_ACCESS("EARLY_ACCESS"),
        Open("Open"),
        Open_Web("Open_Web");

        private String _productEdition;

        private Edition(String productEdition) {
            this._productEdition = productEdition;
        }

        public String getProductEdition() {
            return this._productEdition;
        }
    }
}

