/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.h2internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.http.channel.h2internal.H2InboundLink;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.tcpchannel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcpchannel.TCPReadRequestContext;
import java.io.IOException;
import java.net.SocketTimeoutException;

public class H2MuxTCPReadCallback
implements TCPReadCompletedCallback {
    H2InboundLink connLink = null;
    private static final TraceComponent tc = Tr.register(H2MuxTCPReadCallback.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");

    public void setConnLinkCallback(H2InboundLink _link) {
        this.connLink = _link;
    }

    public void complete(VirtualConnection vc, TCPReadRequestContext rrc) {
        if (this.connLink != null) {
            this.connLink.setReadLinkStatusToNotReadingAndNotify();
            this.connLink.processRead(vc, rrc);
        }
    }

    public void error(VirtualConnection vc, TCPReadRequestContext rrc, IOException exception) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("H2MuxTCPReadCallback error callback called with exception: " + exception), (Object[])new Object[0]);
        }
        if (this.connLink != null) {
            WsByteBuffer wsbb;
            if (exception instanceof SocketTimeoutException) {
                int rTimeout = this.connLink.getconfiguredInactivityTimeout();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("H2MuxTCPReadCallback error: configured readTimeout: " + rTimeout), (Object[])new Object[0]);
                }
                if (rTimeout != 0 && !this.connLink.checkIfGoAwaySendingOrClosing()) {
                    long wLastTime = this.connLink.getLastWriteTime();
                    long diff = System.nanoTime() - wLastTime;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("H2MuxTCPReadCallback error: last write time: " + wLastTime + " diff: " + diff), (Object[])new Object[0]);
                    }
                    if (diff < (long)rTimeout) {
                        int nextTimeout = rTimeout - (int)diff;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("H2MuxTCPReadCallback error: continuing reading, setting nextTimeout to: " + nextTimeout), (Object[])new Object[0]);
                        }
                        this.connLink.setReadLinkStatusToNotReadingAndNotify();
                        this.connLink.processRead(vc, rrc, nextTimeout);
                        return;
                    }
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"H2MuxTCPReadCallback error: closing connection", (Object[])new Object[0]);
            }
            this.connLink.setReadLinkStatusToNotReadingAndNotify();
            if (this.connLink.getFreeBufferOnError() && (wsbb = rrc.getBuffer()) != null) {
                wsbb.release();
                rrc.setBuffer(null);
            }
            if (exception instanceof SocketTimeoutException) {
                this.connLink.closeConnectionLink(exception, true);
            } else {
                this.connLink.closeConnectionLink(exception, false);
            }
        }
    }
}

