/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channelfw.internal;

import com.ibm.websphere.channelfw.CFEndPoint;
import com.ibm.websphere.channelfw.ChainData;
import com.ibm.websphere.channelfw.ChannelData;
import com.ibm.websphere.channelfw.FlowType;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.channelfw.internal.CFEndPointImpl;
import com.ibm.ws.channelfw.internal.ChildChannelDataImpl;
import com.ibm.ws.channelfw.internal.chains.InboundChain;
import com.ibm.ws.channelfw.internal.chains.OutboundChain;
import com.ibm.wsspi.channelfw.ChainEventListener;
import com.ibm.wsspi.channelfw.RetryableChainEventListener;
import com.ibm.wsspi.channelfw.exception.ChannelFrameworkException;
import com.ibm.wsspi.channelfw.exception.IncoherentChainException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public class ChainDataImpl
implements ChainData {
    private static final long serialVersionUID = 4499898682104370008L;
    private static final TraceComponent tc = Tr.register(ChainDataImpl.class, (String)"ChannelFramework", (String)"com.ibm.ws.channelfw.internal.resources.ChannelfwMessages");
    private String name = null;
    private FlowType type = null;
    private ChannelData[] channelDataArray = null;
    private final transient CopyOnWriteArraySet<ChainEventListener> chainEventListeners;
    private int channelFactoryHash = 0;
    private Map<Object, Object> properties = null;
    private transient boolean enabled = true;
    private transient CFEndPointImpl endPoint = null;

    public ChainDataImpl(String chainName, FlowType chainType, ChannelData[] channelList, Map<Object, Object> inputProperties) throws IncoherentChainException {
        this(chainName, chainType, channelList, inputProperties, new CopyOnWriteArraySet<ChainEventListener>());
    }

    private ChainDataImpl(String chainName, FlowType chainType, ChannelData[] channelList, Map<Object, Object> inputProperties, CopyOnWriteArraySet<ChainEventListener> listeners) throws IncoherentChainException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"constructor", (Object[])new Object[]{listeners});
        }
        this.name = chainName;
        this.type = chainType;
        this.channelDataArray = channelList;
        this.chainEventListeners = listeners;
        this.properties = inputProperties;
        if (chainType.equals(FlowType.INBOUND)) {
            InboundChain.verifyChainCoherency(this);
        } else {
            OutboundChain.verifyChainCoherency(this);
        }
        for (int i = 0; i < this.channelDataArray.length; ++i) {
            this.channelFactoryHash += this.channelDataArray[i].getFactoryType().hashCode();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            if (this.properties == null) {
                Tr.debug((TraceComponent)tc, (String)"Properties are null", (Object[])new Object[0]);
            } else {
                Tr.debug((TraceComponent)tc, (String)("Properties: " + this.properties.size()), (Object[])new Object[0]);
                for (Object key : this.properties.keySet()) {
                    Tr.debug((TraceComponent)tc, (String)("\tkey=" + key + ", value=" + this.properties.get(key)), (Object[])new Object[0]);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"constructor");
        }
    }

    public ChainDataImpl(ChainDataImpl oldChainData, ChannelData[] newChannelList) throws IncoherentChainException {
        this(oldChainData.getName(), oldChainData.getType(), newChannelList, oldChainData.getPropertyBag(), oldChainData.chainEventListeners);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String inputName) {
        this.name = inputName;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean flag) {
        this.enabled = flag;
    }

    @Override
    public FlowType getType() {
        return this.type;
    }

    @Override
    public ChannelData[] getChannelList() {
        return this.channelDataArray;
    }

    public int getChannelFactoryHash() {
        return this.channelFactoryHash;
    }

    public void setChannelFactoryHash(int hash) {
        this.channelFactoryHash = hash;
    }

    public Map<Object, Object> getPropertyBag() {
        if (this.properties == null) {
            this.properties = new HashMap<Object, Object>();
        }
        return this.properties;
    }

    public void setPropertyBag(Map<Object, Object> inputProperties) {
        this.properties = inputProperties;
    }

    public boolean containsChannel(String channelName) {
        boolean found = false;
        for (int i = 0; i < this.channelDataArray.length; ++i) {
            if (!this.channelDataArray[i].getName().equals(channelName)) continue;
            found = true;
            break;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("containsChannel: " + channelName + " " + found), (Object[])new Object[0]);
        }
        return found;
    }

    public ChainDataImpl getExternalChainData() {
        ChainDataImpl externalChainData;
        block5: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry((Object)this, (TraceComponent)tc, (String)"getExternalChainData", (Object[])new Object[0]);
            }
            ChannelData[] parents = new ChannelData[this.channelDataArray.length];
            for (int i = 0; i < parents.length; ++i) {
                parents[i] = ((ChildChannelDataImpl)this.channelDataArray[i]).getParent();
            }
            externalChainData = null;
            try {
                externalChainData = new ChainDataImpl(this.getName(), this.getType(), parents, null);
            }
            catch (IncoherentChainException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block5;
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Unable to build external version of chain data, " + this.getName()), (Object[])new Object[0]);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"getExternalChainData");
        }
        return externalChainData;
    }

    public final void addChainEventListener(ChainEventListener listener) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("addChainEventListener: " + listener), (Object[])new Object[0]);
        }
        if (null != listener) {
            this.chainEventListeners.add(listener);
        }
    }

    public final void removeChainEventListener(ChainEventListener listener) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("removeChainEventListener: " + listener), (Object[])new Object[0]);
        }
        if (null != listener && !this.chainEventListeners.remove(listener) && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"Cannot find listener to be removed", (Object[])new Object[0]);
        }
    }

    public Set<ChainEventListener> removeAllChainEventListeners() {
        HashSet<ChainEventListener> returnListeners = new HashSet<ChainEventListener>(this.chainEventListeners);
        this.chainEventListeners.clear();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"removeAllChainEventListeners", (Object[])new Object[]{returnListeners});
        }
        return returnListeners;
    }

    public void setChainEventListeners(Set<ChainEventListener> newListeners) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"removeAllChainEventListeners", (Object[])new Object[]{newListeners});
        }
        this.chainEventListeners.clear();
        this.chainEventListeners.addAll(newListeners);
    }

    public boolean containsChainEventListener(ChainEventListener listener) {
        return this.chainEventListeners.contains(listener);
    }

    public final void chainInitialized() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)("chainInitialized, chain: " + this.name), (Object[])new Object[0]);
        }
        for (ChainEventListener listener : this.chainEventListeners) {
            listener.chainInitialized(this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"chainInitialized");
        }
    }

    public final void chainStarted() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)("chainStarted, chain: " + this.name), (Object[])new Object[0]);
        }
        for (ChainEventListener listener : this.chainEventListeners) {
            listener.chainStarted(this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"chainStarted");
        }
    }

    public final void chainStartFailed(int attemptsMade, int attemptsLeft) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)("chainStartFailed, chain: " + this.name), (Object[])new Object[0]);
        }
        for (ChainEventListener listener : this.chainEventListeners) {
            if (!(listener instanceof RetryableChainEventListener)) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Calling chain retryable chain event listener", (Object[])new Object[0]);
            }
            ((RetryableChainEventListener)listener).chainStartFailed(this, attemptsMade, attemptsLeft);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"chainStartFailed");
        }
    }

    public final void chainStopped() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)("chainStopped, chain: " + this.name), (Object[])new Object[0]);
        }
        for (ChainEventListener listener : this.chainEventListeners) {
            listener.chainStopped(this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"chainStopped");
        }
    }

    public final void chainQuiesced() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)("chainQuiesced, chain: " + this.name), (Object[])new Object[0]);
        }
        for (ChainEventListener listener : this.chainEventListeners) {
            listener.chainQuiesced(this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"chainQuiesced");
        }
    }

    public final void chainDestroyed() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)("chainDestroyed, chain: " + this.name), (Object[])new Object[0]);
        }
        for (ChainEventListener listener : this.chainEventListeners) {
            listener.chainDestroyed(this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"chainDestroyed");
        }
    }

    protected void chainUpdated() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)("chainUpdated, chain: " + this.name), (Object[])new Object[0]);
        }
        for (ChainEventListener listener : this.chainEventListeners) {
            listener.chainUpdated(this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"chainUpdated");
        }
    }

    public CFEndPoint getEndPoint() throws ChannelFrameworkException {
        if (null == this.endPoint) {
            if (FlowType.INBOUND.equals(this.type)) {
                this.endPoint = new CFEndPointImpl(this);
            } else {
                throw new ChannelFrameworkException(this.name + " is not inbound chain");
            }
        }
        return this.endPoint;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(128);
        result.append("ChainData: ");
        result.append(this.name);
        result.append(" type=").append(this.type.getOrdinal());
        result.append(" channels [");
        for (int i = 0; i < this.channelDataArray.length; ++i) {
            result.append(this.channelDataArray[i].getName());
            result.append(',');
        }
        result.setCharAt(result.length() - 1, ']');
        if (this.chainEventListeners != null && !this.chainEventListeners.isEmpty()) {
            result.append(" listeners [");
            for (ChainEventListener listener : this.chainEventListeners) {
                result.append(listener.getClass());
                result.append(',');
            }
            result.setCharAt(result.length() - 1, ']');
        }
        return result.toString();
    }
}

