/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rest.handler.internal.service;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.rest.handler.internal.ExtendedRESTRequestImpl;
import com.ibm.ws.rest.handler.internal.helper.HandlerPath;
import com.ibm.ws.security.audit.Audit;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceSetMap;
import com.ibm.wsspi.kernel.service.utils.ServiceAndServiceReferencePair;
import com.ibm.wsspi.rest.handler.RESTHandler;
import com.ibm.wsspi.rest.handler.RESTHandlerContainer;
import com.ibm.wsspi.rest.handler.RESTRequest;
import com.ibm.wsspi.rest.handler.RESTResponse;
import com.ibm.wsspi.rest.handler.helper.DefaultAuthorizationHelper;
import com.ibm.wsspi.rest.handler.helper.DefaultRoutingHelper;
import com.ibm.wsspi.rest.handler.helper.RESTHandlerForbiddenError;
import com.ibm.wsspi.rest.handler.helper.RESTHandlerInternalError;
import com.ibm.wsspi.rest.handler.helper.RESTHandlerJsonException;
import com.ibm.wsspi.rest.handler.helper.RESTHandlerMethodNotAllowedError;
import com.ibm.wsspi.rest.handler.helper.RESTHandlerUnsupportedMediaType;
import com.ibm.wsspi.rest.handler.helper.RESTHandlerUserError;
import com.ibm.wsspi.rest.handler.helper.RESTRoutingHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={RESTHandlerContainer.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM"})
public class RESTHandlerContainerImpl
implements RESTHandlerContainer {
    private static final TraceComponent tc = Tr.register(RESTHandlerContainerImpl.class, (String)"RESTHandler", (String)"com.ibm.ws.rest.handler.internal.resources.RESTHandlerMessages");
    static final String REST_HANDLER_REF = "restHandler";
    private final String KEY_AUTHORIZATION_HELPER = "authorizationHelper";
    private final AtomicServiceReference<DefaultAuthorizationHelper> authorizationHelperRef = new AtomicServiceReference("authorizationHelper");
    private final String KEY_ROUTING_HELPER = "routingHelper";
    private final AtomicServiceReference<RESTRoutingHelper> routingHelperRef = new AtomicServiceReference("routingHelper");
    private final ConcurrentServiceReferenceSetMap<String, RESTHandler> handlerMap = new ConcurrentServiceReferenceSetMap("restHandler");
    private final CopyOnWriteArraySet<HandlerPath> handlerKeys = new CopyOnWriteArraySet();
    private final HandlerKeyMapSync handlerKeyMapSync = new HandlerKeyMapSync();
    static final long serialVersionUID = 6234413281611979879L;

    @Activate
    protected void activate(ComponentContext context, Map<String, Object> properties) {
        this.handlerMap.activate(context);
        this.authorizationHelperRef.activate(context);
        this.routingHelperRef.activate(context);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)"Activating RESTHandlerContainer", (Object[])new Object[]{properties});
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext context, int reason) {
        this.handlerMap.deactivate(context);
        this.authorizationHelperRef.deactivate(context);
        this.routingHelperRef.deactivate(context);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("Deactivating, reason=" + reason), (Object[])new Object[0]);
        }
    }

    private String[] getValues(Object propValue) {
        String[] keys = null;
        if (propValue instanceof String) {
            keys = new String[]{(String)propValue};
        } else if (propValue instanceof String[]) {
            keys = (String[])propValue;
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((Object)this, (TraceComponent)tc, (String)("Ignoring property with value: " + propValue), (Object[])new Object[0]);
            }
            return null;
        }
        for (String key : keys) {
            if (!key.startsWith("/")) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((Object)this, (TraceComponent)tc, (String)("Ignoring property with value: " + key + " as it does not start with slash ('/')"), (Object[])new Object[0]);
                }
                return null;
            }
            if (!key.isEmpty()) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((Object)this, (TraceComponent)tc, (String)("Ignoring proerty with value: " + key + " as it is empty"), (Object[])new Object[0]);
            }
            return null;
        }
        return keys;
    }

    @Reference(service=RESTRoutingHelper.class, name="routingHelper", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setRoutingHelper(ServiceReference<RESTRoutingHelper> routingHelper) {
        this.routingHelperRef.setReference(routingHelper);
    }

    protected void unsetRoutingHelper(ServiceReference<RESTRoutingHelper> routingHelper) {
        this.routingHelperRef.unsetReference(routingHelper);
    }

    protected RESTRoutingHelper getRoutingHelper() throws IOException {
        RESTRoutingHelper routingHelper = (RESTRoutingHelper)this.routingHelperRef.getService();
        if (routingHelper == null) {
            throw new IOException(Tr.formatMessage((TraceComponent)tc, (String)"OSGI_SERVICE_ERROR", (Object[])new Object[]{"RESTRoutingHelper"}));
        }
        return routingHelper;
    }

    @Reference(service=DefaultAuthorizationHelper.class, name="authorizationHelper")
    protected void setAuthorizationHelper(ServiceReference<DefaultAuthorizationHelper> authorizationHelper) {
        this.authorizationHelperRef.setReference(authorizationHelper);
    }

    protected void unsetAuthorizationHelper(ServiceReference<DefaultAuthorizationHelper> authorizationHelper) {
        this.authorizationHelperRef.unsetReference(authorizationHelper);
    }

    protected DefaultAuthorizationHelper getAuthorizationHelper() throws IOException {
        DefaultAuthorizationHelper authorizationHelper = (DefaultAuthorizationHelper)this.authorizationHelperRef.getService();
        if (authorizationHelper == null) {
            throw new IOException(Tr.formatMessage((TraceComponent)tc, (String)"OSGI_SERVICE_ERROR", (Object[])new Object[]{"DefaultAuthorizationHelper"}));
        }
        return authorizationHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(service=RESTHandler.class, name="restHandler", policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE, policyOption=ReferencePolicyOption.GREEDY)
    protected void setRestHandler(ServiceReference<RESTHandler> handler) {
        String[] rootKeys = this.getValues(handler.getProperty("com.ibm.wsspi.rest.handler.root"));
        String[] contextRootKeys = this.getValues(handler.getProperty("com.ibm.wsspi.rest.handler.context.root"));
        if (rootKeys == null) {
            return;
        }
        if (contextRootKeys == null) {
            contextRootKeys = new String[]{"/ibm/api"};
        }
        for (String contextRoot : contextRootKeys) {
            for (String rootKey : rootKeys) {
                rootKey = contextRoot + rootKey;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("New rootKey: " + rootKey), (Object[])new Object[0]);
                }
                this.handlerMap.putReference((Object)rootKey, handler);
                HandlerKeyMapSync handlerKeyMapSync = this.handlerKeyMapSync;
                synchronized (handlerKeyMapSync) {
                    boolean hidden = this.hasProperty(handler, "com.ibm.wsspi.rest.handler.hidden.api");
                    this.handlerKeys.add(new HandlerPath(rootKey, hidden));
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) continue;
                Tr.event((Object)this, (TraceComponent)tc, (String)("Mapped root [" + rootKey + "] to handler [" + handler + "] in our container."), (Object[])new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unsetRestHandler(ServiceReference<RESTHandler> handler) {
        String[] rootKeys = this.getValues(handler.getProperty("com.ibm.wsspi.rest.handler.root"));
        String[] contextRootKeys = this.getValues(handler.getProperty("com.ibm.wsspi.rest.handler.context.root"));
        if (rootKeys == null) {
            return;
        }
        if (contextRootKeys == null) {
            contextRootKeys = new String[]{"/ibm/api"};
        }
        for (String contextRoot : contextRootKeys) {
            for (String rootKey : rootKeys) {
                rootKey = contextRoot + rootKey;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("New rootKey: " + rootKey), (Object[])new Object[0]);
                }
                this.handlerMap.removeReference((Object)rootKey, handler);
                HandlerKeyMapSync handlerKeyMapSync = this.handlerKeyMapSync;
                synchronized (handlerKeyMapSync) {
                    if (this.handlerMap.getServices((Object)rootKey) == null) {
                        this.handlerKeys.remove(new HandlerPath(rootKey));
                    }
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) continue;
                Tr.event((Object)this, (TraceComponent)tc, (String)("Remove mapping from root [" + rootKey + "] to handler [" + handler + "] in our container."), (Object[])new Object[0]);
            }
        }
    }

    private boolean hasProperty(ServiceReference<RESTHandler> handler, String property) {
        Object propertyObj = handler.getProperty(property);
        return propertyObj instanceof String && "true".equalsIgnoreCase((String)propertyObj);
    }

    public HandlerInfo getHandler(String requestURL) {
        Iterator<HandlerPath> keys = this.handlerKeys.iterator();
        if (requestURL == null || keys == null) {
            return null;
        }
        Iterator itr = this.handlerMap.getServicesWithReferences((Object)requestURL);
        if (itr != null && itr.hasNext()) {
            ServiceAndServiceReferencePair handler = (ServiceAndServiceReferencePair)itr.next();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Found direct URL match: " + handler), (Object[])new Object[0]);
            }
            return new HandlerInfo((RESTHandler)handler.getService(), (ServiceReference<RESTHandler>)handler.getServiceReference());
        }
        HandlerPath bestMatchRoot = null;
        while (keys.hasNext()) {
            HandlerPath key = keys.next();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Checking HandlerPath: " + key.getRegisteredPath() + " | length: " + key.length()), (Object[])new Object[0]);
            }
            if (!key.matches(requestURL) || bestMatchRoot != null && key.length() <= bestMatchRoot.length()) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("New best match: " + key.getRegisteredPath()), (Object[])new Object[0]);
            }
            bestMatchRoot = key;
        }
        if (bestMatchRoot != null && (itr = this.handlerMap.getServicesWithReferences((Object)bestMatchRoot.getRegisteredPath())) != null && itr.hasNext()) {
            ServiceAndServiceReferencePair handler = (ServiceAndServiceReferencePair)itr.next();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Final best handler: " + handler), (Object[])new Object[0]);
            }
            return new HandlerInfo((RESTHandler)handler.getService(), (ServiceReference<RESTHandler>)handler.getServiceReference(), bestMatchRoot);
        }
        return null;
    }

    public Iterator<String> registeredKeys() {
        Iterator<HandlerPath> paths = this.handlerKeys.iterator();
        ArrayList<String> registeredKeys = new ArrayList<String>(this.handlerKeys.size());
        while (paths.hasNext()) {
            HandlerPath path = paths.next();
            if (path.isHidden()) continue;
            registeredKeys.add(path.getRegisteredPath());
        }
        return registeredKeys.iterator();
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={RESTHandlerInternalError.class, RESTHandlerUserError.class, RESTHandlerMethodNotAllowedError.class, RESTHandlerUnsupportedMediaType.class, RESTHandlerJsonException.class, RESTHandlerForbiddenError.class})
    public boolean handleRequest(RESTRequest request, RESTResponse response) throws IOException {
        block18: {
            boolean isRouting;
            String requestURL = request.getContextPath() + request.getPath();
            HandlerInfo handlerInfo = this.getHandler(requestURL);
            boolean bl = isRouting = DefaultRoutingHelper.containsLegacyRoutingContext(request) || DefaultRoutingHelper.containsRoutingContext(request);
            if (handlerInfo == null && !isRouting) {
                return false;
            }
            try {
                boolean isAuthorized = true;
                if (request.getContextPath().equals("/ibm/api") && (handlerInfo == null || !this.hasProperty(handlerInfo.handlerRef, "com.ibm.wsspi.rest.handler.custom.security"))) {
                    isAuthorized = this.getAuthorizationHelper().checkAdministratorRole(request, response);
                }
                if (!isAuthorized) break block18;
                if (handlerInfo != null && handlerInfo.path != null && handlerInfo.path.containsVariable()) {
                    request = new ExtendedRESTRequestImpl(request, handlerInfo.path.mapVariables(requestURL));
                }
                boolean alreadyHandled = false;
                if (isRouting && (handlerInfo == null || !this.hasProperty(handlerInfo.handlerRef, "com.ibm.wsspi.rest.handler.custom.routing"))) {
                    this.getRoutingHelper().routeRequest(request, response);
                    alreadyHandled = true;
                }
                if (alreadyHandled) break block18;
                try {
                    handlerInfo.handler.handleRequest(request, response);
                }
                catch (RESTHandlerForbiddenError fe) {
                    isAuthorized = false;
                    response.sendError(fe.getStatusCode(), fe.getMessage());
                    response.setRequiredRoles(fe.getRequiredRoles());
                }
                catch (RESTHandlerInternalError ie) {
                    response.sendError(ie.getStatusCode(), ie.getMessage());
                }
                catch (RESTHandlerUserError ue) {
                    response.sendError(ue.getStatusCode(), ue.getMessage());
                }
                catch (RESTHandlerUnsupportedMediaType e) {
                    response.sendError(e.getStatusCode(), e.getMessage());
                }
                catch (RESTHandlerMethodNotAllowedError e) {
                    response.setResponseHeader("Allow", e.getAllowedMethods());
                    response.sendError(e.getStatusCode());
                }
                catch (RESTHandlerJsonException e) {
                    try {
                        if (e.isMessageContentJSON()) {
                            response.setStatus(e.getStatusCode());
                            response.setContentType("application/json");
                            response.setCharacterEncoding("UTF-8");
                            response.getWriter().write(e.getMessage());
                        } else {
                            response.sendError(e.getStatusCode(), e.getMessage());
                        }
                    }
                    catch (IllegalStateException illegalStateException) {
                        FFDCFilter.processException((Throwable)illegalStateException, (String)"com.ibm.ws.rest.handler.internal.service.RESTHandlerContainerImpl", (String)"493", (Object)this, (Object[])new Object[]{request, response});
                        if (e.isMessageContentJSON()) {
                            response.setStatus(e.getStatusCode());
                            response.setContentType("application/json");
                            response.setCharacterEncoding("UTF-8");
                            response.getOutputStream().write(e.getMessage().getBytes());
                            break block18;
                        }
                        response.sendError(e.getStatusCode(), e.getMessage());
                    }
                }
            }
            catch (IOException isAuthorized) {
                void ioe;
                FFDCFilter.processException((Throwable)isAuthorized, (String)"com.ibm.ws.rest.handler.internal.service.RESTHandlerContainerImpl", (String)"506", (Object)this, (Object[])new Object[]{request, response});
                response.sendError(500, ioe.getMessage());
            }
        }
        RESTHandlerContainerImpl.auditResponse(request, response);
        return true;
    }

    private static void auditResponse(RESTRequest request, RESTResponse response) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            int code = response.getStatus();
            if (code == 403) {
                Tr.debug((TraceComponent)tc, (String)("Auditing REST request for " + request.getMethod() + " at " + request.getCompleteURL() + " for " + request.getUserPrincipal() + " which requires " + response.getRequiredRoles() + ". Returned status: 403"), (Object[])new Object[0]);
            } else {
                Tr.debug((TraceComponent)tc, (String)("Auditing REST request for " + request.getMethod() + " at " + request.getCompleteURL() + " for " + request.getUserPrincipal() + ". Returned status: " + code), (Object[])new Object[0]);
            }
        }
        Audit.audit((Audit.EventID)Audit.EventID.SECURITY_REST_HANDLER_AUTHZ, (Object[])new Object[]{request, response, response.getStatus()});
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class HandlerInfo {
        public final RESTHandler handler;
        public final ServiceReference<RESTHandler> handlerRef;
        public final HandlerPath path;
        static final long serialVersionUID = 4842100450877640914L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public HandlerInfo(RESTHandler handler, ServiceReference<RESTHandler> handlerRef) {
            this.handler = handler;
            this.handlerRef = handlerRef;
            this.path = null;
        }

        public HandlerInfo(RESTHandler handler, ServiceReference<RESTHandler> handlerRef, HandlerPath path) {
            this.handler = handler;
            this.handlerRef = handlerRef;
            this.path = path;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.rest.handler.internal.service.RESTHandlerContainerImpl$HandlerInfo", HandlerInfo.class, (String)"RESTHandler", (String)"com.ibm.ws.rest.handler.internal.resources.RESTHandlerMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class HandlerKeyMapSync {
        static final long serialVersionUID = 1672869880073793563L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private HandlerKeyMapSync() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.rest.handler.internal.service.RESTHandlerContainerImpl$HandlerKeyMapSync", HandlerKeyMapSync.class, (String)"RESTHandler", (String)"com.ibm.ws.rest.handler.internal.resources.RESTHandlerMessages");
        }
    }
}

