/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.checkpoint.internal.openj9;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.checkpoint.internal.CheckpointImpl;
import io.openliberty.checkpoint.internal.criu.CheckpointFailedException;
import io.openliberty.checkpoint.internal.criu.ExecuteCRIU;
import java.io.File;
import org.eclipse.openj9.criu.CRIUSupport;
import org.eclipse.openj9.criu.JVMCRIUException;
import org.eclipse.openj9.criu.JVMCheckpointException;
import org.eclipse.openj9.criu.SystemCheckpointException;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ExecuteCRIU_OpenJ9
implements ExecuteCRIU {
    private final CheckpointImpl checkpointImpl;
    static final long serialVersionUID = 3196496503811502156L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ExecuteCRIU_OpenJ9(CheckpointImpl checkpointImpl) {
        this.checkpointImpl = checkpointImpl;
    }

    @Override
    @FFDCIgnore(value={JVMCheckpointException.class, SystemCheckpointException.class, JVMCRIUException.class, RuntimeException.class, NoSuchMethodError.class})
    public void dump(Runnable prepare, Runnable restore, File imageDir, String logFileName, File workDir, File envProps, boolean unprivileged) throws CheckpointFailedException {
        CRIUSupport criuSupport = new CRIUSupport(imageDir.toPath());
        try {
            criuSupport.registerPreCheckpointHook(prepare);
        }
        catch (NoSuchMethodError e) {
            criuSupport.registerPreSnapshotHook(prepare);
        }
        criuSupport.registerPostRestoreHook(restore);
        criuSupport.setShellJob(true);
        criuSupport.setFileLocks(true);
        criuSupport.setLogFile(logFileName);
        criuSupport.setWorkDir(workDir.toPath());
        criuSupport.setTCPEstablished(true);
        criuSupport.registerRestoreEnvFile(envProps.toPath());
        this.setCheckpointLogLevel(criuSupport);
        if (unprivileged) {
            try {
                criuSupport.setUnprivileged(true);
            }
            catch (NoSuchMethodError e) {
                throw new CheckpointFailedException(CheckpointFailedException.Type.UNKNOWN_CHECKPOINT, "JVM does not support CRIU unprivileged mode", e);
            }
        }
        try {
            criuSupport.checkpointJVM();
        }
        catch (JVMCheckpointException e) {
            throw new CheckpointFailedException(CheckpointFailedException.Type.JVM_CHECKPOINT_FAILED, e.getMessage(), e);
        }
        catch (SystemCheckpointException e) {
            throw new CheckpointFailedException(CheckpointFailedException.Type.SYSTEM_CHECKPOINT_FAILED, e.getMessage(), e);
        }
        catch (JVMCRIUException e) {
            throw new CheckpointFailedException(this.checkpointImpl.getUnknownType(), e.getMessage(), e);
        }
        catch (RuntimeException e) {
            String exceptionName = e.getClass().getSimpleName();
            if ("JVMRestoreException".equals(exceptionName) || "RestoreException".equals(exceptionName)) {
                throw new CheckpointFailedException(CheckpointFailedException.Type.JVM_RESTORE_FAILED, e.getMessage(), e);
            }
            if ("SystemRestoreException".equals(exceptionName)) {
                throw new CheckpointFailedException(CheckpointFailedException.Type.SYSTEM_RESTORE_FAILED, e.getMessage(), e);
            }
            throw new CheckpointFailedException(this.checkpointImpl.getUnknownType(), e.getMessage(), e);
        }
    }

    private void setCheckpointLogLevel(CRIUSupport criuSupport) {
        String logLevelProp = System.getProperty("io.openliberty.checkpoint.criu.loglevel");
        if (logLevelProp != null) {
            int logLevel = Integer.valueOf(logLevelProp);
            criuSupport.setLogLevel(logLevel);
        }
    }

    @Override
    public void checkpointSupported() throws CheckpointFailedException {
        if (CRIUSupport.isCRIUSupportEnabled()) {
            return;
        }
        throw new CheckpointFailedException(CheckpointFailedException.Type.UNSUPPORTED_DISABLED_IN_JVM, CRIUSupport.getErrorMessage(), null);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.checkpoint.internal.openj9.ExecuteCRIU_OpenJ9", ExecuteCRIU_OpenJ9.class, null, null);
    }
}

