/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi20.internal.cache;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.openapi20.internal.services.ConfigField;
import io.openliberty.microprofile.openapi20.internal.services.ConfigFieldProvider;
import io.smallrye.openapi.api.OpenApiConfig;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.Paths;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPolicy=ConfigurationPolicy.IGNORE, service={ConfigSerializer.class})
public class ConfigSerializer {
    @Reference
    private ConfigFieldProvider configFieldProvider;
    static final long serialVersionUID = -254129637683152L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public Properties serializeConfig(OpenApiConfig config, OpenAPI model) {
        String value;
        Properties result = new Properties();
        for (ConfigField field : this.configFieldProvider.getConfigFields()) {
            value = field.getValue(config);
            if (value == null) continue;
            result.put(field.getMethod(), value);
        }
        for (String pathName : ConfigSerializer.getPathNames(model)) {
            value = this.configFieldProvider.getPathServers(config, pathName);
            if (value == null || value.isEmpty()) continue;
            result.put("pathServer." + pathName, value);
        }
        for (String operationId : ConfigSerializer.getOperationIds(model)) {
            value = this.configFieldProvider.getOperationServers(config, operationId);
            if (value == null || value.isEmpty()) continue;
            result.put("operationServer." + operationId, value);
        }
        return result;
    }

    private static Set<String> getPathNames(OpenAPI model) {
        return ConfigSerializer.getPathItems(model).keySet();
    }

    private static Set<String> getOperationIds(OpenAPI model) {
        return ConfigSerializer.getPathItems(model).values().stream().flatMap(i -> i.getOperations().values().stream()).filter(o -> o.getOperationId() != null).map(Operation::getOperationId).collect(Collectors.toSet());
    }

    private static Map<String, PathItem> getPathItems(OpenAPI model) {
        Paths paths = model.getPaths();
        if (paths == null) {
            return Collections.emptyMap();
        }
        Map pathItems = paths.getPathItems();
        if (pathItems == null) {
            return Collections.emptyMap();
        }
        return pathItems;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.openapi20.internal.cache.ConfigSerializer", ConfigSerializer.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");
    }
}

