/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jmx.connector.server.rest.handlers;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jmx.connector.converter.JSONConverter;
import com.ibm.ws.jmx.connector.datatypes.ServerNotificationRegistration;
import com.ibm.ws.jmx.connector.server.rest.helpers.ErrorHelper;
import com.ibm.ws.jmx.connector.server.rest.helpers.OutputHelper;
import com.ibm.ws.jmx.connector.server.rest.helpers.RESTHelper;
import com.ibm.ws.jmx.connector.server.rest.notification.NotificationManager;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.rest.handler.RESTHandler;
import com.ibm.wsspi.rest.handler.RESTRequest;
import com.ibm.wsspi.rest.handler.RESTResponse;
import com.ibm.wsspi.rest.handler.helper.RESTHandlerMethodNotAllowedError;
import java.util.Map;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={RESTHandler.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM", "com.ibm.wsspi.rest.handler.custom.routing=true", "com.ibm.wsspi.rest.handler.context.root=/IBMJMXConnectorREST", "com.ibm.wsspi.rest.handler.root=/notifications/{clientID}/serverRegistrations/{source_objName}/listeners", "com.ibm.wsspi.rest.handler.root=/notifications/{clientID}/serverRegistrations/{source_objName}/listeners/{listener_objName}/ids", "com.ibm.wsspi.rest.handler.root=/notifications/{clientID}/serverRegistrations/{source_objName}/listeners/{listener_objName}/ids/{registrationID}"})
public class NotificationListenerHandler
implements RESTHandler {
    public static final TraceComponent tc = Tr.register(NotificationListenerHandler.class, (String)"jmx.rest.server.connector", (String)"com.ibm.ws.jmx.connector.server.internal.resources.FileTransferServerMessages");
    static final long serialVersionUID = 3022107883089107796L;

    @Activate
    protected void activate(ComponentContext context, Map<String, Object> properties) {
    }

    @Deactivate
    protected void deactivate(ComponentContext context, int reason) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleRequest(RESTRequest request, RESTResponse response) {
        String method = request.getMethod();
        if (request.getPathVariable("registrationID") != null) {
            if (RESTHelper.isGetMethod(method)) {
                this.getSpecificServerRegistration(request, response);
                return;
            } else {
                if (!RESTHelper.isDeleteMethod(method)) throw new RESTHandlerMethodNotAllowedError("GET,DELETE");
                this.deleteSpecificServerRegistration(request, response);
            }
            return;
        } else if (request.getPathVariable("listener_objName") != null) {
            if (RESTHelper.isGetMethod(method)) {
                this.getRegisteredIDs(request, response);
                return;
            } else {
                if (!RESTHelper.isDeleteMethod(method)) throw new RESTHandlerMethodNotAllowedError("GET,DELETE");
                this.deleteListenerServerRegistrations(request, response);
            }
            return;
        } else if (RESTHelper.isGetMethod(method)) {
            this.getRegisteredListeners(request, response);
            return;
        } else {
            if (!RESTHelper.isDeleteMethod(method)) throw new RESTHandlerMethodNotAllowedError("GET,DELETE");
            this.deleteRegisteredListeners(request, response);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void getSpecificServerRegistration(RESTRequest request, RESTResponse response) {
        String source_objName = RESTHelper.getRequiredParam(request, "source_objName");
        String listener_objName = RESTHelper.getRequiredParam(request, "listener_objName");
        String registrationID = RESTHelper.getRequiredParam(request, "registrationID");
        String clientIDString = RESTHelper.getRequiredParam(request, "clientID");
        int clientID = -1;
        try {
            clientID = Integer.parseInt(clientIDString);
        }
        catch (NumberFormatException numberFormatException) {
            void e;
            FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.jmx.connector.server.rest.handlers.NotificationListenerHandler", (String)"97", (Object)this, (Object[])new Object[]{request, response});
            ErrorHelper.createRESTHandlerJsonException((Throwable)e, null, 400);
        }
        ServerNotificationRegistration registration = NotificationManager.getNotificationManager().getSpecificServerRegistration(request, clientID, source_objName, listener_objName, registrationID);
        if (registration != null) {
            OutputHelper.writeServerRegistrationStreamingOutput(response, registration, JSONConverter.getConverter());
        } else {
            response.setStatus(204);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void deleteSpecificServerRegistration(RESTRequest request, RESTResponse response) {
        String source_objName = RESTHelper.getRequiredParam(request, "source_objName");
        String listener_objName = RESTHelper.getRequiredParam(request, "listener_objName");
        String registrationID = RESTHelper.getRequiredParam(request, "registrationID");
        String clientIDString = RESTHelper.getRequiredParam(request, "clientID");
        int clientID = -1;
        try {
            clientID = Integer.parseInt(clientIDString);
        }
        catch (NumberFormatException numberFormatException) {
            void e;
            FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.jmx.connector.server.rest.handlers.NotificationListenerHandler", (String)"120", (Object)this, (Object[])new Object[]{request, response});
            ErrorHelper.createRESTHandlerJsonException((Throwable)e, null, 400);
        }
        JSONConverter converter = JSONConverter.getConverter();
        ServerNotificationRegistration serverNotificationRegistration = new ServerNotificationRegistration();
        serverNotificationRegistration.objectName = RESTHelper.objectNameConverter(source_objName, true, converter);
        serverNotificationRegistration.listener = RESTHelper.objectNameConverter(listener_objName, true, converter);
        serverNotificationRegistration.operation = ServerNotificationRegistration.Operation.RemoveSpecific;
        NotificationManager.getNotificationManager().deleteServerRegistrationHTTP(request, clientID, serverNotificationRegistration, registrationID, converter);
        response.setStatus(204);
    }

    /*
     * WARNING - void declaration
     */
    private void getRegisteredIDs(RESTRequest request, RESTResponse response) {
        String source_objName = RESTHelper.getRequiredParam(request, "source_objName");
        String listener_objName = RESTHelper.getRequiredParam(request, "listener_objName");
        String clientIDString = RESTHelper.getRequiredParam(request, "clientID");
        int clientID = -1;
        try {
            clientID = Integer.parseInt(clientIDString);
        }
        catch (NumberFormatException numberFormatException) {
            void e;
            FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.jmx.connector.server.rest.handlers.NotificationListenerHandler", (String)"146", (Object)this, (Object[])new Object[]{request, response});
            ErrorHelper.createRESTHandlerJsonException((Throwable)e, null, 400);
        }
        String[] ids = NotificationManager.getNotificationManager().getRegisteredIDs(request, clientID, source_objName, listener_objName);
        OutputHelper.writeStringArrayStreamingOutput(response, ids, JSONConverter.getConverter());
    }

    /*
     * WARNING - void declaration
     */
    private void deleteListenerServerRegistrations(RESTRequest request, RESTResponse response) {
        String source_objName = RESTHelper.getRequiredParam(request, "source_objName");
        String listener_objName = RESTHelper.getRequiredParam(request, "listener_objName");
        String clientIDString = RESTHelper.getRequiredParam(request, "clientID");
        int clientID = -1;
        try {
            clientID = Integer.parseInt(clientIDString);
        }
        catch (NumberFormatException numberFormatException) {
            void e;
            FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.jmx.connector.server.rest.handlers.NotificationListenerHandler", (String)"164", (Object)this, (Object[])new Object[]{request, response});
            ErrorHelper.createRESTHandlerJsonException((Throwable)e, null, 400);
        }
        JSONConverter converter = JSONConverter.getConverter();
        ServerNotificationRegistration serverNotificationRegistration = new ServerNotificationRegistration();
        serverNotificationRegistration.objectName = RESTHelper.objectNameConverter(source_objName, true, converter);
        serverNotificationRegistration.listener = RESTHelper.objectNameConverter(listener_objName, true, converter);
        serverNotificationRegistration.operation = ServerNotificationRegistration.Operation.RemoveAll;
        NotificationManager.getNotificationManager().deleteServerRegistrationHTTP(request, clientID, serverNotificationRegistration, null, converter);
        response.setStatus(204);
    }

    /*
     * WARNING - void declaration
     */
    private void getRegisteredListeners(RESTRequest request, RESTResponse response) {
        String source_objName = RESTHelper.getRequiredParam(request, "source_objName");
        String clientIDString = RESTHelper.getRequiredParam(request, "clientID");
        int clientID = -1;
        try {
            clientID = Integer.parseInt(clientIDString);
        }
        catch (NumberFormatException numberFormatException) {
            void e;
            FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.jmx.connector.server.rest.handlers.NotificationListenerHandler", (String)"189", (Object)this, (Object[])new Object[]{request, response});
            ErrorHelper.createRESTHandlerJsonException((Throwable)e, null, 400);
        }
        String[] listeners = NotificationManager.getNotificationManager().getRegisteredListeners(request, clientID, source_objName);
        OutputHelper.writeStringArrayStreamingOutput(response, listeners, JSONConverter.getConverter());
    }

    /*
     * WARNING - void declaration
     */
    private void deleteRegisteredListeners(RESTRequest request, RESTResponse response) {
        String source_objName = RESTHelper.getRequiredParam(request, "source_objName");
        String clientIDString = RESTHelper.getRequiredParam(request, "clientID");
        int clientID = -1;
        try {
            clientID = Integer.parseInt(clientIDString);
        }
        catch (NumberFormatException numberFormatException) {
            void e;
            FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.jmx.connector.server.rest.handlers.NotificationListenerHandler", (String)"206", (Object)this, (Object[])new Object[]{request, response});
            ErrorHelper.createRESTHandlerJsonException((Throwable)e, null, 400);
        }
        JSONConverter converter = JSONConverter.getConverter();
        NotificationManager.getNotificationManager().deleteRegisteredListeners(request, clientID, RESTHelper.objectNameConverter(source_objName, true, converter), converter);
        response.setStatus(204);
    }
}

