/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.util;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.BeanMetaData;
import com.ibm.ejs.container.EJSContainer;
import com.ibm.ejs.container.EJSHome;
import com.ibm.ejs.container.EJSWrapperBase;
import com.ibm.ejs.container.EJSWrapperCommon;
import com.ibm.ejs.container.WrapperId;
import com.ibm.ejs.container.WrapperInterface;
import com.ibm.ejs.container.WrapperManager;
import com.ibm.ejs.container.WrapperProxyState;
import com.ibm.ejs.container.util.ByteArray;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import java.io.Serializable;

public class SerializableByteArray
implements Serializable {
    private static final long serialVersionUID = 8311919298341109455L;
    private static final TraceComponent tc = Tr.register(SerializableByteArray.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    private static final boolean DEBUG_ON = false;
    private byte[] ivIdBytes;

    public SerializableByteArray(EJSWrapperBase wrapper) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("SerializableByteArray for wrapper = " + wrapper.getClass().getName() + '@' + Integer.toHexString(wrapper.hashCode())), (Object[])new Object[0]);
        }
        BeanId beanId = wrapper.beanId;
        WrapperInterface wrapperInterface = wrapper.ivInterface;
        BeanMetaData bmd = wrapper.bmd;
        if (wrapperInterface == WrapperInterface.BUSINESS_LOCAL) {
            String interfaceName;
            int interfaceIndex = wrapper.ivBusinessInterfaceIndex;
            if (interfaceIndex == -2) {
                interfaceName = "AGGREGATE";
            } else {
                Class<?> biClass = bmd.ivBusinessLocalInterfaceClasses[interfaceIndex];
                interfaceName = biClass.getName();
            }
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("serializing a WrapperId for BeanId = " + beanId + ", local business interface = " + interfaceName + ", primary key = " + beanId.getPrimaryKey()), (Object[])new Object[0]);
            }
            WrapperId wrapperId = new WrapperId(beanId.getByteArrayBytes(), interfaceName, interfaceIndex);
            this.ivIdBytes = wrapperId.getBytes();
        } else {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("serializing a BeanId = " + beanId + ", primary key = " + beanId.getPrimaryKey()), (Object[])new Object[0]);
            }
            this.ivIdBytes = beanId.getByteArrayBytes();
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SerializableByteArray");
        }
    }

    public SerializableByteArray(WrapperProxyState state) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("SerializableByteArray for wrapper proxy state = " + state), (Object[])new Object[0]);
        }
        this.ivIdBytes = state.getSerializerBytes();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SerializableByteArray");
        }
    }

    public Object getWrapper() throws Exception {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getWrapper", (Object[])new Object[0]);
        }
        EJSContainer container2 = EJSContainer.getDefaultContainer();
        Object retObj = null;
        WrapperManager wm = container2.getWrapperManager();
        if (this.ivIdBytes[0] == -84) {
            ByteArray byteArray = new ByteArray(this.ivIdBytes);
            BeanId beanId = BeanId.getBeanId(byteArray, container2);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("deserialized a BeanId = " + beanId + ", primary key = " + beanId.getPrimaryKey()), (Object[])new Object[0]);
            }
            retObj = wm.getWrapper(beanId).getLocalObject();
        } else if (this.ivIdBytes[0] == -83) {
            WrapperId wrapperId = new WrapperId(this.ivIdBytes);
            int index = wrapperId.ivInterfaceIndex;
            String interfaceName = wrapperId.ivInterfaceClassName;
            ByteArray byteArray = wrapperId.getBeanIdArray();
            BeanId beanId = BeanId.getBeanId(byteArray, container2);
            BeanMetaData bmd = beanId.getBeanMetaData();
            Tr.debug((TraceComponent)tc, (String)("deserialized a WrapperId for BeanId = " + beanId + ", primary key = " + beanId.getPrimaryKey()), (Object[])new Object[0]);
            EJSHome home = bmd.getHome();
            EJSWrapperCommon wc = home.internalCreateWrapper(beanId);
            if (index == -2) {
                retObj = wc.getAggregateLocalWrapper();
            } else {
                Class<?>[] bInterfaces = bmd.ivBusinessLocalInterfaceClasses;
                int numberOfLocalInterfaces = bInterfaces.length;
                String wrapperInterfaceName = null;
                if (index < numberOfLocalInterfaces) {
                    wrapperInterfaceName = bInterfaces[index].getName();
                }
                if (wrapperInterfaceName == null || !wrapperInterfaceName.equals(interfaceName)) {
                    index = bmd.getRequiredLocalBusinessInterfaceIndex(interfaceName);
                }
                retObj = wc.getLocalBusinessObject(index);
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getWrapper returning: " + (retObj == null ? retObj : retObj.getClass().getName() + '@' + Integer.toHexString(retObj.hashCode()))));
        }
        return retObj;
    }
}

