/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.http.internal.HostAlias;
import com.ibm.ws.http.internal.HttpEndpointImpl;
import com.ibm.ws.http.internal.HttpProxyRedirect;
import com.ibm.ws.http.internal.VirtualHostConfig;
import com.ibm.ws.http.internal.VirtualHostMap;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.http.DefaultMimeTypes;
import com.ibm.wsspi.http.HttpContainer;
import com.ibm.wsspi.http.VirtualHost;
import com.ibm.wsspi.http.VirtualHostListener;
import com.ibm.wsspi.http.ee7.HttpInboundConnectionExtended;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceSet;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import io.openliberty.checkpoint.spi.CheckpointHook;
import io.openliberty.checkpoint.spi.CheckpointPhase;
import java.lang.constant.Constable;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPid={"com.ibm.ws.http.virtualhost"}, configurationPolicy=ConfigurationPolicy.REQUIRE, immediate=true, service={VirtualHostImpl.class}, property={"service.vendor=IBM"})
public class VirtualHostImpl
implements VirtualHost {
    static final TraceComponent tc = Tr.register(VirtualHostImpl.class, (String)"HttpTransport", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    String name;
    private volatile boolean activated = false;
    private volatile VirtualHostConfig config = new VirtualHostConfig(this);
    private final AtomicInteger listeningPorts = new AtomicInteger(0);
    final ConcurrentHashMap<HttpEndpointImpl, EndpointState> myEndpoints;
    private final CopyOnWriteArraySet<HttpContainerContext> httpContainers;
    private final Object containerLock = new Object(){
        static final long serialVersionUID = 4054884690011993996L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.http.internal.VirtualHostImpl$1", 1.class, (String)"HttpTransport", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
        }
    };
    private volatile DefaultMimeTypes defaultMimeTypes = null;
    private final ConcurrentServiceReferenceSet<VirtualHostListener> _listeners = new ConcurrentServiceReferenceSet("listener");
    private final RegistrationHolder osgiService;
    static final long serialVersionUID = -8551087814811989510L;

    @Activate
    public VirtualHostImpl(ComponentContext context) {
        this.osgiService = new RegistrationHolder(context.getBundleContext(), this);
        this.httpContainers = new CopyOnWriteArraySet();
        this.myEndpoints = new ConcurrentHashMap();
    }

    @Activate
    protected void activate(ComponentContext context, Map<String, Object> properties) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)"Activating VirtualHost", (Object[])new Object[]{properties});
        }
        this.activated = true;
        this._listeners.activate(context);
        this.name = (String)properties.get("id");
        this.modified(properties);
    }

    @Deactivate
    protected void deactivate(ComponentContext context, int reason) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("Deactivating, reason=" + reason), (Object[])new Object[0]);
        }
        this.osgiService.clearRegistration();
        VirtualHostMap.removeVirtualHost(this.config);
        this.activated = false;
        this.httpContainers.clear();
        this._listeners.deactivate(context);
    }

    @Modified
    protected void modified(Map<String, Object> properties) {
        VirtualHostConfig oldConfig = this.config;
        VirtualHostConfig newConfig = new VirtualHostConfig(this, properties);
        if (newConfig.isDefaultHost() != oldConfig.isDefaultHost()) {
            VirtualHostMap.removeVirtualHost(oldConfig);
        }
        if (this.osgiService.isRegistered() && !newConfig.enabled) {
            VirtualHostMap.removeVirtualHost(oldConfig);
            this.osgiService.clearRegistration();
        } else if (newConfig.enabled) {
            VirtualHostMap.addVirtualHost(oldConfig, newConfig);
            if (newConfig.isDefaultHost) {
                newConfig.regenerateAliases();
            }
            this.osgiService.updateRegistration(true, newConfig, false);
        }
        this.config = newConfig;
        if (!this.config.getAllowedEndpoints().isEmpty()) {
            Iterator iter = ((ConcurrentHashMap.KeySetView)this.myEndpoints.keySet()).iterator();
            while (iter.hasNext()) {
                HttpEndpointImpl ep = (HttpEndpointImpl)iter.next();
                if (this.config.getAllowedEndpoints().contains(ep.getPid())) continue;
                iter.remove();
            }
        }
    }

    public VirtualHostConfig getActiveConfig() {
        return this.config;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Reference(name="mimeTypeDefaults")
    protected void setMimeTypeDefaults(DefaultMimeTypes mimeTypes) {
        this.defaultMimeTypes = mimeTypes;
    }

    protected void unsetMimeTypeDefaults(DefaultMimeTypes mimeTypes) {
    }

    @Override
    public String getMimeType(String extension) {
        return this.defaultMimeTypes.getType(extension);
    }

    public Runnable discriminate(HttpInboundConnectionExtended inboundConnection) {
        String requestUri = inboundConnection.getRequest().getURI();
        Runnable requestHandler = null;
        for (HttpContainerContext ctx : this.httpContainers) {
            requestHandler = ctx.container.createRunnableHandler(inboundConnection);
            if (requestHandler == null) continue;
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break;
            if (!requestUri.endsWith("/")) {
                int pos = requestUri.lastIndexOf(63);
                if (pos >= 0) {
                    requestUri = requestUri.substring(0, pos);
                }
                requestUri = requestUri + "/";
            }
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break;
            Tr.event((Object)this, (TraceComponent)tc, (String)("Discriminate " + requestUri), (Object[])new Object[]{ctx.container});
            break;
        }
        return requestHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addContextRoot(String contextRoot, HttpContainer container) {
        if (contextRoot != null && container != null) {
            Object object = this.containerLock;
            synchronized (object) {
                HttpContainerContext found = null;
                for (HttpContainerContext ctx : this.httpContainers) {
                    if (!ctx.sameContainer(container)) continue;
                    found = ctx;
                    break;
                }
                if (found == null) {
                    found = new HttpContainerContext(this, container);
                    this.httpContainers.add(found);
                }
                found.addContextRoot(contextRoot);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeContextRoot(String contextRoot, HttpContainer container) {
        if (this.httpContainers.isEmpty()) {
            return;
        }
        Object object = this.containerLock;
        synchronized (object) {
            for (HttpContainerContext ctx : this.httpContainers) {
                if (!ctx.sameContainer(container)) continue;
                ctx.removeContextRoot(contextRoot);
                if (!ctx.isEmpty()) break;
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((Object)this, (TraceComponent)tc, (String)"Container removed ", (Object[])new Object[]{container});
                }
                this.httpContainers.remove(ctx);
                break;
            }
        }
    }

    @Override
    public String getUrlString(String contextRoot, boolean securedPreferred) {
        if (!this.myEndpoints.isEmpty()) {
            EndpointState httpEndpoint = null;
            EndpointState httpsEndpoint = null;
            for (EndpointState state : this.myEndpoints.values()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("getUrlString -- " + state), (Object[])new Object[0]);
                }
                if (state.httpPort > 0 && state.httpsPort > 0) {
                    if (securedPreferred) {
                        return this.getUrlString(true, state.hostName, state.httpsPort, contextRoot);
                    }
                    return this.getUrlString(false, state.hostName, state.httpPort, contextRoot);
                }
                if (httpEndpoint == null && state.httpPort > 0) {
                    httpEndpoint = state;
                    continue;
                }
                if (httpsEndpoint != null || state.httpsPort <= 0) continue;
                httpsEndpoint = state;
            }
            if (securedPreferred && httpsEndpoint != null) {
                return this.getUrlString(true, httpsEndpoint.hostName, httpsEndpoint.httpsPort, contextRoot);
            }
            if (httpEndpoint != null) {
                return this.getUrlString(false, httpEndpoint.hostName, httpEndpoint.httpPort, contextRoot);
            }
            if (httpsEndpoint != null) {
                return this.getUrlString(true, httpsEndpoint.hostName, httpsEndpoint.httpsPort, contextRoot);
            }
        }
        return "";
    }

    private String getUrlString(boolean isHttps, String host, int port, String contextRoot) {
        String protocol;
        String HTTP = "http://";
        String HTTPS = "https://";
        String string = protocol = isHttps ? "https://" : "http://";
        if (host.startsWith("[") && host.contains("%")) {
            host = host.replace("%", "%25");
        }
        return protocol + host + ":" + port + contextRoot;
    }

    @Override
    @FFDCIgnore(value={NumberFormatException.class})
    public int getHttpPort(String hostAlias) {
        int pos = hostAlias.lastIndexOf(58);
        if (pos > -1 && pos < hostAlias.length()) {
            try {
                int port = Integer.valueOf(hostAlias.substring(pos + 1));
                for (EndpointState state : this.myEndpoints.values()) {
                    if (state.httpPort != port && state.httpsPort != port) continue;
                    return state.httpPort;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    @Override
    @FFDCIgnore(value={NumberFormatException.class})
    public int getSecureHttpPort(String hostAlias) {
        int pos = hostAlias.lastIndexOf(58);
        if (pos > -1 && pos < hostAlias.length()) {
            try {
                int port = Integer.valueOf(hostAlias.substring(pos + 1));
                for (EndpointState state : this.myEndpoints.values()) {
                    if (state.httpPort != port && state.httpsPort != port) continue;
                    return state.httpsPort;
                }
                String host = hostAlias.substring(0, pos);
                Integer httpsPort = HttpProxyRedirect.getRedirectPort(host, port);
                if (httpsPort != null) {
                    return httpsPort;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    @Override
    @FFDCIgnore(value={NumberFormatException.class})
    public String getHostName(String hostAlias) {
        int pos = hostAlias.lastIndexOf(58);
        if (pos > -1 && pos < hostAlias.length()) {
            String hostName = hostAlias.substring(0, pos);
            if (hostName.equals("*")) {
                try {
                    int port = Integer.valueOf(hostAlias.substring(pos + 1));
                    for (EndpointState state : this.myEndpoints.values()) {
                        if (state.httpPort != port && state.httpsPort != port) continue;
                        return state.hostName;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return hostName;
        }
        return hostAlias;
    }

    @Reference(name="listener", service=VirtualHostListener.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE)
    protected void setListener(ServiceReference<VirtualHostListener> reference) {
        this._listeners.addReference(reference);
        this.notifyListener((VirtualHostListener)this._listeners.getService(reference));
    }

    private void notifyListener(VirtualHostListener virtualHostListener) {
        if (this.activated) {
            for (HttpContainerContext hcc : this.httpContainers) {
                hcc.notifyContextRoots(virtualHostListener);
            }
        }
    }

    protected void unsetListener(ServiceReference<VirtualHostListener> reference) {
        this._listeners.removeReference(reference);
    }

    @Override
    public List<String> getAliases() {
        return HostAlias.toStringList(this.config.getHostAliases());
    }

    @Override
    public Collection<String> getAllowedFromEndpoints() {
        return this.config.getAllowedEndpoints();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[name=" + this.name + ",active=" + this.activated + ",endpoints=" + (this.myEndpoints == null ? "null" : Integer.valueOf(this.myEndpoints.size())) + ",haveCtx=" + (this.httpContainers == null ? "null" : Boolean.valueOf(!this.httpContainers.isEmpty())) + ",config=" + this.config + "]";
    }

    synchronized void listenerStarted(HttpEndpointImpl endpoint, VirtualHostConfig targetConfig, Supplier<String> hostNameResolver, int port, boolean isHttps) {
        if (!this.osgiService.listenOnRestore(endpoint, targetConfig, hostNameResolver, port, isHttps)) {
            this.listenerStarted0(endpoint, targetConfig, hostNameResolver, port, isHttps);
        }
    }

    private synchronized void listenerStarted0(HttpEndpointImpl endpoint, VirtualHostConfig targetConfig, Supplier<String> hostNameResolver, int port, boolean isHttps) {
        if (!this.activated) {
            return;
        }
        String resolvedHostName = hostNameResolver.get();
        Collection<String> allowedEndpoints = targetConfig.getAllowedEndpoints();
        if (!allowedEndpoints.isEmpty() && !allowedEndpoints.contains(endpoint.getPid())) {
            return;
        }
        EndpointState oldState = this.myEndpoints.get(endpoint);
        if (oldState == null) {
            oldState = EndpointState.notStarted;
        }
        int newHttpPort = isHttps ? oldState.httpPort : port;
        int newHttpsPort = isHttps ? port : oldState.httpsPort;
        EndpointState newState = new EndpointState(resolvedHostName, newHttpPort, newHttpsPort);
        boolean updatedPort = oldState.httpPort > 0 && oldState.httpPort != newHttpPort || oldState.httpsPort > 0 && oldState.httpsPort != newHttpsPort;
        boolean addedPort = oldState.httpPort == 0 && oldState.httpPort != newHttpPort || oldState.httpsPort == 0 && oldState.httpsPort != newHttpsPort;
        this.myEndpoints.put(endpoint, newState);
        int numPorts = addedPort ? this.listeningPorts.incrementAndGet() : this.listeningPorts.get();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("listener started: " + this.listeningPorts.get()), (Object[])new Object[]{oldState, newState, addedPort, updatedPort});
        }
        if (addedPort || updatedPort) {
            this.osgiService.updateRegistration(this.activated, targetConfig, true);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("listener started for " + this + " on host " + resolvedHostName + " on port " + port), (Object[])new Object[]{endpoint});
        }
        for (HttpContainerContext ctx : this.httpContainers) {
            ctx.notifyExistingContexts(true, resolvedHostName, port, isHttps, numPorts);
        }
    }

    synchronized void listenerStopped(HttpEndpointImpl endpoint, VirtualHostConfig targetConfig, String resolvedHostName, int port, boolean isHttps) {
        boolean removedPort;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("listener stopped for " + this + " on port " + port), (Object[])new Object[]{endpoint});
        }
        if (!this.activated) {
            return;
        }
        EndpointState oldState = this.myEndpoints.get(endpoint);
        if (oldState == null) {
            return;
        }
        int newHttpPort = isHttps ? oldState.httpPort : EndpointState.notStarted.httpPort;
        int newHttpsPort = isHttps ? EndpointState.notStarted.httpsPort : oldState.httpsPort;
        boolean bl = removedPort = oldState.httpPort > 0 && newHttpPort == EndpointState.notStarted.httpPort || oldState.httpsPort > 0 && newHttpsPort == EndpointState.notStarted.httpsPort;
        if (newHttpPort == EndpointState.notStarted.httpPort && newHttpsPort == EndpointState.notStarted.httpsPort) {
            this.myEndpoints.remove(endpoint);
        } else {
            EndpointState newState = new EndpointState(resolvedHostName, newHttpPort, newHttpsPort);
            this.myEndpoints.put(endpoint, newState);
        }
        int numPorts = removedPort ? this.listeningPorts.decrementAndGet() : this.listeningPorts.get();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("listener stopped: " + this.listeningPorts.get()), (Object[])new Object[]{oldState, this.myEndpoints.get(endpoint)});
        }
        for (HttpContainerContext ctx : this.httpContainers) {
            ctx.notifyExistingContexts(false, resolvedHostName, port, isHttps, numPorts);
        }
        this.osgiService.updateRegistration(false, targetConfig, true);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static final class RegistrationHolder {
        private ServiceRegistration<VirtualHost> vhostRegistration = null;
        private final BundleContext bContext;
        private final VirtualHostImpl vhost;
        static final long serialVersionUID = 7427246178985319350L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Trivial
        RegistrationHolder(BundleContext bContext, VirtualHostImpl vhost) {
            this.bContext = bContext;
            this.vhost = vhost;
        }

        public boolean listenOnRestore(final HttpEndpointImpl endpoint, final VirtualHostConfig targetConfig, final Supplier<String> hostNameResolver, final int port, final boolean isHttps) {
            if (this.bContext != null && !CheckpointPhase.getPhase().restored()) {
                Hashtable<String, Constable> hookProps = new Hashtable<String, Constable>();
                hookProps.put("service.ranking", Integer.valueOf(Integer.MAX_VALUE));
                hookProps.put("io.openliberty.checkpoint.hook.multi.threaded", Boolean.TRUE);
                final AtomicReference<ServiceRegistration> hookReg = new AtomicReference<ServiceRegistration>();
                hookReg.set(this.bContext.registerService(CheckpointHook.class, (Object)new CheckpointHook(){
                    static final long serialVersionUID = 1442137341385907461L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    public void restore() {
                        vhost.listenerStarted0(endpoint, targetConfig, hostNameResolver, port, isHttps);
                        ServiceRegistration currentReg = (ServiceRegistration)hookReg.get();
                        if (currentReg == null) {
                            throw new IllegalStateException();
                        }
                        currentReg.unregister();
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"com.ibm.ws.http.internal.VirtualHostImpl$RegistrationHolder$1", 1.class, (String)"HttpTransport", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
                    }
                }, hookProps));
                return true;
            }
            return false;
        }

        synchronized boolean isRegistered() {
            return this.vhostRegistration != null;
        }

        synchronized void clearRegistration() {
            if (this.vhostRegistration != null) {
                this.vhostRegistration.unregister();
                this.vhostRegistration = null;
            }
        }

        synchronized void updateRegistration(boolean createIfNull, VirtualHostConfig targetConfig, boolean regenerateAlias) {
            if (this.vhostRegistration == null && !createIfNull) {
                return;
            }
            List<String> newAliasList = Collections.emptyList();
            List<String> newHttpEndpointReferenceList = Collections.emptyList();
            newAliasList = regenerateAlias ? HostAlias.toStringList(targetConfig.regenerateAliases()) : HostAlias.toStringList(targetConfig.getHostAliases());
            if (targetConfig.allowedEndpointPids != null) {
                newHttpEndpointReferenceList = targetConfig.getAllowedEndpoints();
            }
            Dictionary<String, ?> props = this.makeProperties(newAliasList, newHttpEndpointReferenceList);
            if (this.vhostRegistration == null) {
                this.vhostRegistration = this.bContext.registerService(VirtualHost.class, (Object)this.vhost, props);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"New registration", (Object[])new Object[]{this.vhost, props, newAliasList});
                }
            } else {
                ServiceReference ref = this.vhostRegistration.getReference();
                String[] oldAliasList = (String[])ref.getProperty("aliases");
                Collection oldEndpointReferenceList = (Collection)ref.getProperty("endpointReferences");
                String[] oldEpStrings = null;
                boolean updateHttpsAlias = false;
                Object oldHttpsAlias = ref.getProperty("httpsAlias");
                Object newHttpsAlias = props.get("httpsAlias");
                if (newHttpsAlias == null) {
                    updateHttpsAlias = oldHttpsAlias != null;
                } else {
                    boolean bl = updateHttpsAlias = !newHttpsAlias.equals(oldHttpsAlias);
                }
                if (oldEndpointReferenceList != null) {
                    oldEpStrings = oldEndpointReferenceList.toArray(new String[oldEndpointReferenceList.size()]);
                }
                if (updateHttpsAlias || this.changed(oldAliasList, newAliasList) || this.changed(oldEpStrings, newHttpEndpointReferenceList)) {
                    this.vhostRegistration.setProperties(props);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Updated registration", (Object[])new Object[]{this.vhost, props, oldAliasList, newAliasList, oldEndpointReferenceList, newHttpEndpointReferenceList, oldHttpsAlias, newHttpsAlias});
                    }
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"No change to existing registration", (Object[])new Object[]{this.vhost, this.vhost.config, newAliasList, newHttpEndpointReferenceList});
                }
            }
        }

        boolean changed(String[] oldStrings, Collection<String> newStrings) {
            if (oldStrings == null || oldStrings.length == 0) {
                return newStrings != null && !newStrings.isEmpty();
            }
            if (newStrings == null) {
                return oldStrings.length > 0;
            }
            if (oldStrings.length != newStrings.size()) {
                return true;
            }
            for (String str : oldStrings) {
                if (newStrings.contains(str)) continue;
                return true;
            }
            return false;
        }

        Dictionary<String, ?> makeProperties(List<String> newAliases, Collection<String> newEPReferences) {
            Hashtable<String, Object> map = new Hashtable<String, Object>();
            map.put("service.vendor", "IBM");
            map.put("id", this.vhost.name);
            map.put("enabled", true);
            if (newAliases.size() > 0) {
                map.put("aliases", newAliases.toArray(new String[newAliases.size()]));
            }
            if (newEPReferences.size() > 0) {
                map.put("endpointReferences", newEPReferences);
            }
            for (Map.Entry<HttpEndpointImpl, EndpointState> entry : this.vhost.myEndpoints.entrySet()) {
                EndpointState state = entry.getValue();
                if (state.httpsPort == 0) continue;
                String cfgHost = entry.getKey().getHostName();
                map.put("httpsAlias", cfgHost + ":" + state.httpsPort);
                break;
            }
            return map;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.http.internal.VirtualHostImpl$RegistrationHolder", RegistrationHolder.class, (String)"HttpTransport", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static final class HttpContainerContext {
        final VirtualHostImpl owner;
        final HttpContainer container;
        final Map<String, String> contextRoots = new HashMap<String, String>();
        static final long serialVersionUID = 4485303248927110837L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Trivial
        HttpContainerContext(VirtualHostImpl o, HttpContainer c) {
            this.owner = o;
            this.container = c;
        }

        public boolean isEmpty() {
            return this.contextRoots.isEmpty();
        }

        public boolean sameContainer(HttpContainer c) {
            return this.container == c;
        }

        public synchronized boolean addContextRoot(String contextRoot) {
            if (!this.contextRoots.containsKey(contextRoot)) {
                int numPorts = this.owner.listeningPorts.get();
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((Object)this, (TraceComponent)tc, (String)("Context root added " + contextRoot), (Object[])new Object[]{this.container, numPorts});
                }
                if (contextRoot != null) {
                    String urlString = this.owner.getUrlString(contextRoot, false);
                    this.notifyContextRoot(true, urlString, contextRoot);
                    this.contextRoots.put(contextRoot, urlString);
                } else {
                    this.contextRoots.put(contextRoot, "");
                }
                return true;
            }
            return false;
        }

        public synchronized boolean removeContextRoot(String contextRoot) {
            String urlString = this.contextRoots.remove(contextRoot);
            if (urlString != null && !urlString.isEmpty()) {
                int numPorts = this.owner.listeningPorts.get();
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((Object)this, (TraceComponent)tc, (String)("Context root removed " + contextRoot), (Object[])new Object[]{this.container, numPorts});
                }
                if (contextRoot != null) {
                    this.notifyContextRoot(false, urlString, contextRoot);
                }
                return true;
            }
            return false;
        }

        public synchronized void notifyExistingContexts(boolean added, String hostName, int port, boolean isHttps, int numPorts) {
            for (Map.Entry<String, String> entry : this.contextRoots.entrySet()) {
                String contextRoot = entry.getKey();
                String oldUrl = entry.getValue();
                String changedUrl = this.owner.getUrlString(isHttps, hostName, port, contextRoot);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("evaluate URL, changed=" + changedUrl), (Object[])new Object[]{"old=" + oldUrl, numPorts, added});
                }
                if (added) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("** notify URL addition.. " + changedUrl), (Object[])new Object[0]);
                    }
                    if (!oldUrl.isEmpty()) continue;
                    this.notifyContextRoot(added, changedUrl, contextRoot);
                    entry.setValue(changedUrl);
                    continue;
                }
                if (numPorts > 0) {
                    if (!changedUrl.equals(oldUrl)) continue;
                    String newUrl = this.owner.getUrlString(contextRoot, isHttps);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("** notify URL change.. " + newUrl), (Object[])new Object[]{changedUrl});
                    }
                    entry.setValue(newUrl);
                    if (!FrameworkState.isValid()) continue;
                    int last = newUrl.length() - 1;
                    if (newUrl.charAt(last) == '*') {
                        newUrl = newUrl.substring(0, last);
                    }
                    Tr.audit((TraceComponent)tc, (String)"context.root.changed", (Object[])new Object[]{this.owner.name, newUrl});
                    continue;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("** notify URL removal.. " + changedUrl), (Object[])new Object[]{oldUrl});
                }
                if (oldUrl.isEmpty()) continue;
                this.notifyContextRoot(added, oldUrl, contextRoot);
                entry.setValue("");
            }
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return o != null && o.getClass() == this.getClass() && ((HttpContainerContext)o).container == this.container;
        }

        public int hashCode() {
            return this.container.hashCode();
        }

        private void notifyContextRoot(boolean added, String urlString, String contextRoot) {
            if (urlString != null && !urlString.isEmpty()) {
                int last = urlString.length() - 1;
                if (urlString.charAt(last) == '*') {
                    urlString = urlString.substring(0, last);
                }
                if (added) {
                    Tr.audit((TraceComponent)tc, (String)"context.root.added", (Object[])new Object[]{this.owner.name, urlString});
                } else {
                    Tr.audit((TraceComponent)tc, (String)"context.root.removed", (Object[])new Object[]{this.owner.name, urlString});
                }
            }
            for (VirtualHostListener l : this.owner._listeners.services()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("Notifying listener: context root " + (added ? "added" : "removed")), (Object[])new Object[]{l, contextRoot});
                }
                if (added) {
                    l.contextRootAdded(contextRoot, this.owner);
                    continue;
                }
                l.contextRootRemoved(contextRoot, this.owner);
            }
        }

        public synchronized void notifyContextRoots(VirtualHostListener l) {
            for (String root : this.contextRoots.keySet()) {
                if (root == null) continue;
                l.contextRootAdded(root, this.owner);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.http.internal.VirtualHostImpl$HttpContainerContext", HttpContainerContext.class, (String)"HttpTransport", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static final class EndpointState {
        static final EndpointState notStarted;
        final String hostName;
        final int httpPort;
        final int httpsPort;
        static final long serialVersionUID = -6311161034536307797L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Trivial
        EndpointState(String host, int httpPort, int httpsPort) {
            this.hostName = host;
            this.httpPort = httpPort;
            this.httpsPort = httpsPort;
        }

        public String toString() {
            return "ES[host=" + this.hostName + ",http=" + this.httpPort + ",https=" + this.httpsPort + "]";
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.http.internal.VirtualHostImpl$EndpointState", EndpointState.class, (String)"HttpTransport", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
            notStarted = new EndpointState("locahost", 0, 0);
        }
    }
}

