/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.parsers;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.feature.provisioning.FeatureResource;
import com.ibm.ws.kernel.feature.provisioning.ProvisioningFeatureDefinition;
import com.ibm.ws.kernel.feature.provisioning.SubsystemContentType;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.repository.common.enums.AttachmentType;
import com.ibm.ws.repository.common.enums.DisplayPolicy;
import com.ibm.ws.repository.common.enums.InstallPolicy;
import com.ibm.ws.repository.common.enums.Visibility;
import com.ibm.ws.repository.exceptions.RepositoryException;
import com.ibm.ws.repository.parsers.Parser;
import com.ibm.ws.repository.parsers.ParserBase;
import com.ibm.ws.repository.parsers.exceptions.RepositoryArchiveEntryNotFoundException;
import com.ibm.ws.repository.parsers.exceptions.RepositoryArchiveIOException;
import com.ibm.ws.repository.parsers.exceptions.RepositoryArchiveInvalidEntryException;
import com.ibm.ws.repository.parsers.internal.EsaSubsystemFeatureDefinitionImpl;
import com.ibm.ws.repository.parsers.internal.ManifestHeaderProcessor;
import com.ibm.ws.repository.resources.writeable.AttachmentResourceWritable;
import com.ibm.ws.repository.resources.writeable.EsaResourceWritable;
import com.ibm.ws.repository.resources.writeable.RepositoryResourceWritable;
import com.ibm.ws.repository.resources.writeable.WritableResourceFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.aries.util.VersionRange;
import org.apache.aries.util.manifest.ManifestProcessor;
import org.osgi.framework.Version;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class EsaParser
extends ParserBase
implements Parser<EsaResourceWritable> {
    private static final String REQUIRE_CAPABILITY_HEADER_NAME = "Require-Capability";
    private static final String JAVA_FILTER_KEY = "JavaSE";
    private static final String VERSION_FILTER_KEY = "version";
    private static final String OSGI_EE_NAMESPACE_ID = "osgi.ee";
    private static final VersionRange JAVA_17_RANGE;
    private static final VersionRange JAVA_11_RANGE;
    private static final VersionRange JAVA_10_RANGE;
    private static final VersionRange JAVA_9_RANGE;
    private static final VersionRange JAVA_8_RANGE;
    private static final VersionRange JAVA_7_RANGE;
    private static final VersionRange JAVA_6_RANGE;
    static final long serialVersionUID = 3448337495561377483L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public EsaParser() {
    }

    public EsaParser(boolean overrideLicenseToNonSpecified) {
        this.overrideLicenseToNonSpecified = overrideLicenseToNonSpecified;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public EsaResourceWritable parseFileToResource(File assetFile, File metadataFile, String contentUrl) throws RepositoryException {
        DisplayPolicy webDisplayPolicy;
        DisplayPolicy displayPolicy;
        Visibility visibility;
        String metadataName;
        EsaSubsystemFeatureDefinitionImpl feature;
        ParserBase.ArtifactMetadata artifactMetadata = this.explodeArtifact(assetFile, metadataFile);
        try {
            feature = EsaSubsystemFeatureDefinitionImpl.constructInstance(assetFile);
        }
        catch (IOException iOException) {
            void e;
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.repository.parsers.EsaParser", (String)"110", (Object)this, (Object[])new Object[]{assetFile, metadataFile, contentUrl});
            throw new RepositoryArchiveIOException(e.getMessage(), assetFile, (Throwable)e);
        }
        EsaResourceWritable resource = WritableResourceFactory.createEsa(null);
        String symbolicName = feature.getSymbolicName();
        String version = feature.getVersion().toString();
        String subsystemName = feature.getHeader("Subsystem-Name", Locale.ENGLISH);
        String shortName = feature.getIbmShortName();
        String string = metadataName = artifactMetadata != null ? artifactMetadata.getName() : null;
        String name = metadataName != null && !metadataName.isEmpty() ? metadataName : (subsystemName != null && !subsystemName.isEmpty() ? subsystemName : (shortName != null && !shortName.isEmpty() ? shortName : symbolicName));
        resource.setName(name);
        String shortDescription = null;
        String overriddenDisplayPolicy = null;
        if (artifactMetadata != null) {
            shortDescription = artifactMetadata.getShortDescription();
            resource.setDescription(artifactMetadata.getLongDescription());
            resource.setVanityURL(artifactMetadata.getProperty(PROP_VANITY_URL));
            overriddenDisplayPolicy = artifactMetadata.getProperty(PROP_DISPLAY_POLICY);
        }
        if (shortDescription == null) {
            shortDescription = feature.getHeader("Subsystem-Description", Locale.ENGLISH);
        }
        resource.setShortDescription(shortDescription);
        resource.setVersion(version);
        this.processIcons(assetFile, (ProvisioningFeatureDefinition)feature, resource);
        String provider = feature.getHeader("Subsystem-Vendor");
        if (provider != null && !provider.isEmpty()) {
            resource.setProviderName(provider);
            if ("IBM".equals(provider)) {
                resource.setProviderUrl("http://www.ibm.com");
            }
        } else {
            throw new InvalidParameterException("Subsystem-Vendor must be set in the manifest headers");
        }
        resource.setProvideFeature(symbolicName);
        if (artifactMetadata != null && artifactMetadata.getProperty("IBM-AppliesTo") != null) {
            resource.setAppliesTo(artifactMetadata.getProperty("IBM-AppliesTo"));
        } else {
            resource.setAppliesTo(feature.getHeader("IBM-AppliesTo"));
        }
        if (com.ibm.ws.kernel.feature.Visibility.PUBLIC.equals((Object)feature.getVisibility())) {
            visibility = Visibility.PUBLIC;
            displayPolicy = DisplayPolicy.VISIBLE;
            webDisplayPolicy = DisplayPolicy.VISIBLE;
        } else if (com.ibm.ws.kernel.feature.Visibility.PROTECTED.equals((Object)feature.getVisibility())) {
            visibility = Visibility.PROTECTED;
            displayPolicy = DisplayPolicy.HIDDEN;
            webDisplayPolicy = DisplayPolicy.HIDDEN;
        } else if (com.ibm.ws.kernel.feature.Visibility.INSTALL.equals((Object)feature.getVisibility())) {
            visibility = Visibility.INSTALL;
            displayPolicy = DisplayPolicy.VISIBLE;
            webDisplayPolicy = DisplayPolicy.HIDDEN;
        } else {
            visibility = Visibility.PRIVATE;
            displayPolicy = DisplayPolicy.HIDDEN;
            webDisplayPolicy = DisplayPolicy.HIDDEN;
        }
        resource.setVisibility(visibility);
        if (feature.isAutoFeature()) {
            InstallPolicy installPolicy;
            resource.setProvisionCapability(feature.getHeader("IBM-Provision-Capability"));
            String IBMInstallPolicy = feature.getHeader("IBM-Install-Policy");
            if (IBMInstallPolicy != null && "when-satisfied".equals(IBMInstallPolicy)) {
                installPolicy = InstallPolicy.WHEN_SATISFIED;
            } else {
                installPolicy = InstallPolicy.MANUAL;
                displayPolicy = DisplayPolicy.VISIBLE;
                webDisplayPolicy = DisplayPolicy.VISIBLE;
            }
            resource.setInstallPolicy(installPolicy);
        }
        if (EsaParser.isBeta(resource.getAppliesTo())) {
            resource.setWebDisplayPolicy(DisplayPolicy.HIDDEN);
        } else {
            resource.setWebDisplayPolicy(webDisplayPolicy);
        }
        if (overriddenDisplayPolicy != null) {
            displayPolicy = DisplayPolicy.valueOf((String)overriddenDisplayPolicy);
        }
        resource.setDisplayPolicy(displayPolicy);
        String requiredFixes = feature.getHeader("IBM-Require-Fix");
        if (requiredFixes != null && !requiredFixes.isEmpty()) {
            String[] fixes = requiredFixes.split(",");
            for (String string2 : fixes) {
                String string3 = string2.trim();
                if (string3.isEmpty()) continue;
                resource.addRequireFix(string3);
            }
        }
        resource.setShortName(shortName);
        Collection requiredFeatures = feature.getConstituents(SubsystemContentType.FEATURE_TYPE);
        for (FeatureResource featureResource : requiredFeatures) {
            List tolerates = featureResource.getTolerates();
            String string4 = featureResource.getSymbolicName();
            resource.addRequireFeatureWithTolerates(string4, (Collection)tolerates);
        }
        String supersededBy = feature.getSupersededBy();
        if (supersededBy != null && !supersededBy.trim().isEmpty()) {
            String[] supersededByArray;
            for (String f : supersededByArray = supersededBy.split(",")) {
                if (f.startsWith("[")) {
                    f = f.substring(1, f.length() - 1);
                    resource.addSupersededByOptional(f);
                    continue;
                }
                resource.addSupersededBy(f);
            }
        }
        if (artifactMetadata != null) {
            this.attachLicenseData(artifactMetadata, (RepositoryResourceWritable)resource);
        }
        EsaParser.setJavaRequirements(assetFile, resource);
        String attachmentName = symbolicName + ".esa";
        this.addContent((RepositoryResourceWritable)resource, assetFile, attachmentName, artifactMetadata, contentUrl);
        try {
            this.processLAandLI(assetFile, (RepositoryResourceWritable)resource, (ProvisioningFeatureDefinition)feature);
        }
        catch (IOException tolerates) {
            void e;
            FFDCFilter.processException((Throwable)tolerates, (String)"com.ibm.ws.repository.parsers.EsaParser", (String)"298", (Object)this, (Object[])new Object[]{assetFile, metadataFile, contentUrl});
            throw new RepositoryArchiveIOException(e.getMessage(), assetFile, (Throwable)e);
        }
        resource.setLicenseId(feature.getHeader("Subsystem-License"));
        resource.setSingleton(Boolean.toString(feature.isSingleton()));
        resource.setIBMInstallTo(feature.getHeader("IBM-InstallTo"));
        return resource;
    }

    private void processIcons(File esa, ProvisioningFeatureDefinition feature, EsaResourceWritable resource) throws RepositoryException {
        String current = "";
        String sizeString = "";
        String iconName = "";
        String subsystemIcon = feature.getHeader("Subsystem-Icon");
        if (subsystemIcon != null) {
            subsystemIcon.replaceAll("\\s", "");
            StringTokenizer s = new StringTokenizer(subsystemIcon, ",");
            while (s.hasMoreTokens()) {
                File icon;
                current = s.nextToken();
                int size = 0;
                if (current.contains(";")) {
                    StringTokenizer t = new StringTokenizer(current, ";");
                    while (t.hasMoreTokens()) {
                        sizeString = t.nextToken();
                        if (sizeString.contains("size=")) {
                            String[] sizes = sizeString.split("size=");
                            size = Integer.parseInt(sizes[sizes.length - 1]);
                            continue;
                        }
                        iconName = sizeString;
                    }
                } else {
                    iconName = current;
                }
                if ((icon = this.extractFileFromArchive(esa.getAbsolutePath(), iconName.trim()).getExtractedFile()).exists()) {
                    AttachmentResourceWritable at = resource.addAttachment(icon, AttachmentType.THUMBNAIL);
                    if (size == 0) continue;
                    at.setImageDimensions(size, size);
                    continue;
                }
                throw new RepositoryArchiveEntryNotFoundException("Icon does not exist", esa, iconName);
            }
        }
    }

    public static boolean isBeta(String appliesTo) {
        if (appliesTo == null) {
            return false;
        }
        String regex = ".*productVersion=\"?[2-9][0-9][0-9][0-9][.].*";
        boolean matches = appliesTo.matches(regex);
        return matches;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void setJavaRequirements(File esa, EsaResourceWritable resource) throws RepositoryException {
        HashMap<Path, String> requiresMap;
        StringBuilder message;
        LinkedHashMap<String, VersionRange> matchingEnvs;
        HashMap<String, String> bundleRequirements;
        block15: {
            bundleRequirements = new HashMap<String, String>();
            Path zipfile = esa.toPath();
            matchingEnvs = new LinkedHashMap<String, VersionRange>();
            matchingEnvs.put("Java 6", JAVA_6_RANGE);
            matchingEnvs.put("Java 7", JAVA_7_RANGE);
            matchingEnvs.put("Java 8", JAVA_8_RANGE);
            matchingEnvs.put("Java 9", JAVA_9_RANGE);
            matchingEnvs.put("Java 10", JAVA_10_RANGE);
            matchingEnvs.put("Java 11", JAVA_11_RANGE);
            matchingEnvs.put("Java 17", JAVA_17_RANGE);
            message = new StringBuilder();
            requiresMap = new HashMap<Path, String>();
            try {
                FileSystem zipSystem = FileSystems.newFileSystem(zipfile, null);
                try {
                    Iterable<Path> roots = zipSystem.getRootDirectories();
                    BundleFinder bundleFinder = new BundleFinder(zipSystem);
                    Iterator<Path> iterator = roots.iterator();
                    while (iterator.hasNext()) {
                        Path root = iterator.next();
                        Files.walkFileTree(root, new HashSet<FileVisitOption>(), 1, bundleFinder);
                    }
                    for (Path bundle : bundleFinder.bundles) {
                        EsaParser.addBundleManifestRequireCapability(zipSystem, bundle, requiresMap);
                    }
                    EsaParser.addSubsystemManifestRequireCapability(esa, requiresMap);
                    if (zipSystem == null) break block15;
                }
                catch (Throwable roots) {
                    FFDCFilter.processException((Throwable)roots, (String)"com.ibm.ws.repository.parsers.EsaParser", (String)"428", null, (Object[])new Object[]{esa, resource});
                    if (zipSystem == null) throw roots;
                    try {
                        zipSystem.close();
                        throw roots;
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.repository.parsers.EsaParser", (String)"428", null, (Object[])new Object[]{esa, resource});
                        roots.addSuppressed(throwable);
                    }
                    throw roots;
                }
                zipSystem.close();
            }
            catch (IOException zipSystem) {
                void e;
                FFDCFilter.processException((Throwable)zipSystem, (String)"com.ibm.ws.repository.parsers.EsaParser", (String)"446", null, (Object[])new Object[]{esa, resource});
                throw new RepositoryArchiveIOException(e.getMessage(), esa, (Throwable)e);
            }
        }
        Set entries = requiresMap.entrySet();
        block8: for (Map.Entry entry : entries) {
            Path path = (Path)entry.getKey();
            List<ManifestHeaderProcessor.GenericMetadata> requirementMetadata = ManifestHeaderProcessor.parseRequirementString((String)entry.getValue());
            ManifestHeaderProcessor.GenericMetadata eeVersionMetadata = null;
            for (ManifestHeaderProcessor.GenericMetadata metaData : requirementMetadata) {
                if (!metaData.getNamespace().equals(OSGI_EE_NAMESPACE_ID)) continue;
                eeVersionMetadata = metaData;
                break;
            }
            if (eeVersionMetadata == null) continue;
            Map<String, String> dirs = eeVersionMetadata.getDirectives();
            for (String key : dirs.keySet()) {
                if (!key.equals("filter")) continue;
                Map<String, String> filter = null;
                filter = ManifestHeaderProcessor.parseFilter(dirs.get(key));
                if (!filter.containsKey(OSGI_EE_NAMESPACE_ID) || !filter.get(OSGI_EE_NAMESPACE_ID).equals(JAVA_FILTER_KEY) || !filter.containsKey(VERSION_FILTER_KEY)) continue;
                bundleRequirements.put(path.getFileName().toString(), dirs.get(key));
                VersionRange range = ManifestHeaderProcessor.parseVersionRange(filter.get(VERSION_FILTER_KEY));
                Iterator iterator = matchingEnvs.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry capability = iterator.next();
                    VersionRange intersection = ((VersionRange)capability.getValue()).intersect(range);
                    if (intersection != null) continue;
                    message.append("Manifest from " + path.getFileName() + " with range " + range + " caused env for " + (String)capability.getKey() + " to be removed. ");
                    iterator.remove();
                }
                continue block8;
            }
        }
        if (matchingEnvs.size() == 0) {
            throw new RepositoryException("ESA " + resource.getName() + " is invalid as no Java execution environment matches all the bundle requirements: " + message);
        }
        ArrayList<String> rawRequirements = new ArrayList<String>();
        for (String key : bundleRequirements.keySet()) {
            rawRequirements.add(key + ": " + (String)bundleRequirements.get(key));
        }
        if (rawRequirements.size() == 0) {
            rawRequirements = null;
        }
        Version version = ((VersionRange)matchingEnvs.entrySet().iterator().next().getValue()).getMaximumVersion();
        resource.setJavaSEVersionRequirements(version.toString(), null, rawRequirements);
    }

    @Override
    protected void checkRequiredProperties(ParserBase.ArtifactMetadata artifact) throws RepositoryArchiveInvalidEntryException {
        this.checkPropertySet("longDescription", artifact);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addBundleManifestRequireCapability(FileSystem zipSystem, Path bundle, Map<Path, String> requiresMap) throws IOException {
        Path extractedJar = null;
        try {
            extractedJar = Files.createTempFile("unpackedBundle", ".jar", new FileAttribute[0]);
            extractedJar.toFile().deleteOnExit();
            Files.copy(bundle, extractedJar, StandardCopyOption.REPLACE_EXISTING);
            Manifest bundleJarManifest = null;
            try (JarFile bundleJar = null;){
                bundleJar = new JarFile(extractedJar.toFile());
                bundleJarManifest = bundleJar.getManifest();
            }
            Attributes bundleManifestAttrs = bundleJarManifest.getMainAttributes();
            String requireCapabilityAttr = bundleManifestAttrs.getValue(REQUIRE_CAPABILITY_HEADER_NAME);
            if (requireCapabilityAttr != null) {
                requiresMap.put(bundle, requireCapabilityAttr);
            }
        }
        finally {
            if (extractedJar != null) {
                extractedJar.toFile().delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addSubsystemManifestRequireCapability(File esa, Map<Path, String> requiresMap) throws IOException {
        String esaLocation = esa.getAbsolutePath();
        try (ZipFile zip = null;){
            zip = new ZipFile(esaLocation);
            Enumeration<? extends ZipEntry> zipEntries = zip.entries();
            ZipEntry subsystemEntry = null;
            while (zipEntries.hasMoreElements()) {
                ZipEntry nextEntry = zipEntries.nextElement();
                if (!"OSGI-INF/SUBSYSTEM.MF".equalsIgnoreCase(nextEntry.getName())) continue;
                subsystemEntry = nextEntry;
                break;
            }
            if (subsystemEntry == null) {
            } else {
                Manifest m = ManifestProcessor.parseManifest((InputStream)zip.getInputStream(subsystemEntry));
                Attributes manifestAttrs = m.getMainAttributes();
                String requireCapabilityAttr = manifestAttrs.getValue(REQUIRE_CAPABILITY_HEADER_NAME);
                requiresMap.put(esa.toPath(), requireCapabilityAttr);
            }
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.repository.parsers.EsaParser", EsaParser.class, null, null);
        JAVA_17_RANGE = VersionRange.parseVersionRange((String)"[1.2,17]");
        JAVA_11_RANGE = VersionRange.parseVersionRange((String)"[1.2,11]");
        JAVA_10_RANGE = VersionRange.parseVersionRange((String)"[1.2,10]");
        JAVA_9_RANGE = VersionRange.parseVersionRange((String)"[1.2,9]");
        JAVA_8_RANGE = VersionRange.parseVersionRange((String)"[1.2,1.8]");
        JAVA_7_RANGE = new VersionRange("[1.2,1.7]");
        JAVA_6_RANGE = new VersionRange("[1.2,1.6]");
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static class BundleFinder
    extends SimpleFileVisitor<Path> {
        FileSystem _zipSystem;
        PathMatcher _bundleMatcher;
        ArrayList<Path> bundles = new ArrayList();
        static final long serialVersionUID = -3263862205931564125L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private BundleFinder(FileSystem zipSystem) {
            this._zipSystem = zipSystem;
            this._bundleMatcher = this._zipSystem.getPathMatcher("glob:/*.jar");
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attr) {
            if (this._bundleMatcher.matches(file)) {
                this.bundles.add(file);
            }
            return FileVisitResult.CONTINUE;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.repository.parsers.EsaParser$BundleFinder", BundleFinder.class, null, null);
        }
    }
}

