/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.https;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.ReflectionInvokationHandler;
import org.apache.cxf.common.util.ReflectionUtil;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.configuration.jsse.TLSParameterBase;
import org.apache.cxf.configuration.security.FiltersType;
import org.apache.cxf.transport.https.SSLSocketFactoryWrapper;
import org.apache.cxf.transport.https.SSLUtils;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class HttpsURLConnectionFactory {
    public static final String HTTPS_URL_PROTOCOL_ID = "https";
    private static final Logger LOG = LogUtils.getL7dLogger(HttpsURLConnectionFactory.class);
    private static boolean weblogicWarned;
    SSLSocketFactory socketFactory;
    int lastTlsHash;
    static final long serialVersionUID = 2422129614170803924L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public HttpsURLConnectionFactory() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.https.HttpsURLConnectionFactory", "<init>", new Object[0]);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.https.HttpsURLConnectionFactory", "<init>", this);
        }
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public HttpURLConnection createConnection(TLSClientParameters tlsClientParameters, java.net.Proxy proxy, URL url) throws IOException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.https.HttpsURLConnectionFactory", "createConnection", new Object[]{tlsClientParameters, proxy, url});
        }
        LOG.fine("Create HttpURLConnection to:  " + url);
        HttpURLConnection connection = (HttpURLConnection)(proxy != null ? url.openConnection(proxy) : url.openConnection());
        if (HTTPS_URL_PROTOCOL_ID.equals(url.getProtocol())) {
            if (tlsClientParameters == null) {
                LOG.fine("tlsClientParameters is NULL, create new");
                tlsClientParameters = new TLSClientParameters();
            }
            try {
                this.decorateWithTLS(tlsClientParameters, connection);
            }
            catch (Throwable throwable) {
                void ex;
                FFDCFilter.processException((Throwable)throwable, (String)"org.apache.cxf.transport.https.HttpsURLConnectionFactory", (String)"105", (Object)this, (Object[])new Object[]{tlsClientParameters, proxy, url});
                throw new IOException("Error while initializing secure socket", (Throwable)ex);
            }
        }
        HttpURLConnection httpURLConnection = connection;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            httpURLConnection = httpURLConnection;
            LOG.exiting("org.apache.cxf.transport.https.HttpsURLConnectionFactory", "createConnection", httpURLConnection);
        }
        return httpURLConnection;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected synchronized void decorateWithTLS(TLSClientParameters tlsClientParameters, HttpURLConnection connection) throws GeneralSecurityException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.https.HttpsURLConnectionFactory", "decorateWithTLS", new Object[]{tlsClientParameters, connection});
        }
        int hash = tlsClientParameters.hashCode();
        if (hash != this.lastTlsHash) {
            LOG.fine("Hash does not match!");
            this.lastTlsHash = hash;
            this.socketFactory = null;
        }
        if (tlsClientParameters.isUseHttpsURLConnectionDefaultSslSocketFactory()) {
            LOG.fine("tlsClientParameters property: isUseHttpsURLConnectionDefaultSslSocketFactory is set to true!");
            this.socketFactory = HttpsURLConnection.getDefaultSSLSocketFactory();
        } else if (tlsClientParameters.getSSLSocketFactory() != null) {
            LOG.fine("Get SSL socketFactory from tlsClientParameters");
            this.socketFactory = tlsClientParameters.getSSLSocketFactory();
        } else if (this.socketFactory == null) {
            SSLContext ctx = null;
            LOG.fine("SSL socketFactory is NULL");
            if (tlsClientParameters.getSslContext() != null) {
                LOG.fine("Get SSLContext from tlsClientParameters");
                ctx = tlsClientParameters.getSslContext();
            } else if (tlsClientParameters.isJaxrsClient() || tlsClientParameters.getTrustManagers() != null && tlsClientParameters.getKeyManagers() != null) {
                LOG.fine("Get SSLContext with tlsClientParameters's Trust Managers, Key Managers");
                ctx = SSLUtils.getSSLContext((TLSParameterBase)tlsClientParameters);
            } else {
                LOG.fine("No trustManagers set on tlsClientParameters, so use Liberty's DefaultSSLSocketFactory");
                this.socketFactory = HttpsURLConnection.getDefaultSSLSocketFactory();
            }
            if (ctx != null) {
                LOG.fine("Create new socketFactory from SSLContext and set Ciphersuites");
                String[] cipherSuites = org.apache.cxf.configuration.jsse.SSLUtils.getCiphersuitesToInclude((List)tlsClientParameters.getCipherSuites(), (FiltersType)tlsClientParameters.getCipherSuitesFilter(), (String[])ctx.getSocketFactory().getDefaultCipherSuites(), (String[])org.apache.cxf.configuration.jsse.SSLUtils.getSupportedCipherSuites((SSLContext)ctx), (Logger)LOG);
                String protocol = tlsClientParameters.getSecureSocketProtocol() != null ? tlsClientParameters.getSecureSocketProtocol() : ctx.getProtocol();
                this.socketFactory = new SSLSocketFactoryWrapper(ctx.getSocketFactory(), cipherSuites, protocol);
            }
            if (this.socketFactory != null) {
                LOG.fine("SSL socketFactory: " + this.socketFactory.getClass().getCanonicalName());
            }
            this.lastTlsHash = tlsClientParameters.hashCode();
        } else {
            LOG.fine("SSL socketFactory already initialized!");
        }
        HostnameVerifier verifier = SSLUtils.getHostnameVerifier(tlsClientParameters);
        LOG.fine("Hostname verifier obtained from SSLUtils.getHostnameVerifier: " + (verifier == null ? "null" : verifier.getClass().getCanonicalName()));
        if (tlsClientParameters != null) {
            LOG.fine("isDisableCNCheck value in tlsClientParameters: " + tlsClientParameters.isDisableCNCheck());
        }
        if (connection instanceof HttpsURLConnection) {
            final HttpsURLConnection conn = (HttpsURLConnection)connection;
            if (verifier != null) {
                LOG.fine("Setting Hostname verifier to: " + verifier.getClass().getCanonicalName());
            } else {
                LOG.fine("Something wrong! verifier is NULL!");
            }
            conn.setHostnameVerifier(verifier);
            AccessController.doPrivileged(new PrivilegedAction<Void>(){
                static final long serialVersionUID = -7346763299087277688L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Void run() {
                    LOG.fine("Setiing SSLSocketFactory on connection: " + HttpsURLConnectionFactory.this.socketFactory.getClass().getCanonicalName());
                    conn.setSSLSocketFactory(HttpsURLConnectionFactory.this.socketFactory);
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"org.apache.cxf.transport.https.HttpsURLConnectionFactory$1", 1.class, null, null);
                }
            });
        } else {
            LOG.fine("Handle deprecated sun case...");
            try {
                Method method = connection.getClass().getMethod("getHostnameVerifier", new Class[0]);
                LOG.fine("Invoking method 1: " + method.getName());
                ReflectionInvokationHandler handler = new ReflectionInvokationHandler(verifier){
                    static final long serialVersionUID = 4351777493615938345L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    /*
                     * WARNING - void declaration
                     */
                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        try {
                            return super.invoke(proxy, method, args);
                        }
                        catch (Exception exception) {
                            void ex;
                            FFDCFilter.processException((Throwable)exception, (String)"org.apache.cxf.transport.https.HttpsURLConnectionFactory$2", (String)"233", (Object)((Object)this), (Object[])new Object[]{proxy, method, args});
                            LOG.fine("Exception from invoke: " + ex);
                            return false;
                        }
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"org.apache.cxf.transport.https.HttpsURLConnectionFactory$2", 2.class, null, null);
                    }
                };
                Object proxy = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{method.getReturnType()}, (InvocationHandler)handler);
                method = connection.getClass().getMethod("setHostnameVerifier", method.getReturnType());
                LOG.fine("Invoking method 2: " + method.getName());
                method.invoke((Object)connection, proxy);
            }
            catch (Exception method) {
                void ex;
                FFDCFilter.processException((Throwable)method, (String)"org.apache.cxf.transport.https.HttpsURLConnectionFactory", (String)"246", (Object)this, (Object[])new Object[]{tlsClientParameters, connection});
                LOG.fine("Exception occurred in decorateWithTLS: " + ex);
            }
            try {
                Method getSSLSocketFactory = connection.getClass().getMethod("getSSLSocketFactory", new Class[0]);
                Method setSSLSocketFactory = connection.getClass().getMethod("setSSLSocketFactory", getSSLSocketFactory.getReturnType());
                if (getSSLSocketFactory.getReturnType().isInstance(this.socketFactory)) {
                    LOG.fine("Calling setSSLSocketFactory.invoke 1");
                    setSSLSocketFactory.invoke((Object)connection, this.socketFactory);
                } else {
                    Constructor<?> c = getSSLSocketFactory.getReturnType().getDeclaredConstructor(SSLSocketFactory.class);
                    ReflectionUtil.setAccessible(c);
                    LOG.fine("Calling setSSLSocketFactory.invoke 2");
                    setSSLSocketFactory.invoke((Object)connection, c.newInstance(this.socketFactory));
                }
            }
            catch (Exception getSSLSocketFactory) {
                void ex;
                FFDCFilter.processException((Throwable)getSSLSocketFactory, (String)"org.apache.cxf.transport.https.HttpsURLConnectionFactory", (String)"267", (Object)this, (Object[])new Object[]{tlsClientParameters, connection});
                if (connection.getClass().getName().contains("weblogic")) {
                    if (!weblogicWarned) {
                        weblogicWarned = true;
                        LOG.warning("Could not configure SSLSocketFactory on Weblogic.   Use the Weblogic control panel to configure the SSL settings.");
                    }
                    if (LOG != null && LOG.isLoggable(Level.FINER)) {
                        LOG.exiting("org.apache.cxf.transport.https.HttpsURLConnectionFactory", "decorateWithTLS");
                    }
                    return;
                }
                throw new IllegalArgumentException("Error decorating connection class " + connection.getClass().getName(), (Throwable)ex);
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.https.HttpsURLConnectionFactory", "decorateWithTLS");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void addLogHandler(Handler handler) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.https.HttpsURLConnectionFactory", "addLogHandler", new Object[]{handler});
        }
        LOG.addHandler(handler);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.https.HttpsURLConnectionFactory", "addLogHandler");
        }
    }
}

