/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.servlet;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.Bus;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PropertyUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.FileUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.resource.ResourceManager;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public abstract class AbstractHTTPServlet
extends HttpServlet
implements Filter {
    private static final long serialVersionUID = -8357252743467075117L;
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractHTTPServlet.class);
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(AbstractHTTPServlet.class);
    private static final List<String> KNOWN_HTTP_VERBS = Arrays.asList("POST", "GET", "PUT", "DELETE", "HEAD", "OPTIONS", "TRACE");
    private static final String STATIC_RESOURCES_PARAMETER = "static-resources-list";
    private static final String STATIC_WELCOME_FILE_PARAMETER = "static-welcome-file";
    private static final String STATIC_CACHE_CONTROL = "static-cache-control";
    private static final String STATIC_RESOURCES_MAP_RESOURCE = "/cxfServletStaticResourcesMap.txt";
    private static final String REDIRECTS_PARAMETER = "redirects-list";
    private static final String REDIRECT_SERVLET_NAME_PARAMETER = "redirect-servlet-name";
    private static final String REDIRECT_SERVLET_PATH_PARAMETER = "redirect-servlet-path";
    private static final String REDIRECT_ATTRIBUTES_PARAMETER = "redirect-attributes";
    private static final String REDIRECT_QUERY_CHECK_PARAMETER = "redirect-query-check";
    private static final String REDIRECT_WITH_INCLUDE_PARAMETER = "redirect-with-include";
    private static final String USE_X_FORWARDED_HEADERS_PARAMETER = "use-x-forwarded-headers";
    private static final String X_FORWARDED_PROTO_HEADER = "X-Forwarded-Proto";
    private static final String X_FORWARDED_FOR_HEADER = "X-Forwarded-For";
    private static final String X_FORWARDED_PREFIX_HEADER = "X-Forwarded-Prefix";
    private static final String X_FORWARDED_HOST_HEADER = "X-Forwarded-Host";
    private static final String X_FORWARDED_PORT_HEADER = "X-Forwarded-Port";
    private static final Map<String, String> DEFAULT_STATIC_CONTENT_TYPES = new HashMap<String, String>();
    private List<Pattern> staticResourcesList;
    private String staticWelcomeFile;
    private List<Pattern> redirectList;
    private String dispatcherServletPath;
    private String dispatcherServletName;
    private Map<String, String> redirectAttributes;
    private Map<String, String> staticContentTypes;
    private boolean redirectQueryCheck;
    private boolean useXForwardedHeaders;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public AbstractHTTPServlet() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.servlet.AbstractHTTPServlet", "<init>", new Object[0]);
        }
        this.staticContentTypes = new HashMap<String, String>(DEFAULT_STATIC_CONTENT_TYPES);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.servlet.AbstractHTTPServlet", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void init(ServletConfig servletConfig) throws ServletException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.servlet.AbstractHTTPServlet", "init", new Object[]{servletConfig});
        }
        super.init(servletConfig);
        this.staticResourcesList = AbstractHTTPServlet.parseListSequence(servletConfig.getInitParameter(STATIC_RESOURCES_PARAMETER));
        this.staticWelcomeFile = servletConfig.getInitParameter(STATIC_WELCOME_FILE_PARAMETER);
        this.redirectList = AbstractHTTPServlet.parseListSequence(servletConfig.getInitParameter(REDIRECTS_PARAMETER));
        this.redirectQueryCheck = Boolean.valueOf(servletConfig.getInitParameter(REDIRECT_QUERY_CHECK_PARAMETER));
        this.dispatcherServletName = servletConfig.getInitParameter(REDIRECT_SERVLET_NAME_PARAMETER);
        this.dispatcherServletPath = servletConfig.getInitParameter(REDIRECT_SERVLET_PATH_PARAMETER);
        this.redirectAttributes = AbstractHTTPServlet.parseMapSequence(servletConfig.getInitParameter(REDIRECT_ATTRIBUTES_PARAMETER));
        this.useXForwardedHeaders = Boolean.valueOf(servletConfig.getInitParameter(USE_X_FORWARDED_HEADERS_PARAMETER));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.servlet.AbstractHTTPServlet", "init");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void destroy() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.servlet.AbstractHTTPServlet", "destroy", new Object[0]);
        }
        FileUtils.maybeDeleteDefaultTempDir();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.servlet.AbstractHTTPServlet", "destroy");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void finalizeServletInit(ServletConfig servletConfig) throws ServletException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.servlet.AbstractHTTPServlet", "finalizeServletInit", new Object[]{servletConfig});
        }
        InputStream is = this.getResourceAsStream("/WEB-INF/cxfServletStaticResourcesMap.txt");
        if (is == null) {
            is = this.getResourceAsStream(STATIC_RESOURCES_MAP_RESOURCE);
        }
        if (is != null) {
            try {
                Properties props = new Properties();
                props.load(is);
                for (String name : props.stringPropertyNames()) {
                    this.staticContentTypes.put(name, props.getProperty(name));
                }
                is.close();
            }
            catch (IOException props) {
                FFDCFilter.processException((Throwable)props, (String)"org.apache.cxf.transport.servlet.AbstractHTTPServlet", (String)"146", (Object)((Object)this), (Object[])new Object[]{servletConfig});
                String message = new Message("STATIC_RESOURCES_MAP_LOAD_FAILURE", BUNDLE, new Object[0]).toString();
                LOG.warning(message);
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.servlet.AbstractHTTPServlet", "finalizeServletInit");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected InputStream getResourceAsStream(String path) {
        ResourceManager rm;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.servlet.AbstractHTTPServlet", "getResourceAsStream", new Object[]{path});
        }
        InputStream is = ClassLoaderUtils.getResourceAsStream((String)path, AbstractHTTPServlet.class);
        if (is == null && this.getBus() != null && (rm = (ResourceManager)this.getBus().getExtension(ResourceManager.class)) != null) {
            is = (InputStream)rm.resolveResource(path, InputStream.class);
        }
        InputStream inputStream = is;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            inputStream = inputStream;
            LOG.exiting("org.apache.cxf.transport.servlet.AbstractHTTPServlet", "getResourceAsStream", inputStream);
        }
        return inputStream;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public final void init(final FilterConfig filterConfig) throws ServletException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.servlet.AbstractHTTPServlet", "init", new Object[]{filterConfig});
        }
        this.init(new ServletConfig(){
            static final long serialVersionUID = 6246680372740062680L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public String getServletName() {
                return filterConfig.getFilterName();
            }

            public ServletContext getServletContext() {
                return filterConfig.getServletContext();
            }

            public String getInitParameter(String name) {
                return filterConfig.getInitParameter(name);
            }

            public Enumeration<String> getInitParameterNames() {
                return filterConfig.getInitParameterNames();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"org.apache.cxf.transport.servlet.AbstractHTTPServlet$1", 1.class, null, null);
            }
        });
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.servlet.AbstractHTTPServlet", "init");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected static List<Pattern> parseListSequence(String values) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.servlet.AbstractHTTPServlet", "parseListSequence", new Object[]{values});
        }
        if (values != null) {
            ArrayList<Pattern> list = new ArrayList<Pattern>();
            for (String value : values.split("\\s")) {
                if (value.isEmpty()) continue;
                list.add(Pattern.compile(value));
            }
            list.trimToSize();
            ArrayList<Pattern> arrayList = list;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                arrayList = arrayList;
                LOG.exiting("org.apache.cxf.transport.servlet.AbstractHTTPServlet", "parseListSequence", arrayList);
            }
            return arrayList;
        }
        List<Pattern> list = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            list = list;
            LOG.exiting("org.apache.cxf.transport.servlet.AbstractHTTPServlet", "parseListSequence", list);
        }
        return list;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected static Map<String, String> parseMapSequence(String sequence) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.servlet.AbstractHTTPServlet", "parseMapSequence", new Object[]{sequence});
        }
        if (sequence != null) {
            sequence = sequence.trim();
            HashMap<String, String> map = new HashMap<String, String>();
            for (String pair : sequence.split("\\s")) {
                if (pair.isEmpty()) continue;
                String[] value = pair.split("=");
                if (value.length == 2) {
                    map.put(value[0], value[1]);
                    continue;
                }
                map.put(pair, "");
            }
            HashMap<String, String> hashMap = map;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                hashMap = hashMap;
                LOG.exiting("org.apache.cxf.transport.servlet.AbstractHTTPServlet", "parseMapSequence", hashMap);
            }
            return hashMap;
        }
        Map<String, String> map = Collections.emptyMap();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            map = map;
            LOG.exiting("org.apache.cxf.transport.servlet.AbstractHTTPServlet", "parseMapSequence", map);
        }
        return map;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.servlet.AbstractHTTPServlet", "doPost", new Object[]{request, response});
        }
        this.handleRequest(request, response);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.servlet.AbstractHTTPServlet", "doPost");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.servlet.AbstractHTTPServlet", "doGet", new Object[]{request, response});
        }
        this.handleRequest(request, response);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.servlet.AbstractHTTPServlet", "doGet");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.servlet.AbstractHTTPServlet", "doDelete", new Object[]{request, response});
        }
        this.handleRequest(request, response);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.servlet.AbstractHTTPServlet", "doDelete");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.servlet.AbstractHTTPServlet", "doPut", new Object[]{request, response});
        }
        this.handleRequest(request, response);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.servlet.AbstractHTTPServlet", "doPut");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void doHead(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.servlet.AbstractHTTPServlet", "doHead", new Object[]{request, response});
        }
        this.handleRequest(request, response);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.servlet.AbstractHTTPServlet", "doHead");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void doOptions(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.servlet.AbstractHTTPServlet", "doOptions", new Object[]{request, response});
        }
        this.handleRequest(request, response);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.servlet.AbstractHTTPServlet", "doOptions");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        HttpServletResponse response;
        HttpServletRequest request;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.servlet.AbstractHTTPServlet", "service", new Object[]{req, res});
        }
        try {
            request = (HttpServletRequest)req;
            response = (HttpServletResponse)res;
        }
        catch (ClassCastException classCastException) {
            FFDCFilter.processException((Throwable)classCastException, (String)"org.apache.cxf.transport.servlet.AbstractHTTPServlet", (String)"268", (Object)((Object)this), (Object[])new Object[]{req, res});
            throw new ServletException("Unrecognized HTTP request or response object");
        }
        String method = request.getMethod();
        if (KNOWN_HTTP_VERBS.contains(method)) {
            super.service(request, response);
        } else {
            this.handleRequest(request, response);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.servlet.AbstractHTTPServlet", "service");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        boolean staticWelcomeFileMatch;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.servlet.AbstractHTTPServlet", "handleRequest", new Object[]{request, response});
        }
        if ((this.dispatcherServletPath != null || this.dispatcherServletName != null) && (this.redirectList != null && AbstractHTTPServlet.matchPath(this.redirectQueryCheck, this.redirectList, request) || this.redirectList == null)) {
            this.redirect(request, response, request.getPathInfo());
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.transport.servlet.AbstractHTTPServlet", "handleRequest");
            }
            return;
        }
        boolean staticResourcesMatch = this.staticResourcesList != null && AbstractHTTPServlet.matchPath(false, this.staticResourcesList, request);
        boolean bl = staticWelcomeFileMatch = this.staticWelcomeFile != null && (StringUtils.isEmpty((String)request.getPathInfo()) || "/".equals(request.getPathInfo()));
        if (staticResourcesMatch || staticWelcomeFileMatch) {
            this.serveStaticContent(request, response, staticWelcomeFileMatch ? this.staticWelcomeFile : request.getPathInfo());
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.transport.servlet.AbstractHTTPServlet", "handleRequest");
            }
            return;
        }
        request = this.checkXForwardedHeaders(request);
        this.invoke(request, response);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.servlet.AbstractHTTPServlet", "handleRequest");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected HttpServletRequest checkXForwardedHeaders(HttpServletRequest request) {
        String originalPort;
        String originalHost;
        String originalPrefix;
        String originalRemoteAddr;
        String originalProtocol;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.servlet.AbstractHTTPServlet", "checkXForwardedHeaders", new Object[]{request});
        }
        if (this.useXForwardedHeaders && Stream.of(originalProtocol = request.getHeader(X_FORWARDED_PROTO_HEADER), originalRemoteAddr = request.getHeader(X_FORWARDED_FOR_HEADER), originalPrefix = request.getHeader(X_FORWARDED_PREFIX_HEADER), originalHost = request.getHeader(X_FORWARDED_HOST_HEADER), originalPort = request.getHeader(X_FORWARDED_PORT_HEADER)).anyMatch(Objects::nonNull)) {
            HttpServletRequestXForwardedFilter httpServletRequestXForwardedFilter = new HttpServletRequestXForwardedFilter(request, originalProtocol, originalRemoteAddr, originalPrefix, originalHost, originalPort);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                httpServletRequestXForwardedFilter = httpServletRequestXForwardedFilter;
                LOG.exiting("org.apache.cxf.transport.servlet.AbstractHTTPServlet", "checkXForwardedHeaders", (Object)httpServletRequestXForwardedFilter);
            }
            return httpServletRequestXForwardedFilter;
        }
        HttpServletRequest httpServletRequest = request;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            httpServletRequest = httpServletRequest;
            LOG.exiting("org.apache.cxf.transport.servlet.AbstractHTTPServlet", "checkXForwardedHeaders", httpServletRequest);
        }
        return httpServletRequest;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static boolean matchPath(boolean checkRedirect, List<Pattern> values, HttpServletRequest request) {
        String queryString;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.servlet.AbstractHTTPServlet", "matchPath", new Object[]{checkRedirect, values, request});
        }
        String path = request.getPathInfo();
        if (path == null) {
            path = "/";
        }
        if (checkRedirect && (queryString = request.getQueryString()) != null && !queryString.isEmpty()) {
            path = path + "?" + queryString;
        }
        for (Pattern pattern : values) {
            if (!pattern.matcher(path).matches()) continue;
            boolean bl = true;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.transport.servlet.AbstractHTTPServlet", "matchPath", bl);
            }
            return bl;
        }
        boolean bl = false;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.transport.servlet.AbstractHTTPServlet", "matchPath", bl);
        }
        return bl;
    }

    protected abstract Bus getBus();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void serveStaticContent(HttpServletRequest request, HttpServletResponse response, String pathInfo) throws ServletException {
        block10: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.transport.servlet.AbstractHTTPServlet", "serveStaticContent", new Object[]{request, response, pathInfo});
            }
            try {
                InputStream is = this.getResourceAsStream(pathInfo);
                try {
                    String cacheControl;
                    String type;
                    if (is == null) {
                        throw new ServletException("Static resource " + pathInfo + " is not available");
                    }
                    int ind = pathInfo.lastIndexOf(46);
                    if (ind > 0 && (type = this.getStaticResourceContentType(pathInfo.substring(ind + 1))) != null) {
                        response.setContentType(type);
                    }
                    if ((cacheControl = this.getServletConfig().getInitParameter(STATIC_CACHE_CONTROL)) != null) {
                        response.setHeader("Cache-Control", cacheControl.trim());
                    }
                    IOUtils.copy((InputStream)is, (OutputStream)response.getOutputStream());
                    if (is == null) break block10;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"org.apache.cxf.transport.servlet.AbstractHTTPServlet", (String)"351", (Object)((Object)this), (Object[])new Object[]{request, response, pathInfo});
                    if (is == null) throw throwable;
                    try {
                        is.close();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        FFDCFilter.processException((Throwable)throwable2, (String)"org.apache.cxf.transport.servlet.AbstractHTTPServlet", (String)"351", (Object)((Object)this), (Object[])new Object[]{request, response, pathInfo});
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                is.close();
            }
            catch (IOException is) {
                FFDCFilter.processException((Throwable)is, (String)"org.apache.cxf.transport.servlet.AbstractHTTPServlet", (String)"367", (Object)((Object)this), (Object[])new Object[]{request, response, pathInfo});
                throw new ServletException("Static resource " + pathInfo + " can not be written to the output stream");
            }
        }
        if (LOG == null) return;
        if (!LOG.isLoggable(Level.FINER)) return;
        LOG.exiting("org.apache.cxf.transport.servlet.AbstractHTTPServlet", "serveStaticContent");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected String getStaticResourceContentType(String extension) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.servlet.AbstractHTTPServlet", "getStaticResourceContentType", new Object[]{extension});
        }
        String string = this.staticContentTypes.get(extension);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.transport.servlet.AbstractHTTPServlet", "getStaticResourceContentType", string);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void redirect(HttpServletRequest request, HttpServletResponse response, String pathInfo) throws ServletException {
        RequestDispatcher rd;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.servlet.AbstractHTTPServlet", "redirect", new Object[]{request, response, pathInfo});
        }
        boolean customServletPath = this.dispatcherServletPath != null;
        String theServletPath = customServletPath ? this.dispatcherServletPath : "/";
        ServletContext sc = super.getServletContext();
        RequestDispatcher requestDispatcher = rd = this.dispatcherServletName != null ? sc.getNamedDispatcher(this.dispatcherServletName) : sc.getRequestDispatcher((theServletPath + pathInfo).replace("//", "/"));
        if (rd == null) {
            String errorMessage = "No RequestDispatcher can be created for path " + pathInfo;
            if (this.dispatcherServletName != null) {
                errorMessage = errorMessage + ", dispatcher name: " + this.dispatcherServletName;
            }
            throw new ServletException(errorMessage);
        }
        try {
            for (Map.Entry<String, String> entry : this.redirectAttributes.entrySet()) {
                request.setAttribute(entry.getKey(), (Object)entry.getValue());
            }
            HttpServletRequestRedirectFilter servletRequest = new HttpServletRequestRedirectFilter(request, pathInfo, theServletPath, customServletPath);
            if (PropertyUtils.isTrue((Object)this.getServletConfig().getInitParameter(REDIRECT_WITH_INCLUDE_PARAMETER))) {
                rd.include((ServletRequest)servletRequest, (ServletResponse)response);
            } else {
                rd.forward((ServletRequest)servletRequest, (ServletResponse)response);
            }
        }
        catch (Throwable servletRequest) {
            void ex;
            FFDCFilter.processException((Throwable)servletRequest, (String)"org.apache.cxf.transport.servlet.AbstractHTTPServlet", (String)"405", (Object)((Object)this), (Object[])new Object[]{request, response, pathInfo});
            throw new ServletException("RequestDispatcher for path " + pathInfo + " has failed", (Throwable)ex);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.servlet.AbstractHTTPServlet", "redirect");
        }
    }

    protected abstract void invoke(HttpServletRequest var1, HttpServletResponse var2) throws ServletException;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    static {
        DEFAULT_STATIC_CONTENT_TYPES.put("html", "text/html");
        DEFAULT_STATIC_CONTENT_TYPES.put("txt", "text/plain");
        DEFAULT_STATIC_CONTENT_TYPES.put("css", "text/css");
        DEFAULT_STATIC_CONTENT_TYPES.put("pdf", "application/pdf");
        DEFAULT_STATIC_CONTENT_TYPES.put("xsd", "application/xml");
        DEFAULT_STATIC_CONTENT_TYPES.put("js", "application/javascript");
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class HttpServletRequestXForwardedFilter
    extends HttpServletRequestWrapper {
        private String newProtocol;
        private String newRemoteAddr;
        private String newContextPath;
        private String newServletPath;
        private String newRequestUri;
        private StringBuffer newRequestUrl;
        static final long serialVersionUID = 3459715165274012955L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        HttpServletRequestXForwardedFilter(HttpServletRequest request, String originalProto, String originalRemoteAddr, String originalPrefix, String originalHost, String originalPort) {
            super(request);
            this.newProtocol = originalProto;
            if (originalRemoteAddr != null) {
                this.newRemoteAddr = originalRemoteAddr.split(",")[0].trim();
            }
            this.newRequestUri = HttpServletRequestXForwardedFilter.calculateNewRequestUri(request, originalPrefix);
            String outermostHost = originalHost != null ? originalHost.split(",", 2)[0].trim() : originalHost;
            this.newRequestUrl = HttpServletRequestXForwardedFilter.calculateNewRequestUrl(request, originalProto, originalPrefix, outermostHost, originalPort);
            this.newContextPath = HttpServletRequestXForwardedFilter.calculateNewContextPath(request, originalPrefix);
            this.newServletPath = HttpServletRequestXForwardedFilter.calculateNewServletPath(request, originalPrefix);
        }

        private static String calculateNewContextPath(HttpServletRequest request, String originalPrefix) {
            if (originalPrefix != null) {
                return originalPrefix;
            }
            return request.getContextPath();
        }

        private static String calculateNewServletPath(HttpServletRequest request, String originalPrefix) {
            String servletPath = request.getServletPath();
            if (originalPrefix != null) {
                servletPath = request.getContextPath() + servletPath;
            }
            return servletPath;
        }

        private static String calculateNewRequestUri(HttpServletRequest request, String originalPrefix) {
            String requestUri = request.getRequestURI();
            if (originalPrefix != null) {
                requestUri = originalPrefix + requestUri;
            }
            return requestUri;
        }

        private static StringBuffer calculateNewRequestUrl(HttpServletRequest request, String originalProto, String originalPrefix, String originalHost, String originalPort) {
            URI uri = URI.create(request.getRequestURL().toString());
            StringBuffer sb = new StringBuffer();
            sb.append(originalProto != null ? originalProto : uri.getScheme()).append("://").append(originalHost != null ? originalHost : uri.getHost()).append(originalPort != null && !"-1".equals(originalPort) ? ":" + originalPort : (uri.getPort() != -1 ? ":" + uri.getPort() : "")).append(originalPrefix != null ? originalPrefix : "").append(uri.getRawPath());
            String query = uri.getRawQuery();
            if (query != null) {
                sb.append('?').append(query);
            }
            return sb;
        }

        public boolean isSecure() {
            if (this.newProtocol != null) {
                return "https".equals(this.newProtocol);
            }
            return super.isSecure();
        }

        public StringBuffer getRequestURL() {
            return this.newRequestUrl;
        }

        public String getRemoteAddr() {
            if (this.newRemoteAddr != null) {
                return this.newRemoteAddr;
            }
            return super.getRemoteAddr();
        }

        public String getRequestURI() {
            return this.newRequestUri;
        }

        public String getContextPath() {
            return this.newContextPath;
        }

        public String getServletPath() {
            return this.newServletPath;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.transport.servlet.AbstractHTTPServlet$HttpServletRequestXForwardedFilter", HttpServletRequestXForwardedFilter.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class HttpServletRequestRedirectFilter
    extends HttpServletRequestWrapper {
        private String pathInfo;
        private String servletPath;
        static final long serialVersionUID = 2406852006205380072L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        HttpServletRequestRedirectFilter(HttpServletRequest request, String pathInfo, String servletPath, boolean customServletPath) {
            super(request);
            this.pathInfo = pathInfo;
            this.servletPath = servletPath;
            if ("/".equals(this.servletPath) && !customServletPath) {
                if (this.pathInfo == null) {
                    this.pathInfo = "/";
                    this.servletPath = "";
                } else {
                    this.servletPath = "";
                }
            }
        }

        public String getServletPath() {
            return this.servletPath;
        }

        public String getPathInfo() {
            return this.pathInfo;
        }

        public String getRequestURI() {
            String contextPath = this.getContextPath();
            if ("/".equals(contextPath)) {
                contextPath = "";
            }
            return contextPath + (this.servletPath + this.pathInfo).replace("//", "/");
        }

        public Object getAttribute(String name) {
            if ("http.service.redirection".equals(name)) {
                return "true";
            }
            return super.getAttribute(name);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.transport.servlet.AbstractHTTPServlet$HttpServletRequestRedirectFilter", HttpServletRequestRedirectFilter.class, null, null);
        }
    }
}

