/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.injectionengine;

import com.ibm.ejs.util.dopriv.SetAccessiblePrivilegedAction;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.injectionengine.InjectionBinding;
import com.ibm.wsspi.injectionengine.InjectionConfigurationException;
import com.ibm.wsspi.injectionengine.InjectionException;
import com.ibm.wsspi.injectionengine.InjectionTarget;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedActionException;

public class InjectionTargetMethod
extends InjectionTarget {
    private static final String CLASS_NAME = InjectionTargetMethod.class.getName();
    private static final TraceComponent tc = Tr.register(InjectionTargetMethod.class, (String)"Injection", (String)"com.ibm.wsspi.injectionengine.injection");
    Method ivMethod = null;

    protected InjectionTargetMethod(Method method, InjectionBinding<?> binding) throws InjectionException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)(this.getClass().getSimpleName() + ".<init> : " + method), (Object[])new Object[0]);
        }
        boolean isFromClient = binding.ivNameSpaceConfig.isClientMain(method.getDeclaringClass());
        int methodModifiers = method.getModifiers();
        if (Modifier.isStatic(methodModifiers) && !isFromClient) {
            Tr.warning((TraceComponent)tc, (String)"INJECTION_TARGET_MUST_NOT_BE_STATIC_CWNEN0057W", (Object[])new Object[]{method.getDeclaringClass().getName(), method.getName()});
            if (binding.isValidationFailable()) {
                throw new InjectionConfigurationException("The " + method.getDeclaringClass().getName() + "." + method.getName() + " injection target must not be declared static.");
            }
        } else if (!Modifier.isStatic(methodModifiers) && isFromClient) {
            Tr.error((TraceComponent)tc, (String)"INJECTION_TARGET_IN_CLIENT_MUST_BE_STATIC_CWNEN0058E", (Object[])new Object[]{method.getDeclaringClass().getName(), method.getName()});
            InjectionConfigurationException icex = new InjectionConfigurationException("The injection target method " + method.getName() + " must be declared static in the client container.");
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)(this.getClass().getSimpleName() + ".<init> : " + icex));
            }
            throw icex;
        }
        if (!Modifier.isPublic(methodModifiers)) {
            try {
                SetAccessiblePrivilegedAction privilegedMethodAction = new SetAccessiblePrivilegedAction((AccessibleObject)method, true);
                AccessController.doPrivileged(privilegedMethodAction);
            }
            catch (PrivilegedActionException paex) {
                FFDCFilter.processException((Throwable)paex, (String)(CLASS_NAME + ".<init>"), (String)"97", (Object)this, (Object[])new Object[]{method, binding});
                SecurityException ex = (SecurityException)paex.getException();
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)(this.getClass().getSimpleName() + ".<init> : " + ex));
                }
                throw ex;
            }
        }
        binding.setInjectionClassType(method);
        this.ivMethod = method;
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)(this.getClass().getSimpleName() + ".<init> : " + this.ivMethod));
        }
    }

    @Override
    public Member getMember() {
        return this.ivMethod;
    }

    @Override
    public Class<?> getInjectionClassType() {
        return this.ivMethod.getParameterTypes()[0];
    }

    @Override
    public Type getGenericType() {
        return this.ivMethod.getGenericParameterTypes()[0];
    }

    @Override
    protected void injectMember(Object objectToInject, Object dependentObject) throws Exception {
        try {
            this.ivMethod.invoke(objectToInject, dependentObject);
        }
        finally {
            this.ivInjectionBinding.cleanAfterMethodInvocation();
        }
    }
}

