/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.annocache.info.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.annocache.info.internal.ArrayClassInfoImpl;
import com.ibm.ws.annocache.info.internal.ClassInfoImpl;
import com.ibm.ws.annocache.info.internal.DelayedClassInfoImpl;
import com.ibm.ws.annocache.info.internal.InfoStoreImpl;
import com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl;
import com.ibm.ws.annocache.info.internal.PackageInfoImpl;
import com.ibm.ws.annocache.info.internal.PrimitiveClassInfoImpl;
import com.ibm.ws.annocache.util.internal.UtilImpl_Factory;
import com.ibm.ws.annocache.util.internal.UtilImpl_InternMap;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.anno.util.Util_InternMap;
import com.ibm.wsspi.annocache.info.InfoStoreException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.objectweb.asm.Type;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class ClassInfoCacheImpl {
    private static final Logger logger;
    private static final String CLASS_NAME = "ClassInfoCacheImpl";
    protected String hashText;
    protected InfoStoreImpl infoStore;
    protected UtilImpl_InternMap descriptionInternMap;
    protected UtilImpl_InternMap packageNameInternMap;
    protected UtilImpl_InternMap classNameInternMap;
    protected UtilImpl_InternMap fieldNameInternMap;
    protected UtilImpl_InternMap methodNameInternMap;
    protected Map<String, PackageInfoImpl> packageInfos;
    protected static final boolean DO_FORCE_PACKAGE = true;
    protected static final boolean DO_NOT_FORCE_PACKAGE = false;
    protected static final boolean FOR_FAILED_LOAD = true;
    protected static final boolean NOT_FOR_FAILED_LOAD = false;
    protected HashMap<String, PrimitiveClassInfoImpl> primitiveClassInfos;
    protected static final boolean DO_ALLOW_PRIMITIVE = true;
    protected static final boolean DO_NOT_ALLOW_PRIMITIVE = false;
    protected Map<String, DelayedClassInfoImpl> delayedClassInfos;
    public static final String CLASSINFO_CACHE_LIMIT_PROPERTY_NAME = "classinfocachesize";
    public static final int MIN_CLASSINFO_CACHE_LIMIT = 100;
    public static final int MAX_CLASSINFO_CACHE_LIMIT = 10000;
    public static final int DEFAULT_CLASSINFO_CACHE_LIMIT = 2000;
    protected static final int classInfoCacheLimit;
    protected Map<String, NonDelayedClassInfoImpl> javaClassInfos;
    protected Map<String, NonDelayedClassInfoImpl> annotatedClassInfos;
    protected NonDelayedClassInfoImpl firstClassInfo;
    protected NonDelayedClassInfoImpl lastClassInfo;
    protected Map<String, NonDelayedClassInfoImpl> classInfos;
    static final long serialVersionUID = -3992144556991087542L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void discardRef(Object objectRef) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "discardRef", new Object[]{objectRef});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "discardRef");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ClassInfoCacheImpl(InfoStoreImpl infoStore) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "<init>", new Object[]{infoStore});
        }
        String methodName = "<init>";
        this.hashText = this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode());
        this.infoStore = infoStore;
        UtilImpl_Factory utilFactory = (UtilImpl_Factory)infoStore.getInfoStoreFactory().getUtilFactory();
        this.descriptionInternMap = utilFactory.createInternMap(Util_InternMap.ValueType.VT_OTHER, "DescriptionMap");
        this.packageNameInternMap = utilFactory.createInternMap(Util_InternMap.ValueType.VT_CLASS_NAME, "PackageNameMap");
        this.classNameInternMap = utilFactory.createInternMap(Util_InternMap.ValueType.VT_CLASS_NAME, "ClassNameMap");
        this.fieldNameInternMap = utilFactory.createInternMap(Util_InternMap.ValueType.VT_FIELD_NAME, "FieldNameMap");
        this.methodNameInternMap = utilFactory.createInternMap(Util_InternMap.ValueType.VT_METHOD_NAME, "MethodNameMap");
        this.packageInfos = new HashMap<String, PackageInfoImpl>();
        this.primitiveClassInfos = new HashMap();
        this.delayedClassInfos = new HashMap<String, DelayedClassInfoImpl>();
        this.javaClassInfos = new HashMap<String, NonDelayedClassInfoImpl>();
        this.annotatedClassInfos = new HashMap<String, NonDelayedClassInfoImpl>();
        this.classInfos = new HashMap<String, NonDelayedClassInfoImpl>();
        this.firstClassInfo = null;
        this.lastClassInfo = null;
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Created on manager [ {1} ]", new Object[]{this.getHashText(), this.getInfoStore().getHashText()});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected String getHashText() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "getHashText", new Object[0]);
        }
        String string = this.hashText;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "getHashText", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public InfoStoreImpl getInfoStore() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "getInfoStore", new Object[0]);
        }
        InfoStoreImpl infoStoreImpl = this.infoStore;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            infoStoreImpl = infoStoreImpl;
            logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "getInfoStore", infoStoreImpl);
        }
        return infoStoreImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void scanClass(String name) throws InfoStoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "scanClass", new Object[]{name});
        }
        this.getInfoStore().scanClass(name);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "scanClass");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void scanPackage(String packageClassName) throws InfoStoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "scanPackage", new Object[]{packageClassName});
        }
        this.getInfoStore().scanNewClass(packageClassName);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "scanPackage");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public UtilImpl_InternMap getDescriptionInternMap() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "getDescriptionInternMap", new Object[0]);
        }
        UtilImpl_InternMap utilImpl_InternMap = this.descriptionInternMap;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            utilImpl_InternMap = utilImpl_InternMap;
            logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "getDescriptionInternMap", utilImpl_InternMap);
        }
        return utilImpl_InternMap;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String internDescription(String description) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "internDescription", new Object[]{description});
        }
        String string = this.getDescriptionInternMap().intern(description);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "internDescription", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public UtilImpl_InternMap getPackageNameInternMap() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "getPackageNameInternMap", new Object[0]);
        }
        UtilImpl_InternMap utilImpl_InternMap = this.packageNameInternMap;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            utilImpl_InternMap = utilImpl_InternMap;
            logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "getPackageNameInternMap", utilImpl_InternMap);
        }
        return utilImpl_InternMap;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String internPackageName(String packageName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "internPackageName", new Object[]{packageName});
        }
        String string = this.getPackageNameInternMap().intern(packageName);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "internPackageName", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public UtilImpl_InternMap getClassNameInternMap() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "getClassNameInternMap", new Object[0]);
        }
        UtilImpl_InternMap utilImpl_InternMap = this.classNameInternMap;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            utilImpl_InternMap = utilImpl_InternMap;
            logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "getClassNameInternMap", utilImpl_InternMap);
        }
        return utilImpl_InternMap;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String internClassName(String className) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "internClassName", new Object[]{className});
        }
        String string = this.getClassNameInternMap().intern(className);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "internClassName", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public UtilImpl_InternMap getFieldNameInternMap() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "getFieldNameInternMap", new Object[0]);
        }
        UtilImpl_InternMap utilImpl_InternMap = this.fieldNameInternMap;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            utilImpl_InternMap = utilImpl_InternMap;
            logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "getFieldNameInternMap", utilImpl_InternMap);
        }
        return utilImpl_InternMap;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String internFieldName(String fieldName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "internFieldName", new Object[]{fieldName});
        }
        String string = this.getFieldNameInternMap().intern(fieldName);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "internFieldName", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public UtilImpl_InternMap getMethodNameInternMap() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "getMethodNameInternMap", new Object[0]);
        }
        UtilImpl_InternMap utilImpl_InternMap = this.methodNameInternMap;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            utilImpl_InternMap = utilImpl_InternMap;
            logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "getMethodNameInternMap", utilImpl_InternMap);
        }
        return utilImpl_InternMap;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String internMethodName(String fieldName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "internMethodName", new Object[]{fieldName});
        }
        String string = this.getMethodNameInternMap().intern(fieldName);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "internMethodName", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected PackageInfoImpl basicGetPackageInfo(String packageName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "basicGetPackageInfo", new Object[]{packageName});
        }
        PackageInfoImpl packageInfoImpl = this.packageInfos.get(packageName);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            packageInfoImpl = packageInfoImpl;
            logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "basicGetPackageInfo", packageInfoImpl);
        }
        return packageInfoImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected PackageInfoImpl basicAddPackageInfo(String name, int access) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "basicAddPackageInfo", new Object[]{name, access});
        }
        PackageInfoImpl packageInfo = new PackageInfoImpl(name, access, this.getInfoStore());
        packageInfo.setModifiers(access);
        this.packageInfos.put(name, packageInfo);
        PackageInfoImpl packageInfoImpl = packageInfo;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            packageInfoImpl = packageInfoImpl;
            logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "basicAddPackageInfo", packageInfoImpl);
        }
        return packageInfoImpl;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected PackageInfoImpl getPackageInfo(String packageName, boolean doForce) {
        boolean failedLoad;
        PackageInfoImpl packageInfo;
        String methodName;
        block9: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "getPackageInfo", new Object[]{packageName, doForce});
            }
            methodName = "getPackageInfo";
            packageInfo = this.packageInfos.get(packageName);
            if (packageInfo != null) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] RETURN [ {1} ] - cached", new Object[]{this.getHashText(), packageInfo.getHashText()});
                }
                PackageInfoImpl packageInfoImpl = packageInfo;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    packageInfoImpl = packageInfoImpl;
                    logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "getPackageInfo", packageInfoImpl);
                }
                return packageInfoImpl;
            }
            String packageClassName = PackageInfoImpl.addClassNameToPackageName(packageName);
            try {
                this.scanPackage(packageClassName);
                failedLoad = false;
            }
            catch (InfoStoreException infoStoreException) {
                void e;
                FFDCFilter.processException((Throwable)infoStoreException, (String)"com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", (String)"273", (Object)this, (Object[])new Object[]{packageName, doForce});
                failedLoad = true;
                logger.logp(Level.WARNING, CLASS_NAME, methodName, "[ {0} ] ANNO_CLASSINFO_SCAN_EXCEPTION [ {1} ] [ {2} ] [ {3} ]", new Object[]{this.getHashText(), packageClassName, e.getMessage(), e.getCause() == null ? e : e.getCause()});
                logger.logp(Level.WARNING, CLASS_NAME, methodName, "Scan failure", (Throwable)e);
                if (!logger.isLoggable(Level.FINER)) break block9;
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] [ {1} ]: Scan exception: Generating artifical package", new Object[]{this.getHashText(), packageClassName});
            }
        }
        packageInfo = this.packageInfos.get(packageName);
        if (packageInfo == null && (doForce || failedLoad)) {
            packageInfo = this.storeArtificalPackage(packageName, failedLoad);
        }
        if (logger.isLoggable(Level.FINER)) {
            String packageText = packageInfo != null ? packageInfo.getHashText() : null;
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] RETURN [ {1} ] - new ", new Object[]{this.getHashText(), packageText});
        }
        PackageInfoImpl packageInfoImpl = packageInfo;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            packageInfoImpl = packageInfoImpl;
            logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "getPackageInfo", packageInfoImpl);
        }
        return packageInfoImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected PackageInfoImpl storeArtificalPackage(String packageName, boolean forFailedLoad) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "storeArtificalPackage", new Object[]{packageName, forFailedLoad});
        }
        PackageInfoImpl packageInfo = new PackageInfoImpl(packageName, 0, this.getInfoStore());
        packageInfo.setIsArtificial(true);
        packageInfo.setForFailedLoad(forFailedLoad);
        String i_packageName = packageInfo.getName();
        this.packageInfos.put(i_packageName, packageInfo);
        PackageInfoImpl packageInfoImpl = packageInfo;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            packageInfoImpl = packageInfoImpl;
            logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "storeArtificalPackage", packageInfoImpl);
        }
        return packageInfoImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected ClassInfoImpl getDelayableClassInfo(Type type) {
        String classInfoCase;
        ClassInfoImpl classInfo;
        int sort;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "getDelayableClassInfo", new Object[]{type});
        }
        String methodName = "getDelayableClassInfo";
        String typeClassName = type.getClassName();
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] ENTER [ {1} ] [ {2} ]", new Object[]{this.getHashText(), type, typeClassName});
        }
        if ((sort = type.getSort()) == 9) {
            classInfo = this.getArrayClassInfo(typeClassName, type);
            classInfoCase = "array class";
        } else if (sort == 10) {
            classInfo = this.getDelayableClassInfo(typeClassName, false);
            classInfoCase = classInfo.isJavaClass() ? (classInfo.isDelayedClass() ? "java delayed" : "java non-delayed") : (classInfo.isDelayedClass() ? "non-java delayed" : "non-java non-delayed");
        } else {
            classInfo = this.getPrimitiveClassInfo(typeClassName, type);
            classInfoCase = "primitive class";
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] RETURN [ {1} ] [ {2} ]", new Object[]{this.getHashText(), classInfo.getHashText(), classInfoCase});
        }
        ClassInfoImpl classInfoImpl = classInfo;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            classInfoImpl = classInfoImpl;
            logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "getDelayableClassInfo", classInfoImpl);
        }
        return classInfoImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ArrayClassInfoImpl getArrayClassInfo(String typeClassName, Type arrayType) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "getArrayClassInfo", new Object[]{typeClassName, arrayType});
        }
        ClassInfoImpl elementClassInfo = this.getDelayableClassInfo(arrayType.getElementType());
        ArrayClassInfoImpl arrayClassInfoImpl = new ArrayClassInfoImpl(typeClassName, elementClassInfo);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            arrayClassInfoImpl = arrayClassInfoImpl;
            logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "getArrayClassInfo", arrayClassInfoImpl);
        }
        return arrayClassInfoImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Class<?> getPrimitiveClass(Type type) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "getPrimitiveClass", new Object[]{type});
        }
        switch (type.getDescriptor().charAt(0)) {
            case 'B': {
                Class<Byte> clazz = Byte.TYPE;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    clazz = clazz;
                    logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "getPrimitiveClass", clazz);
                }
                return clazz;
            }
            case 'C': {
                Class<Character> clazz = Character.TYPE;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    clazz = clazz;
                    logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "getPrimitiveClass", clazz);
                }
                return clazz;
            }
            case 'D': {
                Class<Double> clazz = Double.TYPE;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    clazz = clazz;
                    logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "getPrimitiveClass", clazz);
                }
                return clazz;
            }
            case 'F': {
                Class<Float> clazz = Float.TYPE;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    clazz = clazz;
                    logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "getPrimitiveClass", clazz);
                }
                return clazz;
            }
            case 'I': {
                Class<Integer> clazz = Integer.TYPE;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    clazz = clazz;
                    logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "getPrimitiveClass", clazz);
                }
                return clazz;
            }
            case 'J': {
                Class<Long> clazz = Long.TYPE;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    clazz = clazz;
                    logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "getPrimitiveClass", clazz);
                }
                return clazz;
            }
            case 'S': {
                Class<Short> clazz = Short.TYPE;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    clazz = clazz;
                    logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "getPrimitiveClass", clazz);
                }
                return clazz;
            }
            case 'V': {
                Class<Void> clazz = Void.TYPE;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    clazz = clazz;
                    logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "getPrimitiveClass", clazz);
                }
                return clazz;
            }
            case 'Z': {
                Class<Boolean> clazz = Boolean.TYPE;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    clazz = clazz;
                    logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "getPrimitiveClass", clazz);
                }
                return clazz;
            }
        }
        throw new IllegalArgumentException("Unrecognized type [ " + type.getDescriptor() + " ]");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Type getPrimitiveType(String className) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "getPrimitiveType", new Object[]{className});
        }
        if (className.equals("byte")) {
            Type type = Type.BYTE_TYPE;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                type = type;
                logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "getPrimitiveType", type);
            }
            return type;
        }
        if (className.equals("char")) {
            Type type = Type.CHAR_TYPE;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                type = type;
                logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "getPrimitiveType", type);
            }
            return type;
        }
        if (className.equals("double")) {
            Type type = Type.DOUBLE_TYPE;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                type = type;
                logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "getPrimitiveType", type);
            }
            return type;
        }
        if (className.equals("float")) {
            Type type = Type.FLOAT_TYPE;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                type = type;
                logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "getPrimitiveType", type);
            }
            return type;
        }
        if (className.equals("int")) {
            Type type = Type.INT_TYPE;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                type = type;
                logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "getPrimitiveType", type);
            }
            return type;
        }
        if (className.equals("long")) {
            Type type = Type.LONG_TYPE;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                type = type;
                logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "getPrimitiveType", type);
            }
            return type;
        }
        if (className.equals("short")) {
            Type type = Type.SHORT_TYPE;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                type = type;
                logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "getPrimitiveType", type);
            }
            return type;
        }
        if (className.equals("void")) {
            Type type = Type.VOID_TYPE;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                type = type;
                logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "getPrimitiveType", type);
            }
            return type;
        }
        if (className.equals("boolean")) {
            Type type = Type.BOOLEAN_TYPE;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                type = type;
                logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "getPrimitiveType", type);
            }
            return type;
        }
        Type type = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            type = type;
            logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "getPrimitiveType", type);
        }
        return type;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public PrimitiveClassInfoImpl getPrimitiveClassInfo(String typeClassName, Type primitiveType) {
        String primitiveClassInfoCase;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "getPrimitiveClassInfo", new Object[]{typeClassName, primitiveType});
        }
        String methodName = "getPrimitiveClassInfo";
        PrimitiveClassInfoImpl primitiveClassInfo = this.primitiveClassInfos.get(typeClassName);
        if (primitiveClassInfo == null) {
            Class<?> typeClass = ClassInfoCacheImpl.getPrimitiveClass(primitiveType);
            primitiveClassInfo = new PrimitiveClassInfoImpl(typeClassName, typeClass, this.getInfoStore());
            primitiveClassInfoCase = "created";
            typeClassName = primitiveClassInfo.getName();
            this.primitiveClassInfos.put(typeClassName, primitiveClassInfo);
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Primitives cache size [ {1} ]", new Object[]{this.getHashText(), this.primitiveClassInfos.size()});
            }
        } else {
            primitiveClassInfoCase = "cached";
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] RETURN [ {1} ] [ {2} ]", new Object[]{this.getHashText(), primitiveClassInfo.getHashText(), primitiveClassInfoCase});
        }
        PrimitiveClassInfoImpl primitiveClassInfoImpl = primitiveClassInfo;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            primitiveClassInfoImpl = primitiveClassInfoImpl;
            logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "getPrimitiveClassInfo", primitiveClassInfoImpl);
        }
        return primitiveClassInfoImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ClassInfoImpl getDelayableClassInfo(String name, boolean allowPrimitive) {
        Type primitiveType;
        String useHashText;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "getDelayableClassInfo", new Object[]{name, allowPrimitive});
        }
        String methodName = "getDelayableClassInfo";
        String string = useHashText = logger.isLoggable(Level.FINER) ? this.getHashText() : null;
        if (allowPrimitive && (primitiveType = ClassInfoCacheImpl.getPrimitiveType(name)) != null) {
            PrimitiveClassInfoImpl primitiveClassInfo = this.getPrimitiveClassInfo(name, primitiveType);
            if (useHashText != null) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] ENTER / RETURN [ {1} ] primitive class", new Object[]{useHashText, primitiveClassInfo.getHashText()});
            }
            PrimitiveClassInfoImpl primitiveClassInfoImpl = primitiveClassInfo;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                primitiveClassInfoImpl = primitiveClassInfoImpl;
                logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "getDelayableClassInfo", primitiveClassInfoImpl);
            }
            return primitiveClassInfoImpl;
        }
        NonDelayedClassInfoImpl javaClassInfo = this.basicGetJavaClassInfo(name);
        if (javaClassInfo != null) {
            if (useHashText != null) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] ENTER / RETURN [ {1} ] java class", new Object[]{useHashText, javaClassInfo.getHashText()});
            }
            NonDelayedClassInfoImpl nonDelayedClassInfoImpl = javaClassInfo;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                nonDelayedClassInfoImpl = nonDelayedClassInfoImpl;
                logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "getDelayableClassInfo", nonDelayedClassInfoImpl);
            }
            return nonDelayedClassInfoImpl;
        }
        NonDelayedClassInfoImpl annotatedClassInfo = this.basicGetAnnotatedClassInfo(name);
        if (annotatedClassInfo != null) {
            if (useHashText != null) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] ENTER / RETURN [ {1} ] annotated class", new Object[]{useHashText, annotatedClassInfo.getHashText()});
            }
            NonDelayedClassInfoImpl nonDelayedClassInfoImpl = annotatedClassInfo;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                nonDelayedClassInfoImpl = nonDelayedClassInfoImpl;
                logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "getDelayableClassInfo", nonDelayedClassInfoImpl);
            }
            return nonDelayedClassInfoImpl;
        }
        DelayedClassInfoImpl delayedClassInfo = this.basicGetDelayedClassInfo(name);
        if (delayedClassInfo != null) {
            if (useHashText != null) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] ENTER / RETURN [ {1} ] already delayed", new Object[]{useHashText, delayedClassInfo.getHashText()});
            }
            DelayedClassInfoImpl delayedClassInfoImpl = delayedClassInfo;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                delayedClassInfoImpl = delayedClassInfoImpl;
                logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "getDelayableClassInfo", delayedClassInfoImpl);
            }
            return delayedClassInfoImpl;
        }
        delayedClassInfo = this.basicPutDelayedClassInfo(name);
        NonDelayedClassInfoImpl nonDelayedClassInfo = this.associate(delayedClassInfo);
        if (useHashText != null) {
            if (nonDelayedClassInfo != null) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] ENTER / RETURN [ {1} ] newly created delayed for [ {2} ]", new Object[]{useHashText, delayedClassInfo.getHashText(), nonDelayedClassInfo.getHashText()});
            } else {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] ENTER / RETURN [ {1} ] newly created delayed", new Object[]{useHashText, delayedClassInfo.getHashText()});
            }
        }
        DelayedClassInfoImpl delayedClassInfoImpl = delayedClassInfo;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            delayedClassInfoImpl = delayedClassInfoImpl;
            logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "getDelayableClassInfo", delayedClassInfoImpl);
        }
        return delayedClassInfoImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ClassInfoImpl getNonDelayedClassInfo(String name, boolean allowPrimitive) {
        Type primitiveType;
        String useHashText;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "getNonDelayedClassInfo", new Object[]{name, allowPrimitive});
        }
        String methodName = "getNonDelayableClassInfo";
        String string = useHashText = logger.isLoggable(Level.FINER) ? this.getHashText() : null;
        if (allowPrimitive && (primitiveType = ClassInfoCacheImpl.getPrimitiveType(name)) != null) {
            PrimitiveClassInfoImpl primitiveClassInfo = this.getPrimitiveClassInfo(name, primitiveType);
            if (useHashText != null) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] ENTER / RETURN [ {1} ] primitive class", new Object[]{useHashText, primitiveClassInfo.getHashText()});
            }
            PrimitiveClassInfoImpl primitiveClassInfoImpl = primitiveClassInfo;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                primitiveClassInfoImpl = primitiveClassInfoImpl;
                logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "getNonDelayedClassInfo", primitiveClassInfoImpl);
            }
            return primitiveClassInfoImpl;
        }
        NonDelayedClassInfoImpl javaClassInfo = this.basicGetJavaClassInfo(name);
        if (javaClassInfo != null) {
            if (useHashText != null) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] ENTER / RETURN [ {1} ] java class", new Object[]{useHashText, javaClassInfo.getHashText()});
            }
            NonDelayedClassInfoImpl nonDelayedClassInfoImpl = javaClassInfo;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                nonDelayedClassInfoImpl = nonDelayedClassInfoImpl;
                logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "getNonDelayedClassInfo", nonDelayedClassInfoImpl);
            }
            return nonDelayedClassInfoImpl;
        }
        NonDelayedClassInfoImpl annotatedClassInfo = this.basicGetAnnotatedClassInfo(name);
        if (annotatedClassInfo != null) {
            if (useHashText != null) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] ENTER / RETURN [ {1} ] annotated class", new Object[]{useHashText, annotatedClassInfo.getHashText()});
            }
            NonDelayedClassInfoImpl nonDelayedClassInfoImpl = annotatedClassInfo;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                nonDelayedClassInfoImpl = nonDelayedClassInfoImpl;
                logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "getNonDelayedClassInfo", nonDelayedClassInfoImpl);
            }
            return nonDelayedClassInfoImpl;
        }
        NonDelayedClassInfoImpl nonDelayedClassInfo = this.basicGetClassInfo(name);
        if (nonDelayedClassInfo != null) {
            if (useHashText != null) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] ENTER / RETURN [ {1} ]", new Object[]{useHashText, nonDelayedClassInfo.getHashText()});
            }
        } else {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] ENTER / RETURN [ null ]", useHashText);
        }
        NonDelayedClassInfoImpl nonDelayedClassInfoImpl = nonDelayedClassInfo;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            nonDelayedClassInfoImpl = nonDelayedClassInfoImpl;
            logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "getNonDelayedClassInfo", nonDelayedClassInfoImpl);
        }
        return nonDelayedClassInfoImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected DelayedClassInfoImpl basicGetDelayedClassInfo(String name) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "basicGetDelayedClassInfo", new Object[]{name});
        }
        DelayedClassInfoImpl delayedClassInfoImpl = this.delayedClassInfos.get(name);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            delayedClassInfoImpl = delayedClassInfoImpl;
            logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "basicGetDelayedClassInfo", delayedClassInfoImpl);
        }
        return delayedClassInfoImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected DelayedClassInfoImpl basicPutDelayedClassInfo(String name) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "basicPutDelayedClassInfo", new Object[]{name});
        }
        String methodName = "basicPutDelayedClassInfo";
        DelayedClassInfoImpl delayedClassInfo = new DelayedClassInfoImpl(name, this.getInfoStore());
        name = delayedClassInfo.getName();
        this.delayedClassInfos.put(name, delayedClassInfo);
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Adding delayed class info [ {1} ]", new Object[]{this.getHashText(), delayedClassInfo.getHashText()});
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Delayed cache size [ {1} ]", new Object[]{this.getHashText(), this.delayedClassInfos.size()});
        }
        DelayedClassInfoImpl delayedClassInfoImpl = delayedClassInfo;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            delayedClassInfoImpl = delayedClassInfoImpl;
            logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "basicPutDelayedClassInfo", delayedClassInfoImpl);
        }
        return delayedClassInfoImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected NonDelayedClassInfoImpl associate(DelayedClassInfoImpl delayedClassInfo) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "associate", new Object[]{delayedClassInfo});
        }
        String methodName = "associate";
        NonDelayedClassInfoImpl nonDelayedClassInfo = this.basicGetClassInfo(delayedClassInfo.getName());
        if (nonDelayedClassInfo != null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Attaching delayed [ {1} ] to non-delayed [ {2} ]", new Object[]{this.getHashText(), delayedClassInfo.getHashText(), nonDelayedClassInfo.getHashText()});
            }
            delayedClassInfo.setClassInfo(nonDelayedClassInfo);
            nonDelayedClassInfo.setDelayedClassInfo(delayedClassInfo);
            NonDelayedClassInfoImpl nonDelayedClassInfoImpl = nonDelayedClassInfo;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                nonDelayedClassInfoImpl = nonDelayedClassInfoImpl;
                logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "associate", nonDelayedClassInfoImpl);
            }
            return nonDelayedClassInfoImpl;
        }
        NonDelayedClassInfoImpl nonDelayedClassInfoImpl = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            nonDelayedClassInfoImpl = nonDelayedClassInfoImpl;
            logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "associate", nonDelayedClassInfoImpl);
        }
        return nonDelayedClassInfoImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected ClassInfoImpl associate(NonDelayedClassInfoImpl nonDelayedClassInfo) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "associate", new Object[]{nonDelayedClassInfo});
        }
        String methodName = "associate(NonDelayedClassInfo)";
        DelayedClassInfoImpl delayedClassInfo = this.basicGetDelayedClassInfo(nonDelayedClassInfo.getName());
        if (delayedClassInfo != null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Attaching delayed [ {1} ] to non-delayed [ {2} ]", new Object[]{this.getHashText(), delayedClassInfo.getHashText(), nonDelayedClassInfo.getHashText()});
            }
            delayedClassInfo.setClassInfo(nonDelayedClassInfo);
            nonDelayedClassInfo.setDelayedClassInfo(delayedClassInfo);
            DelayedClassInfoImpl delayedClassInfoImpl = delayedClassInfo;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                delayedClassInfoImpl = delayedClassInfoImpl;
                logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "associate", delayedClassInfoImpl);
            }
            return delayedClassInfoImpl;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] No delayed available for non-delayed [ {1} ]", new Object[]{this.getHashText(), nonDelayedClassInfo.getHashText()});
        }
        ClassInfoImpl classInfoImpl = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            classInfoImpl = classInfoImpl;
            logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "associate", classInfoImpl);
        }
        return classInfoImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected NonDelayedClassInfoImpl basicGetJavaClassInfo(String name) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "basicGetJavaClassInfo", new Object[]{name});
        }
        NonDelayedClassInfoImpl nonDelayedClassInfoImpl = this.javaClassInfos.get(name);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            nonDelayedClassInfoImpl = nonDelayedClassInfoImpl;
            logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "basicGetJavaClassInfo", nonDelayedClassInfoImpl);
        }
        return nonDelayedClassInfoImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean basicPutJavaClassInfo(NonDelayedClassInfoImpl classInfo) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "basicPutJavaClassInfo", new Object[]{classInfo});
        }
        String methodName = "basicPutJavaClassInfo";
        String classInfoName = classInfo.getName();
        NonDelayedClassInfoImpl extantClassInfo = this.javaClassInfos.get(classInfoName);
        if (extantClassInfo == null) {
            this.javaClassInfos.put(classInfoName, classInfo);
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Add of [ {1} ] increases java cache to [ {2} ]", new Object[]{this.getHashText(), classInfo.getHashText(), this.javaClassInfos.size()});
            }
            boolean bl = true;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "basicPutJavaClassInfo", bl);
            }
            return bl;
        }
        if (extantClassInfo != classInfo) {
            logger.logp(Level.WARNING, CLASS_NAME, methodName, "[ {0} ] ANNO_CLASSINFO_EXISTS1 [ {1} ] [ {2} ]", new Object[]{this.getHashText(), classInfo.getHashText(), extantClassInfo.getHashText()});
        } else {
            logger.logp(Level.WARNING, CLASS_NAME, methodName, "[ {0} ] ANNO_CLASSINFO_EXISTS2 [ {2} ]", new Object[]{this.getHashText(), classInfo.getHashText()});
        }
        boolean bl = false;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "basicPutJavaClassInfo", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected NonDelayedClassInfoImpl basicGetAnnotatedClassInfo(String name) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "basicGetAnnotatedClassInfo", new Object[]{name});
        }
        NonDelayedClassInfoImpl nonDelayedClassInfoImpl = this.annotatedClassInfos.get(name);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            nonDelayedClassInfoImpl = nonDelayedClassInfoImpl;
            logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "basicGetAnnotatedClassInfo", nonDelayedClassInfoImpl);
        }
        return nonDelayedClassInfoImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean basicPutAnnotatedClassInfo(NonDelayedClassInfoImpl classInfo) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "basicPutAnnotatedClassInfo", new Object[]{classInfo});
        }
        String methodName = "basicPutAnnotatedClassInfo";
        String classInfoName = classInfo.getName();
        NonDelayedClassInfoImpl extantClassInfo = this.annotatedClassInfos.get(classInfoName);
        if (extantClassInfo == null) {
            this.annotatedClassInfos.put(classInfoName, classInfo);
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Add of [ {1} ] increases annotated cache to [ {2} ]", new Object[]{this.getHashText(), classInfo.getHashText(), this.annotatedClassInfos.size()});
            }
            boolean bl = true;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "basicPutAnnotatedClassInfo", bl);
            }
            return bl;
        }
        if (extantClassInfo != classInfo) {
            logger.logp(Level.WARNING, CLASS_NAME, methodName, "[ {0} ] ANNO_CLASSINFO_EXISTS3 [ {1} ] [ {2} ]", new Object[]{this.getHashText(), classInfo.getHashText(), extantClassInfo.getHashText()});
        } else {
            logger.logp(Level.WARNING, CLASS_NAME, methodName, "[ {0} ] ANNO_CLASSINFO_EXISTS4 [ {1} ]", new Object[]{this.getHashText(), classInfo.getHashText()});
        }
        boolean bl = false;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "basicPutAnnotatedClassInfo", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected NonDelayedClassInfoImpl basicGetClassInfo(String name) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "basicGetClassInfo", new Object[]{name});
        }
        if (this.firstClassInfo != null && name.equals(this.firstClassInfo.getName())) {
            NonDelayedClassInfoImpl nonDelayedClassInfoImpl = this.firstClassInfo;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                nonDelayedClassInfoImpl = nonDelayedClassInfoImpl;
                logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "basicGetClassInfo", nonDelayedClassInfoImpl);
            }
            return nonDelayedClassInfoImpl;
        }
        NonDelayedClassInfoImpl nonDelayedClassInfoImpl = this.classInfos.get(name);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            nonDelayedClassInfoImpl = nonDelayedClassInfoImpl;
            logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "basicGetClassInfo", nonDelayedClassInfoImpl);
        }
        return nonDelayedClassInfoImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean basicPutClassInfo(NonDelayedClassInfoImpl classInfo) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "basicPutClassInfo", new Object[]{classInfo});
        }
        String methodName = "basicPutClassInfo";
        String classInfoName = classInfo.getName();
        NonDelayedClassInfoImpl extantClassInfo = this.classInfos.get(classInfoName);
        if (extantClassInfo == null) {
            this.classInfos.put(classInfoName, classInfo);
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Add of [ {1} ] increases class cache to [ {2} ]", new Object[]{this.getHashText(), classInfo.getHashText(), this.classInfos.size()});
            }
            boolean bl = true;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "basicPutClassInfo", bl);
            }
            return bl;
        }
        if (extantClassInfo != classInfo) {
            logger.logp(Level.WARNING, CLASS_NAME, methodName, "[ {0} ] ANNO_CLASSINFO_EXISTS1 [ {1} ] [ {2} ]", new Object[]{this.getHashText(), classInfo.getHashText(), extantClassInfo.getHashText()});
        } else {
            logger.logp(Level.WARNING, CLASS_NAME, methodName, "[ {0} ] ANNO_CLASSINFO_EXISTS2 [ {2} ]", new Object[]{this.getHashText(), classInfo.getHashText()});
        }
        boolean bl = false;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "basicPutClassInfo", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected NonDelayedClassInfoImpl createClassInfo(String name, String superName, int access, String[] interfaces) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "createClassInfo", new Object[]{name, superName, access, interfaces});
        }
        NonDelayedClassInfoImpl nonDelayedClassInfoImpl = new NonDelayedClassInfoImpl(name, superName, access, interfaces, this.getInfoStore());
        if (logger != null && logger.isLoggable(Level.FINER)) {
            nonDelayedClassInfoImpl = nonDelayedClassInfoImpl;
            logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "createClassInfo", nonDelayedClassInfoImpl);
        }
        return nonDelayedClassInfoImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean addClassInfo(NonDelayedClassInfoImpl classInfo) {
        boolean didAdd;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "addClassInfo", new Object[]{classInfo});
        }
        if (classInfo.isJavaClass()) {
            didAdd = this.basicPutJavaClassInfo(classInfo);
        } else if (classInfo.isAnnotationPresent() || classInfo.isFieldAnnotationPresent() || classInfo.isMethodAnnotationPresent()) {
            didAdd = this.basicPutAnnotatedClassInfo(classInfo);
        } else {
            didAdd = this.basicPutClassInfo(classInfo);
            if (didAdd) {
                this.addAsFirst(classInfo);
            }
        }
        if (didAdd) {
            ClassInfoImpl delayedClassInfo = this.associate(classInfo);
            this.discardRef(delayedClassInfo);
        }
        boolean bl = didAdd;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "addClassInfo", bl);
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public NonDelayedClassInfoImpl resolveClassInfo(String name) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "resolveClassInfo", new Object[]{name});
        }
        String methodName = "resolveClassInfo";
        NonDelayedClassInfoImpl cachedClassInfo = this.basicGetClassInfo(name);
        if (cachedClassInfo != null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] ENTER / RETURN [ {1} ] - cached", new Object[]{this.getHashText(), cachedClassInfo.getHashText()});
            }
            NonDelayedClassInfoImpl nonDelayedClassInfoImpl = cachedClassInfo;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                nonDelayedClassInfoImpl = nonDelayedClassInfoImpl;
                logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "resolveClassInfo", nonDelayedClassInfoImpl);
            }
            return nonDelayedClassInfoImpl;
        }
        String useHashText = logger.isLoggable(Level.FINER) ? this.getHashText() : null;
        NonDelayedClassInfoImpl javaClassInfo = this.basicGetJavaClassInfo(name);
        if (javaClassInfo != null) {
            if (useHashText != null) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] RETURN [ {1} ] java class", new Object[]{useHashText, javaClassInfo.getHashText()});
            }
            NonDelayedClassInfoImpl nonDelayedClassInfoImpl = javaClassInfo;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                nonDelayedClassInfoImpl = nonDelayedClassInfoImpl;
                logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "resolveClassInfo", nonDelayedClassInfoImpl);
            }
            return nonDelayedClassInfoImpl;
        }
        NonDelayedClassInfoImpl annotatedClassInfo = this.basicGetAnnotatedClassInfo(name);
        if (annotatedClassInfo != null) {
            if (useHashText != null) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] RETURN [ {1} ] annotated class", new Object[]{useHashText, annotatedClassInfo.getHashText()});
            }
            NonDelayedClassInfoImpl nonDelayedClassInfoImpl = annotatedClassInfo;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                nonDelayedClassInfoImpl = nonDelayedClassInfoImpl;
                logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "resolveClassInfo", nonDelayedClassInfoImpl);
            }
            return nonDelayedClassInfoImpl;
        }
        if (useHashText != null) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "ENTRY [ {0} ] Class [ {1} ] ", new Object[]{useHashText, name});
        }
        try {
            this.scanClass(name);
        }
        catch (InfoStoreException infoStoreException) {
            void e;
            FFDCFilter.processException((Throwable)infoStoreException, (String)"com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", (String)"1142", (Object)this, (Object[])new Object[]{name});
            logger.logp(Level.WARNING, CLASS_NAME, methodName, "ANNO_CLASSINFO_SCAN_EXCEPTION", new Object[]{this.getHashText(), name, e.getMessage(), e.getCause() == null ? e : e.getCause()});
            logger.logp(Level.WARNING, CLASS_NAME, methodName, "Scan failure", (Throwable)e);
            if (useHashText != null) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] RETURN [ null ]; class scan failed with an exception", new Object[]{useHashText, name});
            }
            NonDelayedClassInfoImpl nonDelayedClassInfoImpl = null;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                nonDelayedClassInfoImpl = nonDelayedClassInfoImpl;
                logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "resolveClassInfo", nonDelayedClassInfoImpl);
            }
            return nonDelayedClassInfoImpl;
        }
        cachedClassInfo = this.basicGetClassInfo(name);
        if (cachedClassInfo != null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] ENTER / RETURN [ {1} ] - newly cached", new Object[]{this.getHashText(), cachedClassInfo.getHashText()});
            }
            NonDelayedClassInfoImpl nonDelayedClassInfoImpl = cachedClassInfo;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                nonDelayedClassInfoImpl = nonDelayedClassInfoImpl;
                logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "resolveClassInfo", nonDelayedClassInfoImpl);
            }
            return nonDelayedClassInfoImpl;
        }
        javaClassInfo = this.basicGetJavaClassInfo(name);
        if (javaClassInfo != null) {
            if (useHashText != null) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] RETURN [ {1} ] newly added java class", new Object[]{useHashText, javaClassInfo.getHashText()});
            }
            NonDelayedClassInfoImpl nonDelayedClassInfoImpl = javaClassInfo;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                nonDelayedClassInfoImpl = nonDelayedClassInfoImpl;
                logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "resolveClassInfo", nonDelayedClassInfoImpl);
            }
            return nonDelayedClassInfoImpl;
        }
        annotatedClassInfo = this.basicGetAnnotatedClassInfo(name);
        if (annotatedClassInfo != null) {
            if (useHashText != null) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] RETURN [ {1} ] new added annotated class", new Object[]{useHashText, annotatedClassInfo.getHashText()});
            }
            NonDelayedClassInfoImpl nonDelayedClassInfoImpl = annotatedClassInfo;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                nonDelayedClassInfoImpl = nonDelayedClassInfoImpl;
                logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "resolveClassInfo", nonDelayedClassInfoImpl);
            }
            return nonDelayedClassInfoImpl;
        }
        if (useHashText != null) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] RETURN [ null ] for class which was not found", new Object[]{useHashText, name});
        }
        NonDelayedClassInfoImpl nonDelayedClassInfoImpl = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            nonDelayedClassInfoImpl = nonDelayedClassInfoImpl;
            logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "resolveClassInfo", nonDelayedClassInfoImpl);
        }
        return nonDelayedClassInfoImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void addAsFirst(NonDelayedClassInfoImpl classInfo) {
        String useClassHashText;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "addAsFirst", new Object[]{classInfo});
        }
        String methodName = "addAsFirst";
        boolean doLog = logger.isLoggable(Level.FINER);
        String useHashText = doLog ? this.getHashText() : null;
        String string = useClassHashText = doLog ? classInfo.getHashText() : null;
        if (doLog) {
            this.logLinks(methodName, classInfo);
        }
        if (this.firstClassInfo == null) {
            if (doLog) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Adding [ {1} ] to empty", new Object[]{useHashText, useClassHashText});
            }
            this.firstClassInfo = classInfo;
            this.lastClassInfo = classInfo;
        } else if (this.firstClassInfo == this.lastClassInfo) {
            if (doLog) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Adding [ {1} ] to singleton [ {2} ]", new Object[]{useHashText, useClassHashText, this.firstClassInfo.getHashText()});
            }
            this.firstClassInfo = classInfo;
            this.firstClassInfo.setNextClassInfo(this.lastClassInfo);
            this.lastClassInfo.setPriorClassInfo(classInfo);
        } else {
            if (doLog) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Adding [ {1} ] to multitude [ {2} ]", new Object[]{useHashText, useClassHashText, this.firstClassInfo.getHashText()});
            }
            classInfo.setNextClassInfo(this.firstClassInfo);
            this.firstClassInfo.setPriorClassInfo(classInfo);
            this.firstClassInfo = classInfo;
            if (this.classInfos.size() > classInfoCacheLimit) {
                DelayedClassInfoImpl delayedClassInfo;
                NonDelayedClassInfoImpl oldLastClassInfo = this.lastClassInfo;
                String lastClassName = this.lastClassInfo.getName();
                this.classInfos.remove(lastClassName);
                this.discardRef(lastClassName);
                this.lastClassInfo = oldLastClassInfo.getPriorClassInfo();
                this.lastClassInfo.setNextClassInfo(null);
                oldLastClassInfo.setPriorClassInfo(null);
                if (doLog) {
                    logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] new last [ {1} ] displaces [ {2} ]", new Object[]{useHashText, this.lastClassInfo.getHashText(), oldLastClassInfo.getHashText()});
                }
                if ((delayedClassInfo = oldLastClassInfo.getDelayedClassInfo()) != null) {
                    if (doLog) {
                        logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Clearing link on displaced [ {1} ]", new Object[]{useHashText, oldLastClassInfo.getHashText()});
                    }
                    delayedClassInfo.setClassInfo(null);
                    oldLastClassInfo.setDelayedClassInfo(null);
                }
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "addAsFirst");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void makeFirst(NonDelayedClassInfoImpl classInfo) {
        String useClassHashText;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "makeFirst", new Object[]{classInfo});
        }
        String methodName = "makeFirst";
        boolean doLog = logger.isLoggable(Level.FINER);
        String useHashText = doLog ? this.getHashText() : null;
        String string = useClassHashText = doLog ? classInfo.getHashText() : null;
        if (doLog) {
            this.logLinks(methodName, classInfo);
        }
        if (classInfo == this.firstClassInfo) {
            if (doLog) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Already first [ {1} ]", new Object[]{useHashText, useClassHashText});
            }
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "makeFirst");
            }
            return;
        }
        if (classInfo == this.lastClassInfo) {
            if (doLog) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Moving from last [ {1} ]", new Object[]{useHashText, useClassHashText});
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Old first [ {1} ]", new Object[]{useHashText, this.firstClassInfo.getHashText()});
            }
            this.lastClassInfo = classInfo.getPriorClassInfo();
            this.lastClassInfo.setNextClassInfo(null);
            if (doLog) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] New last [ {1} ]", new Object[]{useHashText, this.lastClassInfo.getHashText()});
            }
            this.firstClassInfo.setPriorClassInfo(classInfo);
            classInfo.setPriorClassInfo(null);
            classInfo.setNextClassInfo(this.firstClassInfo);
            this.firstClassInfo = classInfo;
        } else {
            if (doLog) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Moving from middle [ {1} ]", new Object[]{useHashText, useClassHashText});
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Old first [ {1} ]", new Object[]{useHashText, this.firstClassInfo.getHashText()});
            }
            NonDelayedClassInfoImpl currentPrior = classInfo.getPriorClassInfo();
            NonDelayedClassInfoImpl currentNext = classInfo.getNextClassInfo();
            currentPrior.setNextClassInfo(currentNext);
            currentNext.setPriorClassInfo(currentPrior);
            this.firstClassInfo.setPriorClassInfo(classInfo);
            classInfo.setNextClassInfo(this.firstClassInfo);
            classInfo.setPriorClassInfo(null);
            this.firstClassInfo = classInfo;
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "makeFirst");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void removeAsDelayable(NonDelayedClassInfoImpl classInfo) {
        String useClassHashText;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "removeAsDelayable", new Object[]{classInfo});
        }
        String methodName = "removeAsDelayable";
        boolean doLog = logger.isLoggable(Level.FINER);
        String useHashText = doLog ? this.getHashText() : null;
        String string = useClassHashText = doLog ? classInfo.getHashText() : null;
        if (doLog) {
            this.logLinks(methodName, classInfo);
        }
        if (this.firstClassInfo == null) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Ignoring remove request; no linked classes [ {1} ]", new Object[]{useHashText, useClassHashText});
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "removeAsDelayable");
            }
            return;
        }
        NonDelayedClassInfoImpl currentPrior = classInfo.getPriorClassInfo();
        NonDelayedClassInfoImpl currentNext = classInfo.getNextClassInfo();
        if (this.firstClassInfo != classInfo && currentPrior == null && currentNext == null) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Ignoring remove request; not yet linked [ {1} ]", new Object[]{useHashText, useClassHashText});
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "removeAsDelayable");
            }
            return;
        }
        if (currentPrior != null) {
            currentPrior.setNextClassInfo(currentNext);
        } else {
            this.firstClassInfo = currentNext;
        }
        if (currentNext != null) {
            currentNext.setPriorClassInfo(currentPrior);
        } else {
            this.lastClassInfo = currentPrior;
        }
        classInfo.setPriorClassInfo(null);
        classInfo.setNextClassInfo(null);
        this.classInfos.remove(classInfo.getName());
        this.basicPutAnnotatedClassInfo(classInfo);
        if (doLog) {
            if (currentPrior == null && currentNext == null) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Removing as singleton [ {1} ]", new Object[]{useHashText, useClassHashText});
            } else if (currentPrior == null && currentNext != null) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Removing as first [ {1} ]", new Object[]{useHashText, useClassHashText});
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] New first [ {1} ]", new Object[]{useHashText, currentNext.getHashText()});
            } else if (currentPrior != null && currentNext == null) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Removing as last [ {1} ]", new Object[]{useHashText, useClassHashText});
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] New last [ {1} ]", new Object[]{useHashText, currentPrior.getHashText()});
            } else if (currentPrior != null && currentNext != null) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Removing from middle [ {1} ]", new Object[]{useHashText, useClassHashText});
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Old prior [ {1} ]", new Object[]{useHashText, currentPrior.getHashText()});
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Old next [ {1} ]", new Object[]{useHashText, currentNext.getHashText()});
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "removeAsDelayable");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void logLinks(String methodName, NonDelayedClassInfoImpl classInfo) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "logLinks", new Object[]{methodName, classInfo});
        }
        if (classInfo.getNextClassInfo() != null) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Class [ {1} ] Next [ {2} ]", new Object[]{this.getHashText(), classInfo.getHashText(), classInfo.getNextClassInfo().getHashText()});
        }
        if (classInfo.getPriorClassInfo() != null) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Class [ {1} ] Prior [ {2} ]", new Object[]{this.getHashText(), classInfo.getHashText(), classInfo.getPriorClassInfo().getHashText()});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "logLinks");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void recordAccess(NonDelayedClassInfoImpl classInfo) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "recordAccess", new Object[]{classInfo});
        }
        this.makeFirst(classInfo);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "recordAccess");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void log(Logger useLogger) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "log", new Object[]{useLogger});
        }
        String methodName = "log";
        if (!useLogger.isLoggable(Level.FINER)) {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "log");
            }
            return;
        }
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "BEGIN STATE [ {0} ]", this.getHashText());
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "  Info Store [ {0} ]", this.getInfoStore().getHashText());
        this.log_internMaps(useLogger);
        this.log_packages(useLogger);
        this.log_primitiveClasses(useLogger);
        this.log_delayedClasses(useLogger);
        this.log_javaClasses(useLogger);
        this.log_annotatedClasses(useLogger);
        this.log_classes(useLogger);
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "END STATE [ {0} ]", this.getHashText());
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "log");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void log_internMaps(Logger useLogger) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "log_internMaps", new Object[]{useLogger});
        }
        String methodName = "log_internMaps";
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "BEGIN Intern Maps:");
        this.getDescriptionInternMap().log(useLogger);
        this.getPackageNameInternMap().log(useLogger);
        this.getClassNameInternMap().log(useLogger);
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "END Intern Maps:");
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "log_internMaps");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void log_packages(Logger useLogger) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "log_packages", new Object[]{useLogger});
        }
        String methodName = "log_packages";
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "BEGIN Packages:");
        for (PackageInfoImpl packageInfo : this.packageInfos.values()) {
            packageInfo.log(useLogger);
        }
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "END Packages");
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "log_packages");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void log_classes(Logger useLogger) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "log_classes", new Object[]{useLogger});
        }
        String methodName = "log_classes";
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "BEGIN Classes:");
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "  First Class [ {0} ]:", this.firstClassInfo == null ? null : this.firstClassInfo.getHashText());
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "  Last Class [ {0} ]:", this.lastClassInfo == null ? null : this.lastClassInfo.getHashText());
        for (NonDelayedClassInfoImpl classInfo : this.classInfos.values()) {
            classInfo.log(useLogger);
        }
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "END Classes");
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "log_classes");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void log_annotatedClasses(Logger useLogger) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "log_annotatedClasses", new Object[]{useLogger});
        }
        String methodName = "log_annotatedClasses";
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "BEGIN Annotated Classes:");
        for (NonDelayedClassInfoImpl annotatedClassInfo : this.annotatedClassInfos.values()) {
            annotatedClassInfo.log(useLogger);
        }
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "END Annotated Classes");
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "log_annotatedClasses");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void log_javaClasses(Logger useLogger) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "log_javaClasses", new Object[]{useLogger});
        }
        String methodName = "log_javaClasses";
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "BEGIN Java Classes:");
        for (NonDelayedClassInfoImpl javaClassInfo : this.javaClassInfos.values()) {
            javaClassInfo.log(useLogger);
        }
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "END Java Classes");
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "log_javaClasses");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void log_delayedClasses(Logger useLogger) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "log_delayedClasses", new Object[]{useLogger});
        }
        String methodName = "log_delayedClasses";
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "BEGIN Delayed Classes:");
        for (ClassInfoImpl classInfoImpl : this.delayedClassInfos.values()) {
            classInfoImpl.log(useLogger);
        }
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "END Delayed Classes");
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "log_delayedClasses");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void log_primitiveClasses(Logger useLogger) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "log_primitiveClasses", new Object[]{useLogger});
        }
        String methodName = "log_primitiveClasses";
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "BEGIN Primitive Classes:");
        for (PrimitiveClassInfoImpl primitiveClassInfo : this.primitiveClassInfos.values()) {
            primitiveClassInfo.log(useLogger);
        }
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "END Primitive Classes");
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "log_primitiveClasses");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void log(TraceComponent useLogger) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "log", new Object[]{useLogger});
        }
        Tr.debug((TraceComponent)useLogger, (String)MessageFormat.format("BEGIN STATE [ {0} ]", this.getHashText()), (Object[])new Object[0]);
        Tr.debug((TraceComponent)useLogger, (String)MessageFormat.format("  Info Store [ {0} ]", this.getInfoStore().getHashText()), (Object[])new Object[0]);
        this.log_internMaps(useLogger);
        this.log_packages(useLogger);
        this.log_primitiveClasses(useLogger);
        this.log_delayedClasses(useLogger);
        this.log_javaClasses(useLogger);
        this.log_annotatedClasses(useLogger);
        this.log_classes(useLogger);
        Tr.debug((TraceComponent)useLogger, (String)MessageFormat.format("END STATE [ {0} ]", this.getHashText()), (Object[])new Object[0]);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "log");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void log_internMaps(TraceComponent useLogger) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "log_internMaps", new Object[]{useLogger});
        }
        Tr.debug((TraceComponent)useLogger, (String)"BEGIN Intern Maps:", (Object[])new Object[0]);
        this.getDescriptionInternMap().log(useLogger);
        this.getPackageNameInternMap().log(useLogger);
        this.getClassNameInternMap().log(useLogger);
        Tr.debug((TraceComponent)useLogger, (String)"END Intern Maps:", (Object[])new Object[0]);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "log_internMaps");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void log_packages(TraceComponent useLogger) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "log_packages", new Object[]{useLogger});
        }
        Tr.debug((TraceComponent)useLogger, (String)"BEGIN Packages:", (Object[])new Object[0]);
        for (PackageInfoImpl packageInfo : this.packageInfos.values()) {
            packageInfo.log(useLogger);
        }
        Tr.debug((TraceComponent)useLogger, (String)"END Packages", (Object[])new Object[0]);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "log_packages");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void log_classes(TraceComponent useLogger) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "log_classes", new Object[]{useLogger});
        }
        Tr.debug((TraceComponent)useLogger, (String)"BEGIN Classes:", (Object[])new Object[0]);
        Tr.debug((TraceComponent)useLogger, (String)MessageFormat.format("  First Class [ {0} ]:", this.firstClassInfo == null ? null : this.firstClassInfo.getHashText()), (Object[])new Object[0]);
        Tr.debug((TraceComponent)useLogger, (String)MessageFormat.format("  Last Class [ {0} ]:", this.lastClassInfo == null ? null : this.lastClassInfo.getHashText()), (Object[])new Object[0]);
        for (NonDelayedClassInfoImpl classInfo : this.classInfos.values()) {
            classInfo.log(useLogger);
        }
        Tr.debug((TraceComponent)useLogger, (String)"END Classes", (Object[])new Object[0]);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "log_classes");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void log_annotatedClasses(TraceComponent useLogger) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "log_annotatedClasses", new Object[]{useLogger});
        }
        Tr.debug((TraceComponent)useLogger, (String)"BEGIN Annotated Classes:", (Object[])new Object[0]);
        for (NonDelayedClassInfoImpl annotatedClassInfo : this.annotatedClassInfos.values()) {
            annotatedClassInfo.log(useLogger);
        }
        Tr.debug((TraceComponent)useLogger, (String)"END Annotated Classes", (Object[])new Object[0]);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "log_annotatedClasses");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void log_javaClasses(TraceComponent useLogger) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "log_javaClasses", new Object[]{useLogger});
        }
        Tr.debug((TraceComponent)useLogger, (String)"BEGIN Java Classes:", (Object[])new Object[0]);
        for (NonDelayedClassInfoImpl javaClassInfo : this.javaClassInfos.values()) {
            javaClassInfo.log(useLogger);
        }
        Tr.debug((TraceComponent)useLogger, (String)"END Java Classes", (Object[])new Object[0]);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "log_javaClasses");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void log_delayedClasses(TraceComponent useLogger) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "log_delayedClasses", new Object[]{useLogger});
        }
        Tr.debug((TraceComponent)useLogger, (String)"BEGIN Delayed Classes:", (Object[])new Object[0]);
        for (ClassInfoImpl classInfoImpl : this.delayedClassInfos.values()) {
            classInfoImpl.log(useLogger);
        }
        Tr.debug((TraceComponent)useLogger, (String)"END Delayed Classes", (Object[])new Object[0]);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "log_delayedClasses");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void log_primitiveClasses(TraceComponent useLogger) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "log_primitiveClasses", new Object[]{useLogger});
        }
        Tr.debug((TraceComponent)useLogger, (String)"BEGIN Primitive Classes:", (Object[])new Object[0]);
        for (PrimitiveClassInfoImpl primitiveClassInfo : this.primitiveClassInfos.values()) {
            primitiveClassInfo.log(useLogger);
        }
        Tr.debug((TraceComponent)useLogger, (String)"END Primitive Classes", (Object[])new Object[0]);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", "log_primitiveClasses");
        }
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    static {
        int useCacheLimit;
        logger = Logger.getLogger("com.ibm.ws.annocache.info");
        String methodName = "<static init>";
        String classInfoCacheSizeText = AccessController.doPrivileged(new PrivilegedAction<String>(){
            static final long serialVersionUID = -8035840265994283391L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public String run() {
                return System.getProperty(ClassInfoCacheImpl.CLASSINFO_CACHE_LIMIT_PROPERTY_NAME);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl$1", 1.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
            }
        });
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "Cache Property [ {0} ] and value [ {1} ]", new Object[]{CLASSINFO_CACHE_LIMIT_PROPERTY_NAME, classInfoCacheSizeText});
        }
        String scanLimitCase = "Default; No property";
        if (classInfoCacheSizeText == null) {
            useCacheLimit = 2000;
            scanLimitCase = "default; no property value";
        } else {
            try {
                useCacheLimit = Integer.valueOf(classInfoCacheSizeText);
                if (useCacheLimit < 100) {
                    useCacheLimit = 100;
                    scanLimitCase = "out of range; reassigned to minimum";
                } else if (useCacheLimit > 10000) {
                    useCacheLimit = 10000;
                    scanLimitCase = "out of range; reassigned to maximum";
                } else {
                    scanLimitCase = "in range; assigned from property";
                }
            }
            catch (NumberFormatException numberFormatException) {
                void nfe;
                FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl", (String)"819", null, (Object[])new Object[0]);
                useCacheLimit = 2000;
                scanLimitCase = "defaulted; non-valid integer value ( " + nfe.getMessage() + " )";
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "Setting class info cache size [ {0} ]: [ {1} ]", new Object[]{useCacheLimit, scanLimitCase});
        }
        classInfoCacheLimit = useCacheLimit;
    }
}

