/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdeparser;

import java.util.ArrayList;
import java.util.List;
import org.jboss.jdeparser.JClass;
import org.jboss.jdeparser.JDeclaration;
import org.jboss.jdeparser.JDeparser;
import org.jboss.jdeparser.JFormatter;
import org.jboss.jdeparser.JGenerifiable;
import org.jboss.jdeparser.JTypeVar;

abstract class JGenerifiableImpl
implements JGenerifiable,
JDeclaration {
    private List<JTypeVar> typeVariables = null;

    JGenerifiableImpl() {
    }

    protected abstract JDeparser owner();

    @Override
    public void declare(JFormatter f) {
        if (this.typeVariables != null) {
            f.p('<');
            for (int i = 0; i < this.typeVariables.size(); ++i) {
                if (i != 0) {
                    f.p(',');
                }
                f.d(this.typeVariables.get(i));
            }
            f.p('>');
        }
    }

    @Override
    public JTypeVar generify(String name) {
        JTypeVar v = new JTypeVar(this.owner(), name);
        if (this.typeVariables == null) {
            this.typeVariables = new ArrayList<JTypeVar>(3);
        }
        this.typeVariables.add(v);
        return v;
    }

    @Override
    public JTypeVar generify(String name, Class<?> bound) {
        return this.generify(name, this.owner().ref(bound));
    }

    @Override
    public JTypeVar generify(String name, JClass bound) {
        return this.generify(name).bound(bound);
    }

    @Override
    public JTypeVar[] typeParams() {
        if (this.typeVariables == null) {
            return JTypeVar.EMPTY_ARRAY;
        }
        return this.typeVariables.toArray(new JTypeVar[this.typeVariables.size()]);
    }
}

