/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.filter;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.servlet.error.ServletErrorReport;
import com.ibm.websphere.servlet.request.extended.IRequestExtended;
import com.ibm.ws.webcontainer.filter.FilterInstanceWrapper;
import com.ibm.ws.webcontainer.osgi.interceptor.RegisterRequestInterceptor;
import com.ibm.ws.webcontainer.servlet.H2Handler;
import com.ibm.ws.webcontainer.servlet.WsocHandler;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.wsspi.http.HttpInboundConnection;
import com.ibm.wsspi.webcontainer.RequestProcessor;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.servlet.IExtendedRequest;
import com.ibm.wsspi.webcontainer.util.FFDCWrapper;
import com.ibm.wsspi.webcontainer.util.ServletUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WebAppFilterChain
implements FilterChain {
    private ArrayList _filters = new ArrayList(5);
    private int _currentFilterIndex = -1;
    private int _numberOfFilters = 0;
    private RequestProcessor requestProcessor;
    private boolean _filtersDefined = false;
    protected static final Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer.filter");
    private static final String CLASS_NAME = "com.ibm.ws.webcontainer.filter.WebAppFilterChain";
    private WebApp webapp = null;

    public WebAppFilterChain() {
    }

    public WebAppFilterChain(WebApp webapp) {
        this.webapp = webapp;
    }

    public void doFilter(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "doFilter");
        }
        try {
            if (!this._filtersDefined) {
                this.invokeTarget(request, response);
            } else {
                ++this._currentFilterIndex;
                if (this._currentFilterIndex < this._numberOfFilters) {
                    FilterInstanceWrapper wrapper = (FilterInstanceWrapper)this._filters.get(this._currentFilterIndex);
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "doFilter", "enter filter [" + wrapper.getFilterName() + "] class [" + wrapper.getFilterInstance() + "] request [" + request + "] response [" + response + "]");
                    }
                    wrapper.doFilter(request, response, this);
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "doFilter", "exit filter [" + wrapper.getFilterName() + "]");
                    }
                } else {
                    this.invokeTarget(request, response);
                }
            }
        }
        catch (UnavailableException e) {
            throw e;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (ServletException e) {
            Throwable t = e.getCause();
            if (t != null && t instanceof FileNotFoundException) {
                logger.logp(Level.FINE, CLASS_NAME, "doFilter", "FileNotFound");
            } else if (!this.webapp.getDestroyed().booleanValue()) {
                FFDCWrapper.processException(e, "com.ibm.ws.webcontainer.filter.WebAppFilterChain.doFilter", "82", this);
            } else if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "doFilter", "Can not invoke filter because application is destroyed", e);
            }
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.exiting(CLASS_NAME, "doFilter");
            }
            throw e;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Throwable th) {
            FFDCWrapper.processException(th, "com.ibm.ws.webcontainer.filter.WebAppFilterChain.doFilter", "89", this);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.exiting(CLASS_NAME, "doFilter");
            }
            throw new ServletErrorReport(th);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "doFilter");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeTarget(ServletRequest request, ServletResponse response) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "invokeTarget", "request [" + request + "] response [" + response + "]");
        }
        try {
            if (this.requestProcessor != null) {
                HttpServletResponse httpResponse;
                HttpServletRequest httpRequest = ServletUtil.unwrapRequest(request, HttpServletRequest.class);
                if (!RegisterRequestInterceptor.notifyRequestInterceptors("AfterFilters", httpRequest, httpResponse = (HttpServletResponse)ServletUtil.unwrapResponse(response, HttpServletResponse.class))) {
                    boolean handled = false;
                    WsocHandler wsocHandler = ((com.ibm.ws.webcontainer.osgi.webapp.WebApp)this.webapp).getWebSocketHandler();
                    H2Handler h2Handler = ((com.ibm.ws.webcontainer.osgi.webapp.WebApp)this.webapp).getH2Handler();
                    if (wsocHandler != null && wsocHandler.isWsocRequest(request)) {
                        wsocHandler.handleRequest(httpRequest, httpResponse);
                        handled = true;
                    }
                    if (!handled) {
                        IExtendedRequest srtReq;
                        IRequestExtended iReq;
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "invokeTarget", " looking at H2 upgrade");
                        }
                        HttpInboundConnection httpInboundConnection = null;
                        if (request instanceof IExtendedRequest && (iReq = (IRequestExtended)(srtReq = (IExtendedRequest)request).getIRequest()) != null) {
                            httpInboundConnection = iReq.getHttpInboundConnection();
                            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                logger.logp(Level.FINE, CLASS_NAME, "invokeTarget", "HttpInboundConnection: " + httpInboundConnection);
                            }
                        }
                        if (h2Handler != null && httpInboundConnection != null && request instanceof HttpServletRequest) {
                            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                logger.logp(Level.FINE, CLASS_NAME, "invokeTarget", "looking at isH2Request");
                            }
                            if (h2Handler.isH2Request(httpInboundConnection, request)) {
                                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                    logger.logp(Level.FINE, CLASS_NAME, "invokeTarget", "upgrading to H2");
                                }
                                h2Handler.handleRequest(httpInboundConnection, httpRequest, httpResponse);
                            }
                        }
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "invokeTarget", "calling requestProcessor.handleRequest");
                        }
                        this.requestProcessor.handleRequest(request, response);
                    }
                }
            } else {
                this.webapp.finishedFiltersWithNullTarget(request, response, this.requestProcessor);
            }
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.exiting(CLASS_NAME, "invokeTarget");
            }
        }
    }

    public void addFilter(FilterInstanceWrapper fiw) {
        this._filtersDefined = true;
        ++this._numberOfFilters;
        this._filters.add(fiw);
    }

    public void setRequestProcessor(RequestProcessor requestProcessor) {
        this.requestProcessor = requestProcessor;
    }
}

