/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.webcontainer.util;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.util.WSUtil;
import com.ibm.ws.webcontainer.WebContainer;
import com.ibm.wsspi.webcontainer.WCCustomProperties;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileSystem {
    protected static Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.wsspi.webcontainer.util");
    private static final String CLASS_NAME = "com.ibm.wsspi.webcontainer.util.FileSystem";
    private static boolean tolerateSymLinks = Boolean.valueOf(WebContainer.getWebContainerProperties().getProperty("com.ibm.ws.webcontainer.toleratesymboliclinks"));
    private static int symLinkCacheSize;
    private static Map foundMatches;
    private static final String MAP_VALUE = "";

    public static boolean uriCaseCheck(File file, String matchString) throws IOException {
        return FileSystem.uriCaseCheck(file, matchString, true, true);
    }

    public static boolean uriCaseCheck(File file, String matchString, boolean checkWEBINF) throws IOException {
        return FileSystem.uriCaseCheck(file, matchString, checkWEBINF, true);
    }

    public static boolean uriCaseCheck(File file, String matchString, boolean checkWEBINF, boolean checkMETAINF) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "uriCaseCheck", "file canpath=" + file.getCanonicalPath() + ", matchString=" + matchString + ", checkWEBINF=" + checkWEBINF);
        }
        boolean result = false;
        matchString = WSUtil.resolveURI((String)matchString);
        String upperMatchString = new String(matchString.toUpperCase());
        if (checkWEBINF && (upperMatchString.startsWith("/WEB-INF/") || upperMatchString.equals("/WEB-INF"))) {
            result = false;
        } else if (checkMETAINF && upperMatchString.startsWith("/META-INF/") || upperMatchString.equals("/META-INF")) {
            result = false;
        } else {
            matchString = matchString.replace('/', File.separatorChar);
            String canPath = file.getCanonicalPath();
            int matchStringLength = matchString.length();
            if (WCCustomProperties.TOLERATE_LOCALE_MISMATCH_FOR_SERVING_FILES) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "uriCaseCheck", " tolerateLocaleMismatchForServingFiles Custom property is set");
                }
                result = true;
            } else if (canPath.regionMatches(canPath.length() - matchStringLength, matchString, 0, matchStringLength)) {
                result = true;
            } else if (tolerateSymLinks) {
                if (foundMatches != null && foundMatches.get(matchString) != null) {
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "uriCaseCheck", " : found in Cache");
                    }
                    result = true;
                } else {
                    File appRoot;
                    String absPath = file.getAbsolutePath();
                    String appRootDir = absPath.substring(0, absPath.length() - matchStringLength);
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "uriCaseCheck", "appRoot dir=" + appRootDir);
                    }
                    if (FileSystem.walkPath(appRoot = new File(appRootDir), matchString)) {
                        if (foundMatches != null) {
                            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                logger.logp(Level.FINE, CLASS_NAME, "uriCaseCheck", "add to Cache :" + matchString + ", Cache size: current = " + foundMatches.size() + ", max = " + symLinkCacheSize);
                            }
                            foundMatches.put(matchString, MAP_VALUE);
                        }
                        result = true;
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "uriCaseCheck : result=" + result);
        }
        return result;
    }

    public static boolean walkPath(File appRoot, String relativePath) throws IOException {
        String[] relativePathElements = relativePath.replace(File.separatorChar, '/').split("/");
        File currentPath = new File(appRoot.getCanonicalPath());
        for (int i = 0; i < relativePathElements.length; ++i) {
            if (relativePathElements[i].equals(MAP_VALUE)) continue;
            String[] entries = currentPath.list(new StrictFileNameFilter(relativePathElements[i]));
            if (entries == null || entries.length != 1) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "uriCaseCheck", relativePathElements[i] + " not found.");
                }
                return false;
            }
            currentPath = new File(currentPath, relativePathElements[i]);
        }
        return true;
    }

    static {
        if (tolerateSymLinks) {
            symLinkCacheSize = Integer.valueOf(WebContainer.getWebContainerProperties().getProperty("com.ibm.ws.webcontainer.symboliclinkscachesize", "1000"));
            foundMatches = symLinkCacheSize > 0 ? Collections.synchronizedMap(new LRUCache(symLinkCacheSize)) : null;
        }
    }

    public static final class StrictFileNameFilter
    implements FilenameFilter {
        String fileName;

        StrictFileNameFilter(String fileName) {
            this.fileName = fileName;
        }

        @Override
        public boolean accept(File file, String name) {
            return name.equals(this.fileName);
        }
    }

    public static final class LRUCache
    extends LinkedHashMap {
        private int _maxEntries;

        public LRUCache(int maxEntries) {
            super(maxEntries, 0.75f, true);
            this._maxEntries = maxEntries;
        }

        protected boolean removeEldestEntry(Map.Entry oldest) {
            return this.size() > this._maxEntries;
        }
    }
}

