/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa.diagnostics.utils.encapsulation;

import com.ibm.ws.common.encoder.Base64Coder;
import com.ibm.ws.jpa.diagnostics.utils.encapsulation.CompressionType;
import com.ibm.ws.jpa.diagnostics.utils.encapsulation.xsd10.EncapsulatedDataType;
import com.ibm.ws.jpa.diagnostics.utils.encapsulation.xsd10.PropertiesType;
import com.ibm.ws.jpa.diagnostics.utils.encapsulation.xsd10.PropertyType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class EncapsulatedData {
    private final EncapsulatedDataType edt;
    private byte[] data = null;

    public static EncapsulatedData createEncapsulatedData(String name, String id, byte[] data) throws Exception {
        return EncapsulatedData.createEncapsulatedData(name, id, CompressionType.GZIP, "MD5", data);
    }

    public static EncapsulatedData createEncapsulatedData(String name, String id, CompressionType ct, String hashAlg, byte[] data) throws Exception {
        EncapsulatedDataType edt = new EncapsulatedDataType();
        EncapsulatedData ed = new EncapsulatedData(edt);
        ed.setId(id);
        ed.setName(name);
        ed.setCompressionType(ct);
        ed.setHashAlgorithm(hashAlg);
        ed.setData(data);
        return ed;
    }

    public static EncapsulatedData createEncapsulatedData(EncapsulatedDataType edt) {
        EncapsulatedData ed = new EncapsulatedData(edt);
        return ed;
    }

    public static EncapsulatedData readEncapsulatedData(InputStream is) throws Exception {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{EncapsulatedDataType.class});
        Unmarshaller um = jc.createUnmarshaller();
        EncapsulatedDataType edt = (EncapsulatedDataType)um.unmarshal(is);
        EncapsulatedData ed = new EncapsulatedData(edt);
        return ed;
    }

    private EncapsulatedData(EncapsulatedDataType edt) {
        this.edt = edt;
    }

    public String getId() {
        return this.edt.getId();
    }

    public void setId(String id) {
        this.edt.setId(id);
    }

    public String getName() {
        return this.edt.getName();
    }

    public void setName(String name) {
        this.edt.setName(name);
    }

    public CompressionType getCompressionType() {
        return CompressionType.fromString(this.edt.getCompression());
    }

    public void setCompressionType(CompressionType ct) {
        this.edt.setCompression(ct == null ? "NONE" : ct.toString());
    }

    public String getHashAlgorithm() {
        String alg = this.edt.getHashAlgorithm();
        if (alg == null) {
            return "MD5";
        }
        return alg;
    }

    public void setHashAlgorithm(String alg) {
        if (alg == null) {
            alg = "MD5";
        }
        this.edt.setHashAlgorithm(alg);
    }

    public String getHashValue() {
        return this.edt.getHashValue();
    }

    public void setData(byte[] data) throws Exception {
        if (data == null) {
            data = new byte[]{};
        }
        this.data = Arrays.copyOf(data, data.length);
        MessageDigest md = MessageDigest.getInstance(this.getHashAlgorithm());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DigestOutputStream dos = new DigestOutputStream(baos, md);
        if (CompressionType.ZIP == this.getCompressionType()) {
            ZipOutputStream zos = new ZipOutputStream(dos);
            zos.putNextEntry(new ZipEntry(this.getName()));
            zos.write(data);
            zos.closeEntry();
            zos.close();
        } else if (CompressionType.GZIP == this.getCompressionType()) {
            GZIPOutputStream gzos = new GZIPOutputStream(dos);
            gzos.write(data);
            gzos.flush();
            gzos.close();
        } else {
            dos.write(this.data);
            dos.close();
        }
        BigInteger digestBigInt = new BigInteger(1, md.digest());
        String hashStr = digestBigInt.toString(16);
        this.edt.setHashValue(hashStr);
        this.edt.setData(this.encodeData(baos.toByteArray()));
    }

    private String encodeData(byte[] data) {
        if (data == null) {
            return "";
        }
        byte[] encodedDataBytes = Base64Coder.base64Encode((byte[])data);
        String encodedData = encodedDataBytes == null ? "" : new String(encodedDataBytes);
        String[] lines = encodedData.split("(?<=\\G.{120})");
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        for (String line : lines) {
            sb.append(line).append("\n");
        }
        return sb.toString();
    }

    private byte[] decodeData(String dataBase64) {
        if (dataBase64 == null || "".equals(dataBase64.trim())) {
            return null;
        }
        dataBase64 = dataBase64.replaceAll("\\n", "");
        byte[] encodedDataBytes = dataBase64.getBytes();
        this.data = Base64Coder.base64Decode((byte[])encodedDataBytes);
        return this.data;
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        PropertiesType pt = this.edt.getProperties();
        if (pt != null) {
            List<PropertyType> propList = pt.getProperty();
            for (PropertyType ptEntry : propList) {
                propertiesMap.put(ptEntry.getName(), ptEntry.getValue());
            }
        }
        return propertiesMap;
    }

    public void setProperty(String name, String value) {
        if (name == null || value == null) {
            return;
        }
        PropertiesType pt = this.edt.getProperties();
        if (pt == null) {
            pt = new PropertiesType();
            this.edt.setProperties(pt);
        }
        List<PropertyType> propList = pt.getProperty();
        PropertyType newPt = new PropertyType();
        propList.add(newPt);
        newPt.setName(name);
        newPt.setValue(value);
        newPt.setType(value.getClass().getCanonicalName());
    }

    public void clearProperties() {
        PropertiesType pt = this.edt.getProperties();
        if (pt != null) {
            pt.getProperty().clear();
        }
    }

    public void removeProperty(String name) {
        if (name == null) {
            return;
        }
        PropertiesType pt = this.edt.getProperties();
        if (pt != null) {
            ArrayList<PropertyType> propToRemove = new ArrayList<PropertyType>();
            List<PropertyType> propList = pt.getProperty();
            for (PropertyType p : propList) {
                if (!p.getName().equals(name)) continue;
                propToRemove.add(p);
            }
            for (PropertyType p : propToRemove) {
                propList.remove(p);
            }
        }
    }

    public InputStream getDataAsInputStream() throws Exception {
        byte[] data = this.getData();
        return new ByteArrayInputStream(data);
    }

    public byte[] getData() throws Exception {
        if (this.data == null) {
            this.data = this.decodeData(this.edt.getData());
            if (this.data == null) {
                return new byte[0];
            }
            MessageDigest md = MessageDigest.getInstance(this.getHashAlgorithm());
            DigestInputStream dis = new DigestInputStream(new ByteArrayInputStream(this.data), md);
            byte[] buffer = new byte[4096];
            int read = 0;
            if (CompressionType.ZIP == this.getCompressionType()) {
                ZipInputStream zis = new ZipInputStream(dis);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                zis.getNextEntry();
                while ((read = zis.read(buffer)) != -1) {
                    baos.write(buffer, 0, read);
                }
                zis.closeEntry();
                zis.close();
                this.data = baos.toByteArray();
            } else if (CompressionType.GZIP == this.getCompressionType()) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                GZIPInputStream gis = new GZIPInputStream(dis);
                while ((read = gis.read(buffer)) != -1) {
                    baos.write(buffer, 0, read);
                }
                gis.close();
                this.data = baos.toByteArray();
            } else {
                while ((read = dis.read(buffer)) != -1) {
                }
                dis.close();
            }
            BigInteger digestBigInt = new BigInteger(1, md.digest());
            String hashStr = digestBigInt.toString(16);
            if (!hashStr.equals(this.getHashValue())) {
                throw new IllegalStateException("The data's hash '" + hashStr + "' does not match the expected value '" + this.getHashValue() + "'.");
            }
        }
        return Arrays.copyOf(this.data, this.data.length);
    }

    EncapsulatedDataType getEncapsulatedDataType() {
        return this.edt;
    }

    public void writeToString(OutputStream os) throws Exception {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{EncapsulatedDataType.class});
        Marshaller marshaller = jc.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.marshal((Object)this.edt, os);
    }
}

