/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.ready.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.AuthenticationService;
import com.ibm.ws.security.authorization.AuthorizationService;
import com.ibm.ws.security.ready.SecurityReadyService;
import com.ibm.ws.security.registry.UserRegistry;
import com.ibm.ws.security.registry.UserRegistryService;
import com.ibm.ws.security.token.TokenManager;
import com.ibm.ws.security.token.TokenService;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={}, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class SecurityReadyServiceImpl
implements SecurityReadyService {
    private static final TraceComponent tc = Tr.register(SecurityReadyServiceImpl.class, (String)"security", (String)"com.ibm.ws.security.ready.internal.resources.SecurityReadyServiceMessages");
    static final String KEY_TOKEN_SERVICE = "tokenService";
    static final String KEY_TOKEN_MANAGER = "tokenManager";
    static final String KEY_AUTHENTICATION_SERVICE = "authenticationService";
    static final String KEY_AUTHORIZATION_SERVICE = "authorizationService";
    static final String KEY_USER_REGISTRY = "userRegistry";
    static final String KEY_USER_REGISTRY_FACTORY = "userRegistryFactory";
    static final String KEY_USER_REGISTRY_SERVICE = "userRegistryService";
    private final AtomicServiceReference<TokenService> tokenService = new AtomicServiceReference("tokenService");
    private final AtomicServiceReference<TokenManager> tokenManager = new AtomicServiceReference("tokenManager");
    private final AtomicServiceReference<AuthenticationService> authenticationService = new AtomicServiceReference("authenticationService");
    private final AtomicServiceReference<AuthorizationService> authorizationService = new AtomicServiceReference("authorizationService");
    private final AtomicServiceReference<UserRegistry> userRegistry = new AtomicServiceReference("userRegistry");
    private final AtomicServiceReference<UserRegistryService> userRegistryService = new AtomicServiceReference("userRegistryService");
    private volatile boolean activated = false;
    private volatile boolean securityReady = false;
    private ServiceRegistration<SecurityReadyService> reg;
    private volatile CountDownLatch securityReadyCDL = new CountDownLatch(1);
    static final long serialVersionUID = 3028084943464694470L;

    @Reference(name="tokenService", policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL)
    protected void setTokenService(ServiceReference<TokenService> ref) {
        this.tokenService.setReference(ref);
        this.updateSecurityReadyState();
    }

    protected void unsetTokenService(ServiceReference<TokenService> ref) {
        this.tokenService.unsetReference(ref);
        this.updateSecurityReadyState();
    }

    @Reference(name="tokenManager", policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL)
    protected void setTokenManager(ServiceReference<TokenManager> ref) {
        this.tokenManager.setReference(ref);
        this.updateSecurityReadyState();
    }

    protected void unsetTokenManager(ServiceReference<TokenManager> ref) {
        this.tokenManager.unsetReference(ref);
        this.updateSecurityReadyState();
    }

    @Reference(name="authenticationService", policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL)
    protected void setAuthenticationService(ServiceReference<AuthenticationService> ref) {
        this.authenticationService.setReference(ref);
        this.updateSecurityReadyState();
    }

    protected void unsetAuthenticationService(ServiceReference<AuthenticationService> ref) {
        this.authenticationService.unsetReference(ref);
        this.updateSecurityReadyState();
    }

    @Reference(name="authorizationService", policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL)
    protected void setAuthorizationService(ServiceReference<AuthorizationService> ref) {
        this.authorizationService.setReference(ref);
        this.updateSecurityReadyState();
    }

    protected void unsetAuthorizationService(ServiceReference<AuthorizationService> ref) {
        this.authorizationService.unsetReference(ref);
        this.updateSecurityReadyState();
    }

    @Reference(name="userRegistry", policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL)
    protected void setUserRegistry(ServiceReference<UserRegistry> ref) {
        this.userRegistry.setReference(ref);
        this.updateSecurityReadyState();
    }

    protected void unsetUserRegistry(ServiceReference<UserRegistry> ref) {
        this.userRegistry.unsetReference(ref);
        this.updateSecurityReadyState();
    }

    @Reference(name="userRegistryService", service=UserRegistryService.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL)
    protected void setUserRegistryService(ServiceReference<UserRegistryService> ref) {
        this.userRegistryService.setReference(ref);
        this.updateSecurityReadyState();
    }

    protected void unsetUserRegistryService(ServiceReference<UserRegistryService> ref) {
        this.userRegistryService.unsetReference(ref);
        this.updateSecurityReadyState();
    }

    protected void activate(ComponentContext cc) {
        Tr.info((TraceComponent)tc, (String)"SECURITY_SERVICE_STARTING", (Object[])new Object[0]);
        this.tokenService.activate(cc);
        this.tokenManager.activate(cc);
        this.authenticationService.activate(cc);
        this.authorizationService.activate(cc);
        this.userRegistry.activate(cc);
        this.userRegistryService.activate(cc);
        this.activated = true;
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.vendor", "IBM");
        this.reg = cc.getBundleContext().registerService(SecurityReadyService.class, (Object)this, props);
        this.updateSecurityReadyState();
    }

    protected void deactivate(ComponentContext cc) {
        this.activated = false;
        this.securityReady = false;
        this.securityReadyCDL = new CountDownLatch(1);
        Tr.info((TraceComponent)tc, (String)"SECURITY_SERVICE_STOPPED", (Object[])new Object[0]);
        this.tokenService.deactivate(cc);
        this.tokenManager.deactivate(cc);
        this.authenticationService.deactivate(cc);
        this.authorizationService.deactivate(cc);
        this.userRegistry.deactivate(cc);
        this.userRegistryService.deactivate(cc);
        if (this.reg != null) {
            this.reg.unregister();
        }
    }

    private String getUnavailableServices() {
        StringBuilder missingServices = new StringBuilder();
        if (this.tokenService.getReference() == null) {
            missingServices.append("tokenService, ");
        }
        if (this.tokenManager.getReference() == null) {
            missingServices.append("tokenManager, ");
        }
        if (this.authenticationService.getReference() == null) {
            missingServices.append("authenticationService, ");
        }
        if (this.authorizationService.getReference() == null) {
            missingServices.append("authorizationService, ");
        }
        if (this.userRegistry.getReference() == null) {
            missingServices.append("userRegistry, ");
        }
        if (this.userRegistryService.getReference() == null) {
            missingServices.append("userRegistryService, ");
        }
        if (missingServices.length() == 0) {
            return null;
        }
        return missingServices.substring(0, missingServices.length() - 2);
    }

    private void updateSecurityReadyState() {
        if (!this.activated) {
            return;
        }
        String unavailableServices = this.getUnavailableServices();
        if (unavailableServices == null) {
            Tr.info((TraceComponent)tc, (String)"SECURITY_SERVICE_READY", (Object[])new Object[0]);
            this.securityReady = true;
            this.securityReadyCDL.countDown();
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("The following required security services are not available: " + unavailableServices), (Object[])new Object[0]);
            }
            this.securityReady = false;
            this.securityReadyCDL = new CountDownLatch(1);
        }
    }

    @Override
    public boolean isSecurityReady() {
        return this.securityReady;
    }

    @Override
    public boolean awaitSecurityReady(long timeout, TimeUnit unit) throws InterruptedException {
        return this.securityReadyCDL.await(timeout, unit);
    }
}

