/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi.impl.model;

import com.ibm.ws.microprofile.openapi.model.utils.OpenAPIUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.microprofile.openapi.models.Components;
import org.eclipse.microprofile.openapi.models.callbacks.Callback;
import org.eclipse.microprofile.openapi.models.examples.Example;
import org.eclipse.microprofile.openapi.models.headers.Header;
import org.eclipse.microprofile.openapi.models.links.Link;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;
import org.eclipse.microprofile.openapi.models.security.SecurityScheme;

public class ComponentsImpl
implements Components {
    private Map<String, Schema> schemas = null;
    private Map<String, APIResponse> responses = null;
    private Map<String, Parameter> parameters = null;
    private Map<String, Example> examples = null;
    private Map<String, RequestBody> requestBodies = null;
    private Map<String, Header> headers = null;
    private Map<String, SecurityScheme> securitySchemes = null;
    private Map<String, Link> links = null;
    private Map<String, Callback> callbacks = null;
    private Map<String, Object> extensions = null;

    public Map<String, Schema> getSchemas() {
        return this.schemas;
    }

    public void setSchemas(Map<String, Schema> schemas) {
        this.schemas = schemas;
    }

    public Components schemas(Map<String, Schema> schemas) {
        this.schemas = schemas;
        return this;
    }

    public Components addSchema(String key, Schema schema) {
        if (schema == null) {
            return this;
        }
        if (this.schemas == null) {
            this.schemas = new HashMap<String, Schema>();
        }
        this.schemas.put(key, schema);
        return this;
    }

    public Map<String, APIResponse> getResponses() {
        return this.responses;
    }

    public void setResponses(Map<String, APIResponse> responses) {
        this.responses = responses;
    }

    public Components responses(Map<String, APIResponse> responses) {
        this.responses = responses;
        return this;
    }

    public Components addResponse(String key, APIResponse response) {
        if (response == null) {
            return this;
        }
        if (response == null) {
            return this;
        }
        if (this.responses == null) {
            this.responses = new HashMap<String, APIResponse>();
        }
        this.responses.put(key, response);
        return this;
    }

    public Map<String, Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Parameter> parameters) {
        this.parameters = parameters;
    }

    public Components parameters(Map<String, Parameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    public Components addParameter(String key, Parameter parameter) {
        if (parameter == null) {
            return this;
        }
        if (this.parameters == null) {
            this.parameters = new HashMap<String, Parameter>();
        }
        this.parameters.put(key, parameter);
        return this;
    }

    public Map<String, Example> getExamples() {
        return this.examples;
    }

    public void setExamples(Map<String, Example> examples) {
        this.examples = examples;
    }

    public Components examples(Map<String, Example> examples) {
        this.examples = examples;
        return this;
    }

    public Components addExample(String key, Example example) {
        if (example == null) {
            return this;
        }
        if (this.examples == null) {
            this.examples = new HashMap<String, Example>();
        }
        this.examples.put(key, example);
        return this;
    }

    public Map<String, RequestBody> getRequestBodies() {
        return this.requestBodies;
    }

    public void setRequestBodies(Map<String, RequestBody> requestBodies) {
        this.requestBodies = requestBodies;
    }

    public Components requestBodies(Map<String, RequestBody> requestBodies) {
        this.requestBodies = requestBodies;
        return this;
    }

    public Components addRequestBody(String key, RequestBody requestBody) {
        if (requestBody == null) {
            return this;
        }
        if (this.requestBodies == null) {
            this.requestBodies = new HashMap<String, RequestBody>();
        }
        this.requestBodies.put(key, requestBody);
        return this;
    }

    public Map<String, Header> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, Header> headers) {
        this.headers = headers;
    }

    public Components headers(Map<String, Header> headers) {
        this.headers = headers;
        return this;
    }

    public Components addHeader(String key, Header header) {
        if (header == null) {
            return this;
        }
        if (this.headers == null) {
            this.headers = new HashMap<String, Header>();
        }
        this.headers.put(key, header);
        return this;
    }

    public Map<String, SecurityScheme> getSecuritySchemes() {
        return this.securitySchemes;
    }

    public void setSecuritySchemes(Map<String, SecurityScheme> securitySchemes) {
        this.securitySchemes = securitySchemes;
    }

    public Components securitySchemes(Map<String, SecurityScheme> securitySchemes) {
        this.securitySchemes = securitySchemes;
        return this;
    }

    public Components addSecurityScheme(String key, SecurityScheme securityScheme) {
        if (securityScheme == null) {
            return this;
        }
        if (this.securitySchemes == null) {
            this.securitySchemes = new HashMap<String, SecurityScheme>();
        }
        this.securitySchemes.put(key, securityScheme);
        return this;
    }

    public Map<String, Link> getLinks() {
        return this.links;
    }

    public void setLinks(Map<String, Link> links) {
        this.links = links;
    }

    public Components links(Map<String, Link> links) {
        this.links = links;
        return this;
    }

    public Components addLink(String key, Link linksItem) {
        if (linksItem == null) {
            return this;
        }
        if (this.links == null) {
            this.links = new HashMap<String, Link>();
        }
        this.links.put(key, linksItem);
        return this;
    }

    public Map<String, Callback> getCallbacks() {
        return this.callbacks;
    }

    public void setCallbacks(Map<String, Callback> callbacks) {
        this.callbacks = callbacks;
    }

    public Components callbacks(Map<String, Callback> callbacks) {
        this.callbacks = callbacks;
        return this;
    }

    public Components addCallback(String key, Callback callbacksItem) {
        if (callbacksItem == null) {
            return this;
        }
        if (this.callbacks == null) {
            this.callbacks = new HashMap<String, Callback>();
        }
        this.callbacks.put(key, callbacksItem);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComponentsImpl components = (ComponentsImpl)o;
        return Objects.equals(this.schemas, components.schemas) && Objects.equals(this.responses, components.responses) && Objects.equals(this.parameters, components.parameters) && Objects.equals(this.examples, components.examples) && Objects.equals(this.requestBodies, components.requestBodies) && Objects.equals(this.headers, components.headers) && Objects.equals(this.securitySchemes, components.securitySchemes) && Objects.equals(this.links, components.links) && Objects.equals(this.callbacks, components.callbacks) && Objects.equals(this.extensions, components.extensions);
    }

    public int hashCode() {
        return Objects.hash(this.schemas, this.responses, this.parameters, this.examples, this.requestBodies, this.headers, this.securitySchemes, this.links, this.callbacks, this.extensions);
    }

    public Map<String, Object> getExtensions() {
        return this.extensions;
    }

    public void setExtensions(Map<String, Object> extensions) {
        this.extensions = extensions;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Components {\n");
        sb = this.schemas != null ? sb.append("    schemas: ").append(OpenAPIUtils.mapToString(this.schemas)).append("\n") : sb.append("");
        sb = this.responses != null ? sb.append("    responses: ").append(OpenAPIUtils.mapToString(this.responses)).append("\n") : sb.append("");
        sb = this.parameters != null ? sb.append("    parameters: ").append(OpenAPIUtils.mapToString(this.parameters)).append("\n") : sb.append("");
        sb = this.examples != null ? sb.append("    examples: ").append(OpenAPIUtils.mapToString(this.examples)).append("\n") : sb.append("");
        sb = this.requestBodies != null ? sb.append("    requestBodies: ").append(OpenAPIUtils.mapToString(this.requestBodies)).append("\n") : sb.append("");
        sb = this.headers != null ? sb.append("    headers: ").append(OpenAPIUtils.mapToString(this.headers)).append("\n") : sb.append("");
        sb = this.securitySchemes != null ? sb.append("    securitySchemes: ").append(OpenAPIUtils.mapToString(this.securitySchemes)).append("\n") : sb.append("");
        sb = this.links != null ? sb.append("    links: ").append(OpenAPIUtils.mapToString(this.links)).append("\n") : sb.append("");
        sb = this.callbacks != null ? sb.append("    callbacks: ").append(OpenAPIUtils.mapToString(this.callbacks)).append("\n") : sb.append("");
        sb = this.extensions != null ? sb.append("    extensions: ").append(OpenAPIUtils.mapToString(this.extensions)).append("\n") : sb.append("");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public Components addExtension(String extName, Object value) {
        if (value == null) {
            return this;
        }
        if (this.extensions == null) {
            this.extensions = new HashMap<String, Object>();
        }
        this.extensions.put(extName, value);
        return this;
    }

    public void removeExtension(String arg0) {
        if (this.extensions != null) {
            this.extensions.remove(arg0);
        }
    }

    public void removeCallback(String arg0) {
        if (this.callbacks != null) {
            this.callbacks.remove(arg0);
        }
    }

    public void removeExample(String arg0) {
        if (this.examples != null) {
            this.examples.remove(arg0);
        }
    }

    public void removeHeader(String arg0) {
        if (this.headers != null) {
            this.headers.remove(arg0);
        }
    }

    public void removeLink(String link) {
        if (this.links != null) {
            this.links.remove(link);
        }
    }

    public void removeParameter(String param) {
        if (this.parameters != null) {
            this.parameters.remove(param);
        }
    }

    public void removeRequestBody(String requestBody) {
        if (this.requestBodies != null) {
            this.requestBodies.remove(requestBody);
        }
    }

    public void removeResponse(String response) {
        if (this.responses != null) {
            this.responses.remove(response);
        }
    }

    public void removeSchema(String schema) {
        if (this.schemas != null) {
            this.schemas.remove(schema);
        }
    }

    public void removeSecurityScheme(String secScheme) {
        if (this.securitySchemes != null) {
            this.securitySchemes.remove(secScheme);
        }
    }

    public void addExtension_compat(String name, Object value) {
        this.addExtension(name, value);
    }
}

