/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.util;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.ExternalContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.myfaces.shared.util.ClassUtils;
import org.apache.myfaces.util.Lazy;
import org.apache.myfaces.util._ValidationUtils;

public final class ExternalSpecifications {
    private static final Logger log = Logger.getLogger(ExternalSpecifications.class.getName());
    private static Lazy<Boolean> beanValidationAvailable = new Lazy<Boolean>(() -> {
        boolean available;
        try {
            try {
                available = ClassUtils.classForName("javax.validation.Validation") != null;
            }
            catch (ClassNotFoundException e) {
                available = false;
            }
            if (available) {
                try {
                    _ValidationUtils.tryBuildDefaultValidatorFactory();
                }
                catch (Throwable t) {
                    available = false;
                }
            }
        }
        catch (Throwable t) {
            log.log(Level.FINE, "Error loading class (could be normal)", t);
            available = false;
        }
        log.info("MyFaces Core Bean Validation support " + (available ? "enabled" : "disabled"));
        return available;
    });
    private static Lazy<Boolean> cdiAvailable = new Lazy<Boolean>(() -> {
        boolean available;
        try {
            available = ClassUtils.classForName("javax.enterprise.inject.spi.BeanManager") != null;
        }
        catch (Throwable t) {
            available = false;
        }
        log.info("MyFaces Core CDI support " + (available ? "enabled" : "disabled"));
        return available;
    });
    private static Lazy<Boolean> el3Available = new Lazy<Boolean>(() -> {
        boolean available;
        try {
            available = ClassUtils.classForName("javax.el.StaticFieldELResolver") != null;
        }
        catch (Throwable t) {
            available = false;
        }
        log.info("MyFaces Core EL 3.0 support " + (available ? "enabled" : "disabled"));
        return available;
    });
    private static Lazy<Boolean> sevlet4Available = new Lazy<Boolean>(() -> {
        boolean available;
        try {
            available = ClassUtils.classForName("javax.servlet.http.PushBuilder") != null && HttpServletRequest.class.getMethod("newPushBuilder", null) != null;
        }
        catch (Throwable t) {
            available = false;
        }
        log.info("MyFaces Core Servlet 4.0 support " + (available ? "enabled" : "disabled"));
        return available;
    });

    public static boolean isBeanValidationAvailable() {
        return beanValidationAvailable.get();
    }

    public static boolean isCDIAvailable(ExternalContext externalContext) {
        return cdiAvailable.get() != false && externalContext.getApplicationMap().containsKey("oam.cdi.BEAN_MANAGER_INSTANCE");
    }

    public static boolean isEL3Available() {
        return el3Available.get();
    }

    public static boolean isServlet4Available() {
        return sevlet4Available.get();
    }

    private ExternalSpecifications() {
    }
}

