/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.jcache;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.Serializable;
import java.util.Arrays;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class CacheObject
implements Serializable {
    private static final TraceComponent tc = Tr.register(CacheObject.class, (String)"jcache", (String)"io.openliberty.jcache.internal.resources.JCacheMessages");
    private static final long serialVersionUID = 1L;
    private byte[] objectBytes;
    private transient Object object;

    public CacheObject(@Sensitive Object object, @Sensitive byte[] objectBytes) {
        if (objectBytes == null) {
            throw new IllegalArgumentException("The objectBytes argument cannot be null.");
        }
        this.objectBytes = objectBytes;
        this.object = object;
    }

    @Sensitive
    public Object getObject() {
        return this.object;
    }

    @Sensitive
    public byte[] getObjectBytes() {
        return this.objectBytes;
    }

    public void setObject(@Sensitive Object object) {
        this.object = object;
    }

    @Trivial
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof CacheObject)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return Arrays.equals(this.objectBytes, ((CacheObject)obj).objectBytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.objectBytes);
    }

    public String toString() {
        return super.toString() + "{objectBytes.length=" + this.objectBytes.length + ", object=" + this.object + "}";
    }
}

