/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.jaspi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.SecurityService;
import com.ibm.ws.security.audit.Audit;
import com.ibm.ws.security.authentication.AuthenticationException;
import com.ibm.ws.security.authentication.UnauthenticatedSubjectService;
import com.ibm.ws.security.authentication.utility.SubjectHelper;
import com.ibm.ws.security.context.SubjectManager;
import com.ibm.ws.security.jaspi.AuthConfigFactoryWrapper;
import com.ibm.ws.security.jaspi.BridgeBuilderService;
import com.ibm.ws.security.jaspi.JaspiCallbackHandler;
import com.ibm.ws.security.jaspi.JaspiMessageInfo;
import com.ibm.ws.security.jaspi.JaspiRequest;
import com.ibm.ws.security.jaspi.NonMappingCallbackHandler;
import com.ibm.ws.security.jaspi.ProviderRegistry;
import com.ibm.ws.webcontainer.internalRuntimeExport.srt.IPrivateRequestAttributes;
import com.ibm.ws.webcontainer.security.AuthResult;
import com.ibm.ws.webcontainer.security.AuthenticationResult;
import com.ibm.ws.webcontainer.security.JaspiService;
import com.ibm.ws.webcontainer.security.ReferrerURLCookieHandler;
import com.ibm.ws.webcontainer.security.WebAppSecurityConfig;
import com.ibm.ws.webcontainer.security.WebAuthenticator;
import com.ibm.ws.webcontainer.security.WebProviderAuthenticatorHelper;
import com.ibm.ws.webcontainer.security.WebRequest;
import com.ibm.ws.webcontainer.security.WebRequestImpl;
import com.ibm.ws.webcontainer.security.WebSecurityContext;
import com.ibm.ws.webcontainer.security.metadata.FormLoginConfiguration;
import com.ibm.ws.webcontainer.security.metadata.LoginConfiguration;
import com.ibm.ws.webcontainer.security.metadata.SecurityMetadata;
import com.ibm.ws.webcontainer.security.util.WebConfigUtils;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.security.jaspi.ProviderService;
import com.ibm.wsspi.webcontainer.servlet.IExtendedResponse;
import com.ibm.wsspi.webcontainer.webapp.WebAppConfig;
import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.config.AuthConfigFactory;
import javax.security.auth.message.config.AuthConfigProvider;
import javax.security.auth.message.config.RegistrationListener;
import javax.security.auth.message.config.ServerAuthConfig;
import javax.security.auth.message.config.ServerAuthContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={JaspiService.class, WebAuthenticator.class}, name="com.ibm.ws.security.jaspi", configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM", "com.ibm.ws.security.webAuthenticator.type=JASPI"})
public class JaspiServiceImpl
implements JaspiService,
WebAuthenticator {
    private static final TraceComponent tc = Tr.register(JaspiServiceImpl.class, (String)"security", (String)"com.ibm.ws.security.jaspi.internal.resources.JaspiMessages");
    private static final String AUTH_TYPE = "javax.servlet.http.authType";
    private static final String IS_MANDATORY_POLICY = "javax.security.auth.message.MessagePolicy.isMandatory";
    private static final String JAKARTA_IS_AUTHENTICATION_REQUEST = "jakarta.servlet.http.isAuthenticationRequest";
    private static final String JACC_POLICY_CONTEXT = "javax.security.jacc.PolicyContext";
    public static final String UNAUTHENTICATED_ID = "UNAUTHENTICATED";
    private static final String KEY_UNAUTHENTICATED_SUBJECT_SERVICE = "unauthenticatedSubjectService";
    private UnauthenticatedSubjectService unauthenticatedSubjectService;
    private boolean providerConfigModified = false;
    private WebProviderAuthenticatorHelper authHelper = null;
    private final SubjectHelper subjectHelper = new SubjectHelper();
    private SubjectManager subjectManager = null;
    public HashMap<String, Object> extraAuditData = new HashMap();
    private static final String KEY_JASPI_PROVIDER = "jaspiProvider";
    protected final AtomicServiceReference<ProviderService> jaspiProviderServiceRef = new AtomicServiceReference("jaspiProvider");
    private static final String KEY_JASPI_BRIDGE_BUILDER = "bridgeBuilder";
    protected final AtomicServiceReference<BridgeBuilderService> bridgeBuilderServiceRef = new AtomicServiceReference("bridgeBuilder");
    public static final String KEY_SECURITY_SERVICE = "securityService";
    protected final AtomicServiceReference<SecurityService> securityServiceRef = new AtomicServiceReference("securityService");
    static final String KEY_LOCATION_SERVICE = "locationService";
    private static final AtomicServiceReference<WsLocationAdmin> locationService = new AtomicServiceReference("locationService");
    static final String SERVER_CONFIG_LOCATION = "${server.config.dir}";
    static final long serialVersionUID = 4160869247678623426L;

    @Reference(name="unauthenticatedSubjectService", service=UnauthenticatedSubjectService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setUnauthenticatedSubjectService(UnauthenticatedSubjectService srv) {
        this.unauthenticatedSubjectService = srv;
    }

    protected void unsetUnauthenticatedSubjectService(UnauthenticatedSubjectService srv) {
        if (this.unauthenticatedSubjectService == srv) {
            this.unauthenticatedSubjectService = null;
        }
    }

    @Reference(name="jaspiProvider", service=ProviderService.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setJaspiProvider(ServiceReference<ProviderService> reference) {
        this.jaspiProviderServiceRef.setReference(reference);
        this.providerConfigModified = true;
        Tr.info((TraceComponent)tc, (String)"JASPI_PROVIDER_SERVICE_ACTIVATED", (Object[])new Object[]{((ProviderService)this.jaspiProviderServiceRef.getService()).getClass()});
    }

    protected void unsetJaspiProvider(ServiceReference<ProviderService> reference) {
        Tr.info((TraceComponent)tc, (String)"JASPI_PROVIDER_SERVICE_DEACTIVATED", (Object[])new Object[]{this.jaspiProviderServiceRef.getService() != null ? ((ProviderService)this.jaspiProviderServiceRef.getService()).getClass() : null});
        this.jaspiProviderServiceRef.unsetReference(reference);
        this.providerConfigModified = true;
    }

    @Reference(name="bridgeBuilder", service=BridgeBuilderService.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setBridgeBuilder(ServiceReference<BridgeBuilderService> reference) {
        this.bridgeBuilderServiceRef.setReference(reference);
    }

    protected void unsetBridgeBuilder(ServiceReference<BridgeBuilderService> reference) {
        this.bridgeBuilderServiceRef.unsetReference(reference);
    }

    @Reference(name="securityService", service=SecurityService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setSecurityService(ServiceReference<SecurityService> reference) {
        this.securityServiceRef.setReference(reference);
    }

    protected void unsetSecurityService(ServiceReference<SecurityService> reference) {
        this.securityServiceRef.unsetReference(reference);
    }

    @Reference(service=WsLocationAdmin.class, name="locationService", policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setLocationService(ServiceReference<WsLocationAdmin> reference) {
        locationService.setReference(reference);
    }

    protected void unsetLocationService(ServiceReference<WsLocationAdmin> reference) {
        locationService.unsetReference(reference);
    }

    static String getServerResourceAbsolutePath(String resourcePath) {
        String path = null;
        File f = new File(resourcePath);
        if (f.isAbsolute()) {
            path = resourcePath;
        } else {
            WsLocationAdmin wla = (WsLocationAdmin)locationService.getServiceWithException();
            if (wla != null) {
                path = wla.resolveString("${server.config.dir}/" + resourcePath);
            }
        }
        return path;
    }

    @Activate
    protected void activate(ComponentContext cc) {
        locationService.activate(cc);
        this.jaspiProviderServiceRef.activate(cc);
        this.bridgeBuilderServiceRef.activate(cc);
        this.securityServiceRef.activate(cc);
        AuthConfigFactoryWrapper.setFactoryImplementation();
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        locationService.deactivate(cc);
        this.jaspiProviderServiceRef.deactivate(cc);
        this.bridgeBuilderServiceRef.deactivate(cc);
        this.securityServiceRef.deactivate(cc);
    }

    @FFDCIgnore(value={AuthenticationException.class})
    public AuthenticationResult authenticate(WebRequest webRequest) {
        Subject sessionSubject = null;
        JaspiRequest jaspiRequest = new JaspiRequest(webRequest, null);
        AuthenticationResult result = null;
        AuthConfigProvider provider = this.getAuthConfigProvider(jaspiRequest.getAppContext());
        if (provider != null) {
            try {
                if (jaspiRequest.getWebSecurityContext() != null) {
                    JaspiService.JaspiAuthContext jaspiContext = this.getJaspiAuthContext(jaspiRequest, provider);
                    webRequest.getWebSecurityContext().setJaspiAuthContext((Object)jaspiContext);
                }
                if ((sessionSubject = this.getSessionSubject(jaspiRequest)) != null) {
                    SubjectManager sm = new SubjectManager();
                    sm.setCallerSubject(sessionSubject);
                    sm.setInvocationSubject(sessionSubject);
                }
                result = this.authenticate(new Subject(), this.getJaspiAuthType(jaspiRequest), jaspiRequest, provider);
            }
            catch (AuthenticationException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Internal error during JASPI authentication", (Object[])new Object[]{e});
                }
                if (result == null) {
                    result = new AuthenticationResult(AuthResult.FAILURE, e.getMessage());
                }
            }
        } else {
            result = new AuthenticationResult(AuthResult.CONTINUE, "No JASPIC provider found for request: " + webRequest.getHttpServletRequest().getRequestURI());
        }
        if (provider != null && provider.getClass() != null) {
            result.setAuditAuthConfigProviderName(provider.getClass().toString());
            result.setAuditAuthConfigProviderAuthType(this.getRequestAuthType(jaspiRequest.getHttpServletRequest(), "AUTH_TYPE"));
        }
        return result;
    }

    @FFDCIgnore(value={AuthenticationException.class})
    public AuthenticationResult authenticate(HttpServletRequest request, HttpServletResponse response, HashMap<String, Object> props) throws Exception {
        WebRequestImpl webRequest = new WebRequestImpl(request, response, ((WebAppConfig)props.get("webAppConfig")).getApplicationName(), null, (SecurityMetadata)props.get("securityMetadata"), null, (WebAppSecurityConfig)props.get("webAppSecurityConfig"));
        JaspiRequest jaspiRequest = new JaspiRequest((WebRequest)webRequest, (WebAppConfig)props.get("webAppConfig"));
        AuthenticationResult result = null;
        AuthConfigProvider provider = this.getAuthConfigProvider(jaspiRequest.getAppContext());
        if (provider != null) {
            try {
                if (jaspiRequest.getWebSecurityContext() != null) {
                    JaspiService.JaspiAuthContext jaspiContext = this.getJaspiAuthContext(jaspiRequest, provider);
                    webRequest.getWebSecurityContext().setJaspiAuthContext((Object)jaspiContext);
                }
                result = this.authenticate(new Subject(), this.getJaspiAuthType(jaspiRequest), jaspiRequest, provider);
            }
            catch (AuthenticationException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Internal error during JASPI authentication", (Object[])new Object[]{e});
                }
                result = new AuthenticationResult(AuthResult.FAILURE, e.getMessage());
            }
        } else {
            result = new AuthenticationResult(AuthResult.CONTINUE, "No JASPI provider found for request: " + request.getRequestURI());
        }
        return result;
    }

    @ManualTrace
    @FFDCIgnore(value={AuthException.class, WSLoginFailedException.class})
    private AuthenticationResult authenticate(Subject clientSubject, String authType, JaspiRequest jaspiRequest, AuthConfigProvider provider) throws AuthenticationException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"authenticate", (Object[])new Object[]{clientSubject, authType, jaspiRequest, provider});
        }
        AuthenticationResult authResult = null;
        Subject serviceSubject = null;
        AuthStatus status = null;
        WebSecurityContext webSecurityContext = jaspiRequest.getWebSecurityContext();
        jaspiRequest.getHttpServletRequest().getServletContext().setAttribute("com.ibm.ws.security.jaspi.authenticated", (Object)Boolean.toString(Boolean.TRUE));
        try {
            ServerAuthContext authContext = this.getServerAuthContext(jaspiRequest, provider);
            MessageInfo msgInfo = jaspiRequest.getMessageInfo();
            this.setRequestAuthType(jaspiRequest.getHttpServletRequest(), authType);
            if (webSecurityContext != null) {
                this.setRunSecureResponse(true, (JaspiService.JaspiAuthContext)webSecurityContext.getJaspiAuthContext());
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"******* calling JASPI provider authContext.validateRequest", (Object[])new Object[]{"authContext=" + authContext, clientSubject, msgInfo});
            }
            status = authContext.validateRequest(msgInfo, clientSubject, serviceSubject);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("******* return from JASPI provider authContext.validateRequest, status: " + status), (Object[])new Object[0]);
            }
            authResult = this.createAuthenticationResult(clientSubject, jaspiRequest, status, msgInfo, this.isJsr375BridgeProvider(provider));
            if (provider != null && provider.getClass() != null) {
                authResult.setAuditAuthConfigProviderName(provider.getClass().toString());
                authResult.setAuditAuthConfigProviderAuthType(this.getRequestAuthType(jaspiRequest.getHttpServletRequest(), "AUTH_TYPE"));
            }
        }
        catch (AuthException e) {
            AuthenticationException ex = new AuthenticationException("JASPIC Authenticated with status: SEND_FAILURE, exception: " + (Object)((Object)e));
            ex.initCause((Throwable)e);
            if (webSecurityContext != null) {
                this.setRunSecureResponse(false, (JaspiService.JaspiAuthContext)webSecurityContext.getJaspiAuthContext());
            }
            throw ex;
        }
        catch (WSLoginFailedException e) {
            AuthenticationException ex = new AuthenticationException("Custom login failure after JASPIC authentication completed successfully, exception: " + (Object)((Object)e));
            ex.initCause((Throwable)e);
            throw ex;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"authenticate", (Object)status);
        }
        return authResult;
    }

    private AuthenticationResult createAuthenticationResult(@Sensitive Subject clientSubject, JaspiRequest jaspiRequest, AuthStatus status, MessageInfo msgInfo, boolean isJSR375) throws WSLoginFailedException {
        if (System.getSecurityManager() == null) {
            return this.processAuthStatus(clientSubject, jaspiRequest, status, msgInfo, isJSR375);
        }
        return this.processAuthStatusWithJava2Security(clientSubject, jaspiRequest, status, msgInfo, isJSR375);
    }

    private AuthenticationResult processAuthStatus(Subject clientSubject, JaspiRequest jaspiRequest, AuthStatus status, MessageInfo msgInfo, boolean isJSR375) throws WSLoginFailedException {
        AuthenticationResult authResult;
        if (AuthStatus.SUCCESS == status) {
            Subject callerSubject;
            Object response;
            Object request;
            Map msgInfoMap = msgInfo.getMap();
            if (msgInfoMap != null) {
                String session = (String)msgInfoMap.get("javax.servlet.http.registerSession");
                boolean isJaspiSession = Boolean.valueOf(session);
                if (isJaspiSession) {
                    HashMap<String, String> props = new HashMap<String, String>();
                    props.put("javax.servlet.http.registerSession", session);
                    jaspiRequest.getWebRequest().setProperties(props);
                    this.setUsageAttribute(this.getCustomCredentials(clientSubject), "jaspic");
                } else if ("FORM".equals(this.getRequestAuthType(jaspiRequest.getHttpServletRequest(), "AUTH_TYPE"))) {
                    if (isJSR375) {
                        this.setUsageAttribute(this.getCustomCredentials(clientSubject), "jsr375Form");
                    } else {
                        this.setUsageAttribute(this.getCustomCredentials(clientSubject), "jaspicForm");
                    }
                }
            }
            if ((request = msgInfo.getRequestMessage()) != null && request != jaspiRequest.getHttpServletRequest()) {
                jaspiRequest.getHttpServletRequest().setAttribute("com.ibm.ws.security.jaspi.servlet.request.wrapper", request);
            }
            if ((response = msgInfo.getResponseMessage()) != null && response != jaspiRequest.getHttpServletResponse()) {
                jaspiRequest.getHttpServletRequest().setAttribute("com.ibm.ws.security.jaspi.servlet.response.wrapper", response);
            }
            if ((callerSubject = this.doHashTableLogin(clientSubject, jaspiRequest)) != null && !callerSubject.getPrincipals().isEmpty()) {
                this.extraAuditData.put("jaspiSubject", callerSubject.getPrincipals().iterator().next().getName());
            }
            authResult = this.mapToAuthenticationResult(status, jaspiRequest, callerSubject);
            this.setRequestAuthType(msgInfo, jaspiRequest);
        } else {
            authResult = this.mapToAuthenticationResult(status, jaspiRequest, null);
        }
        return authResult;
    }

    @FFDCIgnore(value={PrivilegedActionException.class})
    private AuthenticationResult processAuthStatusWithJava2Security(@Sensitive Subject clientSubject, JaspiRequest jaspiRequest, AuthStatus status, MessageInfo msgInfo, boolean isJSR375) throws WSLoginFailedException {
        try {
            return AccessController.doPrivileged(new ProcessAuthStatusPrivilegedExceptionAction(clientSubject, jaspiRequest, status, msgInfo, isJSR375));
        }
        catch (PrivilegedActionException privException) {
            throw (WSLoginFailedException)((Object)privException.getException());
        }
    }

    private AuthConfigProvider getAuthConfigProvider(String appContext) {
        AuthConfigProvider provider = null;
        AuthConfigFactory providerFactory = this.getAuthConfigFactory();
        if (providerFactory != null) {
            if (this.providerConfigModified && providerFactory instanceof ProviderRegistry) {
                ((ProviderRegistry)providerFactory).setProvider((ProviderService)this.jaspiProviderServiceRef.getService());
                this.providerConfigModified = false;
            }
            provider = providerFactory.getConfigProvider("HttpServlet", appContext, (RegistrationListener)null);
        }
        return provider;
    }

    /*
     * WARNING - void declaration
     */
    public JaspiService.JaspiAuthContext getJaspiAuthContext(JaspiRequest jaspiRequest, AuthConfigProvider provider) throws AuthenticationException {
        PostInvokeJaspiContext jaspiContext = null;
        try {
            ServerAuthContext authContext = this.getServerAuthContext(jaspiRequest, provider);
            if (authContext != null) {
                jaspiContext = new PostInvokeJaspiContext(authContext, jaspiRequest.getMessageInfo());
            }
        }
        catch (Exception authContext) {
            void e;
            FFDCFilter.processException((Throwable)authContext, (String)"com.ibm.ws.security.jaspi.JaspiServiceImpl", (String)"532", (Object)this, (Object[])new Object[]{jaspiRequest, provider});
            AuthenticationException ex = new AuthenticationException("Unable to get JASPI ServerAuthContext.");
            ex.initCause((Throwable)e);
            throw ex;
        }
        return jaspiContext;
    }

    protected MessageInfo newMessageInfo(JaspiRequest jaspiRequest) {
        HttpServletRequest req = jaspiRequest.getHttpServletRequest();
        JaspiMessageInfo msgInfo = new JaspiMessageInfo(req, jaspiRequest.getHttpServletResponse());
        msgInfo.getMap().put(IS_MANDATORY_POLICY, Boolean.toString(jaspiRequest.isMandatory()));
        msgInfo.getMap().put(JAKARTA_IS_AUTHENTICATION_REQUEST, Boolean.toString(jaspiRequest.isRequestAuthenticate()));
        return msgInfo;
    }

    /*
     * WARNING - void declaration
     */
    protected ServerAuthContext getServerAuthContext(JaspiRequest jaspiRequest, AuthConfigProvider provider) throws AuthenticationException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getServerAuthContext", (Object[])new Object[]{jaspiRequest.getWebSecurityContext(), provider});
        }
        ServerAuthContext authContext = null;
        WebSecurityContext webSecurityContext = jaspiRequest.getWebSecurityContext();
        JaspiService.JaspiAuthContext jaspiContext = null;
        if (webSecurityContext != null && (jaspiContext = (JaspiService.JaspiAuthContext)webSecurityContext.getJaspiAuthContext()) != null) {
            authContext = (ServerAuthContext)jaspiContext.getServerAuthContext();
        } else {
            try {
                authContext = this.getAuthContextFromProvider(jaspiRequest, provider);
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.jaspi.JaspiServiceImpl", (String)"560", (Object)this, (Object[])new Object[]{jaspiRequest, provider});
                AuthenticationException ex = new AuthenticationException("Unable to get JASPI ServerAuthContext.");
                ex.initCause((Throwable)e);
                throw ex;
            }
        }
        return authContext;
    }

    protected ServerAuthContext getAuthContextFromProvider(JaspiRequest jaspiRequest, AuthConfigProvider provider) throws AuthException, SecurityException {
        ServerAuthContext authContext = null;
        String appContext = jaspiRequest.getAppContext();
        if (provider != null) {
            CallbackHandler jaspiCallbackHandler = this.getCallbackHandler(provider);
            ServerAuthConfig authConfig = provider.getServerAuthConfig("HttpServlet", appContext, jaspiCallbackHandler);
            MessageInfo msgInfo = this.newMessageInfo(jaspiRequest);
            jaspiRequest.setMessageInfo(msgInfo);
            String authContextID = authConfig.getAuthContextID(msgInfo);
            Map<String, String> props = this.getAuthContextProps(jaspiRequest);
            Subject serviceSubject = null;
            authContext = authConfig.getAuthContext(authContextID, serviceSubject, props);
        }
        return authContext;
    }

    private CallbackHandler getCallbackHandler(AuthConfigProvider provider) {
        JaspiCallbackHandler callbackHandler = this.isJsr375BridgeProvider(provider) ? new NonMappingCallbackHandler(this) : new JaspiCallbackHandler(this);
        return callbackHandler;
    }

    private boolean isJsr375BridgeProvider(AuthConfigProvider provider) {
        return "Bridge Provider for JSR-375 Java EE Security API" == this.getProviderDescription(provider);
    }

    private String getProviderDescription(final AuthConfigProvider provider) {
        String description = System.getSecurityManager() == null ? this.getDescription(provider) : AccessController.doPrivileged(new PrivilegedAction<String>(){
            static final long serialVersionUID = 9053264814948960814L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public String run() {
                return JaspiServiceImpl.this.getDescription(provider);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.jaspi.JaspiServiceImpl$1", 1.class, (String)"security", (String)"com.ibm.ws.security.jaspi.internal.resources.JaspiMessages");
            }
        });
        return description;
    }

    private String getDescription(AuthConfigProvider provider) {
        AuthConfigFactory factory = AuthConfigFactory.getFactory();
        String id = factory.getRegistrationIDs(provider)[0];
        return factory.getRegistrationContext(id).getDescription();
    }

    protected void setRequestAuthType(MessageInfo msgInfo, JaspiRequest jaspiRequest) {
        String authType = null;
        if (msgInfo.getMap().containsKey(AUTH_TYPE)) {
            authType = (String)msgInfo.getMap().get(AUTH_TYPE);
        } else {
            authType = this.getDDAuthMethod(jaspiRequest);
            if (authType == null) {
                authType = "JASPI";
            }
        }
        HttpServletRequest req = (HttpServletRequest)msgInfo.getRequestMessage();
        this.setRequestAuthType(req, authType);
    }

    protected String getDDAuthMethod(JaspiRequest jaspiRequest) {
        LoginConfiguration loginCfg;
        String authType = null;
        if (jaspiRequest != null && (loginCfg = jaspiRequest.getLoginConfig()) != null) {
            authType = loginCfg.getAuthenticationMethod();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"login configuration", (Object[])new Object[]{loginCfg, authType});
            }
        }
        return authType;
    }

    protected String getJaspiAuthType(JaspiRequest jaspiRequest) {
        String authType = this.getDDAuthMethod(jaspiRequest);
        authType = authType != null && !authType.equals("BASIC") && !authType.equals("CLIENT_CERT") ? "FORM" : "BASIC";
        return authType;
    }

    protected void setRequestAuthType(HttpServletRequest req, String authType) {
        if (authType != null) {
            JaspiServiceImpl.setPrivateAttributes(req, "AUTH_TYPE", authType);
        }
    }

    protected String getRequestAuthType(HttpServletRequest req, String key) {
        return (String)JaspiServiceImpl.getPrivateAttributes(req, key);
    }

    protected int getResponseStatus(HttpServletResponse rsp) {
        if (rsp instanceof IExtendedResponse) {
            return ((IExtendedResponse)rsp).getStatusCode();
        }
        return rsp.getStatus();
    }

    @ManualTrace
    protected AuthenticationResult mapToAuthenticationResult(AuthStatus status, JaspiRequest jaspiRequest, Subject clientSubject) {
        int responseStatus;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"mapToAuthenticationResult", (Object[])new Object[]{"AuthStatus=" + status});
        }
        AuthenticationResult authResult = null;
        String pretty = "FAILURE";
        if (AuthStatus.SEND_SUCCESS == status) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"SEND_SUCCES received. Returning without going to the service.", (Object[])new Object[0]);
            }
            responseStatus = this.getResponseStatus(jaspiRequest.getHttpServletResponse());
            authResult = new AuthenticationResult(AuthResult.RETURN, "Returning response from JASPIC Authenticated with status: " + responseStatus);
            pretty = "SEND_SUCCESS";
        }
        if (AuthStatus.SUCCESS == status) {
            authResult = new AuthenticationResult(AuthResult.SUCCESS, clientSubject);
            pretty = "SUCCESS";
        } else if (AuthStatus.SEND_CONTINUE == status) {
            responseStatus = this.getResponseStatus(jaspiRequest.getHttpServletResponse());
            HttpServletRequest req = jaspiRequest.getHttpServletRequest();
            switch (responseStatus) {
                case 401: {
                    String realm = (String)jaspiRequest.getMessageInfo().getMap().get("com.ibm.wsspi.security.cred.realm");
                    authResult = new AuthenticationResult(AuthResult.SEND_401, realm != null ? realm : (String)null);
                    pretty = "SEND_401";
                    break;
                }
                case 302: 
                case 303: 
                case 307: {
                    String loginURL = this.getLoginURL(jaspiRequest, req);
                    String query = req.getQueryString();
                    String originalURL = req.getRequestURL().append(query != null ? "?" + query : "").toString();
                    authResult = new AuthenticationResult(AuthResult.REDIRECT, loginURL);
                    pretty = "REDIRECT";
                    ReferrerURLCookieHandler referrerURLHandler = WebConfigUtils.getWebAppSecurityConfig().createReferrerURLCookieHandler();
                    referrerURLHandler.setReferrerURLCookie(req, authResult, originalURL);
                    break;
                }
                default: {
                    authResult = new AuthenticationResult(AuthResult.RETURN, "Returning response from JASPIC Authenticated with status: " + responseStatus);
                    break;
                }
            }
        } else if (AuthStatus.SEND_FAILURE == status) {
            pretty = "SEND_FAILURE";
            String detail = "Returning response from JASPIC Authenticated with status: " + pretty + ", map to AuthResult.RETURN";
            authResult = new AuthenticationResult(AuthResult.RETURN, detail);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)detail, (Object[])new Object[0]);
            }
        } else {
            authResult = new AuthenticationResult(AuthResult.RETURN, "Returning response from JASPIC Authentication failed, unexpected JASPIC AuthStatus: " + status + ", map to AuthResult.RETURN");
            pretty = status.toString();
        }
        if (authResult.getStatus().equals((Object)AuthResult.RETURN)) {
            Tr.info((TraceComponent)tc, (String)"JASPI_PROVIDER_FAILED_AUTHENTICATE", (Object[])new Object[]{status, jaspiRequest.getHttpServletRequest().getRequestURI(), this.jaspiProviderServiceRef.getService() != null ? ((ProviderService)this.jaspiProviderServiceRef.getService()).getClass() : null});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"mapToAuthenticationResult", (Object)("Jaspi AuthenticationResult=" + pretty));
        }
        return authResult;
    }

    protected Subject doHashTableLogin(Subject clientSubject, JaspiRequest jaspiRequest) throws WSLoginFailedException {
        Subject authenticatedSubject = null;
        Hashtable<String, Object> hashTable = this.getCustomCredentials(clientSubject);
        String unauthenticatedSubjectString = UNAUTHENTICATED_ID;
        String user = null;
        if (hashTable == null) {
            Subject sessionSubject = this.getSessionSubject(jaspiRequest);
            if (sessionSubject != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"No HashTable returned by the JASPI provider. Using JASPI session subject.", (Object[])new Object[0]);
                }
                return sessionSubject;
            }
            MessageInfo msgInfo = jaspiRequest.getMessageInfo();
            boolean isProtected = Boolean.parseBoolean((String)msgInfo.getMap().get(IS_MANDATORY_POLICY));
            if (isProtected) {
                String msg = "JASPI HashTable login cannot be performed, JASPI provider did not return a HashTable.";
                throw new WSLoginFailedException(msg);
            }
            user = unauthenticatedSubjectString;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Web resource is unprotected and Subject does not have a HashTable.", (Object[])new Object[0]);
            }
        } else {
            user = (String)hashTable.get("com.ibm.wsspi.security.cred.securityName");
        }
        boolean isUnauthenticated = unauthenticatedSubjectString.equals(user);
        if (isUnauthenticated) {
            authenticatedSubject = this.getUnauthenticatedSubject();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"JASPI Subject is unauthenticated, HashTable login is not necessary.", (Object[])new Object[0]);
            }
        } else {
            if (user == null) {
                user = "";
            }
            Subject loginSubject = clientSubject;
            Subject sessionSubject = this.getSessionSubject(jaspiRequest);
            if (sessionSubject != null) {
                Subject clone = new Subject();
                clone.getPrivateCredentials().addAll(sessionSubject.getPrivateCredentials());
                clone.getPublicCredentials().addAll(sessionSubject.getPublicCredentials());
                clone.getPrincipals().addAll(sessionSubject.getPrincipals());
                clone.getPrivateCredentials().add(hashTable);
                loginSubject = clone;
            }
            HttpServletRequest req = jaspiRequest.getHttpServletRequest();
            HttpServletResponse res = (HttpServletResponse)jaspiRequest.getMessageInfo().getResponseMessage();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("JASPI login with HashTable: " + hashTable), (Object[])new Object[0]);
            }
            AuthenticationResult result = this.getWebProviderAuthenticatorHelper().loginWithHashtable(req, res, loginSubject);
            authenticatedSubject = result.getSubject();
            if (sessionSubject != null) {
                this.removeCustomCredentials(sessionSubject, hashTable);
            }
            if (authenticatedSubject == null) {
                throw new WSLoginFailedException("JASPI HashTable login failed, user: " + user);
            }
        }
        return authenticatedSubject;
    }

    public Hashtable<String, Object> getCustomCredentials(@Sensitive Subject clientSubject) {
        return this.subjectHelper.getSensitiveHashtableFromSubject(clientSubject);
    }

    private Subject getSessionSubject(JaspiRequest jaspiRequest) {
        Subject sessionSubject = null;
        Map requestProps = jaspiRequest.getWebRequest().getProperties();
        if (requestProps != null) {
            sessionSubject = (Subject)requestProps.get("javax.servlet.http.registerSession.subject");
        }
        return sessionSubject;
    }

    protected synchronized WebProviderAuthenticatorHelper getWebProviderAuthenticatorHelper() {
        if (this.authHelper == null) {
            this.authHelper = new WebProviderAuthenticatorHelper(this.securityServiceRef);
        }
        return this.authHelper;
    }

    private void removeCustomCredentials(Subject subject, Hashtable creds) {
        block1: {
            Set<Hashtable> s;
            block2: {
                if (subject == null) break block1;
                s = subject.getPrivateCredentials(Hashtable.class);
                if (s != null && !s.isEmpty()) break block2;
                if (!tc.isDebugEnabled()) break block1;
                Tr.debug((TraceComponent)tc, (String)"No custom credentials to remove from Subject.", (Object[])new Object[0]);
                break block1;
            }
            for (Hashtable t : s) {
                if (t != creds) continue;
                s.remove(t);
                break;
            }
        }
    }

    void setRunSecureResponse(boolean isSet, JaspiService.JaspiAuthContext jaspiContext) {
        if (jaspiContext != null) {
            jaspiContext.setRunSecureResponse(isSet);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("setRunSecureResponse: " + isSet), (Object[])new Object[0]);
            }
        }
    }

    private Map<String, String> getAuthContextProps(JaspiRequest jaspiRequest) {
        HashMap<String, String> props = new HashMap<String, String>();
        String jaccContext = null;
        jaccContext = "href:" + jaspiRequest.getApplicationName() + "/" + jaspiRequest.getModuleName();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("JACC Policy Context: " + jaccContext), (Object[])new Object[0]);
        }
        props.put(JACC_POLICY_CONTEXT, jaccContext);
        return props;
    }

    public Subject getUnauthenticatedSubject() {
        return this.unauthenticatedSubjectService.getUnauthenticatedSubject();
    }

    private static void setPrivateAttributes(HttpServletRequest req, String key, Object object) {
        HttpServletRequest sr = req;
        if (sr instanceof HttpServletRequestWrapper) {
            HttpServletRequestWrapper w = (HttpServletRequestWrapper)sr;
            sr = (HttpServletRequest)w.getRequest();
            while (sr != null && sr instanceof HttpServletRequestWrapper) {
                sr = (HttpServletRequest)((HttpServletRequestWrapper)sr).getRequest();
            }
        }
        if (sr != null && sr instanceof IPrivateRequestAttributes) {
            ((IPrivateRequestAttributes)sr).setPrivateAttribute(key, object);
        }
    }

    private static Object getPrivateAttributes(HttpServletRequest req, String key) {
        HttpServletRequest sr = req;
        if (sr instanceof HttpServletRequestWrapper) {
            HttpServletRequestWrapper w = (HttpServletRequestWrapper)sr;
            sr = (HttpServletRequest)w.getRequest();
            while (sr != null && sr instanceof HttpServletRequestWrapper) {
                sr = (HttpServletRequest)((HttpServletRequestWrapper)sr).getRequest();
            }
        }
        if (sr != null && sr instanceof IPrivateRequestAttributes) {
            return ((IPrivateRequestAttributes)sr).getPrivateAttribute(key);
        }
        return null;
    }

    private String getLoginURL(JaspiRequest jaspiRequest, HttpServletRequest req) {
        FormLoginConfiguration formLoginConfig;
        String loginURL = null;
        LoginConfiguration loginConfig = jaspiRequest.getLoginConfig();
        if (loginConfig != null && (formLoginConfig = loginConfig.getFormLoginConfiguration()) != null) {
            String formLoginPageURL = formLoginConfig.getLoginPage();
            StringBuilder builder = new StringBuilder(req.getRequestURL());
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getFormURL", (Object[])new Object[]{"formLoginPageURL=" + formLoginPageURL, " requestURL=" + builder});
            }
            int hostIndex = builder.indexOf("//");
            int contextIndex = builder.indexOf("/", hostIndex + 2);
            builder.replace(contextIndex, builder.length(), this.normalizeURL(formLoginPageURL, req.getContextPath()));
            loginURL = builder.toString();
        }
        return loginURL;
    }

    private String normalizeURL(String url, String contextPath) {
        if (contextPath.equals("/")) {
            contextPath = "";
        }
        if (!url.startsWith("/")) {
            url = "/" + url;
        }
        return contextPath + url;
    }

    /*
     * WARNING - void declaration
     */
    public void postInvoke(WebSecurityContext webSecurityContext) throws AuthenticationException {
        AuthStatus status = null;
        if (webSecurityContext != null) {
            JaspiService.JaspiAuthContext jaspiContext = (JaspiService.JaspiAuthContext)webSecurityContext.getJaspiAuthContext();
            if (!jaspiContext.runSecureResponse()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"postInvoke", (Object[])new Object[]{"skip secureResponse."});
                }
                return;
            }
            MessageInfo msgInfo = (MessageInfo)jaspiContext.getMessageInfo();
            ServerAuthContext authContext = (ServerAuthContext)jaspiContext.getServerAuthContext();
            Subject serviceSubject = webSecurityContext.getReceivedSubject();
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"secureResponse with Jaspi", (Object[])new Object[]{"authContext=" + authContext, "serviceSubject=" + serviceSubject, msgInfo});
                }
                status = authContext.secureResponse(msgInfo, serviceSubject);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("secureResponse status: " + status), (Object[])new Object[0]);
                }
                if (AuthStatus.SEND_SUCCESS != status && AuthStatus.SEND_FAILURE != status && AuthStatus.SEND_CONTINUE != status) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("secureResponse  AuthStatus=" + status), (Object[])new Object[0]);
                    }
                    String msg = "Unexpected AuthStatus received during secureResponse() status=" + status + ", MessageInfo=" + msgInfo + ", ServerAuthContext=" + authContext;
                    throw new AuthenticationException(msg);
                }
            }
            catch (AuthException msg) {
                void e;
                FFDCFilter.processException((Throwable)msg, (String)"com.ibm.ws.security.jaspi.JaspiServiceImpl", (String)"1016", (Object)this, (Object[])new Object[]{webSecurityContext});
                throw new AuthenticationException("JASPI authentication failed after invoking the requested target service.", (Exception)e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void logout(HttpServletRequest req, HttpServletResponse res, WebAppSecurityConfig webAppSecConfig) throws AuthenticationException {
        Subject subject = null;
        WebRequestImpl webRequest = new WebRequestImpl(req, res, null, null, null, null, webAppSecConfig);
        JaspiRequest jaspiRequest = new JaspiRequest((WebRequest)webRequest, null);
        AuthConfigProvider provider = this.getAuthConfigProvider(jaspiRequest.getAppContext());
        if (provider != null) {
            try {
                ServerAuthContext authContext = this.getServerAuthContext(jaspiRequest, provider);
                MessageInfo msgInfo = this.newMessageInfo(jaspiRequest);
                subject = this.getSubjectManager().getInvocationSubject();
                if (subject == null) {
                    subject = new Subject();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"cleanSubject with Jaspi", (Object[])new Object[]{"authContext=" + authContext, msgInfo});
                }
                authContext.cleanSubject(msgInfo, subject);
            }
            catch (AuthException authContext) {
                void e;
                FFDCFilter.processException((Throwable)authContext, (String)"com.ibm.ws.security.jaspi.JaspiServiceImpl", (String)"1053", (Object)this, (Object[])new Object[]{req, res, webAppSecConfig});
                AuthenticationException ex = new AuthenticationException("JASPI cleanSubject failure: " + e);
                ex.initCause((Throwable)e);
                throw ex;
            }
        }
        AuthenticationResult authResult = new AuthenticationResult(AuthResult.SUCCESS, subject);
        authResult.setAuditCredType("JASPIC");
        if (provider != null) {
            authResult.setAuditAuthConfigProviderName(provider.getClass().toString());
        }
        authResult.setAuditAuthConfigProviderAuthType(this.getRequestAuthType(jaspiRequest.getHttpServletRequest(), "AUTH_TYPE"));
        authResult.setAuditOutcome("success");
        Audit.audit((Audit.EventID)Audit.EventID.SECURITY_API_AUTHN_TERMINATE_01, (Object[])new Object[]{req, authResult, res.getStatus()});
    }

    private synchronized SubjectManager getSubjectManager() {
        if (this.subjectManager == null) {
            this.subjectManager = new SubjectManager();
        }
        return this.subjectManager;
    }

    private void setAuditCredValue(AuthenticationResult result) {
        if (this.extraAuditData.get("jaspiSubject") != null) {
            result.setAuditCredValue((String)this.extraAuditData.get("jaspiSubject"));
        }
    }

    public boolean isAnyProviderRegistered(WebRequest webRequest) {
        boolean result = true;
        AuthConfigFactory providerFactory = this.getAuthConfigFactory();
        BridgeBuilderService bridgeBuilderService = (BridgeBuilderService)this.bridgeBuilderServiceRef.getService();
        if (bridgeBuilderService != null) {
            bridgeBuilderService.buildBridgeIfNeeded(null, providerFactory);
        }
        if (providerFactory != null && providerFactory instanceof ProviderRegistry) {
            if (this.providerConfigModified) {
                ((ProviderRegistry)providerFactory).setProvider((ProviderService)this.jaspiProviderServiceRef.getService());
                this.providerConfigModified = false;
            }
            result = ((ProviderRegistry)providerFactory).isAnyProviderRegistered();
        }
        return result;
    }

    private AuthConfigFactory getAuthConfigFactory() {
        return AccessController.doPrivileged(new PrivilegedAction<AuthConfigFactory>(){
            static final long serialVersionUID = -1452938878511910392L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public AuthConfigFactory run() {
                return AuthConfigFactoryWrapper.getFactory();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.jaspi.JaspiServiceImpl$2", 2.class, (String)"security", (String)"com.ibm.ws.security.jaspi.internal.resources.JaspiMessages");
            }
        });
    }

    public boolean isProcessingNewAuthentication(HttpServletRequest req) {
        BridgeBuilderService bridgeBuilderService = (BridgeBuilderService)this.bridgeBuilderServiceRef.getService();
        if (bridgeBuilderService != null) {
            return bridgeBuilderService.isProcessingNewAuthentication(req);
        }
        return false;
    }

    public boolean isCredentialPresent(HttpServletRequest req) {
        BridgeBuilderService bridgeBuilderService = (BridgeBuilderService)this.bridgeBuilderServiceRef.getService();
        if (bridgeBuilderService != null) {
            return bridgeBuilderService.isCredentialPresent(req);
        }
        return false;
    }

    private void setUsageAttribute(Hashtable<String, Object> hashTable, String value) {
        if (hashTable != null) {
            hashTable.put("com.ibm.ws.authentication.internal.auth.provider", value);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Token Usage is set as " + value), (Object[])new Object[0]);
            }
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class ProcessAuthStatusPrivilegedExceptionAction
    implements PrivilegedExceptionAction<AuthenticationResult> {
        private final Subject clientSubject;
        private final JaspiRequest jaspiRequest;
        private final AuthStatus status;
        private final MessageInfo msgInfo;
        private final boolean isJSR375;
        static final long serialVersionUID = -272764142729827563L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Trivial
        public ProcessAuthStatusPrivilegedExceptionAction(Subject clientSubject, JaspiRequest jaspiRequest, AuthStatus status, MessageInfo msgInfo, boolean isJSR375) {
            this.clientSubject = clientSubject;
            this.jaspiRequest = jaspiRequest;
            this.status = status;
            this.msgInfo = msgInfo;
            this.isJSR375 = isJSR375;
        }

        @Override
        public AuthenticationResult run() throws Exception {
            return JaspiServiceImpl.this.processAuthStatus(this.clientSubject, this.jaspiRequest, this.status, this.msgInfo, this.isJSR375);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.jaspi.JaspiServiceImpl$ProcessAuthStatusPrivilegedExceptionAction", ProcessAuthStatusPrivilegedExceptionAction.class, (String)"security", (String)"com.ibm.ws.security.jaspi.internal.resources.JaspiMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class PostInvokeJaspiContext
    implements JaspiService.JaspiAuthContext {
        private final ServerAuthContext authContext;
        private final MessageInfo msgInfo;
        private boolean runSecureResponse;
        static final long serialVersionUID = 6123878316387144105L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public PostInvokeJaspiContext(ServerAuthContext authContext, MessageInfo msgInfo) {
            this.authContext = authContext;
            this.msgInfo = msgInfo;
        }

        public MessageInfo getMessageInfo() {
            return this.msgInfo;
        }

        public ServerAuthContext getServerAuthContext() {
            return this.authContext;
        }

        public boolean runSecureResponse() {
            return this.runSecureResponse;
        }

        public void setRunSecureResponse(boolean isSet) {
            this.runSecureResponse = isSet;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.jaspi.JaspiServiceImpl$PostInvokeJaspiContext", PostInvokeJaspiContext.class, (String)"security", (String)"com.ibm.ws.security.jaspi.internal.resources.JaspiMessages");
        }
    }
}

